<?php
	//Check if display sharing buttons
	$current_post_type = get_post_type();
	$is_sharing_enabled = false;
	
	if($current_post_type == 'galleries')
	{
		$tg_gallery_sharing = kirki_get_option('tg_gallery_sharing');
		if(!empty($tg_gallery_sharing))
		{
			$is_sharing_enabled = true;
		}
	}
	else
	{
		$tg_blog_content_sharing = kirki_get_option('tg_blog_content_sharing');
		if(!empty($tg_blog_content_sharing))
		{
			$is_sharing_enabled = true;
		}
	}
	
	if($is_sharing_enabled)
	{
	    $image_id = get_post_thumbnail_id(get_the_ID());
	    $pin_thumb = wp_get_attachment_image_src($image_id, 'grandphotography_gallery_grid', true);
	    
	    if(!isset($pin_thumb[0]))
	    {
		    $pin_thumb[0] = '';
	    }
?>
	<div class="social_share_button_wrapper">
		<?php
			if(function_exists('pvc_get_post_views'))
			{
		?>
		<div class="social_post_view">
			<?php
				$raw_post_view = grandphotography_get_post_view($post->ID, true);
				$post_view_unit = esc_html__( 'View', 'grandphotography' );
				
				if($raw_post_view > 1)
				{
					$post_view_unit = esc_html__( 'Views', 'grandphotography' );
				}
			?>
			<span class="view_number"><?php echo grandphotography_get_post_view($post->ID); ?></span>&nbsp;<span class="units"><?php echo esc_html($post_view_unit); ?></span>
		</div>
		<?php
			}
			
			if(function_exists('pssc_all'))
			{
		?>
		<div class="social_post_share_count">
			<?php
				$raw_post_share = grandphotography_get_post_share($post->ID, true);
				$post_share_unit = esc_html__( 'Shares', 'grandphotography' );
				
				if($raw_post_share > 1)
				{
					$post_share_unit = esc_html__( 'Shares', 'grandphotography' );
				}
			?>
			<span class="share_number"><?php echo grandphotography_get_post_share($post->ID); ?></span>&nbsp;<span class="units"><?php echo esc_html($post_share_unit); ?></span>
		</div>
		<?php
			}
		?>
		<ul>
			<li><a class="facebook_share" title="<?php esc_html_e( 'Facebook', 'grandphotography' ); ?>" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo get_permalink(); ?>"><?php esc_html_e( 'Facebook', 'grandphotography' ); ?></a></li>
			
			<li><a class="twitter_share" title="<?php esc_html_e( 'Tweet it', 'grandphotography' ); ?>" target="_blank" href="https://twitter.com/intent/tweet?original_referer=<?php echo get_permalink(); ?>&url=<?php echo get_permalink(); ?>&text=<?php echo get_the_title();?>"><?php esc_html_e( 'Tweet it', 'grandphotography' ); ?></a></li>
			
			<li><a class="pinterest_share" title="<?php esc_html_e( 'Pin it', 'grandphotography' ); ?>" target="_blank" href="https://www.pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink()); ?>&media=<?php echo urlencode($pin_thumb[0]); ?>"><?php esc_html_e( 'Pin it', 'grandphotography' ); ?></a></li>
			
			<li><a class="email_share" title="<?php esc_html_e('Share by Email', 'grandphotography' ); ?>" href="mailto:?Subject=<?php echo esc_attr(urlencode($post->post_title)); ?>&amp;Body=<?php echo esc_attr(urlencode(get_permalink($post->ID))); ?>"><?php esc_html_e('Share by Email', 'grandphotography' ); ?></a></li>
		</ul>
	</div>
<?php
	}
?>