<?php  

//Get all filterable option
$tg_portfolio_filterable = kirki_get_option('tg_portfolio_filterable');

//Get all sets and sorting option
$tg_portfolio_filterable_sort = kirki_get_option('tg_portfolio_filterable_sort');

//Check filterable link option
$tg_portfolio_filterable_link = kirki_get_option('tg_portfolio_filterable_link');
 
//Get all portfolio sets
if(!THEMEDEMO)
{
	$sets_arr = get_terms('portfoliosets', 'hide_empty=0&hierarchical=0&parent=0&orderby='.$tg_portfolio_filterable_sort);
}
else
{
	$sets_arr = get_terms('portfoliosets', 'hide_empty=0&hierarchical=0&parent=0&orderby='.$tg_portfolio_filterable_sort.'&exclude='.DEMOPORTFOLIOSETEXCLUDE);
}
    
if(!empty($tg_portfolio_filterable) && !empty($sets_arr) && empty($term))
{
?>
<div class="portfolio_title_wrapper">
	<div class="portfolio_filter_dropdown">
		<div class="portfolio_filter_dropdown_title">
			<a><span class="filter_by"><?php echo _e( 'Filter By', 'grandphotography' ); ?></span><span id="filter_selected"><?php echo esc_html_e('All', 'grandphotography' ); ?></span><i class="fa fa-angle-down"></i></a>
		</div>
	
		<div class="portfolio_filter_dropdown_select">
			<ul id="portfolio_wall_filters" class="portfolio_select">
				<li class="icon arrow"></li>
				<li class="all-projects active">
					<a class="active" href="javascript:;" data-filter=""><?php echo esc_html_e('All', 'grandphotography' ); ?></a>
				</li>
				<?php
					foreach($sets_arr as $key => $set_item)
					{
						$filter_link_url = 'javascript:;';
						    			
						if(!empty($tg_portfolio_filterable_link))
						{
						    $filter_link_url = get_term_link($set_item);
						}
				?>
				<li class="cat-item <?php echo esc_attr($set_item->slug); ?>" data-type="<?php echo esc_attr($set_item->slug); ?>" style="clear:none">
					<a data-filter="<?php echo esc_attr($set_item->slug); ?>" href="<?php echo esc_attr($filter_link_url); ?>" title="<?php echo esc_attr($set_item->name); ?>"><?php echo esc_html($set_item->name); ?></a>
				</li> 
				<?php
					}
				?>
			</ul>
		</div>
	</div>
</div>
<?php
}
?>