<?php
/**
*	Get Current page object
**/
$page = get_page($post->ID);

/**
*	Get current page id
**/

if(!isset($current_page_id) && isset($page->ID))
{
    $current_page_id = $page->ID;
}

$page_menu_transparent = 0;
if(has_post_thumbnail($current_page_id, 'full'))
{
	$pp_page_bg = '';
	
	//Get page featured image
	if(has_post_thumbnail($current_page_id, 'original'))
    {
        $image_id = get_post_thumbnail_id($current_page_id); 
        $image_thumb = wp_get_attachment_image_src($image_id, 'original', true);
        
        if(isset($image_thumb[0]) && !empty($image_thumb[0]))
        {
        	$pp_page_bg = $image_thumb[0];
        }
        
        //Check if add parallax effect
		$tg_page_header_bg_parallax = kirki_get_option('tg_page_header_bg_parallax');
    }
    
    $grandphotography_topbar = grandphotography_get_topbar();
	$grandphotography_screen_class = grandphotography_get_screen_class();
?>
<div id="page_caption" class="<?php if(!empty($pp_page_bg)) { ?>hasbg <?php if(!empty($tg_page_header_bg_parallax)) { ?>parallax<?php } ?> <?php } ?> <?php if(!empty($grandphotography_topbar)) { ?>withtopbar<?php } ?> <?php if(!empty($grandphotography_screen_class)) { ?>split<?php } ?>" <?php if(!empty($pp_page_bg)) { ?>style="background-image:url(<?php echo esc_url($pp_page_bg); ?>);"<?php } ?>>
	
	<div class="page_title_wrapper">
		<div class="page_title_inner">
			<div class="page_title_content">
				<h1 <?php if(!empty($pp_page_bg) && !empty($grandphotography_topbar)) { ?>class ="withtopbar"<?php } ?>><?php the_title(); ?></h1>
				<?php
					$event_ID = get_the_ID();
				
					//Get event data
					$event_date = '';
					$event_from_time = '';
					$event_to_time = '';
					$event_location = '';
					
					$event_date = get_post_meta($event_ID, 'event_date');
					if(isset($event_date[0]))
					{
					    $event_date = $event_date[0];
					}
					
					$event_from_time = get_post_meta($event_ID, 'event_from_time');
					if(isset($event_from_time[0]))
					{
					    $event_from_time = $event_from_time[0];
					}
					
					$event_to_time = get_post_meta($event_ID, 'event_to_time');
					if(isset($event_to_time[0]))
					{
					    $event_to_time = $event_to_time[0];
					}
					
					$event_location = get_post_meta($event_ID, 'event_location');
					if(isset($event_location[0]))
					{
					    $event_location = $event_location[0];
					}
				
			    	if(!empty($event_date) OR !empty($event_location))
				    {
			    ?>
			    	<hr class="title_break bold"/>
			    	<div class="page_tagline">
			    		<?php echo date_i18n('D, F j', strtotime($event_date)); ?>
						<?php
						    if(!empty($event_from_time))
						    {
								echo esc_html($event_from_time);
							}
							
							if(!empty($event_from_time))
						    {
								echo ' - '.esc_html($event_to_time);
							}
						?>
						<?php
						    if(!empty($event_location))
						    {
						?>
							<br/><br/>
						    <i><?php echo esc_html($event_location); ?></i>
						<?php
						    }
						    //End if event location not empty
						?>
			    	</div>
			    <?php
			    	}
			    ?>
			</div>
		</div>
	</div>
</div>
<?php
}
?>

<!-- Begin content -->
<?php
$grandphotography_page_content_class = grandphotography_get_page_content_class();
?>
<div id="page_content_wrapper" class="<?php if(!empty($pp_page_bg)) { ?>hasbg <?php } ?><?php if(!empty($pp_page_bg) && !empty($grandphotography_topbar)) { ?>withtopbar <?php } ?><?php if(!empty($grandphotography_page_content_class)) { echo esc_attr($grandphotography_page_content_class); } ?>">