<?php
/**
 * The main template file for display single event page.
 *
 * @package WordPress
*/

get_header();

$grandphotography_topbar = grandphotography_get_topbar();

/**
*	Get current page id
**/

$current_page_id = $post->ID;

/**
*	Get current page id
**/

$current_page_id = $post->ID;

//Include custom header feature
get_template_part("/templates/template-event-header");
?>
    
    <div class="inner">

    	<!-- Begin main content -->
    	<div class="inner_wrapper">

	    	<div class="sidebar_content">
					
<?php
if (have_posts()) : while (have_posts()) : the_post();

	the_content();
	
?>
<br class="clear"/>
<?php
    //Get share button
    get_template_part("/templates/template-post-share");
?>
<br class="clear"/>
<?php
    //Get current time to filter upcoming events
	if(THEMEDEMO)
	{
	    $current_time = 0;
	}
	else
	{
	    $current_time = time()-(3600*24);
	}
	
	$args = array(
	    'post_type' => 'events',
	    'paged' => $paged,
	    'order' => 'ASC',
	    'orderby' => 'meta_value',
	    'suppress_filters' => 0,
	    'posts_per_page' => 3,
	    'meta_query' => array(
	        array(
	            'key' => 'event_date_raw',
	            'value' => $current_time,
	            'compare' => '>='
	        ),
	    )
	);
	
  	$my_query = new WP_Query($args);
  	$i_post = 1;
  	
  	if( $my_query->have_posts() ) {
 ?>
 	<hr class="double"/><br class="clear"/><br/>
  	<h6 class="subtitle"><span><?php echo esc_html_e('Upcoming Events', 'grandphotography' ); ?></span></h6><hr class="title_break"/><br class="clear"/>
  	<div class="post_related">
    <?php
       while ($my_query->have_posts()) : $my_query->the_post();
       
       $last_class = '';
       if($i_post%3==0)
       {
           $last_class = 'last';
       }
       
       $image_thumb = '';
    				
    	if(has_post_thumbnail(get_the_ID(), 'large'))
    	{
    	    $image_id = get_post_thumbnail_id(get_the_ID());
    	    $image_thumb = wp_get_attachment_image_src($image_id, 'large', true);
    	    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-blog', true);
    	}
    	
    	//Get event data
    	$event_ID = get_the_ID();
		$event_date = '';
		$event_from_time = '';
		$event_to_time = '';
		$event_location = '';
		
		$event_date = get_post_meta($event_ID, 'event_date');
		if(isset($event_date[0]))
		{
		    $event_date = $event_date[0];
		}
		
		$event_from_time = get_post_meta($event_ID, 'event_from_time');
		if(isset($event_from_time[0]))
		{
		    $event_from_time = $event_from_time[0];
		}
		
		$event_to_time = get_post_meta($event_ID, 'event_to_time');
		if(isset($event_to_time[0]))
		{
		    $event_to_time = $event_to_time[0];
		}
		
		$event_location = get_post_meta($event_ID, 'event_location');
		if(isset($event_location[0]))
		{
		    $event_location = $event_location[0];
		}
    ?>
       <div class="one_third <?php echo esc_attr($last_class); ?>">
    	   <!-- Begin each blog post -->
    		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    		
    			<div class="post_wrapper grid_layout">
    			
    				<div class="post_img small static">
    				 <a href="<?php the_permalink(); ?>">
    				 	<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="" class="" style="width:<?php echo esc_attr($small_image_url[1]); ?>px;height:<?php echo esc_attr($small_image_url[2]); ?>px;"/>
    				    </a>
    				</div>
    			    
    			    <div class="blog_grid_content">
    					<div class="post_header">
    					    <h6><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h6>
    					    <div class="post_detail single_post">
    						    <span class="post_info_date">
    						    	<?php
									    if(!empty($event_date) OR !empty($event_location))
									    {
									?>
									<div class="page_tagline"><?php echo date_i18n('D, F j', strtotime($event_date)); ?>
									<?php
									    if(!empty($event_from_time))
									    {
									    	echo esc_html($event_from_time);
									    }
									    
									    if(!empty($event_from_time))
									    {
									    	echo ' - '.esc_html($event_to_time);
									    }
									?>
									</div>
									<?php
									    }
									?>
    						    </span>
    						</div>
    					</div>
    			    </div>
    			    
    			</div>
    		
    		</div>
    		<!-- End each blog post -->
       </div>
     <?php
     		$i_post++;
     		endwhile;
     		
     		wp_reset_postdata();
     ?>
  	</div>
<?php
}
?>

<hr class="double"/><br/>

<?php	
if (comments_open($post->ID)) 
{
?>
<div class="fullwidth_comment_wrapper">
	<?php comments_template( '', true ); ?>
</div>
<?php
}
?>

<?php endwhile; endif; ?>
    	
    	</div>
    	
    		<div class="sidebar_wrapper">
    		
    			<div class="sidebar_top"></div>
    		
    			<div class="sidebar">
    			
    				<div class="content">
    					<?php
						    //Check if has buy ticket URL
						    $event_ticket_url = get_post_meta(get_the_ID(), 'event_ticket_url');
						    
						    if(!empty($event_ticket_url))
						    {
						?>
    					<a id="tg_buy_ticket" class="button medium" href="<?php echo esc_url($event_ticket_url[0]); ?>" target="_blank"><?php echo esc_html_e('Buy Ticket', 'grandphotography' ); ?></a>
						<?php
						    }
						?>

		    	    	<ul class="sidebar_widget">
		    	    	<li id="single_event_widget" class="widget widget_single_event_widget">
			    	        <h2 class="widgettitle"><span><?php esc_html_e('Summary', 'grandphotography' ); ?></span></h2>
			    	        <hr class="title_break"/>
			    	        
			    	        <?php
			    	        	//Get event data
			    	        	$event_ID = get_the_ID();
						    	$event_date = '';
						    	$event_from_time = '';
						    	$event_to_time = '';
						    	$event_location = '';
						    	
						    	$event_date = get_post_meta($event_ID, 'event_date');
						    	if(isset($event_date[0]))
						    	{
						    	    $event_date = $event_date[0];
						    	}
						    	
						    	$event_from_time = get_post_meta($event_ID, 'event_from_time');
						    	if(isset($event_from_time[0]))
						    	{
						    	    $event_from_time = $event_from_time[0];
						    	}
						    	
						    	$event_to_time = get_post_meta($event_ID, 'event_to_time');
						    	if(isset($event_to_time[0]))
						    	{
						    	    $event_to_time = $event_to_time[0];
						    	}
						    	
						    	$event_location = get_post_meta($event_ID, 'event_location');
						    	if(isset($event_location[0]))
						    	{
						    	    $event_location = $event_location[0];
						    	}
			    	        ?>
						    <div class="single_event_widget_info">
						    	<?php
						    	    if(!empty($event_date))
						    	    {
						    	?>
						    	<div class="single_event_widget_row">
						    		<div class="one_third event_label">
						    			<a href="javascript:;" class="tooltip" title="<?php esc_html_e('Date & Time for this event', 'grandphotography' ); ?>"><i class="fa fa-clock-o"></i><?php esc_html_e('When', 'grandphotography' ); ?></a>
						    		</div>
						    		
						    		<div class="two_third last">
						    			<?php echo date_i18n('D, F j', strtotime($event_date)); ?>
						    			<?php
						    			    if(!empty($event_from_time))
						    			    {
						    					echo esc_html($event_from_time);
						    				}
						    				
						    				if(!empty($event_from_time))
						    			    {
						    					echo ' - '.esc_html($event_to_time);
						    				}
						    			?>
						    		</div>
						    	</div>
						    	<br class="clear"/>
						    	<?php
						    		}
						    	?>
						    	
						    	<?php
						    	    if(!empty($event_location))
						    	    {
						    	?>
						    	<div class="single_event_widget_row">
						    		<div class="one_third event_label">
						    			<a href="javascript:;" class="tooltip" title="<?php esc_html_e('Address for this event', 'grandphotography' ); ?>"><i class="fa fa-map-marker"></i><?php esc_html_e('Where', 'grandphotography' ); ?></a>
						    		</div>
						    		
						    		<div class="two_third last">
						    			<?php echo esc_html($event_location); ?>
						    			
						    			<?php
						    				$event_get_direction = get_post_meta(get_the_ID(), 'event_get_direction');
						    				
						    	    		//Check if display get direction from google map
						    	    		if(!empty($event_get_direction))
						    	    		{
						    	    	?>
						    	    	<br class="clear"/>
						    	    	<div class="post_button_wrapper textalignleft">
						    				<a class="readmore" target="_blank" href="https://maps.google.com?saddr=Current+Location&daddr=<?php echo urlencode($event_location); ?>"><?php echo esc_html_e('Get Directions', 'grandphotography' ); ?> →</a>
						    			</div>
						    	    	<?php
						    	    		}
						    	    	?>
						    		</div>
						    	</div>
						    	<br class="clear"/>
						    	<?php
						    		}
						    	?>
						    </div>
		    	    	</li>
		    	    	<?php dynamic_sidebar('single-event-sidebar'); ?>
		    	    	</ul>
    				
    				</div>
    		
    			</div>
    			<br class="clear"/>
    	
    			<div class="sidebar_bottom"></div>
    		</div>
    
    </div>
    <!-- End main content -->
   
</div>

</div>
<?php get_footer(); ?>