<?php
/**
 * Template Name: Page With Background Image
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
if(!is_null($post))
{
	$page_obj = get_page($post->ID);
}

$current_page_id = '';

/**
*	Get current page id
**/

if(!is_null($post) && isset($page_obj->ID))
{
    $current_page_id = $page_obj->ID;
}

$grandphotography_homepage_style = grandphotography_get_homepage_style();
grandphotography_set_homepage_style('fullscreen');

get_header(); 
?>

<br class="clear"/>

<?php
//Get background image
$image_thumb = '';

if(has_post_thumbnail($current_page_id, 'original'))
{
	$image_id = get_post_thumbnail_id($current_page_id); 
    $image_id = get_post_thumbnail_id($current_page_id); 
    $image_thumb = wp_get_attachment_image_src($image_id, 'original', true);
}
?>
<div class="password_container" <?php if(isset($image_thumb[0]) && !empty($image_thumb[0])) { ?>style="background-image:url(<?php echo esc_url($image_thumb[0]); ?>);"<?php }?>>
    <div class="password_wrapper">
    	<!-- Begin main content -->
        <div class="vertical_center_wrapper transparentbg" style="text-align:center">
    	    <div class="overlay_gallery_wrapper fullwidth">
    		    <div class="overlay_gallery_border">
    			    <div class="overlay_gallery_content">
    			    	<?php
    			    		$page_show_title = get_post_meta($current_page_id, 'page_show_title', true);
    			    		
    			    		if(empty($page_show_title))
    			    		{
    			    	?>
    					<h1><?php the_title(); ?></h1>
    				    
    				    <?php
    				    	//Get current page tagline
							$page_tagline = get_post_meta($current_page_id, 'page_tagline', true);
    				    
					    	if(!empty($page_tagline))
					    	{
					    ?>
					    	<hr class="title_break bold"/>
					    	<div class="page_tagline">
					    		<?php echo nl2br($page_tagline); ?>
					    	</div>
					    <?php
					    	}
					    ?>
					    <?php
					    	}
					    ?>
					    
					    <div class="overlay_content">
					    <?php 
			    			if ( have_posts() ) {
			    		    while ( have_posts() ) : the_post(); ?>		
			    	
			    		    <?php the_content(); break;  ?>
			
			    		<?php endwhile; 
			    		}
			    		?>
					    </div>
    			    </div>
    		    </div>
    	    </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>