<?php
require_once get_template_directory() . "/modules/class-tgm-plugin-activation.php";
add_action( 'tgmpa_register', 'grandphotography_require_plugins' );
 
function grandphotography_require_plugins() {
 
    $plugins = array(
	    array(
	        'name'               => 'Grand Photography Theme Custom Post Type',
	        'slug'      		=> 'grandphotography-custom-post',
	        'source'             => get_template_directory() . '/lib/plugins/grandphotography-custom-post.zip',
	        'required'           => true, 
	        'version'            => '2.2',
	    ),
	    array(
	        'name'               => 'One Click Demo Import',
	        'slug'      		 => 'one-click-demo-import',
	        'required'           => true, 
	    ),
	    array(
	        'name'               => 'Revolution Slider',
	        'slug'      		=> 'revslider',
	        'source'             => get_template_directory() . '/lib/plugins/revslider.zip',
	        'required'           => true, 
	        'version'            => '6.2.23',
	    ),
	    array(
	        'name'               => 'Envato Market',
	        'slug'               => 'envato-market',
	        'source'             => get_template_directory() . '/lib/plugins/envato-market.zip',
	        'required'           => true, 
	        'version'            => '2.0.5',
	    ),
	    array(
	        'name'      => 'Post Views Counter',
	        'slug'      => 'post-views-counter',
	        'required'  => true, 
	    ),
	    array(
	        'name'      => 'Posts Social Shares Count',
	        'slug'      => 'posts-social-shares-count',
	        'source'    => get_template_directory() . '/lib/plugins/posts-social-shares-count.zip',
	        'required'  => false, 
	        'version'   => '1.4.1.2',
	    ),
	    array(
	        'name'      => 'Multiple Post Thumbnails',
	        'slug'      => 'multiple-post-thumbnails',
	        'required'  => true, 
	    ),
	    array(
	        'name'      => 'Post Types Order',
	        'slug'      => 'post-types-order',
	        'required'  => false, 
	    ),
	    array(
	        'name'      => 'MailChimp for WordPress',
	        'slug'      => 'mailchimp-for-wp',
	        'required'  => true, 
	    ),
	    array(
	        'name'      => 'WooCommerce',
	        'slug'      => 'woocommerce',
	        'required'  => true, 
	    ),
	    array(
	        'name'      => 'Easy Watermark',
	        'slug'      => 'easy-watermark',
	        'required'  => false, 
	    ),
	    array(
	        'name'      => 'Meks Easy Photo Feed Widget',
	        'slug'      => 'meks-easy-instagram-widget',
	        'required'  => false, 
	    ),
	);
	
	//If theme demo site add other plugins
	if(THEMEDEMO)
	{
		$plugins[] = array(
			'name'      => 'Disable Comments',
	        'slug'      => 'disable-comments',
	        'required'  => false, 
		);
		
		$plugins[] = array(
			'name'      => 'Customizer Export/Import',
	        'slug'      => 'customizer-export-import',
	        'required'  => false, 
		);
		
		$plugins[] = array(
			'name'      => 'Display All Image Sizes',
	        'slug'      => 'display-all-image-sizes',
	        'required'  => false, 
		);
		
		$plugins[] = array(
			'name'      => 'Easy Theme and Plugin Upgrades',
	        'slug'      => 'easy-theme-and-plugin-upgrades',
	        'required'  => false, 
		);
		
		$plugins[] = array(
			'name'      => 'Widget Importer & Exporter',
	        'slug'      => 'grandphotography',
	        'required'  => false, 
		);
		
		$plugins[] = array(
	        'name'      => 'Imsanity',
	        'slug'      => 'imsanity',
	        'required'  => false, 
	    );
		
		$plugins[] = array(
			'name'      => 'WP Super Cache',
	        'slug'      => 'wp-super-cache',
	        'required'  => false, 
		);
		
		$plugins[] = array(
			'name'      => 'Go Live Update URLs',
	        'slug'      => 'go-live-update-urls',
	        'required'  => false, 
		);
		
		$plugins[] = array(
			'name'      => 'Widget Clone',
	        'slug'      => 'widget-clone',
	        'required'  => false, 
		);
	}
	
	$config = array(
		'domain'	=> 'grandphotography',
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'install-required-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'is_automatic' => true,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'          => array(
	        'page_title'                      => esc_html__('Install Required Plugins', 'grandphotography' ),
	        'menu_title'                      => esc_html__('Install Plugins', 'grandphotography' ),
	        'installing'                      => esc_html__('Installing Plugin: %s', 'grandphotography' ),
	        'oops'                            => esc_html__('Something went wrong with the plugin API.', 'grandphotography' ),
	        'return'                          => esc_html__('Return to Required Plugins Installer', 'grandphotography' ),
	        'plugin_activated'                => esc_html__('Plugin activated successfully.', 'grandphotography' ),
	        'complete'                        => esc_html__('All plugins installed and activated successfully. %s', 'grandphotography' ),
	        'nag_type'                        => 'update-nag'
	    )
    );
 
    tgmpa( $plugins, $config );
}
?>