<?php
//Setup theme constant and default data
$theme_obj = wp_get_theme('grandphotography');

define("THEMENAME", $theme_obj['Name']);
if (!defined('THEMEDEMO'))
{
	define("THEMEDEMO", false);
}
define("THEMEDEMOIG", 'kinfolklifestyle');
define("DEMOGALLERYID", 'gallery-archive');
define("DEMOPORTFOLIOSETID", 'video');
define("DEMOPORTFOLIOSETEXCLUDE", 37);
define("SHORTNAME", "pp");
define("SKINSHORTNAME", "ps");
define("THEMEVERSION", $theme_obj['Version']);
define("THEMEDEMOURL", $theme_obj['ThemeURI']);
define("THEMEDATEFORMAT", get_option('date_format'));
define("THEMETIMEFORMAT", get_option('time_format'));
define("ENVATOITEMID", 18556524);
define("BUILDERDOCURL", 'https://themes.themegoods.com/grandphotography/doc/create-a-page-using-content-builder-2/');

//Get default WP uploads folder
$wp_upload_arr = wp_upload_dir();
define("THEMEUPLOAD", $wp_upload_arr['basedir']."/".strtolower(sanitize_title(THEMENAME))."/");
define("THEMEUPLOADURL", $wp_upload_arr['baseurl']."/".strtolower(sanitize_title(THEMENAME))."/");

if(!is_dir(THEMEUPLOAD))
{
	wp_mkdir_p(THEMEUPLOAD);
}

/**
*  Begin Global variables functions
*/

//Get default WordPress post variable
function grandphotography_get_wp_post() {
	global $post;
	return $post;
}

//Get default WordPress file system variable
function grandphotography_get_wp_filesystem() {
	require_once(ABSPATH . 'wp-admin/includes/file.php');
	WP_Filesystem();
	global $wp_filesystem;
	return $wp_filesystem;
}

//Get default WordPress wpdb variable
function grandphotography_get_wpdb() {
	global $wpdb;
	return $wpdb;
}

//Get default WordPress wp_query variable
function grandphotography_get_wp_query() {
	global $wp_query;
	return $wp_query;
}

//Get default WordPress customize variable
function grandphotography_get_wp_customize() {
	global $wp_customize;
	return $wp_customize;
}

//Get default WordPress current screen variable
function grandphotography_get_current_screen() {
	global $current_screen;
	return $current_screen;
}

//Get default WordPress paged variable
function grandphotography_get_paged() {
	global $paged;
	return $paged;
}

//Get default WordPress registered widgets variable
function grandphotography_get_registered_widget_controls() {
	global $wp_registered_widget_controls;
	return $wp_registered_widget_controls;
}

//Get default WordPress registered sidebars variable
function grandphotography_get_registered_sidebars() {
	global $wp_registered_sidebars;
	return $wp_registered_sidebars;
}

//Get default Woocommerce variable
function grandphotography_get_woocommerce() {
	global $woocommerce;
	return $woocommerce;
}

//Get all google font usages in customizer
function grandphotography_get_google_fonts() {
	$grandphotography_google_fonts = array('tg_body_font', 'tg_header_font', 'tg_menu_font', 'tg_sidemenu_font', 'tg_sidebar_title_font', 'tg_button_font');
	
	global $grandphotography_google_fonts;
	return $grandphotography_google_fonts;
}

//Get menu transparent variable
function grandphotography_get_page_menu_transparent() {
	global $grandphotography_page_menu_transparent;
	return $grandphotography_page_menu_transparent;
}

//Set menu transparent variable
function grandphotography_set_page_menu_transparent($new_value = '') {
	global $grandphotography_page_menu_transparent;
	$grandphotography_page_menu_transparent = $new_value;
}

//Get no header checker variable
function grandphotography_get_is_no_header() {
	global $grandphotography_is_no_header;
	return $grandphotography_is_no_header;
}

//Get deafult theme screen CSS class
function grandphotography_get_screen_class() {
	global $grandphotography_screen_class;
	return $grandphotography_screen_class;
}

//Set deafult theme screen CSS class
function grandphotography_set_screen_class($new_value = '') {
	global $grandphotography_screen_class;
	$grandphotography_screen_class = $new_value;
}

//Get theme homepage style
function grandphotography_get_homepage_style() {
	global $grandphotography_homepage_style;
	return $grandphotography_homepage_style;
}

//Set theme homepage style
function grandphotography_set_homepage_style($new_value = '') {
	global $grandphotography_homepage_style;
	$grandphotography_homepage_style = $new_value;
}

//Get page gallery ID
function grandphotography_get_page_gallery_id() {
	global $grandphotography_page_gallery_id;
	return $grandphotography_page_gallery_id;
}

//Get default theme options variable
function grandphotography_get_options() {
	global $grandphotography_options;
	return $grandphotography_options;
}

//Set default theme options variable
function grandphotography_set_options($new_value = '') {
	global $grandphotography_options;
	$grandphotography_options = $new_value;
}

//Get top bar setting
function grandphotography_get_topbar() {
	global $grandphotography_topbar;
	return $grandphotography_topbar;
}

//Set top bar setting
function grandphotography_set_topbar($new_value = '') {
	global $grandphotography_topbar;
	$grandphotography_topbar = $new_value;
}

//Get is hide title option
function grandphotography_get_hide_title() {
	global $grandphotography_hide_title;
	return $grandphotography_hide_title;
}

//Set is hide title option
function grandphotography_set_hide_title($new_value = '') {
	global $grandphotography_hide_title;
	$grandphotography_hide_title = $new_value;
}

//Get theme page content CSS class
function grandphotography_get_page_content_class() {
	global $grandphotography_page_content_class;
	return $grandphotography_page_content_class;
}

//Set theme page content CSS class
function grandphotography_set_page_content_class($new_value = '') {
	global $grandphotography_page_content_class;
	$grandphotography_page_content_class = $new_value;
}

//Get theme portfolio filterable header
function grandphotography_get_portfolio_filterable_header() {
	global $grandphotography_get_portfolio_filterable_header;
	return $grandphotography_get_portfolio_filterable_header;
}

//Set heme portfolio filterable header
function grandphotography_set_portfolio_filterable_header($new_value = '') {
	global $grandphotography_get_portfolio_filterable_header;
	$grandphotography_get_portfolio_filterable_header = $new_value;
}

//Get Kirki global variable
function grandphotography_get_kirki() {
	global $kirki;
	return $kirki;
}

//Get admin theme global variable
function grandphotography_get_wp_admin_css_colors() {
	global $_wp_admin_css_colors;
	return $_wp_admin_css_colors;
}

//Get theme plugins
function grandphotography_get_plugins() {
	global $grandphotography_tgm_plugins;
	return $grandphotography_tgm_plugins;
}

//Set theme plugins
function grandphotography_set_plugins($new_value = '') {
	global $grandphotography_tgm_plugins;
	$grandphotography_tgm_plugins = $new_value;
}

//Get page custom fields values
function grandphotography_get_page_postmetas() {
	//Get all sidebars
	$theme_sidebar = array(
		'' => '',
		'Page Sidebar' => 'Page Sidebar', 
		'Contact Sidebar' => 'Contact Sidebar', 
		'Blog Sidebar' => 'Blog Sidebar',
	);
	
	$dynamic_sidebar = get_option('pp_sidebar');
	
	if(!empty($dynamic_sidebar))
	{
		foreach($dynamic_sidebar as $sidebar)
		{
			$theme_sidebar[$sidebar] = $sidebar;
		}
	}
	
	/*
		Get gallery list
	*/
	$args = array(
	    'numberposts' => -1,
	    'post_type' => array('galleries'),
	);
	
	$galleries_arr = get_posts($args);
	$galleries_select = array();
	$galleries_select['(Display Post Featured Image)'] = '';
	
	foreach($galleries_arr as $gallery)
	{
		$galleries_select[$gallery->ID] = $gallery->post_title;
	}
	
	/*
		Get page templates list
	*/
	if(function_exists('get_page_templates'))
	{
		$page_templates = get_page_templates();
		$page_templates_select = array();
		$page_key = 1;
		
		foreach ($page_templates as $template_name => $template_filename) 
		{
			$page_templates_select[$template_name] = get_template_directory_uri()."/functions/images/page/".basename($template_filename, '.php').".png";
			$page_key++;
		}
	}
	else
	{
		$page_templates_select = array();
	}
	
	/*
		Get all menus available
	*/
	$menus = get_terms('nav_menu');
	$menus_select = array(
		 '' => 'Default Menu'
	);
	foreach($menus as $each_menu)
	{
		$menus_select[$each_menu->slug] = $each_menu->name;
	}
	
	$grandphotography_page_postmetas = array();
	$pp_menu_layout = get_option('pp_menu_layout');
		
	if($pp_menu_layout != 'leftmenu')
	{
	    $grandphotography_page_postmetas[99] = array("section" => "Page Menu", "id" => "page_menu_transparent", "type" => "checkbox", "title" => "Make Menu Transparent", "description" => "Check this option if you want to display main menu in transparent");
	}
	
	$grandphotography_page_postmetas_extended = 
		array (
			/*
				Begin Page custom fields
			*/
			array("section" => "Page Template", "id" => "page_custom_template", "type" => "template", "title" => "Page Template", "description" => "Select template for this page", "items" => $page_templates_select),
			
			array("section" => "Page Title", "id" => "page_show_title", "type" => "checkbox", "title" => "Hide Default Page Header", "description" => "Check this option if you want to hide default page header"),
			
			array("section" => "Page Tagline", "id" => "page_tagline", "type" => "textarea", "title" => "Page Tagline (Optional)", "description" => "Enter page tagline. It will displays under page title (*Note: HTML code also support)"),
			
			array("section" => "Select Sidebar (Optional)", "id" => "page_sidebar", "type" => "select", "title" => "Page Sidebar (Optional)", "description" => "Select this page's sidebar to display. To use this option, you have to select page template end with \"Sidebar\" only</strong>", "items" => $theme_sidebar),
			
			array("section" => "Select Menu", "id" => "page_menu", "type" => "select", "title" => "Page Menu (Optional)", "description" => "Select this page's menu if you want to display main menu other than default one", "items" => $menus_select),
			
			array("section" => "Content Type", "id" => "page_gallery_id", "type" => "select", "title" => "Gallery", "description" => "You can select image gallery to display on this page. To use this option, you have to select Gallery as page template.", "items" => $galleries_select),
			
			array("section" => "Vimeo Video ID", "id" => "page_ft_vimeo", "type" => "text", "title" => "Vimeo Video ID", "description" => "Please enter Vimeo Video ID for example 73317780 (*Note enter if you select \"Vimeo Video\" as Featured Content Type)"),
				
			array("section" => "Youtube Video ID", "id" => "page_ft_youtube", "type" => "text", "title" => "Youtube Video ID", "description" => "Please enter Youtube Video ID for example 6AIdXisPqHc (*Note enter if you select \"Youtube Video\" as Featured Content Type)"),
		);
	
	
	$grandphotography_page_postmetas = $grandphotography_page_postmetas + $grandphotography_page_postmetas_extended;
		
	return $grandphotography_page_postmetas;
}
?>