<?php
/**
 * The main template file for display gallery fullscreen.
 *
 * @package WordPress
 */

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandphotography_page_gallery_id = grandphotography_get_page_gallery_id();
if(!empty($grandphotography_page_gallery_id))
{
	$current_page_id = $grandphotography_page_gallery_id;
}

//Check if password protected
get_template_part("/templates/template-password");

$grandphotography_homepage_style = grandphotography_get_homepage_style();

$tg_full_menu_transparent = kirki_get_option('tg_full_menu_transparent');

if(THEMEDEMO && isset($_GET['nocrop']) && !empty($_GET['nocrop']))
{
    $tg_full_menu_transparent = '';
}

if(empty($tg_full_menu_transparent))
{
	$grandphotography_homepage_style = 'fullscreen_white';
}
else
{
	$grandphotography_homepage_style = 'fullscreen';
}
grandphotography_set_homepage_style($grandphotography_homepage_style);

get_header();

$nocrop_query = '';
if(THEMEDEMO && isset($_GET['nocrop']))
{
	$nocrop_query.= '&nocrop=1';
}

//Run gallery script data
wp_enqueue_style("supersized", get_template_directory_uri()."/css/supersized.css", false, THEMEVERSION, "all");

wp_enqueue_script("supersized", get_template_directory_uri()."/js/supersized.3.2.7.min.js", false, THEMEVERSION, true);
wp_enqueue_script("supersized-shutter", get_template_directory_uri()."/js/supersized.shutter.min.js", false, THEMEVERSION, true);
wp_enqueue_script("touchwipe", get_template_directory_uri()."/js/jquery.touchwipe.1.1.1.js", false, THEMEVERSION, true);
wp_enqueue_script("grandphotography-supersized-gallery", admin_url('admin-ajax.php')."?action=grandphotography_script_supersized_gallery&gallery_id=".$current_page_id.$nocrop_query, false, THEMEVERSION, true);
?>
<?php
	$tg_full_arrow = kirki_get_option('tg_full_arrow');
	
	if(!empty($tg_full_arrow))
	{
?>
<div id="thumb-tray" class="load-item">
    <a id="prevslide" class="load-item"></a>
    <a id="nextslide" class="load-item"></a>
</div>
<?php
	}
	else
	{
?>
<a id="nextslide" class="load-item"></a>
<?php
	}
?>

<div id="controls-wrapper" class="load-item">
	<div id="controls">
	    <?php
	        $tg_full_image_caption = kirki_get_option('tg_full_image_caption');
	        if(!empty($tg_full_image_caption))
	        {
	    ?>
	        <!--Slide captions displayed here--> 
	        <div id="slidecaption"></div>
	    <?php
	        }
	    ?>
	</div>
</div>

<?php
	get_footer();
?>