<?php
/**
 * Template Name: Gallery Archive Fullscreen Split Screen
 * The main template file for display gallery page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$ob_page = get_page($post->ID);
$current_page_id = '';

if(isset($ob_page->ID))
{
    $current_page_id = $ob_page->ID;
}

//important to apply dynamic header & footer style
$grandphotography_homepage_style = grandphotography_get_homepage_style();

get_header();

wp_enqueue_style("grandphotography-jquery-fullpage", get_template_directory_uri()."/css/jquery.fullPage.css", false, THEMEVERSION, "all");
wp_enqueue_script("grandphotography-jquery-fullpage", get_template_directory_uri()."/js/jquery.fullPage.min.js", false, THEMEVERSION, true);
wp_enqueue_script("grandphotography-custom-fullpage", get_template_directory_uri()."/js/custom_fullpage.js", false, THEMEVERSION, true);
?>

<?php
	$grandphotography_hide_title = grandphotography_get_hide_title();
	grandphotography_set_hide_title(1);
	
	$grandphotography_page_content_class = grandphotography_get_page_content_class();
	grandphotography_set_page_content_class('wide');

    //Include custom header feature
	get_template_part("/templates/template-header");
?>

<!-- Begin content -->   
<div id="fullpage" class="split">
	
	<?php
	    //Get galleries
	    $wp_query = grandphotography_get_wp_query();
	    
	    $query_string = 'paged='.$paged.'&orderby=menu_order&order=ASC&post_type=galleries&posts_per_page=-1&suppress_filters=0&meta_key=_thumbnail_id';
	    
	    if(!empty($term))
	    {
	        $query_string .= '&gallerycat='.$term;
	    }
	    
	    if(THEMEDEMO && empty($term))
	    {
		    $query_string .= '&gallerycat='.DEMOGALLERYID;
	    }

	    query_posts($query_string);
	
	    $key = 0;
	    if (have_posts()) : while (have_posts()) : the_post();
	    	$small_image_url = array();
	        $image_url = '';
	        $gallery_ID = get_the_ID();
	        		
	        if(has_post_thumbnail($gallery_ID, 'original'))
	        {
	            $image_id = get_post_thumbnail_id($gallery_ID);
	            $small_image_url = wp_get_attachment_image_src($image_id, 'original', true);
	        }
	        
	        $permalink_url = get_permalink($gallery_ID);
	        $content_class = 'even';
	        
		    if(!empty($small_image_url[0]))
		    {
		?>	
		    <div class="section gallery_archive">
		    	<a href="<?php echo esc_url($permalink_url); ?>">
		    		<div class="background_image split <?php echo esc_attr($content_class); ?>" style="background-image: url('<?php echo esc_url($small_image_url[0]); ?>');"></div>
		    	</a>
		    	<div class="gallery_archive_info split <?php echo esc_attr($content_class); ?>">
		    		<div class="gallery_archive_info_wrapper">
		    			<div class="gallery_archive_info_content">
							<h2><?php the_title(); ?></h2>
							<hr class="title_break bold"/>
							<div class="page_tagline">
								<?php the_excerpt(); ?>
							</div>
							
							<?php
								//Get share button
								get_template_part("/templates/template-post-share");
	    					?>
		    			</div>
		    		</div>
		    	</div>
		    </div>
		<?php
		    }

	    $key++;
	    endwhile; endif;	
	?>
	
</div>
<?php get_footer(); ?>
<!-- End content -->