<?php
/**
 * Template Name: Event 4 Columns
 * The main template file for display event page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
if(!is_null($post))
{
	$page_obj = get_page($post->ID);
}

$current_page_id = '';

/**
*	Get current page id
**/

if(!is_null($post) && isset($page_obj->ID))
{
    $current_page_id = $page_obj->ID;
}

get_header();

$is_display_page_content = TRUE;
$is_standard_wp_post = FALSE;

if(is_tag())
{
    $is_display_page_content = FALSE;
    $is_standard_wp_post = TRUE;
} 
elseif(is_category())
{
    $is_display_page_content = FALSE;
    $is_standard_wp_post = TRUE;
}
elseif(is_archive())
{
    $is_display_page_content = FALSE;
    $is_standard_wp_post = TRUE;
} 

$grandphotography_page_content_class = grandphotography_get_page_content_class();
grandphotography_set_page_content_class('wide photoframe');

//Include custom header feature
get_template_part("/templates/template-header");

wp_enqueue_script("grandphotography-custom-grid-portfolio-click", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=4&id=portfolio_filter_wrapper&gutter=30&photoframe=1"), false, THEMEVERSION, true);
?>
    
    <div class="inner">

    	<!-- Begin main content -->
    	<div class="inner_wrapper">
    		
    		<div class="sidebar_content full_width blog_f">

	    		<?php if ( have_posts() && $is_display_page_content) while ( have_posts() ) : the_post(); ?>		
					
		    		<div class="page_content_wrapper"><?php the_content(); ?></div>
		
		    	<?php endwhile; ?>
<div id="page_main_content" class="sidebar_content full_width fixed_column photoframe">

<div class="standard_wrapper">

<div id="portfolio_filter_wrapper" class="gallery four_cols portfolio-content section content clearfix" data-columns="4">				
<?php 
if(is_front_page())
{
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
}
else
{
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
}

//If theme built-in blog template then add query

if(!$is_standard_wp_post)
{
    //Get current time to filter upcoming events
    if(THEMEDEMO)
	{
	    $current_time = 0;
	}
	else
	{
	    $current_time = time()-(3600*24);
	}
    
    $args = array(
	    'post_type' => 'events',
	    'paged' => $paged,
	    'order' => 'ASC',
	    'orderby' => 'meta_value',
	    'suppress_filters' => 0,
	    'meta_query' => array(
	        array(
	            'key' => 'event_date_raw',
	            'value' => $current_time,
	            'compare' => '>='
	        ),
	    )
	);
	
	if(THEMEDEMO)
    {
	    $args['posts_per_page'] = 8;
    }
    
    query_posts($args);
}

$wp_query = grandphotography_get_wp_query();
$post_counter = 0;
$post_counts = $wp_query->post_count;

if (have_posts()) : while (have_posts()) : the_post();

	$image_thumb = '';
	$small_image_url = '';
	$event_ID = get_the_ID();
								
	if(has_post_thumbnail($event_ID, 'large'))
	{
	    $image_id = get_post_thumbnail_id($event_ID);
	    $image_url = wp_get_attachment_image_src($image_id, 'large', true);
	    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
	}
	
	$permalink_url = get_permalink($event_ID);
	$post_counter++;

	//Get event data
	$event_date = '';
	$event_from_time = '';
	$event_to_time = '';
	$event_location = '';
	
	$event_date = get_post_meta($event_ID, 'event_date');
	if(isset($event_date[0]))
	{
	    $event_date = $event_date[0];
	}
	
	$event_from_time = get_post_meta($event_ID, 'event_from_time');
	if(isset($event_from_time[0]))
	{
	    $event_from_time = $event_from_time[0];
	}
	
	$event_to_time = get_post_meta($event_ID, 'event_to_time');
	if(isset($event_to_time[0]))
	{
	    $event_to_time = $event_to_time[0];
	}
	
	$event_location = get_post_meta($event_ID, 'event_location');
	if(isset($event_location[0]))
	{
	    $event_location = $event_location[0];
	}
?>
<div class="element grid photoframe classic4_cols animated<?php echo esc_attr($post_counter); ?>">
	<div class="one_fourth gallery4 classic static filterable portfolio_type" data-id="post-<?php echo esc_attr($post_counter); ?>">
	    <?php 
	    	if(!empty($image_url[0]))
	    	{
	    ?>
	    	<a href="<?php echo esc_url(get_permalink($event_ID)); ?>">
        		<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
        		
        		<?php
					//Check if has buy ticket URL
					$event_ticket_url = get_post_meta($event_ID, 'event_ticket_url');
					
					if(!empty($event_ticket_url))
					{
				?>
        			<div class="portfolio_type_wrapper tooltip" title="<?php esc_html_e('Buy Ticket', 'grandphotography' ); ?>"><i class="fa fa-ticket"></i></div>
        		<?php
        			}
        		?>
		    </a>
	    <?php
	    	}
	    ?>
	    <div class="gallery_info_wrapper">
        	<h7><?php echo get_the_title(); ?></h7>
        	
        	<?php
			    if(!empty($event_date) OR !empty($event_location))
			    {
			?>
			<div class="page_tagline"><?php echo date_i18n('D, F j', strtotime($event_date)); ?>
			<?php
			    if(!empty($event_from_time))
			    {
					echo esc_html($event_from_time);
				}
				
				if(!empty($event_from_time))
			    {
					echo ' - '.esc_html($event_to_time);
				}
			?>
			<?php
			    if(!empty($event_location))
			    {
			?>
				<br/><br/>
			    <i><?php echo esc_html($event_location); ?></i>
			<?php
			    }
			    //End if event location not empty
			?>
			</div>
			<?php
			    }
			?>
		</div>
	</div>
</div>
<?php endwhile; endif; ?>
</div>  
</div>

    	<?php
		    if($wp_query->max_num_pages > 1)
		    {
		?>
		<div class="standard_wrapper">
		<?php
		    	if (function_exists("grandphotography_pagination")) 
		    	{
		?>
				<br class="clear"/><br/><br/>
		<?php
		    	    grandphotography_pagination($wp_query->max_num_pages);
		    	}
		    	else
		    	{
		    	?>
		    	    <div class="pagination"><p><?php posts_nav_link(' '); ?></p></div>
		    	<?php
		    	}
		    ?>
		    <div class="pagination_detail">
		     	<?php
		     		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		     	?>
		     	<?php esc_html_e('Page', 'grandphotography' ); ?> <?php echo esc_html($paged); ?> <?php esc_html_e('of', 'grandphotography' ); ?> <?php echo esc_html($wp_query->max_num_pages); ?>
		     </div>
		</div>
		<?php
		   }
		?>
    		
    	</div>
    	
    </div>
    <!-- End main content -->

</div>
</div>
</div>
<?php get_footer(); ?>