<?php
/**
 * Template Name: Client Archive
 * The main template file for display clients page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
if(!is_null($post))
{
	$page_obj = get_page($post->ID);
}

$current_page_id = '';

/**
*	Get current page id
**/

if(!is_null($post) && isset($page_obj->ID))
{
    $current_page_id = $page_obj->ID;
}

get_header();

$grandphotography_page_content_class = grandphotography_get_page_content_class();
grandphotography_set_page_content_class('wide');

//Include custom header feature
get_template_part("/templates/template-header");

wp_enqueue_script("grandphotography-custom-grid-client", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=3&id=portfolio_filter_wrapper&gutter=30&photoframe=1"), false, THEMEVERSION, true);
?>

<!-- Begin content -->
<?php
	//Get all portfolio items for paging
	$wp_query = grandphotography_get_wp_query();
	
	$query_string = 'orderby=menu_order&order=ASC&post_type=clients&numberposts=-1&suppress_filters=0&posts_per_page=-1';
	query_posts($query_string);
?>
    
<div class="inner">

	<div class="inner_wrapper nopadding">
	
	<?php
	    if(!empty($post->post_content) && empty($term))
	    {
	?>
	    <div class="standard_wrapper"><?php echo grandphotography_apply_content($post->post_content); ?></div><br class="clear"/><br/>
	<?php
	    }
	    elseif(!empty($term) && !empty($ob_term->description))
	    { 
	?>
	    <div class="standard_wrapper"><?php echo esc_html($ob_term->description); ?></div><br class="clear"/><br/>
	<?php
	    }
	?>
	
	<div id="page_main_content" class="sidebar_content full_width fixed_column photoframe">
	
	<div id="portfolio_filter_wrapper" class="gallery three_cols portfolio-content section content clearfix" data-columns="3">
	
	<?php
		$key = 0;
		if (have_posts()) : while (have_posts()) : the_post();
			$key++;
			$image_url = '';
			$client_ID = get_the_ID();
					
			if(has_post_thumbnail($client_ID, 'grandphotography-gallery-grid'))
			{
			    $image_id = get_post_thumbnail_id($client_ID);
			    $client_thumbnail = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
			}
			
			$permalink_url = get_permalink($client_ID);
			
			$client_galleries = get_post_meta($client_ID, 'client_galleries', true);
			$client_password = get_post_meta($client_ID, 'client_password', true);
			
			if(isset($client_thumbnail[0]) && !empty($client_thumbnail[0]))
		    {
	?>
	
<div class="element grid photoframe classic3_cols animated<?php echo esc_attr($key); ?>">
	
	<div class="one_third gallery3 classic static filterable portfolio_type" data-id="post-<?php echo esc_attr($key); ?>">
	
		<a href="<?php echo esc_url($permalink_url); ?>">
            <img src="<?php echo esc_url($client_thumbnail[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
            
            <?php
            	if(!empty($client_password))
            	{
            ?>
            	<div class="portfolio_type_wrapper"><i class="fa fa-lock"></i></div>
            <?php
            	}
            ?>
		</a>
		
		<div class="gallery_info_wrapper">
            <h6><?php echo get_the_title(); ?></h6>
            <div class="page_tagline">
            	<?php 
            		$client_galleries_count = count($client_galleries);
            		
            		if($client_galleries_count > 1)
            		{
	            		echo intval($client_galleries_count).' '.esc_html__('galleries', 'grandphotography' );
            		}
            		else
            		{
	            		echo intval($client_galleries_count).' '.esc_html__('gallery', 'grandphotography' );
            		}
            	?>
            </div>
		</div>

	</div>
</div>
	<?php
			}
		endwhile; endif;
	?>
		
	</div>
	
	</div>

</div>
</div>

</div>
<?php get_footer(); ?>
<!-- End content -->