<?php
/**
 * The main template file for 404 not found page
 *
 * @package WordPress
*/

$grandphotography_homepage_style = grandphotography_get_homepage_style();
grandphotography_set_homepage_style('fullscreen');
	
get_header(); 
?>
	
<br class="clear"/>

<?php
//Get 404 not found background image
$tg_not_found_bg = kirki_get_option('tg_not_found_bg');
?>
<div class="password_overlay"></div>
<div class="password_container" <?php if(isset($tg_not_found_bg) && !empty($tg_not_found_bg)) { ?>style="background-image:url(<?php echo esc_url($tg_not_found_bg); ?>);"<?php }?>>
    <div class="password_wrapper">
    	<!-- Begin main content -->
        <div class="vertical_center_wrapper transparentbg" style="text-align:center">
    	    <div class="overlay_gallery_wrapper">
    		    <div class="overlay_gallery_border">
    			    <div class="overlay_gallery_content">
    			    	<h1><?php esc_html_e('404 Not Found!', 'grandphotography' ); ?></h1>
    			    	<hr class="title_break bold"/>
						<div class="page_tagline">
						    <?php esc_html_e( "Perhaps you would like to go to our homepage or try searching below.", 'grandphotography' ); ?>
						</div>
						<form class="searchform" method="get" action="<?php echo esc_url(home_url('/')); ?>">
					    	<input style="width:100%" type="text" class="field searchform-s" name="s" value="<?php the_search_query(); ?>" placeholder="<?php esc_html_e('Type to search and hit enter...', 'grandphotography' ); ?>">
					    </form>
    			    </div>
    		    </div>
    	    </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>