<?php
	//Check if display slider
	$tg_blog_slider = kirki_get_option('tg_blog_slider');
	if(THEMEDEMO && isset($_GET['slider']))
	{
		$tg_blog_slider = 1;
	}
	
	//Get post featured category
	$args = array( 
		'orderby' => 'date',
		'order' => 'DESC',
		'post_type' => 'post',
		'suppress_filters' => 0,
	);
	
	//Check if filter slider posts by selected category
	$tg_blog_slider_cat = kirki_get_option('tg_blog_slider_cat');
	if(!empty($tg_blog_slider_cat))
	{
	    $args['cat'] = $tg_blog_slider_cat;
	}
	
	if(!empty($tg_blog_slider) && !is_search() && !is_category() && !is_tag() && !is_archive() && !empty($tg_blog_slider_cat))
	{
		//Check slider post items
		$tg_blog_slider_items = kirki_get_option('tg_blog_slider_items');
		if(!empty($tg_blog_slider_items) && is_numeric($tg_blog_slider_items))
		{
			$args['posts_per_page'] = $tg_blog_slider_items;
		}
		else
		{
			$args['posts_per_page'] = 5;
		}
		
		wp_reset_postdata();
		
		// the query
		$theme_query = new WP_Query( $args );
		
		wp_enqueue_script("flexslider", get_template_directory_uri()."/js/flexslider/jquery.flexslider-min.js", false, THEMEVERSION, true);
		wp_enqueue_script("grandphotography-slider-flexslider", admin_url('admin-ajax.php')."?action=grandphotography_script_slider_flexslider", false, THEMEVERSION, true);
?>
	<div id="post_featured_slider" class="slider_wrapper">
		<div class="flexslider" data-height="550">
			<ul class="slides">
	<?php
		//Display slide content
		if ($theme_query->have_posts()) : while ($theme_query->have_posts()) : $theme_query->the_post();
			//Get post featured image
			$slide_ID = get_the_ID();
			$image_url = array();
						
			if(has_post_thumbnail($slide_ID, 'large'))
			{
			    $image_id = get_post_thumbnail_id($slide_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			}
			
			if(isset($image_url[0]) && !empty($image_url[0]))
			{
	?>
			<li>
				<a href="<?php echo get_permalink($slide_ID); ?>">
					<div class="slider_image" style="background-image:url('<?php echo esc_url($image_url[0]); ?>');">
						<div class="slide_post">
							<div class="slide_post_wrapper">
								<h2><?php the_title(); ?></h2>
								<hr class="title_break bold"/>
								<div class="post_detail single_post">
					    		<span class="post_info_date">
						    		<?php echo date_i18n(THEMEDATEFORMAT, get_the_time('U')); ?>
					    		</span>
					    		<span class="post_info_author">
					    			<?php echo esc_html_e('By', 'grandphotography' ); ?>&nbsp;
					    			<?php
					      				$author_name = get_the_author();
					      			?>
					      			<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo esc_html($author_name); ?></a>
					    		</span>
					    		<span class="post_info_comment">
					    			<?php echo esc_html_e('With', 'grandphotography' ); ?>&nbsp;
					    			<a href="<?php comments_link(); ?>">
					    				<?php 
						    				$post_comment_number = get_comments_number();
						    				echo intval($post_comment_number).'&nbsp;';
						    				
						    				if($post_comment_number <= 1)
						    				{
							    				echo esc_html_e('Comment', 'grandphotography' );
						    				}
						    				else
						    				{
							    				echo esc_html_e('Comments', 'grandphotography' );
						    				}
					    				?>
					    			</a>
					    		</span>
							</div>
							
							<div class="post_info_cat">
							    <?php
							    	//Get Post's Categories
							    	$post_categories = wp_get_post_categories($post->ID);
							    	
							    	$count_categories = count($post_categories);
									$i = 0;
							    	
							    	if(!empty($post_categories))
							    	{
							    		echo esc_html_e('In', 'grandphotography' ).'&nbsp;';
							    	
							        	foreach($post_categories as $key => $c)
							        	{
							        		$cat = get_category( $c );
							    ?>
							        	<a href="<?php echo esc_url(get_category_link($cat->term_id)); ?>"><?php echo esc_html($cat->name); ?></a>
							    <?php
							    			if(++$i != $count_categories) 
							    			{
							    				echo '&nbsp;/&nbsp;';
							    			}
							        	}
							        }
							    ?>
					    	</div>
							</div>
						</div>
					</div>
				</a>
			</li>
	<?php
			}
			
		endwhile; endif;
	?>
			</ul>
		</div>
	</div>
<?php	
		wp_reset_postdata();
	} //End if display slider
	
	
	//Get blog promo links
	get_template_part("/templates/template-blog-promo-links");
?>