<!-- Begin mobile menu -->
<a id="close_mobile_menu" href="javascript:;"></a>

<?php
	$tg_sidemenu_gallery = kirki_get_option( "tg_sidemenu_gallery" );
	
	if(!empty($tg_sidemenu_gallery))
	{
?>
<div class="mobile_gallery_wrapper">
	<?php
		//Check if disable slideshow hover effect
		$tg_gallery_hover_slide = kirki_get_option( "tg_gallery_hover_slide" );
		
		if(!empty($tg_gallery_hover_slide))
		{
			wp_enqueue_script("grandphotography-jquery-cycle2", get_template_directory_uri()."/js/jquery.cycle2.min.js", false, THEMEVERSION, true);
			wp_enqueue_script("grandphotography-custom-cycle", get_template_directory_uri()."/js/custom_cycle.js", false, THEMEVERSION, true);
		}
		
		wp_enqueue_script("grandphotography-custom-grid-sidemenu-gallery", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=3&id=menu_gallery_wrapper&gallery_id=1"), false, THEMEVERSION, true);
	?>
	<div id="menu_gallery_wrapper" class="portfolio_filter_wrapper gallery three_cols portfolio-content section content clearfix wide" data-columns="3">
	
	<?php
	    //Get galleries
	    $wp_query = grandphotography_get_wp_query();
	    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	    
	    $tg_sidemenu_gallery_items = kirki_get_option( "tg_sidemenu_gallery_items" );
	    
	    $query_string = 'paged='.$paged.'&orderby=menu_order&order=ASC&post_type=galleries&posts_per_page='.$tg_sidemenu_gallery_items.'&suppress_filters=0';
	    
	    $tg_sidemenu_gallery_cat = kirki_get_option( "tg_sidemenu_gallery_cat" );
	    
	    if(!empty($tg_sidemenu_gallery_cat))
	    {
	        $query_string .= '&gallerycat='.$tg_sidemenu_gallery_cat;
	    }

	    query_posts($query_string);
	
	    $key = 0;
	    if (have_posts()) : while (have_posts()) : the_post();
	    	$small_image_url = array();
	        $image_url = '';
	        $gallery_ID = get_the_ID();
	        		
	        if(has_post_thumbnail($gallery_ID, 'original'))
	        {
	            $image_id = get_post_thumbnail_id($gallery_ID);
	            $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
	        }
	        
	        $permalink_url = get_permalink($gallery_ID);
	?>
	<div class="element grid classic3_cols">
	
		<div class="one_third gallery3 static filterable gallery_type archive animated<?php echo esc_attr($key+1); ?>" data-id="post-<?php echo esc_attr($key+1); ?>">
		
			<?php 
			    if(!empty($small_image_url[0]))
			    {
			?>	
			    <a href="<?php echo esc_url($permalink_url); ?>">
			    	<?php
				    	$all_photo_arr = array();
				    	
				    	if(!empty($tg_gallery_hover_slide))
				    	{
				    		//Get gallery images
				    		$all_photo_arr = get_post_meta($gallery_ID, 'wpsimplegallery_gallery', true);
				    		
				    		//Get only 5 recent photos
				    		$all_photo_arr = array_slice($all_photo_arr, 0, 5);
				    	}
				    	
					    if(!empty($all_photo_arr))
					    {
					?>
					<ul class="gallery_img_slides">
					<?php
					    foreach($all_photo_arr as $photo)
					    {
					    	$slide_image_url = wp_get_attachment_image_src($photo, 'grandphotography-gallery-grid', true);
					?>
					<li><img src="<?php echo esc_url($slide_image_url[0]); ?>" alt="" class="static"/></li>
					<?php
					    }
					?>
					</ul>
					<?php
					    }
					?>
			        <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
			        <div class="portfolio_title">
					    <div class="image_caption">
					    	<h6><?php the_title(); ?></h6>
					    </div>
					</div>
			    </a>
			<?php
			    }		
			?>
		
		</div>
		
	</div>
	<?php
	    $key++;
	    endwhile; endif;
	    wp_reset_query();
	?>
		
	</div>
</div>
<?php
} //End if not display side menu galleries
?>

<div class="mobile_menu_wrapper">
	<a id="mobile_menu_close" href="javascript:;" class="button"><i class="fa fa-close"></i></a>

	<div class="mobile_menu_content">
    <?php
    	$grandphotography_homepage_style = grandphotography_get_homepage_style();
    
    	//Get main menu layout
		$tg_menu_layout = grandphotography_menu_layout();
    
	    //Check if display search in header	
	    $tg_menu_search = kirki_get_option('tg_menu_search');
	    if($tg_menu_layout == 'leftmenu')
	    {
    	    $tg_menu_search = 0;
	    }
	    
	    if(!empty($tg_menu_search))
	    {
	?>
	<form method="get" name="searchform" id="searchform" action="<?php echo esc_url(home_url('/')); ?>/">
	    <div>
	    	<input type="text" value="<?php the_search_query(); ?>" name="s" id="s" autocomplete="off" placeholder="<?php esc_html_e('Search...', 'grandphotography' ); ?>"/>
	    	<button>
	        	<i class="fa fa-search"></i>
	        </button>
	    </div>
	    <div id="autocomplete"></div>
	</form>
	<?php
	    }
	?>
	
	<?php 
		//Working on page transparent logic
	
    	//Get page ID
    	if(is_object($post))
    	{
    	    $page = get_page($post->ID);
    	}
    	$current_page_id = '';
    	
    	if(isset($page->ID))
    	{
    	    $current_page_id = $page->ID;
    	}
    	elseif(is_home())
    	{
    	    $current_page_id = get_option('page_on_front');
    	}
    	
        //If enable menu transparent
        $page_menu_transparent = 0;
        $page_menu_transparent = get_post_meta($current_page_id, 'page_menu_transparent', true);
        
        $pp_page_bg = '';
	    //Get page featured image
	    if(has_post_thumbnail($current_page_id, 'full'))
	    {
	        $image_id = get_post_thumbnail_id($current_page_id); 
	        $image_thumb = wp_get_attachment_image_src($image_id, 'full', true);
	        $pp_page_bg = $image_thumb[0];
	    }

    	//Check if Woocommerce is installed	
    	if(class_exists('Woocommerce') && grandphotography_is_woocommerce_page())
    	{
    	    //Check if woocommerce page
    		$shop_page_id = get_option( 'woocommerce_shop_page_id' );
    		$page_menu_transparent = get_post_meta($shop_page_id, 'page_menu_transparent', true);
    	}
    	
    	if(is_single() && !empty($pp_page_bg) && !grandphotography_is_woocommerce_page())
		{
		    $post_type = get_post_type();
		    
		    switch($post_type)
		    {
		    	case 'events':
		    	default:
		    		$page_menu_transparent = 1;	
		    	break;
		    	
		    	case 'post':
		    	case 'galleries':
		    	case 'portfolios':
		    	case 'clients':
		    		$page_menu_transparent = 0;	
		    	break;
		    }
		}
		else if(is_single() && empty($pp_page_bg) && !grandphotography_is_woocommerce_page())
		{
			$page_menu_transparent = 0;	
		}
    	
    	if($grandphotography_homepage_style == 'fullscreen')
        {
            $page_menu_transparent = 1;
        }
        
        if(is_search())
        {
    	    $page_menu_transparent = 0;
        }
        
        if(is_404())
        {
    	    $page_menu_transparent = 0;
        }
    ?>
	
	<?php
		//If left menu then display logo
		if($tg_menu_layout == 'leftmenu')
	    {
	    	$page_menu_transparent = 0;
    	    
    	    if($grandphotography_homepage_style == 'fullscreen')
    	    {
    	        $page_menu_transparent = 1;
    	    }
	?>
	
	<?php
	if(empty($page_menu_transparent))
	{
	    //get custom logo
	    $tg_retina_logo = kirki_get_option('tg_retina_logo');

	    if(!empty($tg_retina_logo))
	    {	
	    	//Get image width and height
        	$image_id = grandphotography_get_image_id($tg_retina_logo);
        	$obj_image = wp_get_attachment_image_src($image_id, 'original');
        	$image_width = 0;
        	$image_height = 0;
        	
        	if(isset($obj_image[1]))
        	{
        		$image_width = intval($obj_image[1]/2);
        	}
        	if(isset($obj_image[2]))
        	{
        		$image_height = intval($obj_image[2]/2);
        	}
	?>
	<div class="logo_container">
		<div class="logo_align">
    	    <a class="logo_wrapper <?php if(!empty($page_menu_transparent)) { ?>hidden<?php } else { ?>default<?php } ?>" href="<?php echo esc_url(home_url('/')); ?>">
    	    	<?php
    				if($image_width > 0 && $image_height > 0)
    				{
    			?>
    			<img src="<?php echo esc_url($tg_retina_logo); ?>" alt="<?php esc_attr(get_bloginfo('name')); ?>" width="<?php echo esc_attr($image_width); ?>" height="<?php echo esc_attr($image_height); ?>"/>
    			<?php
    				}
    				else
    				{
    			?>
    	    	<img src="<?php echo esc_url($tg_retina_logo); ?>" alt="<?php esc_attr(get_bloginfo('name')); ?>" width="46" height="33"/>
    	    	<?php 
        	    	}
        	    ?>
    	    </a>
		</div>
	</div>
	<?php
	    }
	?>
	<!-- End logo -->
	<?php
	}
	else
	{
        //get custom logo transparent
        $tg_retina_transparent_logo = kirki_get_option('tg_retina_transparent_logo');

        if(!empty($tg_retina_transparent_logo))
        {
        	//Get image width and height
	    	$image_id = grandphotography_get_image_id($tg_retina_transparent_logo);
	    	$obj_image = wp_get_attachment_image_src($image_id, 'original');
	    	$image_width = 0;
	    	$image_height = 0;
	    	
	    	if(isset($obj_image[1]))
	    	{
	    		$image_width = intval($obj_image[1]/2);
	    	}
	    	if(isset($obj_image[2]))
	    	{
	    		$image_height = intval($obj_image[2]/2);
	    	}
    ?>
    <div id="logo_transparent" class="logo_container">
        <div class="logo_align">
	        <a id="custom_logo_transparent" class="logo_wrapper <?php if(empty($page_menu_transparent)) { ?>hidden<?php } else { ?>default<?php } ?>" href="<?php echo esc_url(home_url('/')); ?>">
	        	<?php
	    			if($image_width > 0 && $image_height > 0)
	    			{
	    		?>
	    		<img src="<?php echo esc_url($tg_retina_transparent_logo); ?>" alt="<?php esc_attr(get_bloginfo('name')); ?>" width="<?php echo esc_attr($image_width); ?>" height="<?php echo esc_attr($image_height); ?>"/>
	    		<?php
	    			}
	    			else
	    			{
	    		?>
	        	<img src="<?php echo esc_url($tg_retina_transparent_logo); ?>" alt="<?php esc_attr(get_bloginfo('name')); ?>" width="46" height="33"/>
	        	<?php 
	    	    	}
	    	    ?>
	        </a>
        </div>
    </div>
    <?php
        }
	}
	?>
	
	<?php
	} //End if left menu
	?>
	
    <?php 
    	//Check if has custom menu
    	if(is_object($post) && $post->post_type == 'page')
    	{
    	    $page_menu = get_post_meta($post->ID, 'page_menu', true);
    	}	
    	
    	if ( has_nav_menu( 'side-menu' ) ) 
    	{
    	    //Get page nav
    	    wp_nav_menu( 
    	        array( 
    	            'menu_id'			=> 'mobile_main_menu',
                    'menu_class'		=> 'mobile_main_nav',
    	            'theme_location' 	=> 'side-menu',
    	        )
    	    ); 
    	}
    ?>
    
    <!-- Begin side menu sidebar -->
    <div class="page_content_wrapper">
    	<div class="sidebar_wrapper">
            <div class="sidebar">
            
            	<div class="content">
            
            		<ul class="sidebar_widget">
            		<?php dynamic_sidebar('Side Menu Sidebar'); ?>
            		</ul>
            	
            	</div>
        
            </div>
    	</div>
    </div>
    <!-- End side menu sidebar -->
    
    <?php
    	//Get social profiles
	    get_template_part("/templates/template-socials");
    ?>
    </div>
</div>
<?php
	$grandphotography_page_menu_transparent = grandphotography_get_page_menu_transparent();
	grandphotography_set_page_menu_transparent($page_menu_transparent);
?>
<!-- End mobile menu -->