<?php
$grandphotography_page_content_class = grandphotography_get_page_content_class();

//Get page header display setting
$page_show_title = get_post_meta($post->ID, 'page_show_title', true);

if(empty($page_show_title))
{
	//Get current page tagline
	$page_tagline = get_post_meta($post->ID, 'page_tagline', true);

	$pp_page_bg = '';
	//Get page featured image
	if(has_post_thumbnail($post->ID, 'full'))
    {
        $image_id = get_post_thumbnail_id($post->ID); 
        $image_thumb = wp_get_attachment_image_src($image_id, 'full', true);
        
        if(isset($image_thumb[0]) && !empty($image_thumb[0]))
        {
        	$pp_page_bg = $image_thumb[0];
        }
    }
    
    //Check if add parallax effect
	$tg_page_header_bg_parallax = kirki_get_option('tg_page_header_bg_parallax');
	
	//Check if enable content builder
	$ppb_enable = get_post_meta($post->ID, 'ppb_enable', true);
	
	$grandphotography_topbar = grandphotography_get_topbar();
?>
<div id="page_caption" class="<?php if(!empty($pp_page_bg)) { ?>hasbg <?php if(!empty($tg_page_header_bg_parallax)) { ?>parallax<?php } ?> <?php } ?> <?php if(!empty($grandphotography_topbar)) { ?>withtopbar<?php } ?> <?php if(!empty($screen_class)) { ?>split<?php } ?> <?php if(!empty($grandphotography_page_content_class)) { echo esc_attr($grandphotography_page_content_class); } ?>" <?php if(!empty($pp_page_bg)) { ?>style="background-image:url(<?php echo esc_url($pp_page_bg); ?>);"<?php } ?>>
	
	<div class="page_title_wrapper">
		<div class="page_title_inner">
			<h1 <?php if(!empty($pp_page_bg) && !empty($grandphotography_topbar)) { ?>class ="withtopbar"<?php } ?>><?php the_title(); ?></h1>
			<?php
				$gallery_excerpt = get_the_excerpt();

		    	if(!empty($gallery_excerpt))
		    	{
		    ?>
		    	<hr class="title_break bold"/>
		    	<div class="page_tagline">
		    		<?php echo nl2br($gallery_excerpt); ?>
		    	</div>
		    <?php
		    	}
		    ?>
		</div>
	</div>
</div>
<?php
}
else
{
?>
<div id="page_caption" class="single_gallery <?php if(!empty($grandphotography_topbar)) { ?>withtopbar<?php } ?>">
	<div class="page_title_wrapper">
		<div class="page_title_inner">
			<h1><?php the_title(); ?></h1>
			<?php
				$gallery_excerpt = get_the_excerpt();

		    	if(!empty($gallery_excerpt))
		    	{
		    ?>
		    	<hr class="title_break"/>
		    	<div class="page_tagline">
		    		<?php echo nl2br($gallery_excerpt); ?>
		    	</div>
		    <?php
		    	}
		    ?>
		</div>
	</div>
</div>
<?php
}
?>
<!-- Begin content -->

<div id="page_content_wrapper" class="<?php if(!empty($grandphotography_page_content_class)) { echo esc_attr($grandphotography_page_content_class); } ?>">