<?php
/**
*	Get Current page object
**/
$page = get_page($post->ID);

/**
*	Get current page id
**/

if(!isset($current_page_id) && isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Get page header display setting
$page_title = get_the_title();
$page_menu_transparent = 0;

//Get galleries
$client_galleries = get_post_meta($current_page_id, 'client_galleries', true);
$client_count_galleries = count($client_galleries);

//Count Photos
$client_count_photos = 0;
if(!empty($client_galleries))
{
    foreach($client_galleries as $key => $client_gallery)
    {
    	//Get gallery images
    	$all_photo_arr = get_post_meta($client_gallery, 'wpsimplegallery_gallery', true);
    	$client_count_photos+= count($all_photo_arr);
    }
}

$temp_image_thumb = '';
if (class_exists('MultiPostThumbnails')) 
{
	$temp_image_thumb = MultiPostThumbnails::get_post_thumbnail_url('clients', 'cover-image', $current_page_id);
}

if (!empty($temp_image_thumb)) 
{
	$pp_page_bg = $temp_image_thumb;
	
	//Get page featured image
    $pp_page_bg = $temp_image_thumb;
    $page_menu_transparent = 1;
    
    //Check if add parallax effect
	$tg_page_header_bg_parallax = kirki_get_option('tg_page_header_bg_parallax');
    
	$grandphotography_topbar = grandphotography_get_topbar();
	$grandphotography_screen_class = grandphotography_get_screen_class();
?>
<div id="page_caption" class="<?php if(!empty($pp_page_bg)) { ?>hasbg <?php if(!empty($tg_page_header_bg_parallax)) { ?>parallax<?php } ?> <?php } ?> <?php if(!empty($grandphotography_topbar)) { ?>withtopbar<?php } ?> <?php if(!empty($grandphotography_screen_class)) { ?>split<?php } ?>" <?php if(!empty($pp_page_bg)) { ?>style="background-image:url(<?php echo esc_url($pp_page_bg); ?>);"<?php } ?>>

	<div class="page_title_wrapper">
		<div class="page_title_inner">
			<div class="page_title_content">
				<?php
			    	//Get client thumbnail
			    	$client_thumbnail = '';
			    	if(has_post_thumbnail($current_page_id, 'thumbnail') && empty($term))
			        {
			            $image_id = get_post_thumbnail_id($current_page_id); 
			            $image_thumb = wp_get_attachment_image_src($image_id, 'thumbnail', true);
			            
			            if(isset($image_thumb[0]) && !empty($image_thumb[0]))
			            {
			            	$client_thumbnail = $image_thumb[0];
			            }
			        }
			        
			        if(!empty($client_thumbnail))
			        {
			    ?>
			    	<div class="client_thumbnail">
			    		<img src="<?php echo esc_url($client_thumbnail); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"/>
			    	</div>
			    <?php
			        }
			    ?>
    
				<h1 <?php if(!empty($pp_page_bg) && !empty($grandphotography_topbar)) { ?>class ="withtopbar"<?php } ?>><?php echo esc_html($page_title); ?></h1>
				<?php
			    	 if(have_posts())
			    	{
			    ?>
			    	<hr class="title_break bold"/>
			    	<div class="page_tagline">
			    		<?php
		    		        while ( have_posts() ) : the_post(); ?>		
		    			        <?php the_content(); break;  ?>
		    		    <?php endwhile; ?>
			    	</div>
			    <?php
			    	}
			    ?>
			</div>
		</div>
	</div>

</div>
<?php
}
else
{
?>
<div id="client_header">
    <?php
    	//Get client thumbnail
    	$client_thumbnail = '';
    	if(has_post_thumbnail($current_page_id, 'thumbnail') && empty($term))
        {
            $image_id = get_post_thumbnail_id($current_page_id); 
            $image_thumb = wp_get_attachment_image_src($image_id, 'thumbnail', true);
            
            if(isset($image_thumb[0]) && !empty($image_thumb[0]))
            {
            	$client_thumbnail = $image_thumb[0];
            }
        }
        
        if(!empty($client_thumbnail))
        {
    ?>
    	<div class="client_thumbnail">
    		<img src="<?php echo esc_url($client_thumbnail); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"/>
    	</div>
    <?php
        }
    ?>

    <div class="client_content">
     	<h1><?php the_title(); ?></h1>
     	
     	<hr class="title_break bold"/>
     	
     	<div class="page_tagline">
        	<?php
                while ( have_posts() ) : the_post(); ?>		
        	        <?php the_content(); break;  ?>
            <?php endwhile; ?>
     	</div>
     	
     	<?php
        	$post_galleries_count_unit = esc_html__( 'Gallery', 'grandphotography' );
        	
        	if($client_count_galleries > 1)
        	{
        		$post_galleries_count_unit = esc_html__( 'Galleries', 'grandphotography' );
        	}
        	
        	$post_photos_count_unit = esc_html__( 'Photo', 'grandphotography' );
        	
        	if($client_count_photos > 1)
        	{
        		$post_photos_count_unit = esc_html__( 'Photos', 'grandphotography' );
        	}
        ?>
        <div class="client_meta">
        	<span class="items_number"><?php echo intval($client_count_galleries); ?></span>&nbsp;<span class="units"><?php echo esc_html($post_galleries_count_unit); ?></span>
        	
        	<span class="items_number"><?php echo intval($client_count_photos); ?></span>&nbsp;<span class="units"><?php echo esc_html($post_photos_count_unit); ?></span>
        </div>
    </div>
</div>
<?php
}
?>

<!-- Begin content -->
<?php
$grandphotography_page_content_class = grandphotography_get_page_content_class();
?>
<div id="page_content_wrapper" class="<?php if(!empty($pp_page_bg)) { ?>hasbg <?php } ?><?php if(!empty($pp_page_bg) && !empty($grandphotography_topbar)) { ?>withtopbar <?php } ?><?php if(!empty($grandphotography_page_content_class)) { echo esc_attr($grandphotography_page_content_class); } ?>">

<?php
	if(!empty($pp_page_bg)) {
?>
	<div class="client_content center">
     	<?php
        	$post_galleries_count_unit = esc_html__( 'Gallery', 'grandphotography' );
        	
        	if($client_count_galleries > 1)
        	{
        		$post_galleries_count_unit = esc_html__( 'Galleries', 'grandphotography' );
        	}
        	
        	$post_photos_count_unit = esc_html__( 'Photo', 'grandphotography' );
        	
        	if($client_count_photos > 1)
        	{
        		$post_photos_count_unit = esc_html__( 'Photos', 'grandphotography' );
        	}
        ?>
        <div class="client_meta">
        	<span class="items_number"><?php echo intval($client_count_galleries); ?></span>&nbsp;<span class="units"><?php echo esc_html($post_galleries_count_unit); ?></span>
        	
        	<span class="items_number"><?php echo intval($client_count_photos); ?></span>&nbsp;<span class="units"><?php echo esc_html($post_photos_count_unit); ?></span>
        </div>
    </div>
<?php
	}
?>