<?php
/**
 * The main template file for preview content builder display page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
if(!is_null($post))
{
	$page_obj = get_page($post->ID);
}

$current_page_id = '';

/**
*	Get current page id
**/

if(!is_null($post) && isset($page_obj->ID))
{
    $current_page_id = $page_obj->ID;
}

get_header(); 

//Include custom header feature
get_template_part("/templates/template-portfolio-header");

//if dont have password set
if(!post_password_required())
{
	wp_enqueue_script("grandphotography-custom-onepage", get_template_directory_uri()."/js/custom_onepage.js", false, THEMEVERSION, true);
?>

<div class="ppb_wrapper">
<?php
	//Check if live content builder mode
	$is_live_builder = false;
	if(isset($_GET['ppb_live']))
	{
		$is_live_builder = true;
		
		wp_enqueue_script("grandphotography-live-builder", get_template_directory_uri()."/js/custom_livebuilder.js", false, THEMEVERSION, true);
	}

	$ppb_form_data_order = get_transient('grandphotography_'.$post->ID.'_data_order');
	$ppb_page_content = '';
	
	if(isset($ppb_form_data_order))
	{
	    $ppb_form_item_arr = explode(',', $ppb_form_data_order);
	}
	
	$ppb_shortcodes = array();
	
	require_once get_template_directory() . "/lib/contentbuilder.shortcode.lib.php";
	
	if(isset($ppb_form_item_arr[0]) && !empty($ppb_form_item_arr[0]))
	{
	    $ppb_shortcode_code = '';
	    $ppb_form_item_data = get_transient('grandphotography_'.$post->ID.'_data');
	    $ppb_form_item_size = get_transient('grandphotography_'.$post->ID.'_size');
	
	    foreach($ppb_form_item_arr as $key => $ppb_form_item)
	    {
	    	if(isset($ppb_form_item_data[$ppb_form_item]))
		    {
		    	$ppb_form_item_data_obj = json_decode(stripslashes($ppb_form_item_data[$ppb_form_item]));
		    	
		    	$ppb_shortcode_content_name = $ppb_form_item_data_obj->shortcode.'_content';
		    	
		    	if(isset($ppb_form_item_data_obj->$ppb_shortcode_content_name))
		    	{
		    		$ppb_shortcode_code = '['.$ppb_form_item_data_obj->shortcode.' size="'.$ppb_form_item_size[$ppb_form_item].'" ';
		    		
		    		//Get shortcode title
		    		$ppb_shortcode_title_name = $ppb_form_item_data_obj->shortcode.'_title';
		    		if(isset($ppb_form_item_data_obj->$ppb_shortcode_title_name))
		    		{
		    			$ppb_shortcode_code.= 'title="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_title_name), ENT_QUOTES, "UTF-8").'" ';
		    		}
		    		
		    		//Get shortcode attributes
		    		if(isset($ppb_shortcodes[$ppb_form_item_data_obj->shortcode]))
		    		{
			    		$ppb_shortcode_arr = $ppb_shortcodes[$ppb_form_item_data_obj->shortcode];
			    		
			    		foreach($ppb_shortcode_arr['attr'] as $attr_name => $attr_item)
			    		{
			    			$ppb_shortcode_attr_name = $ppb_form_item_data_obj->shortcode.'_'.$attr_name;
			    			
			    			if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_name))
			    			{
			    				$ppb_shortcode_code.= $attr_name.'="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_name)).'" ';
			    			}
			    			elseif($attr_name == 'margin')
			    			{
			    				$ppb_shortcode_attr_margin_top = $ppb_form_item_data_obj->shortcode.'_'.$attr_name.'_top';
		    				
			    				if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_top))
								{
				    				$ppb_shortcode_code.= $attr_name.'_top="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_top)).'" ';
				    			}
				    			
				    			$ppb_shortcode_attr_margin_right = $ppb_form_item_data_obj->shortcode.'_'.$attr_name.'_right';
				    			
				    			if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_right))
								{
				    				$ppb_shortcode_code.= $attr_name.'_right="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_right)).'" ';
				    			}
				    			
				    			$ppb_shortcode_attr_margin_bottom = $ppb_form_item_data_obj->shortcode.'_'.$attr_name.'_bottom';
				    			
				    			if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_bottom))
								{
				    				$ppb_shortcode_code.= $attr_name.'_bottom="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_bottom)).'" ';
				    			}
				    			
				    			$ppb_shortcode_attr_margin_left = $ppb_form_item_data_obj->shortcode.'_'.$attr_name.'_left';
				    			
				    			if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_left))
								{
				    				$ppb_shortcode_code.= $attr_name.'_left="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_left)).'" ';
				    			}
			    			}
			    		}
			    	}
			    	
			    	//Check if in live builder
		    		if($is_live_builder)
					{
					    $ppb_shortcode_code.= 'builder_id="'.esc_attr($ppb_form_item).'" ';
					}
	
		    		$ppb_shortcode_code.= ']'.rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_content_name).'[/'.$ppb_form_item_data_obj->shortcode.']';
		    	}
		    	else if(isset($ppb_shortcodes[$ppb_form_item_data_obj->shortcode]))
		    	{
		    		$ppb_shortcode_code = '['.$ppb_form_item_data_obj->shortcode.' size="'.$ppb_form_item_size[$ppb_form_item].'" ';
		    		
		    		//Get shortcode title
		    		$ppb_shortcode_title_name = $ppb_form_item_data_obj->shortcode.'_title';
		    		if(isset($ppb_form_item_data_obj->$ppb_shortcode_title_name))
		    		{
		    			$ppb_shortcode_code.= 'title="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_title_name), ENT_QUOTES, "UTF-8").'" ';
		    		}
		    		
		    		//Get shortcode attributes
		    		if(isset($ppb_shortcodes[$ppb_form_item_data_obj->shortcode]))
		    		{
			    		$ppb_shortcode_arr = $ppb_shortcodes[$ppb_form_item_data_obj->shortcode];
			    		
			    		foreach($ppb_shortcode_arr['attr'] as $attr_name => $attr_item)
			    		{
			    			$ppb_shortcode_attr_name = $ppb_form_item_data_obj->shortcode.'_'.$attr_name;
			    			
			    			if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_name))
			    			{
			    				$ppb_shortcode_code.= $attr_name.'="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_name)).'" ';
			    			}
			    			elseif($attr_name == 'margin')
			    			{
			    				$ppb_shortcode_attr_margin_top = $ppb_form_item_data_obj->shortcode.'_'.$attr_name.'_top';
		    				
			    				if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_top))
								{
				    				$ppb_shortcode_code.= $attr_name.'_top="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_top)).'" ';
				    			}
				    			
				    			$ppb_shortcode_attr_margin_right = $ppb_form_item_data_obj->shortcode.'_'.$attr_name.'_right';
				    			
				    			if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_right))
								{
				    				$ppb_shortcode_code.= $attr_name.'_right="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_right)).'" ';
				    			}
				    			
				    			$ppb_shortcode_attr_margin_bottom = $ppb_form_item_data_obj->shortcode.'_'.$attr_name.'_bottom';
				    			
				    			if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_bottom))
								{
				    				$ppb_shortcode_code.= $attr_name.'_bottom="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_bottom)).'" ';
				    			}
				    			
				    			$ppb_shortcode_attr_margin_left = $ppb_form_item_data_obj->shortcode.'_'.$attr_name.'_left';
				    			
				    			if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_left))
								{
				    				$ppb_shortcode_code.= $attr_name.'_left="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_margin_left)).'" ';
				    			}
			    			}
			    		}
			    	}
		    		
		    		//Check if in live builder
		    		if($is_live_builder)
					{
					    $ppb_shortcode_code.= 'builder_id="'.esc_attr($ppb_form_item).'" ';
					}
		    		
		    		$ppb_shortcode_code.= ']';
		    	}
		    	
		    	$ppb_page_content.= grandphotography_apply_content($ppb_shortcode_code);
	        }
        }
    }
    //echo $ppb_shortcode_code.'<hr/>';
    echo $ppb_page_content;
}
?>
</div>

<?php
//Check if enable portfolio comment
if (comments_open($post->ID)) 
{
?>
<br class="clear"/><br/><br/><hr class="small"/><br class="clear"/><br/>
<div class="standard_wrapper">
	<div class="fullwidth_comment_wrapper">
		<?php comments_template( '', true ); ?>
	</div>
</div>
<br class="clear"/><br/>
<?php
}
?>

<?php
	//Display share button
	$tg_portfolio_sharing = kirki_get_option('tg_portfolio_sharing');
	
	if(!empty($tg_portfolio_sharing))
	{
		//Get share button
		get_template_part("/templates/template-post-share");
	}

	//Get portfolio navigation
	get_template_part("/templates/template-portfolio-navigation");
?>

<?php
//Check if displays recent portfolio
$tg_portfolio_recent = kirki_get_option('tg_portfolio_recent');

if(!empty($tg_portfolio_recent))
{
	$tg_portfolio_recent_items = kirki_get_option('tg_portfolio_recent_items');
	
	$args = array(
        'numberposts' => intval($tg_portfolio_recent_items),
        'order' => 'DESC',
        'orderby' => 'date',
        'post_type' => array('portfolios'),
        'suppress_filters' => 0,
    );
    
    if(THEMEDEMO)
	{
		$args['tax_query'] = array(
		    array(
		        'taxonomy' => 'portfoliosets',
		        'terms' => array(DEMOPORTFOLIOSETID),
		        'field' => 'slug',
		        'operator' => 'NOT IN',
		    ),
		);
	}
    
    $recent_post = get_posts($args);
    
    if(!empty($recent_post))
    {
    	wp_enqueue_script("grandphotography-custom-grid-portfolio-click", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=3&id=portfolio_filter_wrapper&button_id=infinite_load_more&loading_id=infinite_loading"), false, THEMEVERSION, true);
?>
<br class="clear"/>
<div class="standard_wrapper single_portfolio">
	<hr class="double"/><br class="clear"/><br/>
	<h6 class="subtitle"><span><?php esc_html_e('More Portfolios', 'grandphotography' ); ?></span></h6>
	<br class="clear"/>
	<div id="portfolio_filter_wrapper" class="single_recent_portfolio gallery three_cols portfolio-content section content clearfix" data-columns="3">
<?php
	foreach($recent_post as $recent_item)
	{
		$image_url = '';
		$portfolio_ID = $recent_item->ID;
		    	
		if(has_post_thumbnail($portfolio_ID, 'original'))
		{
		    $image_id = get_post_thumbnail_id($portfolio_ID);
		    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
		    
		    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
		}
		
		$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
		
		if(empty($portfolio_link_url))
		{
		    $permalink_url = get_permalink($portfolio_ID);
		}
		else
		{
		    $permalink_url = $portfolio_link_url;
		}
		
		//Get portfolio category
		$portfolio_item_set = '';
		$portfolio_item_sets = wp_get_object_terms($portfolio_ID, 'portfoliosets');
		
		if(is_array($portfolio_item_sets))
		{
		    foreach($portfolio_item_sets as $set)
		    {
		    	$portfolio_item_set.= $set->slug.' ';
		    }
		}
?>
	<div class="element grid classic3_cols <?php echo esc_attr($portfolio_item_set); ?>" data-type="<?php echo esc_attr($portfolio_item_set); ?>">
	
		<div class="one_third gallery3 static filterable gallery_type animated<?php echo esc_attr($key+1); ?> portfolio_type" data-id="post-<?php echo esc_attr($key+1); ?>">
		<?php 
				if(!empty($image_url[0]))
				{
			?>		
					<?php
						$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
						$portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
						
						switch($portfolio_type)
						{
						case 'External Link':
							$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
					?>
					<a target="_blank" href="<?php echo esc_url($portfolio_link_url); ?>">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end external link
						
						case 'Portfolio Content':
        				default:
        			?>
        			<a href="<?php echo esc_url(get_permalink($portfolio_ID)); ?>">
        				<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
        				
        				<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
        				
        				<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
	                
	                <?php
						break;
						//portfolio content
        				
        				case 'Image':
					?>
					<a data-caption="<?php echo esc_attr(get_the_title()); ?>" href="<?php echo esc_url($image_url[0]); ?>" class="fancy-gallery">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
	                </a>
					
					<?php
						break;
						//end image
						
						case 'Youtube Video':
					?>
					
					<a href="https://www.youtube.com/embed/<?php echo esc_attr($portfolio_video_id); ?>" class="lightbox_youtube" data-options="width:1425, height:802">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end youtube
					
					case 'Vimeo Video':
					?>
					<a href="https://player.vimeo.com/video/<?php echo esc_attr($portfolio_video_id); ?>?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end vimeo
						
					case 'Self-Hosted Video':
					
						//Get video URL
						$portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
						$preview_image = wp_get_attachment_image_src($image_id, 'large', true);
					?>
					<a href="<?php echo esc_url($portfolio_mp4_url); ?>" class="lightbox_vimeo">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end self-hosted
					?>
					
					<?php
						}
						//end switch
					?>
			<?php
				}		
			?>
		</div>
	</div>
<?php
	}
	//End foreach
?>
	</div>
</div>

<?php
	}
}
?>
		   

<?php
	//Disable all link for live builder
	if($is_live_builder)
	{
?>
<script>
jQuery(document).ready(function(){
	jQuery('body a').live('click', function() { return false; });
	parent.triggerResize();
	parent.hideLoading();
});
</script>
<style>
.parallax
{
	z-index: 0;
}
</style>
<?php
	}
?>

<?php get_footer(); ?>