<?php
/**
 * The main template file for display portfolio page.
 *
 * @package WordPress
 */

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandphotography_page_gallery_id = grandphotography_get_page_gallery_id();
if(!empty($grandphotography_page_gallery_id))
{
	$current_page_id = $grandphotography_page_gallery_id;
}

//Check if password protected
get_template_part("/templates/template-password");

//Get gallery images
$all_photo_arr = get_post_meta($current_page_id, 'wpsimplegallery_gallery', true);


$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);

$grandphotography_homepage_style = grandphotography_get_homepage_style();
grandphotography_set_homepage_style('horizontal');

get_header();

wp_enqueue_script("grandphotography-horizontal-gallery", get_template_directory_uri()."/js/horizontal_gallery.js", false, THEMEVERSION, true);

$grandphotography_topbar = grandphotography_get_topbar();

//Get gallery header
get_template_part("/templates/template-gallery-header");
?>

<!-- Begin content -->
<div id="page_content_wrapper" class="transparent horizontal">
	<div id="horizontal_gallery">
	<table id="horizontal_gallery_wrapper">
	<tbody><tr>
	<?php
	    foreach($all_photo_arr as $photo_id)
		{
		    $small_image_url = '';
		    $image_url = '';
		    $hyperlink_url = get_permalink($photo_id);
		    $thumb_image_url = '';
		    
		    if(!empty($photo_id))
		    {
		    	$small_image_url = wp_get_attachment_image_src($photo_id, 'grandphotography-gallery-striped', true);
		    	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
		    }
		    
		    //Get image meta data
		    $image_caption = get_post_field('post_excerpt', $photo_id);
		    $image_caption_raw = $image_caption;
		    $image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
		    $tg_full_image_caption = kirki_get_option('tg_full_image_caption');
		    
		    $image_share_url = get_permalink($photo_id);
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
	?>
	<td>
	    <?php 
	    	if(isset($image_url[0]) && !empty($image_url[0]))
	    	{
	    ?>
	    	<div class="gallery_image_wrapper">
	    		<a <?php if(!empty($tg_full_image_caption)) { ?>data-caption="<?php if(!empty($image_caption)) { ?><?php echo esc_attr($image_caption); ?><?php } ?>"<?php } ?> class="fancy-gallery" href="<?php echo esc_url($image_url[0]); ?>">
		    		<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>" class="horizontal_gallery_img"/>
		    	</a>
		    	<?php
				     //Get image purchase URL
				     $grandphotography_purchase_url = get_post_meta($photo_id, 'grandphotography_purchase_url', true);
				     
				     if(!empty($grandphotography_purchase_url))
				     {
				 ?>
				 <a href="<?php echo esc_url($grandphotography_purchase_url); ?>" title="<?php echo esc_html__('Purchase', 'grandphotography' ); ?>" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>
				 <?php
				     }
				 ?>
				 
				 <?php
				 	if(!empty($image_caption))
				 	{
				 ?>
					 <div class="image_caption_wrapper">
				    	<div class="image_caption">
						    <?php echo esc_html($image_caption_raw); ?>
					    </div>
					 </div>
				<?php
					}
				?>
	    	</div>
	    <?php
	    	}		
	    ?>
	</td>
	
	<?php
	    }
	?>
	</tr></tbody>
	</table>
	
	</div>
	
	</div>
</div>
<?php
	//Get share button
	get_template_part("/templates/template-post-share");
	
	//Get gallery navigation
	get_template_part("/templates/template-gallery-navigation");

	get_footer();
?>