<?php

/**
 * The PHP code for setup Theme page custom fields.
 */

function grandphotography_page_create_meta_box() {

	$grandphotography_page_postmetas = grandphotography_get_page_postmetas();
	
	if ( function_exists('add_meta_box') && isset($grandphotography_page_postmetas) && count($grandphotography_page_postmetas) > 0 ) {  
		add_meta_box( 'page_metabox', 'Page Options', 'grandphotography_page_new_meta_box', 'page', 'normal', 'default' );  
	}

}  

function grandphotography_page_new_meta_box() {
	$post = grandphotography_get_wp_post();
	$grandphotography_page_postmetas = grandphotography_get_page_postmetas();
	
	//Get page template sample URL
	$page_template_url = array (
	  'Default Template' 						=> grandphotography_get_demo_url('/pages/page-fullwidth/'),
	  'Blog Fullwidth' 							=> grandphotography_get_demo_url('/blog/blog-fullwidth/'),
	  'Blog Full + Grid Fullwidth' 				=> grandphotography_get_demo_url('/blog/blog-full-post-grid-fullwidth/'),
	  'Blog Full + Grid Left Sidebar' 			=> grandphotography_get_demo_url('/blog/blog-full-post-grid-left-sidebar/'),
	  'Blog Full + Grid Right Sidebar' 			=> grandphotography_get_demo_url('/blog/blog-full-post-grid-right-sidebar/'),
	  'Blog Grid' 								=> grandphotography_get_demo_url('/blog/blog-grid/'),
	  'Blog Grid Left Sidebar' 					=> grandphotography_get_demo_url('/blog/blog-grid-left-sidebar/'),
	  'Blog Grid Right Sidebar' 				=> grandphotography_get_demo_url('/blog/blog-grid-right-sidebar/'),
	  'Blog Left Sidebar' 						=> grandphotography_get_demo_url('/blog/blog-left-sidebar/'),
	  'Blog Right Sidebar' 						=> grandphotography_get_demo_url('/blog/blog-right-sidebar/'),
	  'Blog Split Screen' 						=> grandphotography_get_demo_url('/blog/blog-split-screen/'),
	  'Client Archive' 							=> grandphotography_get_demo_url('/pages/client-archive/'),
	  'Event 2 Columns' 						=> grandphotography_get_demo_url('/pages/event-2-columns/'),
	  'Event 3 Columns' 						=> grandphotography_get_demo_url('/pages/event-3-columns/'),
	  'Event 4 Columns' 						=> grandphotography_get_demo_url('/pages/event-4-columns/'),
	  'Gallery Archive 2 Columns Contained' 	=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-2-columns-contained/'),
	  'Gallery Archive 2 Columns Wide' 			=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-2-columns-wide/'),
	  'Gallery Archive 3 Columns Contained' 	=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-3-columns-contained/'),
	  'Gallery Archive 3 Columns Wide' 			=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-3-columns-wide/'),
	  'Gallery Archive 4 Columns Contained' 	=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-4-columns-contained/'),
	  'Gallery Archive 4 Columns Wide' 			=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-4-columns-wide/'),
	  'Gallery Archive Board' 					=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-3-board/'),
	  'Gallery Archive Fullscreen' 				=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-fullscreen/'),
	  'Gallery Archive Metro Contained' 		=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-metro-contained/'),
	  'Gallery Archive Metro Wide' 				=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-metro-wide/'),
	  'Gallery Archive Parallax' 				=> grandphotography_get_demo_url('/gallery-archive/gallery-archive-parallax/'),
	  'Gallery Archive Fullscreen Split Screen' => grandphotography_get_demo_url('/gallery-archive/gallery-archive-split-screen/'),
	  'Page Split Screen' 						=> grandphotography_get_demo_url('/pages/page-split-screen/'),
	  'Fullscreen Vimeo Video' 					=> grandphotography_get_demo_url('/fullscreen-vimeo-video/'),
	  'Fullscreen Youtube Video' 				=> grandphotography_get_demo_url('/fullscreen-youtube-video/'),
	  'Page Left Sidebar' 						=> grandphotography_get_demo_url('/pages/page-left-sidebar/'),
	  'Page Right Sidebar' 						=> grandphotography_get_demo_url('/pages/page-right-sidebar/'),
	  'Portfolio 2 Columns Contained Classic' 	=> grandphotography_get_demo_url('/portfolio-2-columns-contained-classic/'),
	  'Portfolio 2 Columns Contained' 			=> grandphotography_get_demo_url('/portfolio/portfolio-2-columns-contained/'),
	  'Portfolio 2 Columns Wide Classic' 		=> grandphotography_get_demo_url('/portfolio/portfolio-2-columns-wide-classic/'),
	  'Portfolio 2 Columns Wide' 				=> grandphotography_get_demo_url('/portfolio/portfolio-2-columns-wide/'),
	  'Portfolio 3 Columns Contained' 			=> grandphotography_get_demo_url('/portfolio/portfolio-3-columns-contained/'),
	  'Portfolio 3 Columns Contained Classic' 	=> grandphotography_get_demo_url('/portfolio-3-columns-contained-classic/'),
	  'Portfolio 3 Columns Wide Classic' 		=> grandphotography_get_demo_url('/portfolio/portfolio-3-columns-wide-classic/'),
	  'Portfolio 3 Columns Wide' 				=> grandphotography_get_demo_url('/portfolio/portfolio-3-columns-wide/'),
	  'Portfolio 4 Columns Contained Classic' 	=> grandphotography_get_demo_url('/portfolio-4-columns-contained-classic/'),
	  'Portfolio 4 Columns Contained' 			=> grandphotography_get_demo_url('/portfolio/portfolio-4-columns-contained/'),
	  'Portfolio 4 Columns Wide Classic' 		=> grandphotography_get_demo_url('/portfolio/portfolio-4-columns-wide-classic/'),
	  'Portfolio 4 Columns Wide' 				=> grandphotography_get_demo_url('/portfolio/portfolio-4-columns-wide/'),
	  'Portfolio 5 Columns Wide' 				=> grandphotography_get_demo_url('/portfolio/portfolio-5-columns-wide/'),
	  'Portfolio Flow' 							=> grandphotography_get_demo_url('/portfolio/portfolio-flow/'),
	  'Portfolio Fullscreen Split Screen' 		=> grandphotography_get_demo_url('/portfolio/portfolio-fullscreen-split-screen/'),
	  'Portfolio Fullscreen' 					=> grandphotography_get_demo_url('/portfolio/portfolio-fullscreen/'),
	  'Portfolio Horizontal Contained' 			=> grandphotography_get_demo_url('/portfolio/portfolio-horizontal-contained/'),
	  'Portfolio Horizontal' 					=> grandphotography_get_demo_url('/portfolio/portfolio-horizontal/'),
	  'Portfolio Metro Contained' 				=> grandphotography_get_demo_url('/portfolio/portfolio-metro-contained/'),
	  'Portfolio Metro Wide' 					=> grandphotography_get_demo_url('/portfolio/portfolio-metro-wide/'),
	  'Portfolio Parallax' 						=> grandphotography_get_demo_url('/portfolio/portfolio-parallax/'),
	  'Portfolio Split Screen Wide' 			=> grandphotography_get_demo_url('/portfolio/portfolio-split-screen-wide/'),
	  'Portfolio Split Screen Classic' 			=> grandphotography_get_demo_url('/portfolio/portfolio-split-screen-classic/'),
	  'Portfolio Split Screen' 					=> grandphotography_get_demo_url('/portfolio/portfolio-split-screen/'),
	  'Portfolio Striped' 						=> grandphotography_get_demo_url('/portfolio/portfolio-striped/'),
	);

	echo '<input type="hidden" name="pp_meta_form" id="pp_meta_form" value="' . wp_create_nonce('grandphotography_once') . '" />';
	
	//Get visual page template option
	$pp_visual_page_templates = get_option('pp_visual_page_templates');
	
	$meta_section = '';
	$key = 0;
	foreach ( $grandphotography_page_postmetas as $key => $postmeta ) {

		$meta_id = $postmeta['id'];
		$meta_title = $postmeta['title'];
		$meta_description = $postmeta['description'];
		$meta_section = $postmeta['section'];
		
		$meta_type = '';
		if(isset($postmeta['type']))
		{
			$meta_type = $postmeta['type'];
		}
		
		echo '<div id="page_option_'.strtolower($postmeta['id']).'" class="pp_meta_option page key'.intval($key+1).' '.$meta_type.'">';
		echo "<div class=\"meta_title_wrapper\">";
		echo "<strong>".$meta_title."</strong>";
		
		echo "<div class='pp_widget_description'>$meta_description</div>";
		
		echo "</div>";
		echo "<div class=\"meta_title_field\">";

		if ($meta_type == 'checkbox') {
			$checked = get_post_meta($post->ID, $meta_id, true) == '1' ? "checked" : "";
			echo "<input type='checkbox' name='$meta_id' id='$meta_id' class='iphone_checkboxes' value='1' $checked />";
		}
		else if ($meta_type == 'select') {
			echo "<select name='$meta_id' id='$meta_id'>";
			
			if(!empty($postmeta['items']))
			{
				foreach ($postmeta['items'] as $key => $item)
				{
					$page_style = get_post_meta($post->ID, $meta_id);
				
					if(isset($page_style[0]) && $key == $page_style[0])
					{
						$css_string = 'selected';
					}
					else
					{
						$css_string = '';
					}
				
					echo '<option value="'.$key.'" '.$css_string.'>'.$item.'</option>';
				}
			}
			
			echo "</select>";
		}
		else if ($meta_type == 'template') {
		    $current_value = get_post_meta($post->ID, $meta_id, true);
		    
		    echo "<input type='hidden' name='$meta_id' id='$meta_id' value='$current_value' />";
		    echo "<ul name=\"".$meta_id."_list\" id=\"".$meta_id."_list\" class=\"meta_template_list\">";
		    
		    echo '<li data-parent="'.$meta_id.'" data-value="Default Template" data-type="page" ';
		    
		    if($current_value == 'Default Template')
		    {
		        echo 'class="checked"';
		    }
		    
		    echo '>';
		    
		    //Check if use visual page templates
		    if(!empty($pp_visual_page_templates))
		    {
			    if(isset($page_template_url['Default Template']))
				{
				    echo '<a href="'.esc_url($page_template_url['Default Template']).'" target="_blank" title="View Sample" class="tooltipster meta_template_link"><i class="fa fa-external-link"></i></a>';
				}
			    
			    echo '<a href="javascript:;" class="preview"><img src="'.get_template_directory_uri().'/functions/images/page/default.png"/></a><div class="meta_template_check"><i class="fa fa-check"></i></div>';
		    }
		    echo '<div class="template_title">Default Template</div>';
		    echo '</li>';
		    
		    if(!empty($postmeta['items']))
		    {
		    	foreach ($postmeta['items'] as $key => $image_thumb)
		    	{
		    		if(array_key_exists($key, $page_template_url))
		    		{
			    		echo '<li data-parent="'.$meta_id.'" data-value="'.esc_attr($key).'" data-type="page" ';
			    		
			    		if($key == $current_value)
			    		{
			    			echo 'class="checked"';
			    		}
			    		
			    		echo '>';
			    		
			    		//Check if use visual page templates
					    if(!empty($pp_visual_page_templates))
					    {
				    		if(isset($page_template_url[$key]))
							{
							    echo '<a href="'.esc_url($page_template_url[$key]).'" target="_blank" title="View Sample" class="tooltipster meta_template_link"><i class="fa fa-external-link"></i></a><a href="javascript:;" class="preview"><img src="'.$image_thumb.'"/></a><div class="meta_template_check"><i class="fa fa-check"></i></div>';
							}
			    		}
			    		echo '<div class="template_title">'.$key.'</div>';
			    		echo '</li>';
			    	}
		    	}
		    }
		    
		    echo "</ul>";
		}
		else if ($meta_type == 'file') { 
		    echo "<input type='text' name='$meta_id' id='$meta_id' class='' value='".get_post_meta($post->ID, $meta_id, true)."' style='width:calc(100% - 75px)' /><input id='".$meta_id."_button' name='".$meta_id."_button' type='button' value='Upload' class='metabox_upload_btn button' readonly='readonly' rel='".$meta_id."' style='margin:0 0 0 5px' />";
		}
		else if ($meta_type == 'textarea') { 
			echo "<textarea name='$meta_id' id='$meta_id' class='' style='width:100%' rows='7'>".get_post_meta($post->ID, $meta_id, true)."</textarea>";
		}
		else {
			echo "<input type='text' name='$meta_id' id='$meta_id' class='' value='".get_post_meta($post->ID, $meta_id, true)."' style='width:100%' />";
		}
		
		echo '</div>';
		echo '</div>';
	}

}

function grandphotography_page_save_postdata( $post_id ) {

	$grandphotography_page_postmetas = grandphotography_get_page_postmetas();

	// verify this came from the our screen and with proper authorization,
	// because save_post can be triggered at other times

	if ( isset($_POST['pp_meta_form']) && !wp_verify_nonce( $_POST['pp_meta_form'], 'grandphotography_once' )) {
		return $post_id;
	}

	// verify if this is an auto save routine. If it is our form has not been submitted, so we dont want to do anything

	if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;

	// Check permissions

	if ( isset($_POST['post_type']) && 'page' == $_POST['post_type'] ) {
		if ( !current_user_can( 'edit_page', $post_id ) )
			return $post_id;
		} else {
		if ( !current_user_can( 'edit_post', $post_id ) )
			return $post_id;
	}

	// OK, we're authenticated

	if ( $parent_id = wp_is_post_revision($post_id) )
	{
		$post_id = $parent_id;
	}
	
	if (isset($_POST['pp_meta_form'])) 
	{
		//If import page content builder
		if(is_admin() && isset($_POST['ppb_import_current']) && !empty($_POST['ppb_import_current']))
		{
			//If upload import builder file
			if(isset($_FILES['ppb_import_current_file']['name']) && !empty($_FILES['ppb_import_current_file']['name']))
			{
				//Check if zip file
				$import_filename = $_FILES['ppb_import_current_file']['name'];
				$import_type = $_FILES['ppb_import_current_file']['type'];
				$is_zip = FALSE;
				$new_filename = basename($import_filename, '_.zip');
				
				$accepted_types = array('application/zip', 
	                                'application/x-zip-compressed', 
	                                'multipart/x-zip', 
	                                'application/s-compressed');
	 
			    foreach($accepted_types as $mime_type) {
			        if($mime_type == $import_type) {
			            $is_zip = TRUE;
			            break;
			        } 
			    }
			}
			//If import demo pages
			else if(isset($_POST['ppb_import_demo_file']) && !empty($_POST['ppb_import_demo_file']))
			{
				$is_zip = FALSE;
			}
			//If import from saved template
			else if(isset($_POST['ppb_import_template_key']) && !empty($_POST['ppb_import_template_key']))
			{
				$is_zip = FALSE;
			} 
			
			WP_Filesystem();
			
			if($is_zip)
			{
				$upload_dir = wp_upload_dir();
				$cache_dir = '';
				
				if(isset($upload_dir['basedir']))
				{
					$cache_dir = $upload_dir['basedir'].'/meteors';
				}
				
				move_uploaded_file($_FILES["ppb_import_current_file"]["tmp_name"], $cache_dir.'/'.$import_filename);
				//$unzipfile = unzip_file( $cache_dir.'/'.$import_filename, $cache_dir);
				
				$zip = new ZipArchive();
				$x = $zip->open($cache_dir.'/'.$import_filename);
				
				for($i = 0; $i < $zip->numFiles; $i++) {
			        $new_filename = $zip->getNameIndex($i);
			        break;
			    }  
				
				if ($x === true) {
					$zip->extractTo($cache_dir); 
					$zip->close();
				}

				$wp_filesystem = grandphotography_get_wp_filesystem();
				$import_options_json = $wp_filesystem->get_contents($cache_dir.'/'.$new_filename);
				
				unlink($cache_dir.'/'.$import_filename);
				unlink($cache_dir.'/'.$new_filename);
			}
			else
			{
				$wp_filesystem = grandphotography_get_wp_filesystem();
			
				//If import demo pages
				if(isset($_POST['ppb_import_demo_file']) && !empty($_POST['ppb_import_demo_file']))
				{
					$import_options_json = $wp_filesystem->get_contents(get_template_directory().'/cache/demos/pages/'.$_POST['ppb_import_demo_file']);
				}
				//If import from saved template
				else if(isset($_POST['ppb_import_template_key']) && !empty($_POST['ppb_import_template_key']))
				{
					$import_options_json = get_option( SHORTNAME."_template_".$_POST['ppb_import_template_key']);
				}
				//If upload import builder file
				else
				{
					//If .json file then import
					$import_options_json = $wp_filesystem->get_contents($_FILES["ppb_import_current_file"]["tmp_name"]);
				}
			}
			
			//Decode JSON content
			$import_options_arr = json_decode($import_options_json, true);
			
			if(isset($import_options_arr['ppb_form_data_order'][0]) && !empty($import_options_arr['ppb_form_data_order'][0]))
			{
				grandphotography_page_update_custom_meta($post_id, $import_options_arr['ppb_form_data_order'][0], 'ppb_form_data_order');
			}
			
			$ppb_item_arr = explode(',', $import_options_arr['ppb_form_data_order'][0]);
			
			if(is_array($ppb_item_arr) && !empty($ppb_item_arr))
			{
				foreach($ppb_item_arr as $key => $ppb_item_arr)
				{
					if(isset($import_options_arr[$ppb_item_arr.'_data'][0]) && !empty($import_options_arr[$ppb_item_arr.'_data'][0]))
					{
						grandphotography_page_update_custom_meta($post_id, $import_options_arr[$ppb_item_arr.'_data'][0], $ppb_item_arr.'_data');
					}
					
					if(isset($import_options_arr[$ppb_item_arr.'_size'][0]) && !empty($import_options_arr[$ppb_item_arr.'_size'][0]))
					{
						grandphotography_page_update_custom_meta($post_id, $import_options_arr[$ppb_item_arr.'_size'][0], $ppb_item_arr.'_size');
					}
				}
			}
			
			$refresh_url = '';
			if(isset($_POST['ppb_edit_mode']) && $_POST['ppb_edit_mode'] == 'live')
			{
				$refresh_url.= '&ppb_mode=live';
			}
			
			header("Location: ".$_SERVER['HTTP_REFERER'].$refresh_url);
			exit;
		}
	
		//If export page content builder
		if(is_admin() && isset($_POST['ppb_export_current']) && !empty($_POST['ppb_export_current']))
		{
			$json_file_name = $post_id;
	
			header('Content-disposition: attachment; filename='.$json_file_name.'.json');
			header('Content-type: application/json');
			
			//Get current content builder data
			$ppb_form_data_order = get_post_meta($post_id, 'ppb_form_data_order');
			$export_options_arr = array();
			
			if(!empty($ppb_form_data_order))
			{
				$export_options_arr['ppb_form_data_order'] = $ppb_form_data_order;

				//Get each builder module data
				$ppb_form_item_arr = explode(',', $ppb_form_data_order[0]);
			
				foreach($ppb_form_item_arr as $key => $ppb_form_item)
				{
					$ppb_form_item_data = get_post_meta($post_id, $ppb_form_item.'_data');
					$export_options_arr[$ppb_form_item.'_data'] = $ppb_form_item_data;
					
					$ppb_form_item_size = get_post_meta($post_id, $ppb_form_item.'_size');
					$export_options_arr[$ppb_form_item.'_size'] = $ppb_form_item_size;
				}
			}
		
			echo json_encode($export_options_arr);
			
			exit;
		}
	
		foreach ( $grandphotography_page_postmetas as $postmeta ) 
		{
		
			if (isset($_POST[$postmeta['id']]) && $_POST[$postmeta['id']]) {
				grandphotography_page_update_custom_meta($post_id, $_POST[$postmeta['id']], $postmeta['id']);
			}
	
			if (isset($_POST[$postmeta['id']]) && $_POST[$postmeta['id']] == "") {
				delete_post_meta($post_id, $postmeta['id']);
			}
			
			if (!isset($_POST[$postmeta['id']])) {
				delete_post_meta($post_id, $postmeta['id']);
			}
		}
		
		// Saving Page Builder Data
		if(isset($_POST['ppb_enable']) && !empty($_POST['ppb_enable']))
		{
			grandphotography_page_update_custom_meta($post_id, $_POST['ppb_enable'], 'ppb_enable');
		}
		else
		{
			delete_post_meta($post_id, 'ppb_enable');
		}

		if(isset($_POST['ppb_form_data_order']) && !empty($_POST['ppb_form_data_order']))
		{
			grandphotography_page_update_custom_meta($post_id, $_POST['ppb_form_data_order'], 'ppb_form_data_order');
			
			$ppb_item_arr = explode(',', $_POST['ppb_form_data_order']);
			if(is_array($ppb_item_arr) && !empty($ppb_item_arr))
			{
				foreach($ppb_item_arr as $key => $ppb_item_arr)
				{
					if(isset($_POST[$ppb_item_arr.'_data']) && !empty($_POST[$ppb_item_arr.'_data']))
					{
						grandphotography_page_update_custom_meta($post_id, $_POST[$ppb_item_arr.'_data'], $ppb_item_arr.'_data');
					}
					
					if(isset($_POST[$ppb_item_arr.'_size']) && !empty($_POST[$ppb_item_arr.'_size']))
					{
						grandphotography_page_update_custom_meta($post_id, $_POST[$ppb_item_arr.'_size'], $ppb_item_arr.'_size');
					}
				}
			}
		}
		//If content builder is empty
		else if(isset($_POST['ppb_remove_all']) && !empty($_POST['ppb_remove_all']))
		{
			grandphotography_page_update_custom_meta($post_id, '', 'ppb_form_data_order');
		}
	}
	
	//If enable Content Builder then also copy its content to standard page content
	if (isset($_POST['ppb_enable']) && !empty($_POST['ppb_enable']) && ! wp_is_post_revision( $post_id ) )
	{
		//unhook this function so it doesn't loop infinitely
		remove_action('save_post', 'grandphotography_page_save_postdata');
	
		//update the post, which calls save_post again
		$ppb_page_content = grandphotography_apply_builder($post_id, 'page', FALSE);
		
		$current_post = array (
	      'ID'           => $post_id,
	      'post_content' => $ppb_page_content,
	    );
	    
	    wp_update_post($current_post);
	    if (is_wp_error($post_id)) {
			$errors = $post_id->get_error_messages();
			foreach ($errors as $error) {
				echo esc_html($error);
			}
		}

		//re-hook this function
		add_action('save_post', 'grandphotography_page_save_postdata');
	}

}

function grandphotography_page_update_custom_meta($postID, $newvalue, $field_name) {

	if (isset($_POST['pp_meta_form'])) 
	{
		if (!get_post_meta($postID, $field_name)) {
			add_post_meta($postID, $field_name, $newvalue);
		} else {
			update_post_meta($postID, $field_name, $newvalue);
		}
	}

}

//init

add_action('admin_menu', 'grandphotography_page_create_meta_box'); 
add_action('save_post', 'grandphotography_page_save_postdata');  

/*
	End creating custom fields
*/

?>
