<?php
/**
 * The main template file for display single post portfolio.
 *
 * @package WordPress
*/

//Check if content builder preview
if(isset($_GET['rel']) && !empty($_GET['rel']) && isset($_GET['ppb_preview']))
{
	get_template_part("page-preview");
	die;
}

//Check if content builder preview page
if(isset($_GET['ppb_preview_page']))
{
	get_template_part("portfolio-preview-page");
	die;
}

if(isset($post->ID))
{
    $current_page_id = $post->ID;
}

get_header(); 

//Include custom header feature
get_template_part("/templates/template-portfolio-header");
?>

<?php
	//Check if use page builder
	$ppb_form_data_order = '';
	$ppb_form_item_arr = array();
	$ppb_enable = get_post_meta($current_page_id, 'ppb_enable', true);
?>

<?php
	if(!empty($ppb_enable))
	{
		//if dont have password set
		if(!post_password_required())
		{
?>
<div class="ppb_wrapper <?php if(!empty($pp_page_bg)) { ?>hasbg<?php } ?> <?php if(!empty($pp_page_bg) && !empty($global_pp_topbar)) { ?>withtopbar<?php } ?>">
<?php
	grandphotography_apply_builder($current_page_id, 'portfolios');
?>
</div>
<?php
		} //end if dont have password set
		else
		{
?>
<div id="page_content_wrapper" class="<?php if(!empty($pp_page_bg)) { ?>hasbg<?php } ?> <?php if(!empty($pp_page_bg) && !empty($global_pp_topbar)) { ?>withtopbar<?php } ?>">
    <div class="inner">
    	<!-- Begin main content -->
    	<div class="inner_wrapper">
    		<div class="sidebar_content full_width">
<?php
			the_content();
?>
    		<br/><br/></div>
    	</div>
    </div>
</div>
<?php
		}
	}
	else
	{
?>
    
    <div class="inner">

    	<!-- Begin main content -->
    	<div class="inner_wrapper">

	    	<div class="sidebar_content full_width">
	    	
	    		<?php
					if (have_posts())
					{ 
						while (have_posts()) : the_post();
		
						the_content();
		    		    
		    		    endwhile; 
		    		}
		    	?>
		    </div>
		    
    	</div>
    
    </div>
    <!-- End main content -->
   
</div> 
		    	
<?php
} // End if not using content builder
?>

<?php
//Check if enable portfolio comment
if (comments_open($post->ID)) 
{
?>
<br class="clear"/><br/><br/><hr class="small"/><br class="clear"/><br/>
<div class="standard_wrapper">
	<div class="fullwidth_comment_wrapper">
		<?php comments_template( '', true ); ?>
	</div>
</div>
<br class="clear"/><br/>
<?php
}
?>

<?php
	//Display share button
	$tg_portfolio_sharing = kirki_get_option('tg_portfolio_sharing');
	
	if(!empty($tg_portfolio_sharing))
	{
		//Get share button
		get_template_part("/templates/template-post-share");
	}

	//Get portfolio navigation
	get_template_part("/templates/template-portfolio-navigation");
?>

<?php
//Check if displays recent portfolio
$tg_portfolio_recent = kirki_get_option('tg_portfolio_recent');

if(!empty($tg_portfolio_recent))
{
	$tg_portfolio_recent_items = kirki_get_option('tg_portfolio_recent_items');
	
	$args = array(
        'numberposts' => intval($tg_portfolio_recent_items),
        'order' => 'DESC',
        'orderby' => 'date',
        'post_type' => array('portfolios'),
        'suppress_filters' => 0,
    );
    
    if(THEMEDEMO)
	{
		$args['tax_query'] = array(
		    array(
		        'taxonomy' => 'portfoliosets',
		        'terms' => array(DEMOPORTFOLIOSETID),
		        'field' => 'slug',
		        'operator' => 'NOT IN',
		    ),
		);
	}
    
    $recent_post = get_posts($args);
    
    if(!empty($recent_post))
    {
    	wp_enqueue_script("grandphotography-custom-grid-portfolio-click", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=3&id=portfolio_filter_wrapper&button_id=infinite_load_more&loading_id=infinite_loading"), false, THEMEVERSION, true);
?>
<br class="clear"/>
<div class="standard_wrapper single_portfolio">
	<hr class="double"/><br class="clear"/><br/>
	<h6 class="subtitle"><span><?php esc_html_e('More Portfolios', 'grandphotography' ); ?></span></h6>
	<br class="clear"/>
	<div id="portfolio_filter_wrapper" class="single_recent_portfolio gallery three_cols portfolio-content section content clearfix" data-columns="3">
<?php
	foreach($recent_post as $key => $recent_item)
	{
		$image_url = '';
		$portfolio_ID = $recent_item->ID;
		    	
		if(has_post_thumbnail($portfolio_ID, 'original'))
		{
		    $image_id = get_post_thumbnail_id($portfolio_ID);
		    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
		    
		    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
		}
		
		$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
		
		if(empty($portfolio_link_url))
		{
		    $permalink_url = get_permalink($portfolio_ID);
		}
		else
		{
		    $permalink_url = $portfolio_link_url;
		}
		
		//Get portfolio category
		$portfolio_item_set = '';
		$portfolio_item_sets = wp_get_object_terms($portfolio_ID, 'portfoliosets');
		
		if(is_array($portfolio_item_sets))
		{
		    foreach($portfolio_item_sets as $set)
		    {
		    	$portfolio_item_set.= $set->slug.' ';
		    }
		}
?>
	<div class="element grid classic3_cols <?php echo esc_attr($portfolio_item_set); ?>" data-type="<?php echo esc_attr($portfolio_item_set); ?>">
	
		<div class="one_third gallery3 static filterable gallery_type animated<?php echo esc_attr($key+1); ?> portfolio_type" data-id="post-<?php echo esc_attr($key+1); ?>">
		<?php 
				if(!empty($image_url[0]))
				{
			?>		
					<?php
						$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
						$portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
						
						switch($portfolio_type)
						{
						case 'External Link':
							$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
					?>
					<a target="_blank" href="<?php echo esc_url($portfolio_link_url); ?>">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($recent_item->post_title); ?>"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo $recent_item->post_title; ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end external link
						
						case 'Portfolio Content':
        				default:
        			?>
        			<a href="<?php echo esc_url(get_permalink($portfolio_ID)); ?>">
        				<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($recent_item->post_title); ?>" />
        				
        				<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
        				
        				<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo $recent_item->post_title; ?></h6>
        					</div>
				        </div>
		            </a>
	                
	                <?php
						break;
						//portfolio content
        				
        				case 'Image':
					?>
					<a data-caption="<?php echo esc_attr($recent_item->post_title); ?>" href="<?php echo esc_url($image_url[0]); ?>" class="fancy-gallery">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($recent_item->post_title); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo $recent_item->post_title; ?></h6>
        					</div>
				        </div>
	                </a>
					
					<?php
						break;
						//end image
						
						case 'Youtube Video':
					?>
					
					<a href="https://www.youtube.com/embed/<?php echo esc_attr($portfolio_video_id); ?>" class="lightbox_youtube" data-options="width:1425, height:802">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($recent_item->post_title); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo $recent_item->post_title; ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end youtube
					
					case 'Vimeo Video':
					?>
					<a href="https://player.vimeo.com/video/<?php echo esc_attr($portfolio_video_id); ?>?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($recent_item->post_title); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo $recent_item->post_title; ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end vimeo
						
					case 'Self-Hosted Video':
					
						//Get video URL
						$portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
						$preview_image = wp_get_attachment_image_src($image_id, 'large', true);
					?>
					<a href="<?php echo esc_url($portfolio_mp4_url); ?>" class="lightbox_vimeo">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($recent_item->post_title); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo $recent_item->post_title; ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end self-hosted
					?>
					
					<?php
						}
						//end switch
					?>
			<?php
				}		
			?>
		</div>
	</div>
<?php
	}
	//End foreach
?>
	</div>
</div>

<?php
	}
}
?>

<?php get_footer(); ?>