<?php
/**
 * The main template file for display single post page.
 *
 * @package WordPress
*/

get_header();

$grandphotography_topbar = grandphotography_get_topbar();

/**
*	Get current page id
**/

$current_page_id = $post->ID;

//If display feat content
$tg_blog_feat_content = kirki_get_option('tg_blog_feat_content');

/**
*	Get current page id
**/

$current_page_id = $post->ID;

//Include custom header feature
get_template_part("/templates/template-post-header");
?>
    
    <div class="inner">

    	<!-- Begin main content -->
    	<div class="inner_wrapper">

	    	<div class="sidebar_content full_width">
					
<?php
if (have_posts()) : while (have_posts()) : the_post();
?>
						
<!-- Begin each blog post -->
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="post_wrapper">
	    
	    <div class="post_content_wrapper">
	    
	    	<?php
	    		$large_image_url = wp_get_attachment_image_src($current_page_id, 'original', true);
	    		
	    		$image_caption = get_post_field('post_excerpt', $current_page_id);
				$image_description = get_post_field('post_content', $current_page_id);
			?>
			
			<img src="<?php echo esc_url($large_image_url[0]); ?>" alt="" class="post_img" />
			
			<div class="post_header">
			    <div class="post_header_title">
			    	<h5><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr($image_caption); ?>"><?php echo esc_html($image_caption); ?></a></h5>

			    	<div class="post_detail single_post">
			    		<span class="post_info_date">
			        		<?php echo esc_html($image_description); ?>
			    		</span>
			    	</div>
			    	
			    	<div class="post_info_cat">
			    	    <?php
			    	    	//Get Post's Categories
			    	    	$post_categories = wp_get_post_categories($post->ID);
			    	    	
			    	    	$count_categories = count($post_categories);
			    			$i = 0;
			    	    	
			    	    	if(!empty($post_categories))
			    	    	{
			    	    		echo esc_html_e('In', 'grandphotography' ).'&nbsp;';
			    	    	
			    	        	foreach($post_categories as $key => $c)
			    	        	{
			    	        		$cat = get_category( $c );
			    	    ?>
			    	        	<a href="<?php echo esc_url(get_category_link($cat->term_id)); ?>"><?php echo esc_html($cat->name); ?></a>
			    	    <?php
			    	    			if(++$i != $count_categories) 
			    	    			{
			    	    				echo '&nbsp;/&nbsp;';
			    	    			}
			    	        	}
			    	        }
			    	    ?>
			    	</div>
			    </div>
			</div>
			
			<?php
				//Get photo EXIF data
				echo grandphotography_get_exif();
			?>
			
			<br class="clear"/><br/><hr class="double"/>
			
			<?php
				//Get share button
				get_template_part("/templates/template-post-share");
			?>
			
	    </div>
	    
	</div>

</div>
<!-- End each blog post -->


<?php
if (comments_open($post->ID)) 
{
?>
<br class="clear"/>
<div class="fullwidth_comment_wrapper">
	<?php comments_template( '', true ); ?>
</div>
<?php
}
?>

<?php endwhile; endif; ?>
    	
    	</div>
    
    </div>
    <!-- End main content -->
   
</div>

<br class="clear"/><br/><br/>
</div>
<?php get_footer(); ?>