<?php
/**
 * Template Name: Portfolio Striped
 * The main template file for display portfolio page.
 *
 * @package WordPress
 */

/**
*	Get Current page object
**/
$ob_page = get_page($post->ID);
$current_page_id = '';

if(isset($ob_page->ID))
{
    $current_page_id = $ob_page->ID;
}

get_header();

wp_enqueue_script("grandphotography-horizontal-gallery", get_template_directory_uri()."/js/horizontal_gallery.js", false, THEMEVERSION, true);

$grandphotography_topbar = grandphotography_get_topbar();

$grandphotography_get_portfolio_filterable_header = grandphotography_get_portfolio_filterable_header();
grandphotography_set_portfolio_filterable_header(true);

//Include custom header feature
get_template_part("/templates/template-header");

$tg_portfolio_filterable = kirki_get_option('tg_portfolio_filterable');
if(!empty($tg_portfolio_filterable))
{
	wp_enqueue_script("grandphotography-custom-horizontal-portfolio-filterable-click", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_horizontal_portfolio_filterable_click&id=horizontal_gallery_wrapper&loading_id=infinite_loading&type=striped"), false, THEMEVERSION, true);
}
?>

<!-- Begin content -->
<div id="page_content_wrapper" class="transparent horizontal">
	<div id="horizontal_gallery">
	<table id="horizontal_gallery_wrapper">
	<tbody><tr>
	<?php
	    //Get all portfolio items for paging
		$wp_query = grandphotography_get_wp_query();
		
		$query_string = 'paged='.$paged.'&orderby=menu_order&order=ASC&post_type=portfolios&numberposts=-1&suppress_filters=0&posts_per_page=-1';
		
		if(!empty($term))
		{
			$ob_term = get_term_by('slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
			$custom_tax = $wp_query->query_vars['taxonomy'];
		    $query_string .= '&posts_per_page=-1&'.$custom_tax.'='.$term;
		}
		
		parse_str($query_string, $args);
		
		if(THEMEDEMO)
		{
			$args['tax_query'] = array(
			    array(
			        'taxonomy' => 'portfoliosets',
			        'terms' => array(DEMOPORTFOLIOSETID),
			        'field' => 'slug',
			        'operator' => 'NOT IN',
			    ),
			);
		}
	
		query_posts($args);
	
	    $key = 0;
	    if (have_posts()) : while (have_posts()) : the_post();
	    	$key++;
			$image_url = '';
			$portfolio_ID = get_the_ID();
					
			if(has_post_thumbnail($portfolio_ID, 'grandphotography-gallery-striped'))
			{
			    $image_id = get_post_thumbnail_id($portfolio_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-striped', true);
			}
			
			$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
			
			if(empty($portfolio_link_url))
			{
			    $permalink_url = get_permalink($portfolio_ID);
			}
			else
			{
			    $permalink_url = $portfolio_link_url;
			}
	        
		    if(!empty($image_url[0]))
		    {
		    	$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
				$portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
				
				switch($portfolio_type)
			    {
				    case 'External Link':
				    	$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
	?>	
	<td>
		<a href="<?php echo esc_url($portfolio_link_url); ?>">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php
					break;
				    
				    case 'Portfolio Content':
				    default:
	?>
	<td>
		<a href="<?php echo esc_url(get_permalink($portfolio_ID)); ?>">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php 
				    break;
				    
				    case 'Image':
	?>
	<td>
		<a data-caption="<?php echo esc_attr(get_the_title()); ?>" href="<?php echo esc_url($image_url[0]); ?>" class="fancy-gallery">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php
				    break;
				    
				    case 'Youtube Video':
	?>
	<td>
		<a href="https://www.youtube.com/embed/<?php echo esc_attr($portfolio_video_id); ?>" class="lightbox_youtube" data-options="width:1425, height:802">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php			    
				    break;
				    
				    case 'Vimeo Video':
	?>
	<td>
		<a href="https://player.vimeo.com/video/<?php echo esc_attr($portfolio_video_id); ?>?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php
				    break;
				    
				    case 'Self-Hosted Video':
				    
				    //Get video URL
					$portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
					$preview_image = wp_get_attachment_image_src($image_id, 'large', true);
	?>
	<td>
		<a href="<?php echo esc_url($portfolio_mp4_url); ?>" class="lightbox_vimeo">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php				
					break;
				}
		    }

	    endwhile; endif;	
	?>
	</tr></tbody>
	</table>
	<br class="clear"/>
	<div id="infinite_loading" class="infinite_loading"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
	</div>
	</div>
</div>

<?php
	get_footer();
?>