<?php
/**
 * Template Name: Portfolio Parallax
 * The main template file for display gallery page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$ob_page = get_page($post->ID);
$current_page_id = '';

if(isset($ob_page->ID))
{
    $current_page_id = $ob_page->ID;
}

get_header();

$grandphotography_page_content_class = grandphotography_get_page_content_class();
grandphotography_set_page_content_class('wide');

$grandphotography_screen_class = grandphotography_get_screen_class();
grandphotography_set_screen_class('single_gallery');

//Include custom header feature
get_template_part("/templates/template-header");
?>

<!-- Begin content --> 
<div class="inner">

	<div class="inner_wrapper nopadding">
	
	<div id="page_main_content" class="sidebar_content full_width nopadding fixed_column">
	
	<?php
	    //Get all portfolio items for paging
		$wp_query = grandphotography_get_wp_query();
		
		$query_string = 'paged='.$paged;
		$query_string.= grandphotography_get_initial_portfolio_query(2);
		
		if(!empty($term))
		{
			$ob_term = get_term_by('slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
			$custom_tax = $wp_query->query_vars['taxonomy'];
		    $query_string .= '&posts_per_page=-1&'.$custom_tax.'='.$term;
		}
		
		parse_str($query_string, $args);
		
		if(THEMEDEMO)
		{
			$args['tax_query'] = array(
			    array(
			        'taxonomy' => 'portfoliosets',
			        'terms' => array(DEMOPORTFOLIOSETID),
			        'field' => 'slug',
			        'operator' => 'NOT IN',
			    ),
			);
		}
	
		query_posts($args);
		$current_photo_count = $wp_query->post_count;
		$all_photo_count = $wp_query->found_posts;
	
	    $key = 0;
	    if (have_posts()) : while (have_posts()) : the_post();
	    	$small_image_url = array();
	        $image_url = '';
	        $portfolio_ID = get_the_ID();
	        		
	        if(has_post_thumbnail($portfolio_ID, 'original'))
	        {
	            $image_id = get_post_thumbnail_id($portfolio_ID);
	            $image_url = wp_get_attachment_image_src($image_id, 'original', true);
	        }
	        
	        $permalink_url = get_permalink($portfolio_ID);

	    if(!empty($image_url[0]))
		{
			$background_image = $image_url[0];
			$background_image_width = $image_url[1];
			$background_image_height = $image_url[2];
	?>
	<div class="one archive_parallax parallax" data-id="post-<?php echo esc_attr($key+1); ?>" style="background-image: url(<?php echo esc_attr($background_image); ?>);"></div>
		
		<?php
		    $portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
		    $portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
		    
		    switch($portfolio_type)
		    {
		    case 'External Link':
		    	$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
		?>
		<br class="clear"/>
		<div class="one parallax_content withpadding" style="text-align:center">
			<h4><?php the_title(); ?></h4>
			<hr class="title_break bold"/>
			<div class="page_tagline">
				<?php 
				    if(THEMEDEMO)
				    {
				    	echo 'Creativity thrives with collaboration.<br/>The joining of mind to forge something real.';
				    }
				    else
				    {
				    	the_excerpt();
				    }
				?>
			</div>
			<div class="post_button_wrapper">
			    <a class="readmore" href="<?php echo esc_url($portfolio_link_url); ?>"><?php echo esc_html_e('View Portfolio', 'grandphotography' ); ?></a>
			</div>
		</div>
		<br class="clear"/>
		
		<?php
		    break;
		    //end external link
		    
		    case 'Portfolio Content':
            default:
        ?>
        <br class="clear"/>
		<div class="one parallax_content withpadding" style="text-align:center">
			<h4><?php the_title(); ?></h4>
			<hr class="title_break bold"/>
			<div class="page_tagline">
				<?php 
				    if(THEMEDEMO)
				    {
				    	echo 'Creativity thrives with collaboration.<br/>The joining of mind to forge something real.';
				    }
				    else
				    {
				    	the_excerpt();
				    }
				?>
			</div>
			<div class="post_button_wrapper">
			    <a class="readmore" href="<?php echo esc_url($permalink_url); ?>"><?php echo esc_html_e('View Portfolio', 'grandphotography' ); ?></a>
			</div>
		</div>
		<br class="clear"/>
	    
	    <?php
		    break;
		    //portfolio content
            
            case 'Image':
		?>
		<br class="clear"/>
		<div class="one parallax_content withpadding" style="text-align:center">
			<h4><?php the_title(); ?></h4>
			<hr class="title_break bold"/>
			<div class="page_tagline">
				<?php 
				    if(THEMEDEMO)
				    {
				    	echo 'Creativity thrives with collaboration.<br/>The joining of mind to forge something real.';
				    }
				    else
				    {
				    	the_excerpt();
				    }
				?>
			</div>
			<div class="post_button_wrapper">
			    <a title="<?php echo esc_attr(get_the_title()); ?>" href="<?php echo esc_url($image_url[0]); ?>" class="readmore"><?php echo esc_html_e('View Image', 'grandphotography' ); ?></a>
			</div>
		</div>
		<br class="clear"/>
		
		<?php
		    break;
		    //end image
		    
		    case 'Youtube Video':
		?>
		<br class="clear"/>
		<div class="one parallax_content withpadding" style="text-align:center">
			<h4><?php the_title(); ?></h4>
			<hr class="title_break bold"/>
			<div class="page_tagline">
				<?php 
				    if(THEMEDEMO)
				    {
				    	echo 'Creativity thrives with collaboration.<br/>The joining of mind to forge something real.';
				    }
				    else
				    {
				    	the_excerpt();
				    }
				?>
			</div>
			<div class="post_button_wrapper">
			    <a href="https://www.youtube.com/embed/<?php echo esc_attr($portfolio_video_id); ?>" class="lightbox_youtube readmore" data-options="width:1425, height:802"><?php echo esc_html_e('Play Video', 'grandphotography' ); ?></a>
			</div>
		</div>
		<br class="clear"/>
		
		<?php
		    break;
		    //end youtube
		
		case 'Vimeo Video':
		?>
		<br class="clear"/>
		<div class="one parallax_content withpadding" style="text-align:center">
			<h4><?php the_title(); ?></h4>
			<hr class="title_break bold"/>
			<div class="page_tagline">
				<?php 
				    if(THEMEDEMO)
				    {
				    	echo 'Creativity thrives with collaboration.<br/>The joining of mind to forge something real.';
				    }
				    else
				    {
				    	the_excerpt();
				    }
				?>
			</div>
			<div class="post_button_wrapper">
			    <a href="https://player.vimeo.com/video/<?php echo esc_attr($portfolio_video_id); ?>?badge=0" class="lightbox_vimeo readmore" data-options="width:1425, height:802"><?php echo esc_html_e('Play Video', 'grandphotography' ); ?></a>
			</div>
		</div>
		<br class="clear"/>
		
		<?php
		    break;
		    //end vimeo
		    
		case 'Self-Hosted Video':
		
		    //Get video URL
		    $portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
		    $preview_image = wp_get_attachment_image_src($image_id, 'large', true);
		?>
		<br class="clear"/>
		<div class="one parallax_content withpadding" style="text-align:center">
			<h4><?php the_title(); ?></h4>
			<hr class="title_break bold"/>
			<div class="page_tagline">
				<?php 
				    if(THEMEDEMO)
				    {
				    	echo 'Creativity thrives with collaboration.<br/>The joining of mind to forge something real.';
				    }
				    else
				    {
				    	the_excerpt();
				    }
				?>
			</div>
			<div class="post_button_wrapper">
			    <a href="<?php echo esc_url($portfolio_mp4_url); ?>" class="lightbox_vimeo readmore"><?php echo esc_html_e('Play Video', 'grandphotography' ); ?></a>
			</div>
		</div>
		<br class="clear"/>
		
		<?php
		    break;
		    //end self-hosted
		?>
		
		<?php
		    }
		    //end switch
		?>
		
	<?php
		}
	
	    $key++;
	    endwhile; endif;	
	?>
	
	</div>

</div>
</div>
</div>
<?php get_footer(); ?>
<!-- End content -->