<?php
/*
Theme Name: Grand Photography Theme
Theme URI: http://themes.themegoods.com/grandphotography
Author: ThemeGoods
Author URI: http://themeforest.net/user/ThemeGoods
License: GPLv2
*/

//Setup theme default constant and data
require_once get_template_directory() . "/lib/config.lib.php";

//Setup theme translation
require_once get_template_directory() . "/lib/translation.lib.php";

//Setup theme admin action handler
require_once get_template_directory() . "/lib/admin.action.lib.php";

//Setup theme support and image size handler
require_once get_template_directory() . "/lib/theme.support.lib.php";

//Get custom function
require_once get_template_directory() . "/lib/custom.lib.php";

//Setup menu settings
require_once get_template_directory() . "/lib/menu.lib.php";

//Setup CSS compression related functions
require_once get_template_directory() . "/lib/cssmin.lib.php";

//Setup JS compression related functions
require_once get_template_directory() . "/lib/jsmin.lib.php";

//Setup Sidebar
require_once get_template_directory() . "/lib/sidebar.lib.php";

//Setup theme custom widgets
require_once get_template_directory() . "/lib/widgets.lib.php";

//Setup required plugin activation
require_once get_template_directory() . "/lib/tgm.lib.php";

//Setup theme admin settings
require_once get_template_directory() . "/lib/admin.lib.php";

/**
*	Begin Theme Setting Panel
**/ 
function grandphotography_add_menu_icons_styles(){
?>
 
<style>
#adminmenu .menu-icon-events div.wp-menu-image:before {
  content: '\f145';
}
#adminmenu .menu-icon-portfolios div.wp-menu-image:before {
  content: '\f119';
}
#adminmenu .menu-icon-galleries div.wp-menu-image:before {
  content: '\f161';
}
#adminmenu .menu-icon-testimonials div.wp-menu-image:before {
  content: '\f122';
}
#adminmenu .menu-icon-team div.wp-menu-image:before {
  content: '\f307';
}
#adminmenu .menu-icon-pricing div.wp-menu-image:before {
  content: '\f214';
}
#adminmenu .menu-icon-clients div.wp-menu-image:before {
  content: '\f110';
}
</style>
 
<?php
}
add_action( 'admin_head', 'grandphotography_add_menu_icons_styles' );

//Create theme admin panel
function grandphotography_add_admin() 
{
	$grandphotography_options = grandphotography_get_options();
	
	if ( isset($_GET['page']) && $_GET['page'] == 'functions.php' ) {
		
		$redirect_uri = '';
	 
		if ( isset($_REQUEST['action']) && 'save' == $_REQUEST['action'] ) {
			
			//check if verify purchase code
			if(isset($_REQUEST['pp_envato_personal_token']) && !empty($_REQUEST['pp_envato_personal_token']) && $_REQUEST['pp_envato_personal_token'] != '[ThemeGoods Activation]')
			{
				$is_verified_envato_purchase_code = false;
				require_once (get_template_directory() . "/lib/envato.lib.php");
				$obj_envato = new Envato($_REQUEST['pp_envato_personal_token']);
	
				update_option("pp_envato_personal_token", $_REQUEST['pp_envato_personal_token']);
				
				$obj_envato->set_response_type('array');
				
				$purchase_data = $obj_envato->call('/buyer/list-purchases?filter_by=wordpress-themes');
				
				if(isset($purchase_data['results']) && is_array($purchase_data['results']))
				{
					foreach($purchase_data['results'] as $result_arr)
					{
						if(isset($result_arr['item']['id']) && $result_arr['item']['id'] == ENVATOITEMID)
						{
							$is_verified_envato_purchase_code = true;
							update_option("pp_verified_envato_grandphotography", true);
							break;
						}
					}
				}
				else if(isset($_REQUEST['pp_envato_personal_token']) && $_REQUEST['pp_envato_personal_token'] == '[ThemeGoods Activation]')
				{
					$is_verified_envato_purchase_code = true;
				}
				else
				{
					$is_verified_envato_purchase_code = false;
					delete_option("pp_verified_envato_grandphotography", true);
				}
				
				if(!$is_verified_envato_purchase_code)
				{
					$redirect_uri.= '&action=invalid-purchase';
				}
			}
	 
			foreach ($grandphotography_options as $value) 
			{
				if($value['type'] != 'image' && isset($value['id']) && isset($_REQUEST[ $value['id'] ]))
				{
					update_option( $value['id'], $_REQUEST[ $value['id'] ] );
				}
			}
			
			foreach ($grandphotography_options as $value) {
			
				if( isset($value['id']) && isset( $_REQUEST[ $value['id'] ] )) 
				{ 
	
					if($value['id'] != SHORTNAME."_sidebar0" && $value['id'] != SHORTNAME."_ggfont0")
					{
						//if sortable type
						if(is_admin() && $value['type'] == 'sortable')
						{
							$sortable_array = serialize($_REQUEST[ $value['id'] ]);
							
							$sortable_data = $_REQUEST[ $value['id'].'_sort_data'];
							$sortable_data_arr = explode(',', $sortable_data);
							$new_sortable_data = array();
							
							foreach($sortable_data_arr as $key => $sortable_data_item)
							{
								$sortable_data_item_arr = explode('_', $sortable_data_item);
								
								if(isset($sortable_data_item_arr[0]))
								{
									$new_sortable_data[] = $sortable_data_item_arr[0];
								}
							}
							
							update_option( $value['id'], $sortable_array );
							update_option( $value['id'].'_sort_data', serialize($new_sortable_data) );
						}
						elseif(is_admin() && $value['type'] == 'font')
						{
							if(!empty($_REQUEST[ $value['id'] ]))
							{
								update_option( $value['id'], $_REQUEST[ $value['id'] ] );
								update_option( $value['id'].'_value', $_REQUEST[ $value['id'].'_value' ] );
							}
							else
							{
								delete_option( $value['id'] );
								delete_option( $value['id'].'_value' );
							}
						}
						elseif(is_admin())
						{
							if($value['type']=='image')
							{
								update_option( $value['id'], esc_url($_REQUEST[ $value['id'] ])  );
							}
							elseif($value['type']=='textarea')
							{
								if(isset($value['validation']) && !empty($value['validation']))
								{
									update_option( $value['id'], esc_textarea($_REQUEST[ $value['id'] ]) );
								}
								else
								{
									update_option( $value['id'], $_REQUEST[ $value['id'] ] );
								}
							}
							elseif($value['type']=='iphone_checkboxes' OR $value['type']=='jslider')
							{
								update_option( $value['id'], $_REQUEST[ $value['id'] ]  );
							}
							else
							{
								if(isset($value['validation']) && !empty($value['validation']))
								{
									$request_value = $_REQUEST[ $value['id'] ];
									
									//Begin data validation
									switch($value['validation'])
									{
										case 'text':
										default:
											$request_value = sanitize_text_field($request_value);
										
										break;
										
										case 'email':
											$request_value = sanitize_email($request_value);
	
										break;
										
										case 'javascript':
											$request_value = sanitize_text_field($request_value);
	
										break;
										
									}
									update_option( $value['id'], $request_value);
								}
								else
								{
									update_option( $value['id'], $_REQUEST[ $value['id'] ]  );
								}
							}
						}
					}
					elseif(is_admin() && isset($_REQUEST[ $value['id'] ]) && !empty($_REQUEST[ $value['id'] ]))
					{
						if($value['id'] == SHORTNAME."_sidebar0")
						{
							//get last sidebar serialize array
							$current_sidebar = get_option(SHORTNAME."_sidebar");
							$request_value = $_REQUEST[ $value['id'] ];
							$request_value = sanitize_text_field($request_value);
							
							$current_sidebar[ $request_value ] = $request_value;
				
							update_option( SHORTNAME."_sidebar", $current_sidebar );
						}
						elseif($value['id'] == SHORTNAME."_ggfont0")
						{
							//get last ggfonts serialize array
							$current_ggfont = get_option(SHORTNAME."_ggfont");
							$current_ggfont[ $_REQUEST[ $value['id'] ] ] = $_REQUEST[ $value['id'] ];
				
							update_option( SHORTNAME."_ggfont", $current_ggfont );
						}
					}
				} 
				else 
				{ 
					if(is_admin() && isset($value['id']))
					{
						delete_option( $value['id'] );
					}
				} 
			}
	
			header("Location: admin.php?page=functions.php&saved=true".$redirect_uri.$_REQUEST['current_tab']);
		}  
	} 
	 
	add_menu_page('Theme Setting', 'Theme Setting', 'administrator', 'functions.php', 'grandphotography_admin', '', 3);
}

function grandphotography_enqueue_admin_page_scripts() 
{
	$current_screen = grandphotography_get_current_screen();
	
	wp_enqueue_style('thickbox');
	
	if(property_exists($current_screen, 'base') && $current_screen->base != 'toplevel_page_revslider')
	{
		wp_enqueue_style('jquery-ui', get_template_directory_uri().'/functions/jquery-ui/css/custom-theme/jquery-ui-1.8.24.custom.css', false, '1.0', 'all');
	}
	
	wp_enqueue_style('grandphotography-functions', get_template_directory_uri().'/functions/functions.css', false, THEMEVERSION, 'all');
	
	if(property_exists($current_screen, 'post_type') && ($current_screen->post_type == 'page' OR $current_screen->post_type == 'portfolios'))
	{
		wp_enqueue_style('grandphotography-jqueryui', get_template_directory_uri().'/css/jqueryui/custom.css', false, THEMEVERSION, 'all');
	}
	
	wp_enqueue_style('grandphotography-colorpicker', get_template_directory_uri().'/functions/colorpicker/css/colorpicker.css', false, THEMEVERSION, 'all');
	wp_enqueue_style('fancybox', get_template_directory_uri().'/js/fancybox/jquery.fancybox.admin.css', false, THEMEVERSION, 'all');
	wp_enqueue_style('switchery', get_template_directory_uri().'/css/switchery.css', false, THEMEVERSION, 'all');
	wp_enqueue_style('timepicker', get_template_directory_uri().'/functions/jquery.timepicker.css', false, THEMEVERSION, 'all');
	wp_enqueue_style("fontawesome", get_template_directory_uri()."/css/font-awesome.min.css", false, THEMEVERSION, "all");
	wp_enqueue_style("tooltipster", get_template_directory_uri()."/css/tooltipster.css", false, THEMEVERSION, "all");
	
	if(isset($current_screen->base) && $current_screen->base == 'toplevel_page_functions')
	{
		wp_enqueue_style("codemirror", get_template_directory_uri()."/css/codemirror.css", false, THEMEVERSION, "all");
	}
	
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-tabs');
	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	wp_enqueue_script('jquery-ui-datepicker');
	
	$ap_vars = array(
	    'url' => esc_url(get_home_url('/')),
	    'includes_url' => esc_url(includes_url())
	);
	
	wp_register_script( 'js-wpeditor', get_template_directory_uri() . '/functions/js-wp-editor.js', array( 'jquery' ), '1.1', true );
	wp_localize_script( 'js-wpeditor', 'ap_vars', $ap_vars );
	wp_enqueue_script( 'js-wpeditor' );
	
	wp_enqueue_script('grandphotography-colorpicker', get_template_directory_uri().'/functions/colorpicker/js/colorpicker.js', false, THEMEVERSION);
	wp_enqueue_script('eye', get_template_directory_uri().'/functions/colorpicker/js/eye.js', false, THEMEVERSION);
	wp_enqueue_script('utils', get_template_directory_uri().'/functions/colorpicker/js/utils.js', false, THEMEVERSION);
	wp_enqueue_script('switchery', get_template_directory_uri().'/functions/switchery.js', false, THEMEVERSION);
	wp_enqueue_script('fancybox', get_template_directory_uri().'/js/fancybox/jquery.fancybox.admin.js', false, THEMEVERSION);
	wp_enqueue_script('timepicker', get_template_directory_uri().'/functions/jquery.timepicker.js', false, THEMEVERSION);
	wp_enqueue_script('tooltipster', get_template_directory_uri().'/js/jquery.tooltipster.min.js', false, THEMEVERSION);
	
	if(isset($current_screen->base) && $current_screen->base == 'toplevel_page_functions')
	{
		wp_enqueue_script('codemirror', get_template_directory_uri().'/functions/codemirror.js', false, THEMEVERSION);
		wp_enqueue_script('codemirror-css', get_template_directory_uri().'/functions/css.js', false, THEMEVERSION);
	}
	
	wp_register_script('grandphotography-theme-script', get_template_directory_uri().'/functions/theme_script.js', false, THEMEVERSION, true);
	$params = array(
	  'ajaxurl' => esc_url(admin_url('admin-ajax.php')),
	);
	wp_localize_script( 'grandphotography-theme-script', 'tgAjax', $params );
	wp_enqueue_script( 'grandphotography-theme-script' );
}

add_action('admin_enqueue_scripts',	'grandphotography_enqueue_admin_page_scripts' );

function grandphotography_enqueue_front_page_scripts() 
{
    wp_enqueue_style("grandphotography-reset-css", get_template_directory_uri()."/css/reset.css", false, "");
	wp_enqueue_style("grandphotography-wordpress-css", get_template_directory_uri()."/css/wordpress.css", false, "");
	wp_enqueue_style("grandphotography-animation-css", get_template_directory_uri()."/css/animation.css", false, "", "all");
	wp_enqueue_style("ilightbox", get_template_directory_uri()."/css/ilightbox/ilightbox.css", false, "", "all");
	wp_enqueue_style("jquery-ui", get_template_directory_uri()."/css/jqueryui/custom.css", false, "");
	wp_enqueue_style("mediaelement", get_template_directory_uri()."/js/mediaelement/mediaelementplayer.css", false, "", "all");
	wp_enqueue_style("flexslider", get_template_directory_uri()."/js/flexslider/flexslider.css", false, "", "all");
	wp_enqueue_style("tooltipster", get_template_directory_uri()."/css/tooltipster.css", false, "", "all");
	wp_enqueue_style("odometer-theme", get_template_directory_uri()."/css/odometer-theme-minimal.css", false, "", "all");
	wp_enqueue_style("grandphotography-screen", get_template_directory_uri().'/css/screen.css', false, "", "all");
	
	//Check menu layout
	$tg_menu_layout = grandphotography_menu_layout();
	
	switch($tg_menu_layout)
	{
		case 'leftmenu':
			wp_enqueue_style("grandphotography-leftmenu", get_template_directory_uri().'/css/menus/leftmenu.css', false, "", "all");
		break;
		
		case 'leftalign':
			wp_enqueue_style("grandphotography-leftalignmenu", get_template_directory_uri().'/css/menus/leftalignmenu.css', false, "", "all");
		break;
		
		case 'hammenufull':
			wp_enqueue_style("grandphotography-hammenufull", get_template_directory_uri().'/css/menus/hammenufull.css', false, "", "all");
		break;
		
		case 'centeralogo':
			wp_enqueue_style("grandphotography-centeralogo", get_template_directory_uri().'/css/menus/centeralogo.css', false, "", "all");
		break;
	}
	
	//Add Font Awesome Support
	wp_enqueue_style("fontawesome", get_template_directory_uri()."/css/font-awesome.min.css", false, "", "all");
	
	$tg_boxed = kirki_get_option('tg_boxed');
    if(THEMEDEMO && isset($_GET['boxed']) && !empty($_GET['boxed']))
    {
    	$tg_boxed = 1;
    }
    
    if(!empty($tg_boxed) && $tg_menu_layout != 'leftmenu')
    {
    	wp_enqueue_style("grandphotography-boxed", get_template_directory_uri().'/css/tg_boxed.css', false, "", "all");
    }
    
    //Add custom CSS
    if(THEMEDEMO && isset($_GET['menulayout']) && !empty($_GET['menulayout']))
	{
		wp_enqueue_style("grandphotography-script-custom-css", admin_url('admin-ajax.php')."?action=grandphotography_custom_css&menulayout=".$_GET['menulayout'], false, "", "all");
	}
	else
	{
		wp_enqueue_style("grandphotography-script-custom-css", admin_url('admin-ajax.php')."?action=grandphotography_custom_css", false, "", "all");
	}
	
	//If using child theme
	if(is_child_theme())
	{
	    wp_enqueue_style('grandphotography-childtheme', get_stylesheet_directory_uri()."/style.css", false, "", "all");
	}
	
	//Enqueue javascripts
	wp_enqueue_script(array('jquery'));
	
	$js_path = get_template_directory()."/js/";
	$js_arr = array(
		'requestAnimationFrame' 	=> 'jquery.requestAnimationFrame.js',
		'mousewheel'				=> 'jquery.mousewheel.min.js',
		'ilightbox'					=> 'ilightbox.packed.js',
		'easing'					=> 'jquery.easing.js',
	    'waypoints'					=> 'waypoints.min.js',
	    'isotope'					=> 'jquery.isotope.js',
	    'masory'					=> 'jquery.masory.js',
	    'tooltipster'				=> 'jquery.tooltipster.min.js',
	    'jarallax'					=> 'jarallax.js',
	    'stellar'					=> 'jquery.stellar.min.js',
	    'grandphotography-custom-plugins'	=> 'custom_plugins.js',
	    'grandphotography-custom-script' 	=>'custom.js',
	);

	foreach($js_arr as $key => $file) {
		if($file != 'jquery.js' && $file != 'jquery-ui.js')
		{
			wp_enqueue_script($key, get_template_directory_uri()."/js/".$file, false, "", true);
		}
	}
}
add_action( 'wp_enqueue_scripts', 'grandphotography_enqueue_front_page_scripts' );


//Enqueue mobile CSS after all others CSS load
function grandphotography_register_mobile_css() 
{
	//Check if enable responsive layout
	$tg_mobile_responsive = kirki_get_option('tg_mobile_responsive');
	
	if(!empty($tg_mobile_responsive))
	{
		//enqueue frontend css files
		$pp_advance_combine_css = get_option('pp_advance_combine_css');
	
		if(!empty($pp_advance_combine_css))
		{
			wp_enqueue_style('grandphotography-script-responsive-css', admin_url('admin-ajax.php')."?action=grandphotography_responsive_css", false, "", "all");
		}
		else
		{
	    	wp_enqueue_style('grandphotography-script-responsive-css', get_template_directory_uri()."/css/grid.css", false, "", "all");
	    }
	}
}
add_action('wp_enqueue_scripts', 'grandphotography_register_mobile_css', 15);


function grandphotography_admin() 
{ 
	$grandphotography_options = grandphotography_get_options();
	$i=0;
	
	$pp_font_family = get_option('pp_font_family');
	
	if(function_exists( 'wp_enqueue_media' )){
	    wp_enqueue_media();
	}
	?>
		
		<div id="pp_loading"><span><?php esc_html_e('Updating...', 'grandphotography' ); ?></span></div>
		
		<form id="pp_form" method="post" enctype="multipart/form-data">
		<div class="pp_wrap rm_wrap">
		
		<div class="header_wrap">
			<div style="float:left">
			<?php
				//Display logo in theme setting
				$tg_retina_logo_for_admin = kirki_get_option('tg_retina_logo_for_admin');
				$tg_retina_logo = kirki_get_option('tg_retina_logo');
				
				if(empty($tg_retina_logo_for_admin))
				{
			?>
			<h2><?php esc_html_e('Theme Setting', 'grandphotography' ); ?><span class="pp_version"><?php esc_html_e('Version', 'grandphotography' ); ?> <?php echo THEMEVERSION; ?></span></h2>
			<?php
				}
				else if(!empty($tg_retina_logo))
				{
			?>
			<div class="pp_setting_logo_wrapper">
			<?php
					//Get image width and height
			    	$image_id = grandphotography_get_image_id($tg_retina_logo);
			    	if(!empty($image_id))
			    	{
			    		$obj_image = wp_get_attachment_image_src($image_id, 'original');
			    		
			    		$image_width = 0;
				    	$image_height = 0;
				    	
				    	if(isset($obj_image[1]))
				    	{
				    		$image_width = intval($obj_image[1]/2);
				    	}
				    	if(isset($obj_image[2]))
				    	{
				    		$image_height = intval($obj_image[2]/2);
				    	}
			    	}
			    	else
			    	{
				    	$image_width = 0;
				    	$image_height = 0;
			    	}
						
					if($image_width > 0 && $image_height > 0)
					{
					?>
					<img src="<?php echo esc_url($tg_retina_logo); ?>" alt="<?php esc_attr(get_bloginfo('name')); ?>" width="<?php echo esc_attr($image_width); ?>" height="<?php echo esc_attr($image_height); ?>"/>
					<?php
					}
					else
					{
					?>
	    	    	<img src="<?php echo esc_url($tg_retina_logo); ?>" alt="<?php esc_attr(get_bloginfo('name')); ?>" width="46" height="33"/>
	    	    <?php 
		    	    }
		    	?>
		    	<span class="pp_version"><?php esc_html_e('Version', 'grandphotography' ); ?> <?php echo THEMEVERSION; ?></span>
			</div>
			<?php
				}
			?>
			</div>
			<div style="float:right;margin:32px 0 0 0">
				<input id="save_ppsettings" name="save_ppsettings" class="button button-primary button-large" type="submit" value="<?php esc_html_e('Save', 'grandphotography' ); ?>" />
				<br/><br/>
				<input type="hidden" name="action" value="save" />
				<input type="hidden" name="current_tab" id="current_tab" value="#pp_panel_general" />
				<input type="hidden" name="pp_save_skin_flg" id="pp_save_skin_flg" value="" />
				<input type="hidden" name="pp_save_skin_name" id="pp_save_skin_name" value="" />
			</div>
			<input type="hidden" name="pp_admin_url" id="pp_admin_url" value="<?php echo get_template_directory_uri(); ?>"/>
			<br style="clear:both"/><br/>
	
	<?php
		//Check if theme has new update
	?>
	
		</div>
		
		<div class="pp_wrap">
		<div id="pp_panel">
		<?php 
			foreach ($grandphotography_options as $value) {
				
				$active = '';
				
				if($value['type'] == 'section')
				{
					if($value['name'] == 'Home')
					{
						$active = 'nav-tab-active';
					}
					echo '<a id="pp_panel_'.strtolower($value['name']).'_a" href="#pp_panel_'.strtolower($value['name']).'" class="nav-tab '.$active.'"><span class="dashicons  '.$value['icon'].'"></span>'.str_replace('-', ' ', $value['name']).'</a>';
				}
			}
		?>
		</h2>
		</div>
	
		<div class="rm_opts">
		
	<?php 
	$url = (!empty($_SERVER['HTTPS'])) ? "https://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'] : "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
	
	foreach ($grandphotography_options as $value) {
	switch ( $value['type'] ) {
	 
	case "open":
	?> <?php break;
	 
	case "close":
	?>
		
		</div>
		</div>
	
	
		<?php break;
	 
	case "title":
	?>
		<br />
	
	
	<?php break;
	 
	case 'text':
		
		//if sidebar input then not show default value
		if($value['id'] != SHORTNAME."_sidebar0" && $value['id'] != SHORTNAME."_ggfont0")
		{
			$default_val = get_option( $value['id'] );
		}
		else
		{
			$default_val = '';	
		}
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_text"><label for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label>
		
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		
		<input name="<?php echo esc_attr($value['id']); ?>"
			id="<?php echo esc_attr($value['id']); ?>" type="<?php echo esc_attr($value['type']); ?>"
			value="<?php if ($default_val != "") { echo esc_attr(get_option( $value['id'])) ; } else { echo esc_attr($value['std']); } ?>"
			<?php if(!empty($value['size'])) { echo 'style="width:'.intval($value['size']).'"'; } ?> />
		<div class="clearfix"></div>
		
		<?php
		if($value['id'] == SHORTNAME."_sidebar0")
		{
			$current_sidebar = get_option(SHORTNAME."_sidebar");
			
			if(!empty($current_sidebar))
			{
		?>
			<br class="clear"/><br/>
		 	<div class="pp_sortable_wrapper">
			<ul id="current_sidebar" class="rm_list">
	
		<?php
			foreach($current_sidebar as $sidebar)
			{
		?> 
				
				<li id="<?php echo esc_attr($sidebar); ?>"><div class="title"><?php echo esc_html($sidebar); ?></div><a href="<?php echo esc_url($url); ?>" class="sidebar_del" rel="<?php echo esc_attr($sidebar); ?>"><span class="dashicons dashicons-no"></span></a><br style="clear:both"/></li>
		
		<?php
			}
		?>
		
			</ul>
			</div>
			<br style="clear:both"/>
		<?php
			}
		}
		?>
	
		</div>
		<?php
	break;
	
	case 'image':
	case 'music':
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_text"><label for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
		<input id="<?php echo esc_attr($value['id']); ?>" type="text" name="<?php echo esc_attr($value['id']); ?>" value="<?php echo get_option($value['id']); ?>" style="width:200px" class="upload_text" readonly />
		<input id="<?php echo esc_attr($value['id']); ?>_button" name="<?php echo esc_attr($value['id']); ?>_button" type="button" value="Browse" class="upload_btn button" rel="<?php echo esc_attr($value['id']); ?>" style="margin:5px 0 0 5px" />
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		<div class="clearfix"></div>
		
		<script>
		jQuery(document).ready(function() {
			jQuery('#<?php echo esc_js($value['id']); ?>_button').click(function() {
	         	var send_attachment_bkp = wp.media.editor.send.attachment;
			    wp.media.editor.send.attachment = function(props, attachment) {
			    	formfield = jQuery('#<?php echo esc_js($value['id']); ?>').attr('name');
		         	jQuery('#'+formfield).val(attachment.url);
			
			        wp.media.editor.send.attachment = send_attachment_bkp;
			    }
			
			    wp.media.editor.open();
	        });
	    });
		</script>
		
		<?php 
			$current_value = get_option( $value['id'] );
			
			if(!is_bool($current_value) && !empty($current_value))
			{
				$url = (!empty($_SERVER['HTTPS'])) ? "https://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'] : "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
			
				if($value['type']=='image')
				{
		?>
		
			<div id="<?php echo esc_attr($value['id']); ?>_wrapper" style="width:380px;font-size:11px;"><br/>
				<img src="<?php echo get_option($value['id']); ?>" style="max-width:500px"/><br/><br/>
				<a href="<?php echo esc_url($url); ?>" class="image_del button" rel="<?php echo esc_attr($value['id']); ?>"><?php esc_html_e('Delete', 'grandphotography' ); ?></a>
			</div>
			<?php
				}
				else
				{
			?>
			<div id="<?php echo esc_attr($value['id']); ?>_wrapper" style="width:380px;font-size:11px;">
				<br/><a href="<?php echo get_option( $value['id'] ); ?>">
				<?php esc_html_e('Listen current music', 'grandphotography' ); ?></a>&nbsp;<a href="<?php echo esc_url($url); ?>" class="image_del button" rel="<?php echo esc_attr($value['id']); ?>"><?php esc_html_e('Delete', 'grandphotography' ); ?></a>
			</div>
		<?php
				}
			}
		?>
	
		</div>
		<?php
	break;
	
	case 'jslider':
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_text"><label for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
		<div style="float:left;width:290px;margin-top:10px">
		<input name="<?php echo esc_attr($value['id']); ?>"
			id="<?php echo esc_attr($value['id']); ?>" type="text" class="jslider"
			value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'])  ); } else { echo esc_attr($value['std']); } ?>"
			<?php if(!empty($value['size'])) { echo 'style="width:'.$value['size'].'"'; } ?> />
		</div>
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		<div class="clearfix"></div>
		
		<script>jQuery("#<?php echo esc_js($value['id']); ?>").slider({ from: <?php echo esc_js($value['from']); ?>, to: <?php echo esc_js($value['to']); ?>, step: <?php echo esc_js($value['step']); ?>, smooth: true, skin: "round_plastic" });</script>
	
		</div>
		<?php
	break;
	
	case 'colorpicker':
	?>
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_text"><label for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
		<input name="<?php echo esc_attr($value['id']); ?>"
			id="<?php echo esc_attr($value['id']); ?>" type="text" 
			value="<?php if ( get_option( $value['id'] ) != "" ) { echo stripslashes(get_option( $value['id'])  ); } else { echo esc_attr($value['std']); } ?>"
			<?php if(!empty($value['size'])) { echo 'style="width:'.$value['size'].'"'; } ?>  class="color_picker" readonly/>
		<div id="<?php echo esc_attr($value['id']); ?>_bg" class="colorpicker_bg" onclick="jQuery('#<?php echo esc_js($value['id']); ?>').click()" style="background:<?php if (get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'])  ); } else { echo esc_attr($value['std']); } ?> url(<?php echo get_template_directory_uri(); ?>/functions/images/trigger.png) center no-repeat;">&nbsp;</div>
			<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		<div class="clearfix"></div>
		
		</div>
		
	<?php
	break;
	 
	case 'textarea':
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_textarea"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label>
			
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		
		<textarea id="<?php echo esc_attr($value['id']); ?>" name="<?php echo esc_attr($value['id']); ?>"
			type="<?php echo esc_attr($value['type']); ?>" cols="" rows=""><?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id']) ); } else { echo esc_html($value['std']); } ?></textarea>
		
		<div class="clearfix"></div>
	
		</div>
	
		<?php
	break;
	
	case 'css':
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_textarea"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label>
			
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		
		<textarea id="<?php echo esc_attr($value['id']); ?>" class="css" name="<?php echo esc_attr($value['id']); ?>"
			type="<?php echo esc_attr($value['type']); ?>"><?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id']) ); } else { echo esc_html($value['std']); } ?></textarea>
		
		<div class="clearfix"></div>
	
		</div>
	
		<?php
	break;
	 
	case 'select':
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_select"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
	
		<select name="<?php echo esc_attr($value['id']); ?>"
			id="<?php echo esc_attr($value['id']); ?>">
			<?php foreach ($value['options'] as $key => $option) { ?>
			<option
			<?php if (get_option( $value['id'] ) == $key) { echo 'selected="selected"'; } ?>
				value="<?php echo esc_attr($key); ?>"><?php echo esc_html($option); ?></option>
			<?php } ?>
		</select> <small class="description"><?php echo stripslashes($value['desc']); ?></small>
		<div class="clearfix"></div>
		</div>
		<?php
	break;
	
	case 'font':
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_font"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
	
		<div id="<?php echo esc_attr($value['id']); ?>_wrapper" style="float:left;font-size:11px;">
		<select class="pp_font" data-sample="<?php echo esc_attr($value['id']); ?>_sample" data-value="<?php echo esc_attr($value['id']); ?>_value" name="<?php echo esc_attr($value['id']); ?>"
			id="<?php echo esc_attr($value['id']); ?>">
			<option value="" data-family="">---- <?php esc_html_e('Theme Default Font', 'grandphotography' ); ?> ----</option>
			<?php 
				foreach ($pp_font_arr as $key => $option) { ?>
			<option
			<?php if (get_option( $value['id'] ) == $option['css-name']) { echo 'selected="selected"'; } ?>
				value="<?php echo esc_attr($option['css-name']); ?>" data-family="<?php echo esc_attr($option['font-name']); ?>"><?php echo esc_html($option['font-name']); ?></option>
			<?php } ?>
		</select> 
		<input type="hidden" id="<?php echo esc_attr($value['id']); ?>_value" name="<?php echo esc_attr($value['id']); ?>_value" value="<?php echo get_option( $value['id'].'_value' ); ?>"/>
		<br/><br/><div id="<?php echo esc_attr($value['id']); ?>_sample" class="pp_sample_text"><?php esc_html_e('Sample Text', 'grandphotography' ); ?></div>
		</div>
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		<div class="clearfix"></div>
		</div>
		<?php
	break;
	 
	case 'radio':
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_select"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/><br/>
	
		<div style="margin-top:5px;float:left;<?php if(!empty($value['desc'])) { ?>width:300px<?php } else { ?>width:500px<?php } ?>">
		<?php foreach ($value['options'] as $key => $option) { ?>
		<div style="float:left;<?php if(!empty($value['desc'])) { ?>margin:0 20px 20px 0<?php } ?>">
			<input style="float:left;" id="<?php echo esc_attr($value['id']); ?>" name="<?php echo esc_attr($value['id']); ?>" type="radio"
			<?php if (get_option( $value['id'] ) == $key) { echo 'checked="checked"'; } ?>
				value="<?php echo esc_attr($key); ?>"/><?php echo esc_html($option); ?>
		</div>
		<?php } ?>
		</div>
		
		<?php if(!empty($value['desc'])) { ?>
			<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		<?php } ?>
		<div class="clearfix"></div>
		</div>
		<?php
	break;
	
	case 'sortable':
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_select"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
	
		<div style="float:left;width:100%;">
		<?php 
		$sortable_array = array();
		if(get_option( $value['id'] ) != 1)
		{
			$sortable_array = unserialize(get_option( $value['id'] ));
		}
		
		$current = 1;
		
		if(!empty($value['options']))
		{
		?>
		<select name="<?php echo esc_attr($value['id']); ?>"
			id="<?php echo esc_attr($value['id']); ?>" class="pp_sortable_select">
		<?php
		foreach ($value['options'] as $key => $option) { 
			if($key > 0)
			{
		?>
		<option value="<?php echo esc_attr($key); ?>" data-rel="<?php echo esc_attr($value['id']); ?>_sort" title="<?php echo html_entity_decode($option); ?>"><?php echo html_entity_decode($option); ?></option>
		<?php }
		
				if($current>1 && ($current-1)%3 == 0)
				{
		?>
		
				<br style="clear:both"/>
		
		<?php		
				}
				
				$current++;
			}
		?>
		</select>
		<a class="button pp_sortable_button" data-rel="<?php echo esc_attr($value['id']); ?>" class="button" style="display:inline-block"><?php echo esc_html__('Add', 'grandphotography' ); ?></a>
		<?php
		}
		?>
		 
		 <br style="clear:both"/><br/>
		 
		 <div class="pp_sortable_wrapper">
		 <ul id="<?php echo esc_attr($value['id']); ?>_sort" class="pp_sortable" rel="<?php echo esc_attr($value['id']); ?>_sort_data"> 
		 <?php
		 	$sortable_data_array = unserialize(get_option( $value['id'].'_sort_data' ));
	
		 	if(!empty($sortable_data_array))
		 	{
		 		foreach($sortable_data_array as $key => $sortable_data_item)
		 		{
			 		if(!empty($sortable_data_item))
			 		{
		 		
		 ?>
		 		<li id="<?php echo esc_attr($sortable_data_item); ?>_sort" class="ui-state-default"><div class="title"><?php echo esc_html($value['options'][$sortable_data_item]); ?></div><a data-rel="<?php echo esc_attr($value['id']); ?>_sort" href="javascript:;" class="remove"><span class="dashicons dashicons-no"></span></a><br style="clear:both"/></li> 	
		 <?php
		 			}
		 		}
		 	}
		 ?>
		 </ul>
		 
		 </div>
		 
		</div>
		
		<input type="hidden" id="<?php echo esc_attr($value['id']); ?>_sort_data" name="<?php echo esc_attr($value['id']); ?>_sort_data" value="" style="width:100%"/>
		<br style="clear:both"/><br/>
		
		<div class="clearfix"></div>
		</div>
		<?php
	break;
	 
	case "checkbox":
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_checkbox"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
	
		<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
		<input type="checkbox" name="<?php echo esc_attr($value['id']); ?>"
			id="<?php echo esc_attr($value['id']); ?>" value="true" <?php echo esc_html($checked); ?> />
	
	
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
		<div class="clearfix"></div>
		</div>
	<?php break; 
	
	case "iphone_checkboxes":
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_checkbox"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label>
	
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
	
		<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
		<input type="checkbox" class="iphone_checkboxes" name="<?php echo esc_attr($value['id']); ?>"
			id="<?php echo esc_attr($value['id']); ?>" value="true" <?php echo esc_html($checked); ?> />
	
		<div class="clearfix"></div>
		</div>
	
	<?php break; 
	
	case "html":
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_checkbox"><label
			for="<?php echo esc_attr($value['id']); ?>"><?php echo stripslashes($value['name']); ?></label><br/>
	
		<small class="description"><?php echo stripslashes($value['desc']); ?></small>
	
		<?php echo stripslashes($value['html']); ?>
	
		<div class="clearfix"></div>
		</div>
	
	<?php break; 
	
	case "shortcut":
	?>
	
		<div id="<?php echo esc_attr($value['id']); ?>_section" class="rm_input rm_shortcut">
	
		<ul class="pp_shortcut_wrapper">
		<?php 
			$count_shortcut = 1;
			foreach ($value['options'] as $key_shortcut => $option) { ?>
			<li><a href="#<?php echo esc_attr($key_shortcut); ?>" <?php if($count_shortcut==1) { ?>class="active"<?php } ?>><?php echo esc_html($option); ?></a></li>
		<?php $count_shortcut++; } ?>
		</ul>
	
		<div class="clearfix"></div>
		</div>
	
	<?php break; 
		
	case "section":
	
	$i++;
	
	?>
	
		<div id="pp_panel_<?php echo strtolower($value['name']); ?>" class="rm_section">
		<div class="rm_title">
		<h3><img
			src="<?php echo get_template_directory_uri(); ?>/functions/images/trans.png"
			class="inactive" alt=""><?php echo stripslashes($value['name']); ?></h3>
		<span class="submit"><input class="button-primary" name="save<?php echo esc_attr($i); ?>" type="submit"
			value="Save changes" /> </span>
		<div class="clearfix"></div>
		</div>
		<div class="rm_options"><?php break;
	 
	}
	}
	?>
	 	
	 	<div class="clearfix"></div>
	 	</form>
	 	</div>
	</div>
<?php
}

add_action('admin_menu', 'grandphotography_add_admin');

/**
*	End Theme Setting Panel
**/ 


//Setup theme custom filters
require_once get_template_directory() . "/lib/theme.filter.lib.php";

//Setup theme Gutenberg compatibility
require_once get_template_directory() . "/lib/gutenberg.lib.php";

//Setup Theme Customizer
require_once get_template_directory() . "/modules/kirki/kirki.php";
require_once get_template_directory() . "/lib/customizer.lib.php";

//Setup page custom fields and action handler
require_once get_template_directory() . "/fields/page.fields.php";

//Setup content builder
require_once get_template_directory() . "/modules/content_builder.php";

// Setup shortcode generator
require_once get_template_directory() . "/modules/shortcode_generator.php";


//Check if Woocommerce is installed	
if(class_exists('Woocommerce'))
{
	//Setup Woocommerce Config
	require_once get_template_directory() . "/modules/woocommerce.php";
}

/**
*	Setup AJAX portfolio content builder function
**/
add_action('wp_ajax_grandphotography_ppb', 'grandphotography_ppb');
add_action('wp_ajax_nopriv_grandphotography_ppb', 'grandphotography_ppb');

function grandphotography_ppb() {
	if(is_admin() && isset($_GET['shortcode']) && !empty($_GET['shortcode']))
	{
		require_once get_template_directory() . "/lib/contentbuilder.shortcode.lib.php";
		//pp_debug($ppb_shortcodes);
		
		if(isset($ppb_shortcodes[$_GET['shortcode']]) && !empty($ppb_shortcodes[$_GET['shortcode']]))
		{
			$selected_shortcode = $_GET['shortcode'];
			$selected_shortcode_arr = $ppb_shortcodes[$_GET['shortcode']];
			//pp_debug($selected_shortcode_arr);
			
			//get action value
			$ppb_builder_remove_id = '';
			if(isset($_GET['builder_action']) && isset($_GET['builder_action']) == 'add')
			{
				$ppb_builder_remove_id = $_GET['rel'];
			}
?>
			<!-- Display button for this content -->
			<div class="ppb_inline_title_bar">
				<h2><?php echo esc_html($selected_shortcode_arr['title']); ?></h2>
			</div>
			
			<div class="ppb_inline_wrap">
			    <a id="save_<?php echo esc_attr($_GET['rel']); ?>" data-parent="ppb_inline_<?php echo esc_attr($selected_shortcode); ?>" class="button ppb_inline_save" href="javascript:;"><?php esc_html_e('Update', 'grandphotography' ); ?></a>
			    
			    <a class="button" href="javascript:;" onClick="cancelContent('<?php echo esc_attr($ppb_builder_remove_id); ?>');"><?php esc_html_e('Cancel', 'grandphotography' ); ?></a>
			    
			</div>
			
			<div id="ppb_inline_<?php echo esc_attr($selected_shortcode); ?>" data-shortcode="<?php echo esc_attr($selected_shortcode); ?>" class="ppb_inline">
			<div class="ppb_inline_option_wrap">
				<?php
					if(isset($selected_shortcode_arr['title']) && $selected_shortcode_arr['title']!='Divider')
					{
				?>
				<div class="ppb_inline_option">
					
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_title"><?php esc_html_e('Title', 'grandphotography' ); ?></label><br/>
						<span class="label_desc"><?php esc_html_e('Enter Title for this content', 'grandphotography' ); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<input type="text" id="<?php echo esc_attr($selected_shortcode); ?>_title" name="<?php echo esc_attr($selected_shortcode); ?>_title" data-attr="title" value="Title" class="ppb_input"/>
					</div>
				</div>
				<br/>
				<?php
					}
					else
					{
				?>
				<input type="hidden" id="<?php echo esc_attr($selected_shortcode); ?>_title" name="<?php echo esc_attr($selected_shortcode); ?>_title" data-attr="title" value="<?php echo esc_attr($selected_shortcode_arr['title']); ?>" class="ppb_input"/>
				<?php
					}
				?>
				
				<?php
					$num_attr = count($selected_shortcode_arr['attr']);
					$i_count = 0;
				
					foreach($selected_shortcode_arr['attr'] as $attr_name => $attr_item)
					{
						$last_class = '';
						if(++$i_count === $num_attr)
						{
							$last_class = 'last';
						}
					
						if(!isset($attr_item['title']))
						{
							$attr_title = ucfirst($attr_name);
						}
						else
						{
							$attr_title = $attr_item['title'];
						}
					
						if($attr_item['type']=='jslider')
						{
				?>
				<div class="ppb_inline_option">
				
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>"><?php echo esc_html($attr_title); ?></label><br/>
						<span class="label_desc"><?php echo esc_html($attr_item['desc']); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<input name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" type="range" class="ppb_input" min="<?php echo esc_attr($attr_item['min']); ?>" max="<?php echo esc_attr($attr_item['max']); ?>" step="<?php echo esc_attr($attr_item['step']); ?>" value="<?php echo esc_attr($attr_item['std']); ?>" /><output for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" onforminput="value = foo.valueAsNumber;"></output><br/>
					</div>
					
					<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="jslider"/>
				</div>
				<br/>
				<?php
						}
				
						if($attr_item['type']=='file')
						{
				?>
				<div class="ppb_inline_option <?php echo esc_attr($last_class); ?>">
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>"><?php echo esc_html($attr_title); ?></label><br/>
						<span class="label_desc"><?php echo esc_html($attr_item['desc']); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<input name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" type="text"  class="ppb_input ppb_file" />
						<a id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_button" name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_button" type="button" class="metabox_upload_btn button" rel="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>">Upload</a>
						<img id="image_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" class="ppb_file_image" />
					</div>
					
					<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="file"/>
				</div>
				<br/>
				<?php
						}
						
						if($attr_item['type']=='select')
						{
				?>
				<div class="ppb_inline_option <?php echo esc_attr($last_class); ?>">
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>"><?php echo esc_html($attr_title); ?></label><br/>
						<span class="label_desc"><?php echo esc_html($attr_item['desc']); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<select name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" class="ppb_input">
						<?php
								foreach($attr_item['options'] as $attr_key => $attr_item_option)
								{
						?>
								<option value="<?php echo esc_attr($attr_key); ?>"><?php echo ucfirst($attr_item_option); ?></option>
						<?php
								}
						?>
						</select>
					</div>	
					<br style="clear:both"/>
					
					<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="select"/>
					
					<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="select"/>
				</div>
				<br/>
				<?php
						}
						
						if($attr_item['type']=='select_multiple')
						{
				?>
				<div class="ppb_inline_option <?php echo esc_attr($last_class); ?>">
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>"><?php echo esc_html($attr_title); ?></label><br/>
						<span class="label_desc"><?php echo esc_html($attr_item['desc']); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<select name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" class="ppb_input" multiple="multiple">
						<?php
								foreach($attr_item['options'] as $attr_key => $attr_item_option)
								{
									if(!empty($attr_item_option))
									{
						?>
									<option value="<?php echo esc_attr($attr_key); ?>"><?php echo ucfirst($attr_item_option); ?></option>
						<?php
									}
								}
						?>
						</select>
					</div>
					<br style="clear:both"/>
					
					<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="select_multiple"/>
				</div>
				<br/>
				<?php
						}
						
						if($attr_item['type']=='margin')
						{
				?>
				<div class="ppb_inline_option <?php echo esc_attr($last_class); ?>">
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>"><?php echo esc_html($attr_title); ?></label><br/>
						<span class="label_desc"><?php echo esc_html($attr_item['desc']); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<strong><?php esc_html_e('top', 'grandphotography' ); ?></strong>&nbsp;
						<input name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_top" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_top" type="text" class="ppb_input type_margin" />&nbsp;px&nbsp;
						&nbsp;
						<strong><?php esc_html_e('bottom', 'grandphotography' ); ?></strong>&nbsp;
						<input name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_bottom" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_bottom" type="text" class="ppb_input type_margin" />&nbsp;px&nbsp;
						<br/>
						<strong><?php esc_html_e('left', 'grandphotography' ); ?></strong>&nbsp;
						<input name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_left" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_left" type="text" class="ppb_input type_margin" />&nbsp;px&nbsp;
						&nbsp;
						<strong><?php esc_html_e('right', 'grandphotography' ); ?></strong>&nbsp;
						<input name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_right" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_right" type="text" class="ppb_input type_margin" />&nbsp;px&nbsp;
					
						<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="margin"/>
					</div>
				</div>
				<br/>
				<?php
						}
						
						if($attr_item['type']=='text')
						{
				?>
				<div class="ppb_inline_option <?php echo esc_attr($last_class); ?>">
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>"><?php echo esc_html($attr_title); ?></label><br/>
						<span class="label_desc"><?php echo esc_html($attr_item['desc']); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<input name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" type="text" class="ppb_input" />
					
						<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="text"/>
					</div>
				</div>
				<br/>
				<?php
						}
								
						if($attr_item['type']=='colorpicker')
						{
				?>
				<div class="ppb_inline_option <?php echo esc_attr($last_class); ?>">
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>"><?php echo esc_html($attr_title); ?></label><br/>
						<span class="label_desc"><?php echo esc_html($attr_item['desc']); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<input name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" type="text" class="ppb_input color_picker" />
						<div id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>_bg" class="colorpicker_bg" onclick="jQuery('#<?php echo esc_js($selected_shortcode); ?>_<?php echo esc_js($attr_name); ?>').click()" style="background-color:<?php echo esc_attr($attr_item['std']); ?>;background-image: url(<?php echo get_template_directory_uri(); ?>/functions/images/trigger.png);margin-top:3px">&nbsp;</div><br style="clear:both"/>
					</div>
					
					<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="colorpicker"/>
				</div>
				<br/>
				<?php
						}
						
						if($attr_item['type']=='textarea')
						{
				?>
				<div class="ppb_inline_option <?php echo esc_attr($last_class); ?>">
					<div class="ppb_inline_label">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>"><?php echo esc_html($attr_title); ?></label><br/>
						<span class="label_desc"><?php echo esc_html($attr_item['desc']); ?></span>
					</div>
					
					<div class="ppb_inline_field">
						<textarea name="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" id="<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" cols="" rows="3" class="ppb_input type_textarea"></textarea>
					</div>
					
					<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="textarea"/>
				</div>
				<br/>
				<?php
						}
					}
				?>
				
				<?php
					if($attr_item['type']=='visual_editor')
					{
				?>
					<div class="ppb_inline_option <?php echo esc_attr($last_class); ?>">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_content"><?php esc_html_e('Content', 'grandphotography' ); ?></label><br/>
						<span class="label_desc"><?php esc_html_e('You can enter text, HTML for its content', 'grandphotography' ); ?></span><br/><br/>
						
						<textarea id="<?php echo esc_attr($selected_shortcode); ?>_content" name="<?php echo esc_attr($selected_shortcode); ?>_content" cols="" rows="5" class="ppb_input <?php if($_GET['builder_action'] == 'add') { ?>ppb_textarea<?php } ?>"></textarea>
						
						<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="content"/>
					</div>
				<?php
					}
				?>
				
				<?php
					if(isset($selected_shortcode_arr['content']) && $selected_shortcode_arr['content'])
					{
				?>
					<div class="ppb_inline_option <?php echo esc_attr($last_class); ?> content_option">
						<label for="<?php echo esc_attr($selected_shortcode); ?>_content"><?php esc_html_e('Content', 'grandphotography' ); ?></label><br/>
						<span class="label_desc"><?php esc_html_e('You can enter text, HTML for its content', 'grandphotography' ); ?></span><br/><br/>
						
						<textarea id="<?php echo esc_attr($selected_shortcode); ?>_content" name="<?php echo esc_attr($selected_shortcode); ?>_content" cols="" rows="5" class="ppb_input <?php if($_GET['builder_action'] == 'add') { ?>ppb_textarea<?php } ?>"></textarea>
						
						<input type="hidden" id="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" name="type_<?php echo esc_attr($selected_shortcode); ?>_<?php echo esc_attr($attr_name); ?>" value="content"/>
					</div>
				<?php
					}
				?>
			</div>
		</div>
		
		<script>
		jQuery(document).ready(function(){
			var formfield = '';
			
			ppbSetUnsaveStatus();
			
			if(jQuery('body').hasClass('ppb_duplicated'))
			{
				jQuery('.fancybox-inner .ppb_inline_wrap').addClass('duplicated');
			}
	
			jQuery('.metabox_upload_btn').click(function() {
			    jQuery('.fancybox-overlay').css('visibility', 'hidden');
			    jQuery('.fancybox-wrap').css('visibility', 'hidden');
		     	formfield = jQuery(this).attr('rel');
			    
			    var send_attachment_bkp = wp.media.editor.send.attachment;
			    wp.media.editor.send.attachment = function(props, attachment) {
			     	jQuery('#'+formfield).val( attachment.url);
			     	jQuery('#image_'+formfield).attr('src', attachment.url);
			
			        wp.media.editor.send.attachment = send_attachment_bkp;
			        jQuery('.fancybox-overlay').css('visibility', 'visible');
			     	jQuery('.fancybox-wrap').css('visibility', 'visible');
			    }
			
			    wp.media.editor.open();
		     	return false;
		    });
		
			jQuery("#ppb_inline :input").each(function(){
				if(typeof jQuery(this).attr('id') != 'undefined')
				{
					 jQuery(this).val('');
				}
			});
			
			var currentItemData = jQuery('#<?php echo esc_js($_GET['rel']); ?>').data('ppb_setting');
			var currentItemOBJ = jQuery.parseJSON(currentItemData);
			
			jQuery.each(currentItemOBJ, function(index, value) { 
			  	if(typeof jQuery('#'+index) != 'undefined' && jQuery('#'+index).length > 0)
				{
					jQuery('#'+index).val(decodeURI(value));
					
					if(jQuery('#'+index).is('textarea') && jQuery('#'+index).hasClass('ppb_input') && !jQuery('#'+index).hasClass('type_textarea'))
					{
					    jQuery('#'+index).html(decodeURI(value));
					    jQuery('#'+index).wp_editor();
					}
					
					if(jQuery('#'+index).is('textarea') && jQuery('#'+index).hasClass('ppb_input') && jQuery('#'+index).hasClass('type_textarea'))
					{
					    jQuery('#'+index).html(decodeURI(value));
					}
					
					//Check if color picker
					if(jQuery('#'+index).hasClass('color_picker'))
					{
						var inputID = jQuery('#'+index).attr('id');
						jQuery('#'+inputID+'_bg').css('backgroundColor', jQuery('#'+index).val());
					}
					
					//Check if input file
					if(jQuery('#type_'+index).val()=='file')
					{
						jQuery('#image_'+index).attr('src', value);
					}
					
					//Check if input video
					if(jQuery('#type_'+index).val()=='video')
					{
						jQuery('#video_view_'+index).attr('href', value);
					}
					
					//Check if multiple select
					if(jQuery('#type_'+index).val()=='select_multiple')
					{
						var data = value + '';
						var data_array = data.split(",");
						jQuery('#'+index).val(data_array);
					}
				}
			});
			
			jQuery('.color_picker').each(function()
			{	
			    var inputID = jQuery(this).attr('id');
			    
			    jQuery(this).ColorPicker({
			    	color: jQuery(this).val(),
			    	onShow: function (colpkr) {
			    		jQuery(colpkr).fadeIn(200);
			    		return false;
			    	},
			    	onHide: function (colpkr) {
			    		jQuery(colpkr).fadeOut(200);
			    		return false;
			    	},
			    	onChange: function (hsb, hex, rgb, el) {
			    		jQuery('#'+inputID).val('#' + hex);
			    		jQuery('#'+inputID+'_bg').css('backgroundColor', '#' + hex);
			    	}
			    });	
			    
			    jQuery(this).css('width', '200px');
			    jQuery(this).css('float', 'left');
			});
			
			var el, newPoint, newPlace, offset;
 
			 jQuery("input[type='range']").change(function() {
			 
			   el = jQuery(this);
			   
			   width = el.width();
			   newPoint = (el.val() - el.attr("min")) / (el.attr("max") - el.attr("min"));
			   el.next("output").text(el.val());
			 })
			 .trigger('change');
			
			jQuery("#save_<?php echo esc_js($_GET['rel']); ?>").click(function(){
				//Save undo data to localstorage
				ppbAddHistory('undo');
			
				tinyMCE.triggerSave();
			
			    var targetItem = '<?php echo esc_js($_GET['rel']); ?>';
			    var parentInline = jQuery(this).attr('data-parent');
			    var currentItemData = jQuery('#'+targetItem).find('.ppb_setting_data').val();
			    var currentShortcode = jQuery('#'+parentInline).attr('data-shortcode');
			    
			    var itemData = {};
			    itemData.id = targetItem;
			    itemData.shortcode = currentShortcode;
			    
			    jQuery("#"+parentInline+" :input.ppb_input").each(function(){
			     	if(typeof jQuery(this).attr('id') != 'undefined')
			     	{	
			    	 	if(jQuery(this).attr('multiple') != 'multiple')
			     		{
			    	 		itemData[jQuery(this).attr('id')] = encodeURI(jQuery(this).val());
			    	 	}
			    	 	else
			    	 	{
				    	 	itemData[jQuery(this).attr('id')] = jQuery(this).val();
			    	 	}
			    	 	
				    	 if(jQuery(this).attr('data-attr') == 'title')
				    	 {
				    	 	//Set saved module title
				    	 	var shortcodeName = jQuery('#'+targetItem).find('.title').find('.shortcode_title').html();
				    	 	
				    	 	var updatedShortcodeTitle = '<div class="shortcode_title">'+shortcodeName+'</div>'+decodeURI(jQuery(this).val());
				    	 	
				    	  	jQuery('#'+targetItem).find('.title').html(updatedShortcodeTitle);
				    	  	
				    	  	if(jQuery('#'+targetItem).find('.ppb_unsave').length==0)
				    	  	{
				    	  		ppbSetUnsaveStatus();
				    	  	}
				    	 }
			     	}
			    });
			    
			    var currentItemDataJSON = JSON.stringify(itemData);
			    jQuery('#'+targetItem).data('ppb_setting', currentItemDataJSON);
			    
			    //If in live mode
				if(isLiveMode())
				{
					//Save all content
					ppbSaveAll();
					
					//Set preview frame data
					ppbSetPreviewData();
						
					//Reload preview frame
					ppbReloadPreview();
				}
			    
			    refreshBuilderBlockEvents();
			    
			    jQuery.fancybox.close();
			});
			
			jQuery.fancybox.hideLoading();
		});
		</script>
<?php
		}
	}
	
	die();
}

/**
*	Setup AJAX portfolio content builder preview function
**/
add_action('wp_ajax_grandphotography_ppb_preview', 'grandphotography_ppb_preview');
add_action('wp_ajax_nopriv_grandphotography_ppb_preview', 'grandphotography_ppb_preview');

function grandphotography_ppb_preview() {
	if(is_admin() && isset($_GET['page_id']) && !empty($_GET['page_id']) && isset($_GET['rel']) && !empty($_GET['rel']))
	{
		$page_id = $_GET['page_id'];
		$page_title = $_GET['title'];
		$ppb_form_item = $_GET['rel'];
		$preview_url = get_permalink($page_id);
		$preview_url.= '?ppb_preview=true&rel='.$ppb_form_item;
?>
	<iframe id="ppb_preview_frame" src="<?php echo esc_url($preview_url); ?>"></iframe>
<?php
	}
	die();
}

/**
*	Setup AJAX portfolio content builder preview page function
**/
add_action('wp_ajax_grandphotography_ppb_preview_page', 'grandphotography_ppb_preview_page');
add_action('wp_ajax_nopriv_grandphotography_ppb_preview_page', 'grandphotography_ppb_preview_page');

function grandphotography_ppb_preview_page() {
	if(is_admin() && isset($_GET['page_id']) && !empty($_GET['page_id']))
	{
		$page_id = $_GET['page_id'];
		$page_title = get_the_title($page_id);
		$preview_url = get_permalink($page_id);
		$preview_url.= '?ppb_preview_page=true';
?>
	<iframe id="ppb_preview_frame" src="<?php echo esc_url($preview_url); ?>"></iframe>
<?php
	}
	die();
}


/**
*	Setup content builder set data for preview page function
**/
add_action('wp_ajax_grandphotography_ppb_preview_page_set_data', 'grandphotography_ppb_preview_page_set_data');
add_action('wp_ajax_nopriv_grandphotography_ppb_preview_page_set_data', 'grandphotography_ppb_preview_page_set_data');

function grandphotography_ppb_preview_page_set_data() {
	
	if(is_admin() && isset($_POST['page_id']) && !empty($_POST['page_id']))
	{
		$page_id = $_POST['page_id'];
		$data = mb_convert_encoding($_POST['data'],'UTF-8','UTF-8');
		$data = json_decode($_POST['data']);
		//var_dump($_POST['data']);
		//var_dump($_POST['data_order']);
		$data_order = $_POST['data_order'];
		
		//Set data order to WordPress cache
		set_transient('grandphotography_'.$page_id.'_data_order', $data_order, 3600 );
		
		//Convert order data to array
		$ppb_form_item_arr = array();
		if(!empty($data_order))
		{
		    $ppb_form_item_arr = explode(',', $data_order);
		}
		
		if(isset($ppb_form_item_arr[0]) && !empty($ppb_form_item_arr[0]))
		{
		    $data_arr = array();
		    $size_arr = array();
		
		    foreach($ppb_form_item_arr as $key => $ppb_form_item)
		    {
		    	if(isset($_POST[$ppb_form_item.'_data']))
		    	{
			    	$data_arr[$ppb_form_item] = $_POST[$ppb_form_item.'_data'];
			    	$size_arr[$ppb_form_item] = $_POST[$ppb_form_item.'_size'];
		    	}
		    }
		}
		
		set_transient('grandphotography_'.$page_id.'_data', $data_arr, 3600 );
		set_transient('grandphotography_'.$page_id.'_size', $size_arr, 3600 );
?>
	
<?php
	}
	die();
}


/**
*	Setup preview demo page function
**/
add_action('wp_ajax_grandphotography_ppb_demo_preview', 'grandphotography_ppb_demo_preview');
add_action('wp_ajax_nopriv_grandphotography_ppb_demo_preview', 'grandphotography_ppb_demo_preview');

function grandphotography_ppb_demo_preview() {
	if(is_admin() && isset($_POST['key']) && !empty($_POST['key']))
	{
		require_once get_template_directory() . "/lib/contentbuilder.shortcode.lib.php";
		
		if(isset($ppb_shortcodes[$_POST['key']]))
		{
			$page_title = $ppb_shortcodes[$_POST['key']]['title'];
			$preview_url = $ppb_shortcodes[$_POST['key']]['url'];
?>
	<div class="ppb_inline_wrap preview">
	    <h2><?php esc_html_e('Preview', 'grandphotography' ); ?> <?php echo urldecode($page_title); ?></h2>
	    <a class="button button-primary" href="javascript:;" onClick="jQuery.fancybox.close();"><?php esc_html_e('Close', 'grandphotography' ); ?></a>
	</div>	
	<iframe id="ppb_preview_frame" src="<?php echo esc_url($preview_url); ?>"></iframe>
<?php
		}
	}
	die();
}


/**
*	Setup live preview element function
**/
add_action('wp_ajax_grandphotography_ppb_get_live_preview', 'grandphotography_ppb_get_live_preview');
add_action('wp_ajax_nopriv_grandphotography_ppb_get_live_preview', 'grandphotography_ppb_get_live_preview');

function grandphotography_ppb_get_live_preview() {

	if(is_admin() && isset($_POST['data']) && !empty($_POST['data']) && isset($_POST['size']) && !empty($_POST['size']))
	{
		$ppb_form_item = $_POST['rel'];
		$ppb_form_item_size = $_POST['size'];
		$ppb_form_item_data = $_POST['data'];
		$ppb_form_item_data = mb_convert_encoding($ppb_form_item_data,'UTF-8','UTF-8');
		$ppb_form_item_data_obj = json_decode(stripslashes($ppb_form_item_data));
	    $ppb_shortcode_content_name = $_GET['shortcode'];
	    $ppb_shortcode_code = '';
	    
	    /*print '<pre>';
	    print_r($ppb_form_item_data_obj);
	    print '</pre>';*/
	    
	    $ppb_shortcodes = array();
		require_once get_template_directory() . "/lib/contentbuilder.shortcode.lib.php";
	    
	    if(isset($ppb_form_item_data_obj->$ppb_shortcode_content_name))
	    {
	        $ppb_shortcode_code = '['.$ppb_form_item_data_obj->shortcode.' size="'.$ppb_form_item_size.'" ';
	        
	        //Get shortcode title
	        $ppb_shortcode_title_name = $ppb_form_item_data_obj->shortcode.'_title';
	        if(isset($ppb_form_item_data_obj->$ppb_shortcode_title_name))
	        {
	        	$ppb_shortcode_code.= 'title="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_title_name), ENT_QUOTES, "UTF-8").'" ';
	        }
	        
	        //Get shortcode attributes
	        if(isset($ppb_shortcodes[$ppb_form_item_data_obj->shortcode]))
	        {
	        	$ppb_shortcode_arr = $ppb_shortcodes[$ppb_form_item_data_obj->shortcode];
	        	
	        	foreach($ppb_shortcode_arr['attr'] as $attr_name => $attr_item)
	        	{
	        		$ppb_shortcode_attr_name = $ppb_form_item_data_obj->shortcode.'_'.$attr_name;
	        		
	        		if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_name))
	        		{
	        			$ppb_shortcode_code.= $attr_name.'="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_name)).'" ';
	        		}
	        	}
	        }
	
	        $ppb_shortcode_code.= ']'.rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_content_name).'[/'.$ppb_form_item_data_obj->shortcode.']';
	    }
	    else
	    {
	        $ppb_shortcode_code = '['.$ppb_form_item_data_obj->shortcode.' size="'.$ppb_form_item_size.'" ';
	        
	        //Get shortcode title
	        $ppb_shortcode_title_name = $ppb_form_item_data_obj->shortcode.'_title';
	        if(isset($ppb_form_item_data_obj->$ppb_shortcode_title_name))
	        {
	        	$ppb_shortcode_code.= 'title="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_title_name), ENT_QUOTES, "UTF-8").'" ';
	        }
	        
	        //Get shortcode attributes
	        if(isset($ppb_shortcodes[$ppb_form_item_data_obj->shortcode]))
	        {
	        	$ppb_shortcode_arr = $ppb_shortcodes[$ppb_form_item_data_obj->shortcode];
	        	
	        	foreach($ppb_shortcode_arr['attr'] as $attr_name => $attr_item)
	        	{
	        		$ppb_shortcode_attr_name = $ppb_form_item_data_obj->shortcode.'_'.$attr_name;
	        		
	        		if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_name))
	        		{
	        			$ppb_shortcode_code.= $attr_name.'="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_name)).'" ';
	        		}
	        	}
	        }
	        
	        $ppb_shortcode_code.= ']';
	    }
	    //echo $ppb_shortcode_code;
	    echo do_shortcode($ppb_shortcode_code);
	}
	die();
}


/**
*	Save current as template function
**/
add_action('wp_ajax_grandphotography_ppb_set_template', 'grandphotography_ppb_set_template');
add_action('wp_ajax_nopriv_grandphotography_ppb_set_template', 'grandphotography_ppb_set_template');

function grandphotography_ppb_set_template() {
	if(is_admin() && isset($_POST['template_name']) && !empty($_POST['template_name']) && isset($_GET['page_id']) && !empty($_GET['page_id']) && strlen($_POST['template_name']) >= 3)
	{
		//Get page ID
		$page_id = $_GET['page_id'];
		
		//get list of my templates in array
		$my_current_templates = get_option(SHORTNAME."_my_templates");
		
		//set new template ID and name
		$new_template_name = sanitize_text_field($_POST['template_name']);
		$new_template_id = $page_id.'_'.time();
		$my_current_templates[$new_template_id] = $new_template_name;
		
		//Update my template list
		update_option( SHORTNAME."_my_templates", $my_current_templates );
		
		//Save current page builder content to my template
		$ppb_form_data_order = get_post_meta($page_id, 'ppb_form_data_order');
		$export_options_arr = array();

		if(!empty($ppb_form_data_order))
		{
		    $export_options_arr['ppb_form_data_order'] = $ppb_form_data_order;

		    //Get each builder module data
		    $ppb_form_item_arr = explode(',', $ppb_form_data_order[0]);
		
		    foreach($ppb_form_item_arr as $key => $ppb_form_item)
		    {
		    	$ppb_form_item_data = get_post_meta($page_id, $ppb_form_item.'_data');
		    	$export_options_arr[$ppb_form_item.'_data'] = $ppb_form_item_data;
		    	
		    	$ppb_form_item_size = get_post_meta($page_id, $ppb_form_item.'_size');
		    	$export_options_arr[$ppb_form_item.'_size'] = $ppb_form_item_size;
		    }
		}
		
		update_option( SHORTNAME."_template_".$new_template_id, json_encode($export_options_arr) );
		
		//return template ID
		echo $new_template_id;
	}
	
	die();
}


/**
*	Remove current template function
**/
add_action('wp_ajax_grandphotography_ppb_remove_template', 'grandphotography_ppb_remove_template');
add_action('wp_ajax_nopriv_grandphotography_ppb_remove_template', 'grandphotography_ppb_remove_template');

function grandphotography_ppb_remove_template() {
	if(is_admin() && isset($_GET['template_id']) && !empty($_GET['template_id']))
	{
		//get list of my templates in array
		$my_current_templates = get_option(SHORTNAME."_my_templates");
		$template_id = $_GET['template_id'];
		
		if(isset($my_current_templates[$template_id]))
		{
			//Remove template from array
			unset($my_current_templates[$template_id]);
			
			//Remove from my template list
			update_option( SHORTNAME."_my_templates", $my_current_templates );
			
			//Remove template data
			delete_option( SHORTNAME."_template_".$template_id );
			
			//display to AJAX response
			echo 1;
		}
	}
	
	die();
}


/**
*	Save page builder custom fields
**/
add_action('wp_ajax_grandphotography_ppb_save_page_builder', 'grandphotography_ppb_save_page_builder');
add_action('wp_ajax_nopriv_grandphotography_ppb_save_page_builder', 'grandphotography_ppb_save_page_builder');

function grandphotography_ppb_save_page_builder() {
	if(is_admin() && isset($_POST['data_order']) && isset($_GET['page_id']) && !empty($_GET['page_id']))
	{
		$page_id = $_GET['page_id'];
		
		 //Get builder item
	    $ppb_form_data_order = $_POST['data_order'];
	    $ppb_form_item_arr = array();
	    
	    if(isset($ppb_form_data_order))
	    {
	    	$ppb_form_item_arr = explode(',', $ppb_form_data_order);
	    }
	    
	    if(!empty($ppb_form_item_arr))
	    {
	    	update_post_meta($page_id, 'ppb_form_data_order', $ppb_form_data_order);
	    
	    	foreach($ppb_form_item_arr as $key => $ppb_form_item)
	    	{
	    		if(isset($_POST[$ppb_form_item.'_data']) && $_POST[$ppb_form_item.'_data'] != 'undefined')
		    	{
	    			update_post_meta($page_id, $ppb_form_item.'_data', $_POST[$ppb_form_item.'_data']);
	    		}
	    		
	    		if(isset($_POST[$ppb_form_item.'_size']) && $_POST[$ppb_form_item.'_size'] != 'undefined')
	    		{
	    			update_post_meta($page_id, $ppb_form_item.'_size', $_POST[$ppb_form_item.'_size']);
	    		}
	    	}
	    }
	}
	
	die();
}


/**
*	Save page custom fields
**/
add_action('wp_ajax_grandphotography_ppb_save_page_custom_field', 'grandphotography_ppb_save_page_custom_field');
add_action('grandphotography_ppb_save_page_custom_field', 'grandphotography_ppb_save_page_custom_field');

function grandphotography_ppb_save_page_custom_field() {
	if(is_admin() && isset($_GET['page_id']) && !empty($_GET['page_id']) && isset($_POST['field']) && !empty($_POST['field']) && isset($_POST['data']))
	{
		echo $page_id;
		$page_id = $_GET['page_id'];
		update_post_meta($page_id, $_POST['field'], $_POST['data']);
	}
	
	die();
}

/**
*	Setup one click importer function
**/
add_action('wp_ajax_grandphotography_import_demo_content', 'grandphotography_import_demo_content');

function grandphotography_import_demo_content() {

	if(is_admin() && isset($_POST['demo']) && !empty($_POST['demo']))
	{
	    if ( !defined('WP_LOAD_IMPORTERS') ) define('WP_LOAD_IMPORTERS', true);
	    
	    // Load Importer API
	    require_once ABSPATH . 'wp-admin/includes/import.php';
	
	    if ( ! class_exists( 'WP_Importer' ) ) {
	        $class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
	        if ( file_exists( $class_wp_importer ) )
	        {
	            require_once $class_wp_importer;
	        }
	    }
	
	    if ( ! class_exists( 'WP_Import' ) ) {
	    	$class_wp_importer = get_template_directory() ."/modules/import/wordpress-importer.php";

	        if ( file_exists( $class_wp_importer ) )
	            require_once $class_wp_importer;
	    }
	    
	    grandphotography_get_wp_filesystem();
	
	    $import_files = array();
	    $page_on_front = '';
	    
	    //Create empty menu first before importing
	    $footer_menu_exists = wp_get_nav_menu_object('Footer Menu');
	    if(!$footer_menu_exists)
	    {
		    $footer_menu_id = wp_create_nav_menu('Footer Menu');
	    }
	    
	    $main_left_menu_exists = wp_get_nav_menu_object('Main Left Menu');
	    if(!$main_left_menu_exists)
	    {
		    $main_left_menu_id = wp_create_nav_menu('Main Left Menu');
	    }
	    
	    $main_right_menu_exists = wp_get_nav_menu_object('Main Right Menu');
	    if(!$main_right_menu_exists)
	    {
		    $main_right_menu_id = wp_create_nav_menu('Main Right Menu');
	    }
	    
	    $side_mobile_menu_exists = wp_get_nav_menu_object('Side Mobile Menu');
	    if(!$side_mobile_menu_exists)
	    {
		    $side_mobile_menu_id = wp_create_nav_menu('Side Mobile Menu');
	    }
	    
	    $top_menu_exists = wp_get_nav_menu_object('Top Menu');
	    if(!$top_menu_exists)
	    {
		    $top_menu_id = wp_create_nav_menu('Top Menu');
	    }

		//Check import selected demo
	    if ( class_exists( 'WP_Import' ) ) 
	    { 
	    	switch($_POST['demo'])
	    	{
		    	case 1:
		    	default:
		    		//Check if install Woocommerce
		    		if(!class_exists('Woocommerce'))
					{
		    			$import_filepath = get_template_directory() ."/cache/demos/xml/demo1/1.xml" ;
		    		}
		    		else
		    		{
			    		$import_filepath = get_template_directory() ."/cache/demos/xml/demo1/1_woo.xml" ;
		    		}
		    		
		    		$page_on_front = 3602; //Demo Homepage ID
		    		$oldurl = 'http://themes.themegoods.com/grandphotography/demo';
		    	break;
	    	}
			
			//Run and download demo contents
			$wp_import = new WP_Import();
	        $wp_import->fetch_attachments = true;
	        $wp_import->import($import_filepath);
	        
	        //Remove default Hello World post
	        wp_delete_post(1);
	    }
	    
	    //Remove all theme mods first
	    remove_theme_mods();
		
		//Setup default styling
		$default_dat_customizer = get_template_directory().'/cache/demos/xml/demo'.$_POST['demo'].'/'.$_POST['demo'].'.dat';
		if(file_exists($default_dat_customizer))
		{
			WP_Filesystem();
			$wp_filesystem = grandphotography_get_wp_filesystem();
			$styling_data = $wp_filesystem->get_contents($default_dat_customizer);
			$styling_data_arr = unserialize($styling_data);
			
			if(isset($styling_data_arr['mods']) && is_array($styling_data_arr['mods']))
			{	
				$import_customizer_serialize = file_get_contents($default_dat_customizer);
			    $import_customizer_arr = unserialize($import_customizer_serialize);
			    
			    if(isset($import_customizer_arr['mods']) && !empty($import_customizer_arr['mods']) && is_array($import_customizer_arr['mods']))
			    {	
			    	
			    	foreach($import_customizer_arr['mods'] as $key => $import_customizer)
			    	{	
			    		if(!is_array($import_customizer) && grandphotography_starts_with($key, 'tg_'))
			    		{
			    			set_theme_mod($key, $import_customizer);
						}
			    	}
			    }
			}
		}
		
		//Import widgets
		if(file_exists(get_template_directory() ."/cache/demos/xml/demo".$_POST['demo']."/".$_POST['demo'].".wie"))
		{
			$import_widget_filepath = get_template_directory() ."/cache/demos/xml/demo".$_POST['demo']."/".$_POST['demo'].".wie";
			
			// Get file contents and decode
			WP_Filesystem();
			$wp_filesystem = grandphotography_get_wp_filesystem();
			$data = $wp_filesystem->get_contents($import_widget_filepath);
			$data = json_decode( $data );
		
			// Import the widget data
			// Make results available for display on import/export page
			$widget_import_results = grandphotography_import_data( $data );
		}
		
		//Import Revolution Slider if activate
		if(class_exists('RevSlider'))
		{
			$slider_array = array();
			
			switch($_POST['demo'])
	    	{
		    	case 1:
		    	default:
		    		$slider_array = array(
		    			get_template_directory() ."/cache/demos/xml/demo1/home-6.zip",
		    			get_template_directory() ."/cache/demos/xml/demo1/home-14.zip",
		    		);
		    	break;
	    	}
	    	
	    	if(!empty($slider_array))
	    	{
		    	require_once ABSPATH . 'wp-admin/includes/file.php';
				$obj_revslider = new RevSlider();
				
				foreach($slider_array as $revslider_filepath)
				{
					$obj_revslider->importSliderFromPost(true,true,$revslider_filepath);
				}
			}
		}
		
		//Setup default front page settings.
	    update_option('show_on_front', 'page');
	    update_option('page_on_front', $page_on_front);
	    
	    //Set default custom menu settings
	    $locations = get_theme_mod('nav_menu_locations');
	    switch($_POST['demo'])
	    {
		    case 1:
		    default:
		    	$locations['primary-menu'] = $main_left_menu_id;
				$locations['secondary-menu'] = $main_right_menu_id;
				$locations['top-menu'] = $top_menu_id;
				$locations['side-menu'] = $side_mobile_menu_id;
				$locations['footer-menu'] = $footer_menu_id;
		    break;
	    }
	    
		set_theme_mod( 'nav_menu_locations', $locations );
		
		//Set default Blog Slider category
		set_theme_mod( 'tg_blog_slider_cat', 17 );
		
		//Change all URLs from demo URL to localhost
		$update_options = array ( 0 => 'content', 1 => 'excerpts', 2 => 'links', 3 => 'attachments', 4 => 'custom', 5 => 'guids', );
		$newurl = esc_url( site_url() ) ;
		grandphotography_update_urls($update_options, $oldurl, $newurl);
		
		//Refresh rewrite rules
		flush_rewrite_rules();
	    
		exit();
	}
}

/**
*	Setup get styling function
**/
add_action('wp_ajax_grandphotography_get_styling', 'grandphotography_get_styling');

function grandphotography_get_styling() {
	if(is_admin() && isset($_POST['styling']) && !empty($_POST['styling']))
	{
	    require_once ABSPATH . 'wp-admin/includes/file.php';
		$styling_file = get_template_directory() . "/cache/demos/customizer/settings/".$_POST['styling'].".dat";

		if(file_exists($styling_file))
		{
			WP_Filesystem();
			$wp_filesystem = grandphotography_get_wp_filesystem();
			$styling_data = $wp_filesystem->get_contents($styling_file);
			$styling_data_arr = unserialize($styling_data);
			
			if(isset($styling_data_arr['mods']) && is_array($styling_data_arr['mods']))
			{	
				// Get menu locations and save to array
				$locations = get_theme_mod('nav_menu_locations');
				$save_menus = array();
				foreach( $locations as $key => $val ) 
				{
					$save_menus[$key] = $val;
				}
			
				//Remove all theme customizer
				remove_theme_mods();
				
				//Re-add the menus
				set_theme_mod('nav_menu_locations', array_map( 'absint', $save_menus ));
			
				foreach($styling_data_arr['mods'] as $key => $styling_mod)
				{
					if(!is_array($styling_mod))
					{
						set_theme_mod( $key, $styling_mod );
					}
				}
			}
		    
			exit();
		}
	}
}

/**
*	Setup AJAX search function
**/
add_action('wp_ajax_grandphotography_ajax_search', 'grandphotography_ajax_search');
add_action('wp_ajax_nopriv_grandphotography_ajax_search', 'grandphotography_ajax_search');

function grandphotography_ajax_search() {
	$wpdb = grandphotography_get_wpdb();
	
	if (strlen($_POST['s'])>0) {
		$limit=5;
		$s=strtolower(addslashes($_POST['s']));
		$querystr = "
			SELECT $wpdb->posts.*
			FROM $wpdb->posts
			WHERE 1=1 AND ((lower($wpdb->posts.post_title) like %s))
			AND $wpdb->posts.post_type IN ('post', 'page', 'portfolios', 'galleries')
			AND (post_status = 'publish')
			ORDER BY $wpdb->posts.post_date DESC
			LIMIT $limit;
		 ";

	 	$pageposts = $wpdb->get_results($wpdb->prepare($querystr, '%'.$wpdb->esc_like($s).'%'), OBJECT);
	 	
	 	if(!empty($pageposts))
	 	{
			echo '<ul>';
	
	 		foreach($pageposts as $result_item) 
	 		{
	 			$post=$result_item;
	 			
	 			$post_type = get_post_type($post->ID);
				$post_type_class = '';
				$post_type_title = '';
				
				switch($post_type)
				{
				    case 'galleries':
				    	$post_type_class = '<i class="fa fa-picture-o"></i>';
				    	$post_type_title = esc_html__('Gallery', 'grandphotography' );
				    break;
				    
				    case 'page':
				    default:
				    	$post_type_class = '<i class="fa fa-file-text-o"></i>';
				    	$post_type_title = esc_html__('Page', 'grandphotography' );
				    break;
				    
				    case 'projects':
				    	$post_type_class = '<i class="fa fa-folder-open-o"></i>';
				    	$post_type_title = esc_html__('Projects', 'grandphotography' );
				    break;
				    
				    case 'services':
				    	$post_type_class = '<i class="fa fa-star"></i>';
				    	$post_type_title = esc_html__('Service', 'grandphotography' );
				    break;
				    
				    case 'clients':
				    	$post_type_class = '<i class="fa fa-user"></i>';
				    	$post_type_title = esc_html__('Client', 'grandphotography' );
				    break;
				}
				
				$post_thumb = array();
				if(has_post_thumbnail($post->ID, 'thumbnail'))
				{
				    $image_id = get_post_thumbnail_id($post->ID);
				    $post_thumb = wp_get_attachment_image_src($image_id, 'thumbnail', true);
				    $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
				    
				    if(isset($post_thumb[0]) && !empty($post_thumb[0]))
				    {
				        $post_type_class = '<div class="search_thumb"><img src="'.$post_thumb[0].'" alt="'.esc_attr($image_alt).'"/></div>';
				    }
				}
	 			
				echo '<li>';
				
				if(!isset($post_thumb[0]))
				{
					echo '<div class="post_type_icon">';
				}
				
				echo '<a href="'.get_permalink($post->ID).'">'.$post_type_class.'</i></a>';
				
				if(!isset($post_thumb[0]))
				{
					echo '</div>';
				}
				
				echo '<div class="ajax_post">';
				echo '<a href="'.get_permalink($post->ID).'"><strong>'.$post->post_title.'</strong><br/>';
				echo '<span class="post_detail">'.date(THEMEDATEFORMAT, strtotime($post->post_date)).'</span></a>';
				echo '</div>';
				echo '</li>';
			}
			
			echo '<li class="view_all"><a href="javascript:jQuery(\'#searchform\').submit()">'.esc_html__('View all results', 'grandphotography' ).'</a></li>';
	
			echo '</ul>';
		}

	}
	else 
	{
		echo '';
	}
	die();

}


/**
*	End theme custom AJAX calls handler
**/


/**
*	Setup image proofing function
**/
add_action('wp_ajax_grandphotography_image_proofing', 'grandphotography_image_proofing');
add_action('wp_ajax_nopriv_grandphotography_image_proofing', 'grandphotography_image_proofing');

function grandphotography_image_proofing() {
	if(!THEMEDEMO)
	{
		check_ajax_referer( 'tgajax-post-contact-nonce', 'tg_security' );
		
		$gallery_id = '';
		$image_id = '';
		
		if(isset($_POST['gallery_id']))
		{
			$gallery_id = $_POST['gallery_id'];
		}
		
		if(isset($_POST['image_id']))
		{
			$image_id = $_POST['image_id'];
		}
		
		if(isset($_POST['method']) && $_POST['method'] == 'approve')
		{
			//Get current approved images
			$current_images_approve = get_post_meta($gallery_id, 'gallery_images_approve', true);
			
			if(!is_array($current_images_approve))
			{
				$current_images_approve = array();
			}
			
			if(!empty($current_images_approve))
			{
				if ( !in_array( $image_id, $current_images_approve ) ) {
					$current_images_approve[] = $image_id;
				}
	
				$current_images_approve = array_unique($current_images_approve);
				update_post_meta($gallery_id, 'gallery_images_approve', $current_images_approve);
			}
			else
			{
				$current_images_approve[] = $image_id;
				$current_images_approve = array_unique($current_images_approve);
				update_post_meta($gallery_id, 'gallery_images_approve', $current_images_approve);	
			}
		}
		else if(isset($_POST['method']) && $_POST['method'] == 'unapprove')
		{
			//Get current approved images
			$current_images_approve = get_post_meta($gallery_id, 'gallery_images_approve', true);
			
			if(!is_array($current_images_approve))
			{
				$current_images_approve = array();
			}
			
			if(!empty($current_images_approve))
			{
				if (($key = array_search($image_id, $current_images_approve)) !== false) 
				{
				    unset($current_images_approve[$key]);
				}
				
				update_post_meta($gallery_id, 'gallery_images_approve', $current_images_approve);
			}
		}
	}
	
	die();
}

/**
*	End image proofing function
**/


/**
*	Setup custom CSS function
**/
add_action('wp_ajax_grandphotography_custom_css', 'grandphotography_custom_css');
add_action('wp_ajax_nopriv_grandphotography_custom_css', 'grandphotography_custom_css');

function grandphotography_custom_css() {
	get_template_part("/modules/custom_css");

	die();
}

/**
*	Setup responsive CSS function
**/
add_action('wp_ajax_grandphotography_responsive_css', 'grandphotography_responsive_css');
add_action('wp_ajax_nopriv_grandphotography_responsive_css', 'grandphotography_responsive_css');

function grandphotography_responsive_css() {
	get_template_part("/modules/responsive_css");

	die();
}

/**
*	End responsive CSS function
**/


/**
*	Setup custom script function
**/
add_action('wp_ajax_grandphotography_script_animate_circle_shortcode', 'grandphotography_script_animate_circle_shortcode');
add_action('wp_ajax_nopriv_grandphotography_script_animate_circle_shortcode', 'grandphotography_script_animate_circle_shortcode');

function grandphotography_script_animate_circle_shortcode() {
	get_template_part("/modules/script/script-animate-circle-shortcode");

	die();
}

add_action('wp_ajax_grandphotography_script_animate_counter_shortcode', 'grandphotography_script_animate_counter_shortcode');
add_action('wp_ajax_nopriv_grandphotography_script_animate_counter_shortcode', 'grandphotography_script_animate_counter_shortcode');

function grandphotography_script_animate_counter_shortcode() {
	get_template_part("/modules/script/script-animate-counter-shortcode");

	die();
}

add_action('wp_ajax_grandphotography_script_audio_shortcode', 'grandphotography_script_audio_shortcode');
add_action('wp_ajax_nopriv_grandphotography_script_audio_shortcode', 'grandphotography_script_audio_shortcode');

function grandphotography_script_audio_shortcode() {
	get_template_part("/modules/script/script-audio-shortcode");

	die();
}

add_action('wp_ajax_grandphotography_script_contact_form', 'grandphotography_script_contact_form');
add_action('wp_ajax_nopriv_grandphotography_script_contact_form', 'grandphotography_script_contact_form');

function grandphotography_script_contact_form() {
	get_template_part("/modules/script/script-contact-form");

	die();
}

add_action('wp_ajax_grandphotography_script_demo', 'grandphotography_script_demo');
add_action('wp_ajax_nopriv_grandphotography_script_demo', 'grandphotography_script_demo');

function grandphotography_script_demo() {
	get_template_part("/modules/script/script-demo");

	die();
}

add_action('wp_ajax_grandphotography_script_image_proofing_notification', 'grandphotography_script_image_proofing_notification');
add_action('wp_ajax_nopriv_grandphotography_script_image_proofing_notification', 'grandphotography_script_image_proofing_notification');

function grandphotography_script_image_proofing_notification() {
	get_template_part("/modules/script/script-photoproofing-notify");

	die();
}

/**
*	Setup blur image function
**/
add_action('wp_ajax_grandphotography_blurred_image', 'grandphotography_blurred_image');
add_action('wp_ajax_nopriv_grandphotography_blurred_image', 'grandphotography_blurred_image');

function grandphotography_blurred_image() {
	$do_blur = FALSE;
	if(isset($_GET['src']) && !empty($_GET['src']))
	{
		$image_id = grandphotography_get_image_id($_GET['src']);
		if(!empty($image_id))
		{
			$do_blur = TRUE;
		}
	}
	$blurFactor = 5;
	if(isset($_GET['blur_factor']) && is_numeric($_GET['blur_factor']))
	{
		$blurFactor = $_GET['blur_factor'];
	}
	
	if($do_blur)
	{
		header('Content-Type: image/jpeg');
		$image = imagecreatefromjpeg($_GET['src']);
		$new_image = grandphotography_blur($image,$blurFactor);
		imagejpeg($new_image);
		imagedestroy($new_image);
	}

	die();
}

/**
*	End blur image function
**/

/**
*	Setup contact form captcha function
**/
add_action('wp_ajax_grandphotography_get_captcha', 'grandphotography_get_captcha');
add_action('wp_ajax_nopriv_grandphotography_get_captcha', 'grandphotography_get_captcha');

function grandphotography_get_captcha() {
	session_start();

	if(isset($_GET['check']) && !empty($_GET['check']))
	{	
		if($_GET['captcha-code']==$_SESSION['random_number'])
		{
			echo 'true';
		}
		else
		{
			echo esc_html__('Please enter correct captcha text', 'grandphotography' );
		}
			
		exit;
	}
	else
	{
		$word_1 = '';
		$word_2 = '';
		
		for ($i = 0; $i < 4; $i++) 
		{
			$word_1 .= chr(rand(97, 122));
		}
		for ($i = 0; $i < 4; $i++) 
		{
			$word_2 .= chr(rand(97, 122));
		}
		
		$_SESSION['random_number'] = $word_1.' '.$word_2;
		
		$dir = get_template_directory().'/images/';
		
		$image = imagecreatetruecolor(165, 50);
		
		$font = "recaptchaFont.ttf"; // font style
		
		$color = imagecolorallocate($image, 0, 0, 0);// color
		
		$white = imagecolorallocate($image, 255, 255, 255); // background color white
		
		imagefilledrectangle($image, 0,0, 709, 99, $white);
		
		imagettftext ($image, 22, 0, 5, 30, $color, $dir.$font, $_SESSION['random_number']);
		
		header("Content-type: image/png");
		
		imagepng($image);  
	}

	die();
}

/**
*	End contact form captcha function
**/

add_action('wp_ajax_grandphotography_script_flow_gallery', 'grandphotography_script_flow_gallery');
add_action('wp_ajax_nopriv_grandphotography_script_flow_gallery', 'grandphotography_script_flow_gallery');

function grandphotography_script_flow_gallery() {
	get_template_part("/modules/script/script-flow-gallery");

	die();
}

add_action('wp_ajax_grandphotography_script_flow_gallery_xml', 'grandphotography_script_flow_gallery_xml');
add_action('wp_ajax_nopriv_grandphotography_script_flow_gallery_xml', 'grandphotography_script_flow_gallery_xml');

function grandphotography_script_flow_gallery_xml() {
	$all_photo_arr = array();
	if(isset($_GET['gallery_id']) OR !empty($_GET['gallery_id']))
	{
		$all_photo_arr = get_post_meta($_GET['gallery_id'], 'wpsimplegallery_gallery', true);
		$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);
	}
	
	header("Content-type: text/xml");
	echo '<?xml version="1.0" encoding="utf-8" ?>
			<bank>';
			
	$tg_full_image_caption = kirki_get_option('tg_full_image_caption');
			
	foreach($all_photo_arr as $photo_id)
	{
		$full_image_url = wp_get_attachment_image_src( $photo_id, 'full' );
		$small_image_url = wp_get_attachment_image_src( $photo_id, 'large' );
		$image_caption = get_post_field('post_excerpt', $photo_id);
		
		//Get image meta data
		$image_title = get_the_title($photo_id);
	
		echo '<img>';
		echo '<src>'.$small_image_url[0].'</src>';
		
		$tg_flow_enable_lightbox = kirki_get_option('tg_flow_enable_lightbox');
	
		if(!empty($tg_flow_enable_lightbox))
		{
			echo '<link>'.$full_image_url[0].'</link>';
		}
		else
		{
			echo '<link></link>';
		}
		
		if(!empty($tg_full_image_caption) && !empty($image_caption))
		{
			$image_caption = '<div class="image_caption">'.get_post_field('post_excerpt', $photo_id).'</div>';
			
			//Get image purchase URL
			$grandphotography_purchase_url = get_post_meta($photo_id, 'grandphotography_purchase_url', true);
			if(!empty($grandphotography_purchase_url))
			{
				$image_caption.= '<a href="'.esc_url($grandphotography_purchase_url).'" class="button">'.esc_html__('Purchase', 'grandphotography' ).'</a>';
			}
		
			echo '<caption>'.esc_attr(htmlspecialchars($image_caption)).'</caption>';
		}
		else
		{
			echo '<caption></caption>';
		}
		
		echo '</img>';
	}
			
	echo '</bank>';

	die();
}

add_action('wp_ajax_grandphotography_script_flow_portfolio', 'grandphotography_script_flow_portfolio');
add_action('wp_ajax_nopriv_grandphotography_script_flow_portfolio', 'grandphotography_script_flow_portfolio');

function grandphotography_script_flow_portfolio() {
	get_template_part("/modules/script/script-flow-portfolio");

	die();
}

add_action('wp_ajax_grandphotography_script_flow_portfolio_xml', 'grandphotography_script_flow_portfolio_xml');
add_action('wp_ajax_nopriv_grandphotography_script_flow_portfolio_xml', 'grandphotography_script_flow_portfolio_xml');

function grandphotography_script_flow_portfolio_xml() {
	//Get all portfolio items
	$query_string = 'orderby=menu_order&order=ASC&post_type=portfolios&numberposts=-1&suppress_filters=0&posts_per_page=-1';
		
	if(!empty($term))
	{
	    $ob_term = get_term_by('slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
	    $custom_tax = $wp_query->query_vars['taxonomy'];
	    $query_string .= '&posts_per_page=-1&'.$custom_tax.'='.$term;
	}
	
	parse_str($query_string, $args);
	
	if(THEMEDEMO)
	{
		$args['tax_query'] = array(
		    array(
		        'taxonomy' => 'portfoliosets',
		        'terms' => array(DEMOPORTFOLIOSETID),
		        'field' => 'slug',
		        'operator' => 'NOT IN',
		    ),
		);
	}
	
	query_posts($args);
	
	header("Content-type: text/xml");
	echo '<?xml version="1.0" encoding="utf-8" ?>
			<bank>';
			
	$tg_full_image_caption = kirki_get_option('tg_full_image_caption');
	
			
	if (have_posts()) : while (have_posts()) : the_post();
		$image_url = '';
		$portfolio_ID = get_the_ID();
		    	
		if(has_post_thumbnail($portfolio_ID, 'original'))
		{
		    $image_id = get_post_thumbnail_id($portfolio_ID);
		    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
		}
		
		//Get portfolio meta data
		$image_title = get_the_title();
		
		$portfolio_content = '<div class="image_caption"><h5>'.$image_title.'</h5></div>';
	
		echo '<img>';
		echo '<src>'.$image_url[0].'</src>';
		echo '<caption>'.esc_attr(htmlspecialchars($portfolio_content)).'</caption>';
		
		$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
		$portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
		
		switch($portfolio_type)
		{
		    case 'External Link':
		    	$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
		    	echo '<link>'.esc_url($portfolio_link_url).'</link>';
		    break;
		    
		    case 'Portfolio Content':
		    	echo '<link>'.esc_url(get_permalink($portfolio_ID)).'</link>';
		    break;
		    
		    case 'Image':
		    default:
		    	echo '<link>'.$image_url[0].'</link>';
		    break;
		    
		    case 'Youtube Video':
		    	echo '<link>'.esc_url('https://www.youtube.com/embed/'.esc_attr($portfolio_video_id)).'</link>';
		    break;
		    
		    case 'Vimeo Video':
		    	echo '<link>'.esc_url('https://player.vimeo.com/video/'.esc_attr($portfolio_video_id)).'</link>';
		    break;
		}
		
		echo '</img>';
		
	endwhile; endif;
			
	echo '</bank>';

	die();
}

add_action('wp_ajax_grandphotography_script_gallery_flexslider', 'grandphotography_script_gallery_flexslider');
add_action('wp_ajax_nopriv_grandphotography_script_gallery_flexslider', 'grandphotography_script_gallery_flexslider');

function grandphotography_script_gallery_flexslider() {
	get_template_part("/modules/script/script-gallery-flexslider");

	die();
}

add_action('wp_ajax_grandphotography_script_gallery_infinite_scroll', 'grandphotography_script_gallery_infinite_scroll');
add_action('wp_ajax_nopriv_grandphotography_script_gallery_infinite_scroll', 'grandphotography_script_gallery_infinite_scroll');

function grandphotography_script_gallery_infinite_scroll() {
	get_template_part("/modules/script/script-gallery-infinite-scroll");

	die();
}

add_action('wp_ajax_grandphotography_script_gridrotator', 'grandphotography_script_gridrotator');
add_action('wp_ajax_nopriv_grandphotography_script_gridrotator', 'grandphotography_script_gridrotator');

function grandphotography_script_gridrotator() {
	get_template_part("/modules/script/script-gridrotator");

	die();
}

add_action('wp_ajax_grandphotography_script_jwplayer_shortcode', 'grandphotography_script_jwplayer_shortcode');
add_action('wp_ajax_nopriv_grandphotography_script_jwplayer_shortcode', 'grandphotography_script_jwplayer_shortcode');

function grandphotography_script_jwplayer_shortcode() {
	get_template_part("/modules/script/script-jwplayer-shortcode");

	die();
}

add_action('wp_ajax_grandphotography_script_kenburns_gallery', 'grandphotography_script_kenburns_gallery');
add_action('wp_ajax_nopriv_grandphotography_script_kenburns_gallery', 'grandphotography_script_kenburns_gallery');

function grandphotography_script_kenburns_gallery() {
	get_template_part("/modules/script/script-kenburns-gallery");

	die();
}

add_action('wp_ajax_grandphotography_script_map_shortcode', 'grandphotography_script_map_shortcode');
add_action('wp_ajax_nopriv_grandphotography_script_map_shortcode', 'grandphotography_script_map_shortcode');

function grandphotography_script_map_shortcode() {
	get_template_part("/modules/script/script-map-shortcode");

	die();
}

add_action('wp_ajax_grandphotography_script_portfolio_flexslider', 'grandphotography_script_portfolio_flexslider');
add_action('wp_ajax_nopriv_grandphotography_script_portfolio_flexslider', 'grandphotography_script_portfolio_flexslider');

function grandphotography_script_portfolio_flexslider() {
	get_template_part("/modules/script/script-portfolio-flexslider");

	die();
}

add_action('wp_ajax_grandphotography_script_portfolio_infinite_scroll', 'grandphotography_script_portfolio_infinite_scroll');
add_action('wp_ajax_nopriv_grandphotography_script_portfolio_infinite_scroll', 'grandphotography_script_portfolio_infinite_scroll');

function grandphotography_script_portfolio_infinite_scroll() {
	get_template_part("/modules/script/script-portfolio-infinite-scroll");

	die();
}

add_action('wp_ajax_grandphotography_script_self_hosted_video', 'grandphotography_script_self_hosted_video');
add_action('wp_ajax_nopriv_grandphotography_script_self_hosted_video', 'grandphotography_script_self_hosted_video');

function grandphotography_script_self_hosted_video() {
	get_template_part("/modules/script/script-self-hosted-video");

	die();
}

add_action('wp_ajax_grandphotography_script_slider_flexslider', 'grandphotography_script_slider_flexslider');
add_action('wp_ajax_nopriv_grandphotography_script_slider_flexslider', 'grandphotography_script_slider_flexslider');

function grandphotography_script_slider_flexslider() {
	get_template_part("/modules/script/script-slider-flexslider");

	die();
}

add_action('wp_ajax_grandphotography_script_supersized_gallery', 'grandphotography_script_supersized_gallery');
add_action('wp_ajax_nopriv_grandphotography_script_supersized_gallery', 'grandphotography_script_supersized_gallery');

function grandphotography_script_supersized_gallery() {
	get_template_part("/modules/script/script-supersized-gallery");

	die();
}

add_action('wp_ajax_grandphotography_script_testimonials_flexslider', 'grandphotography_script_testimonials_flexslider');
add_action('wp_ajax_nopriv_grandphotography_script_testimonials_flexslider', 'grandphotography_script_testimonials_flexslider');

function grandphotography_script_testimonials_flexslider() {
	get_template_part("/modules/script/script-testimonials-flexslider");

	die();
}

add_action('wp_ajax_grandphotography_script_grid_gallery_pagination_click', 'grandphotography_script_grid_gallery_pagination_click');
add_action('wp_ajax_nopriv_grandphotography_script_grid_gallery_pagination_click', 'grandphotography_script_grid_gallery_pagination_click');

function grandphotography_script_grid_gallery_pagination_click() {

	$id = 'portfolio_filter_wrapper';
	if(isset($_GET['id']))
	{
		$id = $_GET['id'];
	}
	
	$button_id = '';
	if(isset($_GET['button_id']))
	{
		$button_id = $_GET['button_id'];
	}
	
	$loading_id = '';
	if(isset($_GET['loading_id']))
	{
		$loading_id = $_GET['loading_id'];
	}
	
	$columns = 2;
	if(isset($_GET['columns']))
	{
		$columns = $_GET['columns'];
	}
	
	$gallery_id = '';
	if(isset($_GET['gallery_id']) && !empty($_GET['gallery_id']))
	{
		$gallery_id = $_GET['gallery_id'];
	}
	
	$type = 'grid';
	if(isset($_GET['type']))
	{
		$type = $_GET['type'];
	}
	
	$element = 'element';
	if(isset($_GET['element']))
	{
		$element = $_GET['element'];
	}
	
	$gutter = 0;
	if(isset($_GET['gutter']))
	{
		$gutter = $_GET['gutter'];
	}
	
	$photoframe = 0;
	if(isset($_GET['photoframe']))
	{
		$photoframe = $_GET['photoframe'];
	}
	
	$justified = 0;
	if(isset($_GET['justified']))
	{
		$justified = $_GET['justified'];
	}

	if(!empty($gallery_id))
	{	
		header("content-type: application/x-javascript");
		
		$function_action = 'grandphotography_script_grid_gallery_pagination_load';
?>
jQuery(window).load(function(){ 
<?php
	if($type == 'masonry' && empty($justified))
	{
?>

jQuery("#<?php echo esc_js($id); ?>").masonry({
  itemSelector: ".<?php echo esc_js($element); ?>",
  columnWidth: ".<?php echo esc_js($element); ?>",
  gutter: <?php echo esc_js($gutter); ?>,
  transitionDuration: 0
});
<?php
	if(empty($photoframe))
	{
?>
jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
    jQuery("#<?php echo esc_js($id); ?>").children(".<?php echo esc_js($element); ?>").children(".gallery_type").each(function(){
        jQuery(this).addClass("slideUp");
    });
});
<?php
	}
	else
	{
?>
jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
    jQuery("#<?php echo esc_js($id); ?>").children(".<?php echo esc_js($element); ?>").each(function(){
        jQuery(this).addClass("slideUp");
    });
});
<?php
}
?>
<?php		
	}
	else if($type == 'metro')
	{
		$function_action = 'grandphotography_script_metro_gallery_pagination_load';
?>
jQuery("#<?php echo esc_js($id); ?>").masonry({
  itemSelector: ".<?php echo esc_js($element); ?>",
  gutter: <?php echo esc_js($gutter); ?>,
  columnWidth: Math.floor(jQuery("#<?php echo esc_js($id); ?>").width()/ 3)
});

<?php
if(empty($photoframe))
{
?>
jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
    jQuery("#<?php echo esc_js($id); ?>").children(".<?php echo esc_js($element); ?>").children(".gallery_type").each(function(){
        jQuery(this).addClass("slideUp");
    });
});
<?php
}
else
{
?>
jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
    jQuery("#<?php echo esc_js($id); ?>").children(".<?php echo esc_js($element); ?>").each(function(){
        jQuery(this).addClass("slideUp");
    });
});
<?php
}
?>

jQuery(window).resize(function () {
	jQuery("#<?php echo esc_js($id); ?>").masonry({
	  itemSelector: ".<?php echo esc_js($element); ?>",
	  gutter: <?php echo esc_js($gutter); ?>,
	  columnWidth: Math.floor(jQuery("#<?php echo esc_js($id); ?>").width()/ 3)
	});
});
<?php	
	}
	else
	{
?>
jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
    jQuery("#<?php echo esc_js($id); ?>").children(".<?php echo esc_js($element); ?>").children(".gallery_type").each(function(){
	    jQuery(this).addClass("slideUp");
    });
});
<?php
	}
		//Get gallery images
		$all_photo_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
		if(is_array($all_photo_arr))
		{
			$all_photo_count = count($all_photo_arr);
		}
		else
		{
			$all_photo_count = 0;
		}
?>

<?php
if(!empty($button_id))
{
?>
jQuery('#<?php echo esc_js($button_id); ?>').click(function(){
	jQuery(this).hide();
    jQuery('#<?php echo esc_js($loading_id); ?>').addClass('visible');
    
    var startItem = parseInt(jQuery(this).attr('data-start'));
    var loadItems = parseInt(jQuery(this).attr('data-items'));
    
    jQuery.ajax({
	    url:"<?php echo admin_url('admin-ajax.php'); ?>",
	    type:'POST',
<?php
	if($type == 'masonry' OR $type == 'grid')
	{
?>
	    data:'action=<?php echo esc_js($function_action); ?>&gallery_id=<?php echo esc_js($gallery_id); ?>&start='+startItem+'&items='+loadItems+'&columns=<?php echo esc_js($columns); ?>&type=<?php echo esc_js($type); ?>&photoframe=<?php echo esc_js($photoframe); ?>&justified=<?php echo esc_js($justified); ?>',
<?php
	}
	else if($type == 'metro')
	{
?>
		data:'action=<?php echo esc_js($function_action); ?>&gallery_id=<?php echo esc_js($gallery_id); ?>&start='+startItem+'&items='+loadItems+'&columns=<?php echo esc_js($columns); ?>&type=<?php echo esc_js($type); ?>&largecounter='+jQuery(this).attr('data-largecounter')+'&nextnumbertoadd='+jQuery(this).attr('data-nextnumbertoadd')+'&nexttrigger='+jQuery(this).attr('data-nexttrigger'),
<?php
	}
?>
	    success:function(results) {
	    	if(results != '')
	    	{
<?php
	if(($type == 'masonry' && empty($justified)) OR $type == 'metro')
	{
?>
				var html = jQuery(results);
				jQuery("#<?php echo esc_js($id); ?>").append(html).masonry( 'appended', html ).masonry();
				
				jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
					jQuery("#<?php echo esc_js($id); ?>").masonry( 'reloadItems' );
					jQuery("#<?php echo esc_js($id); ?>").masonry( 'layout' );
				});
				
				jQuery('#<?php echo esc_js($button_id); ?>').attr('data-start', parseInt(startItem+loadItems));

<?php
	}
	else
	{
?>
				jQuery('#<?php echo esc_js($id); ?>').append(results);
<?php
	}
?>
	    		jQuery(document).setiLightbox();
	    		jQuery('#<?php echo esc_js($loading_id); ?>').removeClass('visible');
	    		
	    		var newStartItems = parseInt(startItem + loadItems);
	    		if(newStartItems >= <?php echo intval($all_photo_count); ?>)
	    		{
	    			jQuery('#<?php echo esc_js($button_id); ?>').remove();
	    		}
	    		else
	    		{
	    			jQuery('#<?php echo esc_js($button_id); ?>').attr('data-start', newStartItems);
	    			jQuery('#<?php echo esc_js($button_id); ?>').show();
	    			
	    			<?php
						$tg_gallery_pagination_infinite = kirki_get_option('tg_gallery_pagination_infinite');
						
						if(!empty($tg_gallery_pagination_infinite))
						{
					?>
					if(jQuery('#<?php echo esc_js($button_id); ?>').length > 0)
					{
						Waypoint.destroyAll();
						var waypoint = new Waypoint({
						  element: document.getElementById('<?php echo esc_js($button_id); ?>'),
						  handler: function(direction) {
						    jQuery('#<?php echo esc_js($button_id); ?>').trigger('click');
						  },
						  offset: '100%'
						});
					}
					<?php
						}
					?>
	    		}
	    	}
	    	else
	    	{
	    		
	    	}
	    }
	})
});
<?php
	$tg_gallery_pagination_infinite = kirki_get_option('tg_gallery_pagination_infinite');
	
	if(!empty($tg_gallery_pagination_infinite))
	{
?>
if(jQuery('#<?php echo esc_js($button_id); ?>').length > 0)
{
	var waypoint = new Waypoint({
	  element: document.getElementById('<?php echo esc_js($button_id); ?>'),
	  handler: function(direction) {
	    jQuery('#<?php echo esc_js($button_id); ?>').trigger('click');
	  },
	  offset: '120%'
	});
}
<?php
	}
?>

<?php
	}
?>
<?php
}
?>
});
<?php
	die();
}

add_action('wp_ajax_grandphotography_script_grid_gallery_pagination_load', 'grandphotography_script_grid_gallery_pagination_load');
add_action('wp_ajax_nopriv_grandphotography_script_grid_gallery_pagination_load', 'grandphotography_script_grid_gallery_pagination_load');

function grandphotography_script_grid_gallery_pagination_load() {
	$gallery_id = '';
	if(isset($_POST['gallery_id']) && !empty($_POST['gallery_id']))
	{
		$gallery_id = $_POST['gallery_id'];
	}
	
	$type = 'grid';
	if(isset($_POST['type']))
	{
		$type = $_POST['type'];
	}
	
	$photoframe = '';
	if(isset($_POST['photoframe']) && !empty($_POST['photoframe']))
	{
		$photoframe = 'photoframe';
	}
	
	$justified = 0;
	if(isset($_POST['justified']))
	{
		$justified = $_POST['justified'];
	}

	if(!empty($gallery_id))
	{
		$columns = 2;
		$element_class = 'element '.$type.' classic2_cols';
		$columns_class = 'one_half gallery2 static filterable gallery_type';
		$image_size = 'grandphotography-gallery-'.$type;
		
		if(isset($_POST['columns']))
		{
			$columns = $_POST['columns'];
		}
		
		switch($columns)
		{
			case 1:
				$element_class = 'element '.$type.' classic1_cols';
				$columns_class = 'one gallery1 static filterable gallery_type';
				$image_size = 'original';
			break;
			
			case 2:
			default:
				$element_class = 'element '.$type.' classic2_cols';
				$columns_class = 'one_half gallery2 static filterable gallery_type';
			break;
			
			case 3:
				$element_class = 'element '.$type.' classic3_cols '.$photoframe;
				$columns_class = 'one_third gallery3 static filterable gallery_type';
			break;
			
			case 4:
				$element_class = 'element '.$type.' classic4_cols';
				$columns_class = 'one_fourth gallery4 static filterable gallery_type';
			break;
			
			case 5:
				$element_class = 'element '.$type.' classic5_cols';
				$columns_class = 'one_fifth gallery5 static filterable gallery_type';
			break;
		}
	
		$start = 0;
		if(isset($_POST['start']))
		{
			$start = $_POST['start'];
		}
		
		$items = 0;
		if(isset($_POST['items']))
		{
			$items = $_POST['items'];
		}
		
		//Get gallery images
		$all_photo_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
		$all_photo_count = count($all_photo_arr);
		
		//Sort gallery images
		$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);

		//Get only images from setting
		$all_photo_arr = array_slice($all_photo_arr, $start, $items);
		$current_photo_count = count($all_photo_arr);
		
		foreach($all_photo_arr as $key => $photo_id)
		{
		    $small_image_url = '';
		    $image_url = '';
		    
		    if(!empty($photo_id))
		    {
		    	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
		    	$small_image_url = wp_get_attachment_image_src($photo_id, $image_size, true);
		    }
		    
		    //Get image meta data
		    $image_caption = get_post_field('post_excerpt', $photo_id);
		    $image_caption_raw = $image_caption;
		    $image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
		    $tg_full_image_caption = kirki_get_option('tg_full_image_caption');
		    $image_share_url = get_permalink($photo_id);
		    
		    //Get image purchase URL
		    $grandphotography_purchase_url = get_post_meta($photo_id, 'grandphotography_purchase_url', true);
		    
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
?>
<div class="<?php echo esc_attr($element_class); ?> <?php if(!empty($photoframe)) { ?>slideUp animated<?php echo esc_attr($key+1); ?> <?php } ?>">
			
    <div class="<?php echo esc_attr($columns_class); ?> <?php if(empty($photoframe)) { ?>slideUp animated<?php echo esc_attr($key+1); ?> <?php } ?>" data-id="post-<?php echo esc_attr($photo_id); ?>">
    <?php 
        if(isset($image_url[0]) && !empty($image_url[0]))
    	{
    ?>		
        <a <?php if(!empty($tg_full_image_caption)) { ?>data-caption="<?php if(!empty($image_caption)) { ?><?php echo esc_attr($image_caption); ?><?php } ?>"<?php } ?> class="fancy-gallery" href="<?php echo esc_url($image_url[0]); ?>">
    	    <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>" />
    	    
    	    <?php
    		     if(!empty($grandphotography_purchase_url))
    		     {
    		 ?>
    		 <a href="<?php echo esc_url($grandphotography_purchase_url); ?>" title="<?php echo esc_html__('Purchase', 'grandphotography' ); ?>" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>
    		 <?php
    		     }
    		 ?>
    	    
    	    <?php
    		 	if(!empty($image_caption_raw) && empty($photoframe))
    		 	{
    		 ?>
    			 <div class="portfolio_title">
    		    	<div class="image_caption">
    				    <?php echo esc_html($image_caption_raw); ?>
    			    </div>
    			 </div>
    		<?php
    			}
    		?>
        </a>
    <?php
        }		
    ?>
    </div>
    
    <?php
     	if(!empty($image_caption_raw) && !empty($photoframe))
     	{
     ?>
         <div class="gallery_info_wrapper"><?php echo esc_html($image_caption_raw); ?></div>
    <?php
        }
    ?>
</div>
<?php
		}
		
	}
	
	die();
}

add_action('wp_ajax_grandphotography_script_metro_gallery_pagination_load', 'grandphotography_script_metro_gallery_pagination_load');
add_action('wp_ajax_nopriv_grandphotography_script_metro_gallery_pagination_load', 'grandphotography_script_metro_gallery_pagination_load');

function grandphotography_script_metro_gallery_pagination_load() {
	$type = 'grid';
	$gallery_id = '';
	if(isset($_POST['gallery_id']) && !empty($_POST['gallery_id']))
	{
		$gallery_id = $_POST['gallery_id'];
	}

	if(!empty($gallery_id))
	{
		$start = 0;
		if(isset($_POST['start']))
		{
			$start = $_POST['start'];
		}
		
		$items = 0;
		if(isset($_POST['items']))
		{
			$items = $_POST['items'];
		}
		
		//Get gallery images
		$all_photo_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
		$all_photo_count = count($all_photo_arr);
		
		//Sort gallery images
		$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);

		//Get only images from setting
		$all_photo_arr = array_slice($all_photo_arr, $start, $items);
		$current_photo_count = count($all_photo_arr);
		
		$large_counter = 1;
		if(isset($_POST['largecounter']))
		{
			$large_counter = $_POST['largecounter'];
		}
		
		$next_number_to_add = 4;
		if(isset($_POST['nextnumbertoadd']))
		{
			$next_number_to_add = $_POST['nextnumbertoadd'];
		}
		
		$next_trigger = 1;
		if(isset($_POST['nexttrigger']))
		{
			$next_trigger = $_POST['nexttrigger'];
		}
		
		$key = $start;
		$counter = 0;
		
		foreach($all_photo_arr as $photo_id)
		{
		    $small_image_url = '';
	        $image_url = '';
	        
	        //Calculated columns size
			$element_class = 'element '.$type.' classic3_cols';
			$columns_class = 'one_third gallery3 static filterable gallery_type';
			$grandphotography_image_size = 'grandphotography-gallery-grid';
			
			$large_counter_trigger = FALSE;
			
			if($next_trigger == $key+1)
			{
				$large_counter_trigger = TRUE;
				$next_trigger = $next_trigger+$next_number_to_add;
				
				if($next_number_to_add == 4)
				{
					$next_number_to_add = 2;
				}
				else if($next_number_to_add==2)
				{
					$next_number_to_add = 4;
				}
			}
			
			if($large_counter_trigger)
			{
				$columns_class = 'one_third gallery3 static filterable gallery_type double_size';
				$element_class = 'element '.$type.' classic3_cols double_size';
				
				$grandphotography_image_size = 'grandphotography-gallery-grid-large';
			}
			
			$large_counter++;
			$key++;
	        $counter++;
	        
	        if(!empty($photo_id))
	        {
	        	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
	        	$small_image_url = wp_get_attachment_image_src($photo_id, $grandphotography_image_size, true);
	        }
	        
	        //Get image meta data
			$image_caption = get_post_field('post_excerpt', $photo_id);
			$image_caption_raw = $image_caption;
			$image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
			$tg_full_image_caption = kirki_get_option('tg_full_image_caption');
			$image_share_url = get_permalink($photo_id);
			
			//Get image purchase URL
			$grandphotography_purchase_url = get_post_meta($photo_id, 'grandphotography_purchase_url', true);
			
			$image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
?>
<div class="<?php echo esc_attr($element_class); ?>">
			
    <div class="<?php echo esc_attr($columns_class); ?> slideUp animated<?php echo esc_attr($counter+1); ?>" data-id="post-<?php echo esc_attr($photo_id); ?>">
    <?php 
        if(isset($image_url[0]) && !empty($image_url[0]))
    	{
    ?>		
        <a <?php if(!empty($tg_full_image_caption)) { ?>data-caption="<?php if(!empty($image_caption)) { ?><?php echo esc_attr($image_caption); ?><?php } ?>"<?php } ?> class="fancy-gallery" href="<?php echo esc_url($image_url[0]); ?>">
    	    <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>" />
    	    
    	    <?php
    		     if(!empty($grandphotography_purchase_url))
    		     {
    		 ?>
    		 <a href="<?php echo esc_url($grandphotography_purchase_url); ?>" title="<?php echo esc_html__('Purchase', 'grandphotography' ); ?>" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>
    		 <?php
    		     }
    		 ?>
    	    
    	    <?php
    		 	if(!empty($image_caption_raw))
    		 	{
    		 ?>
    			 <div class="portfolio_title">
    		    	<div class="image_caption">
    				    <?php echo esc_html($image_caption_raw); ?>
    			    </div>
    			 </div>
    		<?php
    			}
    		?>
        </a>
    <?php
        }		
    ?>
    </div>
</div>
<?php
		}
?>
<script>
jQuery(window).load(function(){ 
	jQuery('#infinite_load_more').attr('data-largecounter', <?php echo esc_js($large_counter); ?>);
	jQuery('#infinite_load_more').attr('data-nextnumbertoadd', <?php echo esc_js($next_number_to_add); ?>);
	jQuery('#infinite_load_more').attr('data-nexttrigger', <?php echo esc_js($next_trigger); ?>);
});
</script>
<?php
	}
	
	die();
}

add_action('wp_ajax_grandphotography_script_grid_portfolio_pagination_click', 'grandphotography_script_grid_portfolio_pagination_click');
add_action('wp_ajax_nopriv_grandphotography_script_grid_portfolio_pagination_click', 'grandphotography_script_grid_portfolio_pagination_click');

function grandphotography_script_grid_portfolio_pagination_click() {

	$id = 'portfolio_filter_wrapper';
	if(isset($_GET['id']))
	{
		$id = $_GET['id'];
	}
	
	$button_id = '';
	if(isset($_GET['button_id']))
	{
		$button_id = $_GET['button_id'];
	}
	
	$loading_id = '';
	if(isset($_GET['loading_id']))
	{
		$loading_id = $_GET['loading_id'];
	}
	
	$columns = 2;
	if(isset($_GET['columns']))
	{
		$columns = $_GET['columns'];
	}
	
	$type = 'grid';
	if(isset($_GET['type']))
	{
		$type = $_GET['type'];
	}
	
	$element = 'element';
	if(isset($_GET['element']))
	{
		$element = $_GET['element'];
	}
	
	$gutter = 0;
	if(isset($_GET['gutter']))
	{
		$gutter = $_GET['gutter'];
	}
	
	$photoframe = 0;
	if(isset($_GET['photoframe']))
	{
		$photoframe = $_GET['photoframe'];
	}
	
	$start = 0;
	if(isset($_POST['start']))
	{
		$start = $_POST['start'];
	}
	
	$items = 0;
	if(isset($_POST['items']))
	{
		$items = $_POST['items'];
	}

	if(!empty($id))
	{	
		header("content-type: application/x-javascript");
		
		$function_action = 'grandphotography_script_grid_portfolio_pagination_load';
?>
jQuery(window).load(function(){ 
<?php
	if($type == 'metro')
	{
		$function_action = 'grandphotography_script_metro_portfolio_pagination_load';
?>
jQuery("#<?php echo esc_js($id); ?>").masonry({
  itemSelector: ".<?php echo esc_js($element); ?>",
  gutter: <?php echo esc_js($gutter); ?>,
  columnWidth: Math.floor(jQuery("#<?php echo esc_js($id); ?>").width()/ 3)
});

jQuery(window).resize(function () {
	jQuery("#<?php echo esc_js($id); ?>").masonry({
	  itemSelector: ".<?php echo esc_js($element); ?>",
	  gutter: <?php echo esc_js($gutter); ?>,
	  columnWidth: Math.floor(jQuery("#<?php echo esc_js($id); ?>").width()/ 3)
	});
});
<?php	
	}
	else if(!empty($photoframe))
	{
?>
jQuery("#<?php echo esc_js($id); ?>").masonry({
  itemSelector: ".<?php echo esc_js($element); ?>",
  columnWidth: ".<?php echo esc_js($element); ?>",
  gutter: <?php echo esc_js($gutter); ?>,
  transitionDuration: 0
});
<?php
	}
?>
<?php
if(empty($photoframe))
{
?>
jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
    jQuery("#<?php echo esc_js($id); ?>").children(".<?php echo esc_js($element); ?>").children(".portfolio_type").each(function(){
        jQuery(this).addClass("slideUp");
    });
});
<?php
}
else
{
?>
jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
    jQuery("#<?php echo esc_js($id); ?>").children(".<?php echo esc_js($element); ?>").each(function(){
        jQuery(this).addClass("slideUp");
    });
});
<?php
}
	//Get gallery images
	$wp_query = grandphotography_get_wp_query();
	
	$query_string = '&orderby=menu_order&order=ASC&post_type=portfolios&posts_per_page='.$items.'&suppress_filters=0&post_status=publish&offset='.$start;
	
	if(!empty($portfolio_set))
	{
		$query_string .= '&portfoliosets='.$portfolio_set;
	}
	
	parse_str($query_string, $args);
	
	if(THEMEDEMO)
	{
		$args['tax_query'] = array(
		    array(
		        'taxonomy' => 'portfoliosets',
		        'terms' => array(DEMOPORTFOLIOSETID),
		        'field' => 'slug',
		        'operator' => 'NOT IN',
		    ),
		);
	}
	
	$wp_query->query($args);
	$all_photo_count = $wp_query->found_posts;
?>

<?php
if(!empty($button_id))
{
?>
jQuery('#<?php echo esc_js($button_id); ?>').click(function(){
	jQuery(this).hide();
    jQuery('#<?php echo esc_js($loading_id); ?>').addClass('visible');
    
    var startItem = parseInt(jQuery(this).attr('data-start'));
    var loadItems = parseInt(jQuery(this).attr('data-items'));
    
    jQuery.ajax({
	    url:"<?php echo admin_url('admin-ajax.php'); ?>",
	    type:'POST',
<?php
	if($type == 'masonry' OR $type == 'grid')
	{
?>
	    data:'action=<?php echo esc_js($function_action); ?>&start='+startItem+'&items='+loadItems+'&columns=<?php echo esc_js($columns); ?>&type=<?php echo esc_js($type); ?>&photoframe=<?php echo esc_js($photoframe); ?>',
<?php
	}
	else if($type == 'metro')
	{
?>
		data:'action=<?php echo esc_js($function_action); ?>&start='+startItem+'&items='+loadItems+'&columns=<?php echo esc_js($columns); ?>&type=<?php echo esc_js($type); ?>&largecounter='+jQuery(this).attr('data-largecounter')+'&nextnumbertoadd='+jQuery(this).attr('data-nextnumbertoadd')+'&nexttrigger='+jQuery(this).attr('data-nexttrigger'),
<?php
	}
?>
	    success:function(results) {
	    	if(results != '')
	    	{
<?php
	if(!empty($photoframe) OR $type == 'metro')
	{
?>
				var html = jQuery(results);
				jQuery("#<?php echo esc_js($id); ?>").append(html).masonry( 'appended', html ).masonry();
				
				jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
					jQuery("#<?php echo esc_js($id); ?>").masonry( 'reloadItems' );
					jQuery("#<?php echo esc_js($id); ?>").masonry( 'layout' );
				});
				
				jQuery('#<?php echo esc_js($button_id); ?>').attr('data-start', parseInt(startItem+loadItems));

<?php
	}
	else
	{
?>
				jQuery('#<?php echo esc_js($id); ?>').append(results);
<?php
	}
?>
	    		jQuery(document).setiLightbox();
	    		jQuery('#<?php echo esc_js($loading_id); ?>').removeClass('visible');
	    		
	    		var newStartItems = parseInt(startItem + loadItems);
	    		if(newStartItems >= <?php echo intval($all_photo_count); ?>)
	    		{
	    			jQuery('#<?php echo esc_js($button_id); ?>').remove();
	    		}
	    		else
	    		{
	    			jQuery('#<?php echo esc_js($button_id); ?>').attr('data-start', newStartItems);
	    			jQuery('#<?php echo esc_js($button_id); ?>').show();
	    			
	    			<?php
						$tg_gallery_pagination_infinite = kirki_get_option('tg_gallery_pagination_infinite');
						
						if(!empty($tg_gallery_pagination_infinite))
						{
					?>
					if(jQuery('#<?php echo esc_js($button_id); ?>').length > 0)
					{
						Waypoint.destroyAll();
						var waypoint = new Waypoint({
						  element: document.getElementById('<?php echo esc_js($button_id); ?>'),
						  handler: function(direction) {
						    jQuery('#<?php echo esc_js($button_id); ?>').trigger('click');
						  },
						  offset: '100%'
						});
					}
					<?php
						}
					?>
	    		}
	    	}
	    }
	})
});

<?php
	$tg_gallery_pagination_infinite = kirki_get_option('tg_gallery_pagination_infinite');
	
	if(!empty($tg_gallery_pagination_infinite))
	{
?>
if(jQuery('#<?php echo esc_js($button_id); ?>').length > 0)
{
	var waypoint = new Waypoint({
	  element: document.getElementById('<?php echo esc_js($button_id); ?>'),
	  handler: function(direction) {
	    jQuery('#<?php echo esc_js($button_id); ?>').trigger('click');
	  },
	  offset: '120%'
	});
}
<?php
	}
?>

<?php
}
?>
<?php
	}
?>
});
<?php
	die();
}

add_action('wp_ajax_grandphotography_script_grid_portfolio_filterable_click', 'grandphotography_script_grid_portfolio_filterable_click');
add_action('wp_ajax_nopriv_grandphotography_script_grid_portfolio_filterable_click', 'grandphotography_script_grid_portfolio_filterable_click');

function grandphotography_script_grid_portfolio_filterable_click() {

	$id = 'portfolio_filter_wrapper';
	if(isset($_GET['id']))
	{
		$id = $_GET['id'];
	}
	
	$button_id = 'infinite_load_more';
	if(isset($_GET['button_id']))
	{
		$button_id = $_GET['button_id'];
	}
	
	$loading_id = 'infinite_loading';
	if(isset($_GET['loading_id']))
	{
		$loading_id = $_GET['loading_id'];
	}
	
	$columns = 2;
	if(isset($_GET['columns']))
	{
		$columns = $_GET['columns'];
	}
	
	$type = 'grid';
	if(isset($_GET['type']))
	{
		$type = $_GET['type'];
	}
	
	$element = 'element';
	if(isset($_GET['element']))
	{
		$element = $_GET['element'];
	}
	
	$gutter = 0;
	if(isset($_GET['gutter']))
	{
		$gutter = $_GET['gutter'];
	}
	
	$photoframe = 0;
	if(isset($_GET['photoframe']))
	{
		$photoframe = $_GET['photoframe'];
	}

	if(!empty($id))
	{	
		header("content-type: application/x-javascript");
		
		$function_action = 'grandphotography_script_grid_portfolio_pagination_load';
		
		if($type == 'metro')
		{
			$function_action = 'grandphotography_script_metro_portfolio_pagination_load';
		}
?>
jQuery(window).load(function(){ 

if(jQuery('#tg_portfolio_filterable_link').val()!=1)
{
jQuery('#portfolio_wall_filters li a').click(function(){
	jQuery('#portfolio_wall_filters li a').removeClass('active');
    jQuery(this).addClass('active');
    jQuery('#<?php echo esc_js($id); ?>').html('');
    <?php
		if(!empty($photoframe) OR $type == 'metro')
		{
	?>
	jQuery('#<?php echo esc_js($id); ?>').css('height', '0px');
	<?php
		}
	?>
    jQuery('#<?php echo esc_js($button_id); ?>').remove();
    
    var selectedSet = jQuery(this).attr('data-filter');
    
    jQuery('#<?php echo esc_js($loading_id); ?>').addClass('visible');

    jQuery.ajax({
	    url:"<?php echo admin_url('admin-ajax.php'); ?>",
	    type:'POST',
		data:'action=<?php echo esc_js($function_action); ?>&columns=<?php echo esc_js($columns); ?>&type=<?php echo esc_js($type); ?>&photoframe=<?php echo esc_js($photoframe); ?>&portfolio_set='+selectedSet,
		success:function(results) {
	    	if(results != '')
	    	{
	    		jQuery('#<?php echo esc_js($loading_id); ?>').removeClass('visible');
<?php
	if(!empty($photoframe) OR $type == 'metro')
	{
?>
				var html = jQuery(results);
				jQuery("#<?php echo esc_js($id); ?>").append(html).masonry( 'appended', html ).masonry();
				
				jQuery("#<?php echo esc_js($id); ?>").imagesLoaded( function(){
					jQuery("#<?php echo esc_js($id); ?>").masonry( 'reloadItems' );
					jQuery("#<?php echo esc_js($id); ?>").masonry( 'layout' );
				});

<?php
	}
	else
	{
?>
				jQuery('#<?php echo esc_js($id); ?>').html(results);
<?php
	}
?>
	    		jQuery(document).setiLightbox();
	    		
	    		var scrollToPos = parseInt(jQuery('#<?php echo esc_js($id); ?>').offset().top);
    
			    jQuery('body,html').animate({
					scrollTop: scrollToPos
				}, 300);
	    	}
	    }
	});
});
}
<?php
	}
?>
});
<?php
	die();
}

add_action('wp_ajax_grandphotography_script_grid_portfolio_pagination_load', 'grandphotography_script_grid_portfolio_pagination_load');
add_action('wp_ajax_nopriv_grandphotography_script_grid_portfolio_pagination_load', 'grandphotography_script_grid_portfolio_pagination_load');

function grandphotography_script_grid_portfolio_pagination_load() {
	$type = 'grid';
	if(isset($_POST['type']))
	{
		$type = $_POST['type'];
	}
	
	$photoframe = '';
	if(isset($_POST['photoframe']) && !empty($_POST['photoframe']))
	{
		$photoframe = 'photoframe';
	}
	
	$portfolio_set = '';
	if(isset($_POST['portfolio_set']))
	{
		$portfolio_set = $_POST['portfolio_set'];
	}

	$columns = 2;
	$element_class = 'element '.$type.' classic2_cols';
	$columns_class = 'one_half gallery2 static filterable portfolio_type';
	$image_size = 'grandphotography-gallery-'.$type;
	$header_tag = 'h5';
	
	if(isset($_POST['columns']))
	{
	    $columns = $_POST['columns'];
	}
	
	switch($columns)
	{
	    case 2:
	    default:
	    	$element_class = 'element '.$type.' classic2_cols';
	    	$columns_class = 'one_half gallery2 static filterable portfolio_type';
	    	$header_tag = 'h5';
	    break;
	    
	    case 3:
	    	$element_class = 'element '.$type.' classic3_cols '.$photoframe;
	    	$columns_class = 'one_third gallery3 static filterable portfolio_type';
	    	$header_tag = 'h6';
	    break;
	    
	    case 4:
	    	$element_class = 'element '.$type.' classic4_cols';
	    	$columns_class = 'one_fourth gallery4 static filterable portfolio_type';
	    	$header_tag = 'h7';
	    break;
	    
	    case 5:
	    	$element_class = 'element '.$type.' classic5_cols';
	    	$columns_class = 'one_fifth gallery5 static filterable portfolio_type';
	    	$header_tag = 'h7';
	    break;
	}
	
	$start = 0;
	if(isset($_POST['start']))
	{
	    $start = $_POST['start'];
	}
	
	$items = 0;
	if(isset($_POST['items']))
	{
	    $items = $_POST['items'];
	}
	
	if(is_null($_POST['start']) && is_null($_POST['items']))
	{
		$items = -1;
	}
	
	//Get all portfolio items for paging
	$wp_query = grandphotography_get_wp_query();
	
	$query_string = '&orderby=menu_order&order=ASC&post_type=portfolios&posts_per_page='.$items.'&suppress_filters=0&post_status=publish&offset='.$start;
	
	if(!empty($portfolio_set))
	{
		$query_string .= '&portfoliosets='.$portfolio_set;
	}
	
	parse_str($query_string, $args);
	
	if(THEMEDEMO)
	{
		$args['tax_query'] = array(
		    array(
		        'taxonomy' => 'portfoliosets',
		        'terms' => array(DEMOPORTFOLIOSETID),
		        'field' => 'slug',
		        'operator' => 'NOT IN',
		    ),
		);
	}
	
	query_posts($args);
	$current_photo_count = $wp_query->post_count;
	$all_photo_count = $wp_query->found_posts;
	
	$key = 0;
	if (have_posts()) : while (have_posts()) : the_post();
	    $key++;
	    $image_url = '';
	    $portfolio_ID = get_the_ID();
	    		
	    if(has_post_thumbnail($portfolio_ID, 'original'))
	    {
	        $image_id = get_post_thumbnail_id($portfolio_ID);
	        $image_url = wp_get_attachment_image_src($image_id, 'original', true);
	        
	        $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
	    }
	    
	    $portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
	    
	    if(empty($portfolio_link_url))
	    {
	        $permalink_url = get_permalink($portfolio_ID);
	    }
	    else
	    {
	        $permalink_url = $portfolio_link_url;
	    }
	    
	    //Get portfolio category
	    $portfolio_item_set = '';
	    $portfolio_item_sets = wp_get_object_terms($portfolio_ID, 'portfoliosets');
	    
	    if(is_array($portfolio_item_sets))
	    {
	        foreach($portfolio_item_sets as $set)
	        {
	        	$portfolio_item_set.= $set->slug.' ';
	        }
	    }
?>
<div class="<?php echo esc_attr($element_class); ?> <?php if(!empty($photoframe)) { ?>photoframe slideUp animated<?php echo esc_attr($key+1); ?> <?php } ?>">
			
    <div class="<?php echo esc_attr($columns_class); ?> <?php if(empty($photoframe)) { ?>slideUp animated<?php echo esc_attr($key+1); ?> <?php } ?>" data-id="post-<?php echo esc_attr($portfolio_ID); ?>">
    
    	<?php 
			if(!empty($image_url[0]))
			{
		?>		
				<?php
					$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
					$portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
					
					switch($portfolio_type)
					{
					case 'External Link':
						$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
				?>
				<a target="_blank" href="<?php echo esc_url($portfolio_link_url); ?>">
					<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"/>
					
					<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
					
					<?php if(empty($photoframe)) { ?>
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
	    					<div class="image_caption">
						        <<?php echo esc_html($header_tag); ?>><?php echo get_the_title(); ?></<?php echo esc_html($header_tag); ?>>
	    					</div>
				        </div>
				    <?php } ?>
	            </a>
				
				<?php
					break;
					//end external link
					
					case 'Portfolio Content':
    				default:
    			?>
    			<a href="<?php echo esc_url(get_permalink($portfolio_ID)); ?>">
    				<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
    				
    				<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
    				
    				<?php if(empty($photoframe)) { ?>
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
	    					<div class="image_caption">
						        <<?php echo esc_html($header_tag); ?>><?php echo get_the_title(); ?></<?php echo esc_html($header_tag); ?>>
	    					</div>
				        </div>
				    <?php } ?>
	            </a>
                
                <?php
					break;
					//portfolio content
    				
    				case 'Image':
				?>
				<a data-caption="<?php echo esc_attr(get_the_title()); ?>" href="<?php echo esc_url($image_url[0]); ?>" class="fancy-gallery">
					<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
					
					<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
					
					<?php if(empty($photoframe)) { ?>
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
	    					<div class="image_caption">
						        <<?php echo esc_html($header_tag); ?>><?php echo get_the_title(); ?></<?php echo esc_html($header_tag); ?>>
	    					</div>
				        </div>
				    <?php } ?>
                </a>
				
				<?php
					break;
					//end image
					
					case 'Youtube Video':
				?>
				
				<a href="https://www.youtube.com/embed/<?php echo esc_attr($portfolio_video_id); ?>" class="lightbox_youtube" data-options="width:1425, height:802">
					<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
					
					<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
					
					<?php if(empty($photoframe)) { ?>
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
	    					<div class="image_caption">
						        <<?php echo esc_html($header_tag); ?>><?php echo get_the_title(); ?></<?php echo esc_html($header_tag); ?>>
	    					</div>
				        </div>
				    <?php } ?>
	            </a>
				
				<?php
					break;
					//end youtube
				
				case 'Vimeo Video':
				?>
				<a href="https://player.vimeo.com/video/<?php echo esc_attr($portfolio_video_id); ?>?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802">
					<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
					
					<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
					
					<?php if(empty($photoframe)) { ?>
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
	    					<div class="image_caption">
						        <<?php echo esc_html($header_tag); ?>><?php echo get_the_title(); ?></<?php echo esc_html($header_tag); ?>>
	    					</div>
				        </div>
				    <?php } ?>
	            </a>
				
				<?php
					break;
					//end vimeo
					
				case 'Self-Hosted Video':
				
					//Get video URL
					$portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
					$preview_image = wp_get_attachment_image_src($image_id, 'large', true);
				?>
				<a href="<?php echo esc_url($portfolio_mp4_url); ?>" class="lightbox_vimeo">
					<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
					
					<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
					
					<?php if(empty($photoframe)) { ?>
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
	    					<div class="image_caption">
						        <<?php echo esc_html($header_tag); ?>><?php echo get_the_title(); ?></<?php echo esc_html($header_tag); ?>>
	    					</div>
				        </div>
				    <?php } ?>
	            </a>
				
				<?php
					break;
					//end self-hosted
				?>
				
				<?php
					}
					//end switch
				?>
				
				<?php if(!empty($photoframe)) { ?>
					<div class="gallery_info_wrapper">
        			    <<?php echo esc_html($header_tag); ?>><?php echo get_the_title(); ?></<?php echo esc_html($header_tag); ?>>
				    </div>
				<?php } ?>
		<?php
			}		
		?>
    
    </div>
    
</div>
<?php
	endwhile; endif;
	die();
}

add_action('wp_ajax_grandphotography_script_horizontal_portfolio_filterable_click', 'grandphotography_script_horizontal_portfolio_filterable_click');
add_action('wp_ajax_nopriv_grandphotography_script_horizontal_portfolio_filterable_click', 'grandphotography_script_horizontal_portfolio_filterable_click');

function grandphotography_script_horizontal_portfolio_filterable_click() {

	$id = 'horizontal_gallery_wrapper';
	if(isset($_GET['id']))
	{
		$id = $_GET['id'];
	}
	
	$loading_id = 'infinite_loading';
	if(isset($_GET['loading_id']))
	{
		$loading_id = $_GET['loading_id'];
	}
	
	$type = 'horizontal';
	if(isset($_GET['type']))
	{
		$type = $_GET['type'];
	}

	if(!empty($id))
	{	
		header("content-type: application/x-javascript");
		
		$function_action = 'grandphotography_script_horizontal_portfolio_pagination_load';
?>
jQuery(window).load(function(){ 

if(jQuery('#tg_portfolio_filterable_link').val()!=1)
{
jQuery('#portfolio_wall_filters li a').click(function(){
	jQuery('#portfolio_wall_filters li a').removeClass('active');
    jQuery(this).addClass('active');
    jQuery('#<?php echo esc_js($id); ?> tbody tr').remove();
    
    var selectedSet = jQuery(this).attr('data-filter');
    
    jQuery('#<?php echo esc_js($loading_id); ?>').addClass('visible');

    jQuery.ajax({
	    url:"<?php echo admin_url('admin-ajax.php'); ?>",
	    type:'POST',
		data:'action=<?php echo esc_js($function_action); ?>&type=<?php echo esc_js($type); ?>&portfolio_set='+selectedSet,
		success:function(results) {
	    	if(results != '')
	    	{
	    		jQuery('#<?php echo esc_js($loading_id); ?>').removeClass('visible');
				jQuery('#<?php echo esc_js($id); ?>').html(results);
	    		jQuery(document).setiLightbox();
	    		
	    		jQuery('#<?php echo esc_js($id); ?> tbody tr td .gallery_image_wrapper').children('.horizontal_gallery_img').each(function(index, value)
				{
				   	var calScreenWidth = jQuery(window).width();
				   	var calScreenHeight = parseInt(jQuery(window).height()*0.75);
				   	
				   	jQuery(this).css('height', calScreenHeight+'px');
				    jQuery(this).parent().addClass('visible');
				});
	    		
	    		var scrollToPos = parseInt(jQuery('#<?php echo esc_js($id); ?>').offset().top);
    
			    jQuery('body,html').animate({
					scrollTop: scrollToPos
				}, 300);
	    	}
	    }
	});
});
}
<?php
	}
?>
});
<?php
	die();
}

add_action('wp_ajax_grandphotography_script_horizontal_portfolio_pagination_load', 'grandphotography_script_horizontal_portfolio_pagination_load');
add_action('wp_ajax_nopriv_grandphotography_script_horizontal_portfolio_pagination_load', 'grandphotography_script_horizontal_portfolio_pagination_load');

function grandphotography_script_horizontal_portfolio_pagination_load() {
	$portfolio_set = '';
	if(isset($_POST['portfolio_set']))
	{
		$portfolio_set = $_POST['portfolio_set'];
	}
	
	$image_size = 'large';
	if(isset($_POST['type']) && $_POST['type'] == 'striped')
	{
		$image_size = 'grandphotography-gallery-striped';
	}
	
	//Get all portfolio items for paging
	$wp_query = grandphotography_get_wp_query();
	
	$query_string = '&orderby=menu_order&order=ASC&post_type=portfolios&posts_per_page=-1&suppress_filters=0&post_status=publish';
	
	if(!empty($portfolio_set))
	{
		$query_string .= '&portfoliosets='.$portfolio_set;
	}
	
	parse_str($query_string, $args);
	
	if(THEMEDEMO)
	{
		$args['tax_query'] = array(
		    array(
		        'taxonomy' => 'portfoliosets',
		        'terms' => array(DEMOPORTFOLIOSETID),
		        'field' => 'slug',
		        'operator' => 'NOT IN',
		    ),
		);
	}
	
	query_posts($args);
	$current_photo_count = $wp_query->post_count;
	$all_photo_count = $wp_query->found_posts;
?>
<tbody><tr>
<?php
	$key = 0;
	if (have_posts()) : while (have_posts()) : the_post();
	    $key++;
	    $image_url = '';
	    $portfolio_ID = get_the_ID();
	    		
	    if(has_post_thumbnail($portfolio_ID, $image_size))
	    {
	        $image_id = get_post_thumbnail_id($portfolio_ID);
	        $image_url = wp_get_attachment_image_src($image_id, $image_size, true);
	    }
	    
	    $portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
	    
	    if(empty($portfolio_link_url))
	    {
	        $permalink_url = get_permalink($portfolio_ID);
	    }
	    else
	    {
	        $permalink_url = $portfolio_link_url;
	    }

		if(!empty($image_url[0]))
		    {
		    	$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
				$portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
				
				switch($portfolio_type)
			    {
				    case 'External Link':
				    	$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
	?>	
	<td>
		<a href="<?php echo esc_url($portfolio_link_url); ?>">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php
					break;
				    
				    case 'Portfolio Content':
				    default:
	?>
	<td>
		<a href="<?php echo esc_url(get_permalink($portfolio_ID)); ?>">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php 
				    break;
				    
				    case 'Image':
	?>
	<td>
		<a data-caption="<?php echo esc_attr(get_the_title()); ?>" href="<?php echo esc_url($image_url[0]); ?>" class="fancy-gallery">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php
				    break;
				    
				    case 'Youtube Video':
	?>
	<td>
		<a href="https://www.youtube.com/embed/<?php echo esc_attr($portfolio_video_id); ?>" class="lightbox_youtube" data-options="width:1425, height:802">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php			    
				    break;
				    
				    case 'Vimeo Video':
	?>
	<td>
		<a href="https://player.vimeo.com/video/<?php echo esc_attr($portfolio_video_id); ?>?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
	<?php
				    break;
				    
				    case 'Self-Hosted Video':
				    
				    //Get video URL
					$portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
					$preview_image = wp_get_attachment_image_src($image_id, 'large', true);
	?>
	<td>
		<a href="<?php echo esc_url($portfolio_mp4_url); ?>" class="lightbox_vimeo">
	    	<div class="gallery_image_wrapper">
			    <img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" class="horizontal_gallery_img"/>
			
				<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
				
				<div class="image_caption_wrapper">
				   <div class="image_caption">
				       <h6><?php echo get_the_title(); ?></h6>
				   </div>
				</div>
			</div>
		</a>
	</td>
<?php				
					break;
				}
		    }

	endwhile; endif;
?>
</tr></tbody>
<?php
	die();
}

add_action('wp_ajax_grandphotography_script_metro_portfolio_pagination_load', 'grandphotography_script_metro_portfolio_pagination_load');
add_action('wp_ajax_nopriv_grandphotography_script_metro_portfolio_pagination_load', 'grandphotography_script_metro_portfolio_pagination_load');

function grandphotography_script_metro_portfolio_pagination_load() {
	$start = 0;
	if(isset($_POST['start']))
	{
	    $start = $_POST['start'];
	}
	
	$items = 0;
	if(isset($_POST['items']))
	{
	    $items = $_POST['items'];
	}
	
	if(is_null($_POST['start']) && is_null($_POST['items']))
	{
		$items = -1;
		$start = 0;
	}
	
	$portfolio_set = '';
	if(isset($_POST['portfolio_set']))
	{
		$portfolio_set = $_POST['portfolio_set'];
	}
	
	//Get all portfolio items for paging
	$wp_query = grandphotography_get_wp_query();
	
	$query_string = '&orderby=menu_order&order=ASC&post_type=portfolios&posts_per_page='.$items.'&suppress_filters=0&post_status=publish&offset='.$start;
	
	if(!empty($portfolio_set))
	{
		$query_string .= '&portfoliosets='.$portfolio_set;
	}
	
	parse_str($query_string, $args);
	
	if(THEMEDEMO)
	{
		$args['tax_query'] = array(
		    array(
		        'taxonomy' => 'portfoliosets',
		        'terms' => array(DEMOPORTFOLIOSETID),
		        'field' => 'slug',
		        'operator' => 'NOT IN',
		    ),
		);
	}

	query_posts($args);
	$current_photo_count = $wp_query->post_count;
	$all_photo_count = $wp_query->found_posts;
	
	$large_counter = 1;
	if(isset($_POST['largecounter']))
	{
	    $large_counter = $_POST['largecounter'];
	}
	
	$next_number_to_add = 4;
	if(isset($_POST['nextnumbertoadd']))
	{
	    $next_number_to_add = $_POST['nextnumbertoadd'];
	}
	
	$next_trigger = 1;
	if(isset($_POST['nexttrigger']))
	{
	    $next_trigger = $_POST['nexttrigger'];
	}
	
	$key = $start;
	$counter = 0;
	
	if (have_posts()) : while (have_posts()) : the_post();
	    $small_image_url = '';
	    $image_url = '';
	    $portfolio_ID = get_the_ID();
	    
	    //Calculated columns size
	    $element_class = 'element '.$type.' classic3_cols';
	    $columns_class = 'one_third gallery3 static filterable gallery_type';
	    $grandphotography_image_size = 'grandphotography-gallery-grid';
	    
	    $large_counter_trigger = FALSE;
	    
	    if($next_trigger == $key+1)
	    {
	    	$large_counter_trigger = TRUE;
	    	$next_trigger = $next_trigger+$next_number_to_add;
	    	
	    	if($next_number_to_add == 4)
	    	{
	    		$next_number_to_add = 2;
	    	}
	    	else if($next_number_to_add==2)
	    	{
	    		$next_number_to_add = 4;
	    	}
	    }
	    
	    if($large_counter_trigger)
	    {
	    	$columns_class = 'one_third gallery3 static filterable gallery_type double_size';
	    	$element_class = 'element '.$type.' classic3_cols double_size';
	    	
	    	$grandphotography_image_size = 'grandphotography-gallery-grid-large';
	    }
	    
	    $large_counter++;
	    $key++;
	    $counter++;
	    		
	    if(has_post_thumbnail($portfolio_ID, 'large'))
	    {
	        $image_id = get_post_thumbnail_id($portfolio_ID);
	        $image_url = wp_get_attachment_image_src($image_id, 'large', true);
	        
	        $small_image_url = wp_get_attachment_image_src($image_id, $grandphotography_image_size, true);
	    }
	    
	    $portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
	    
	    if(empty($portfolio_link_url))
	    {
	        $permalink_url = get_permalink($portfolio_ID);
	    }
	    else
	    {
	        $permalink_url = $portfolio_link_url;
	    }
	    
	    //Get portfolio category
	    $portfolio_item_set = '';
	    $portfolio_item_sets = wp_get_object_terms($portfolio_ID, 'portfoliosets');
	    
	    if(is_array($portfolio_item_sets))
	    {
	        foreach($portfolio_item_sets as $set)
	        {
	        	$portfolio_item_set.= $set->slug.' ';
	        }
	    }
?>
<div class="<?php echo esc_attr($element_class); ?> <?php echo esc_attr($portfolio_item_set); ?>" data-type="<?php echo esc_attr($portfolio_item_set); ?>">
			
    <div class="<?php echo esc_attr($columns_class); ?> slideUp animated<?php echo esc_attr($counter+1); ?> portfolio_type" data-id="post-<?php echo esc_attr($photo_id); ?>">
    <?php 
        if(isset($image_url[0]) && !empty($image_url[0]))
    	{
    ?>		
        <?php
		    $portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
		    $portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
		    
		    switch($portfolio_type)
		    {
		    case 'External Link':
		    	$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
		?>
		<a target="_blank" href="<?php echo esc_url($portfolio_link_url); ?>">
		    <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"/>
		    
		    <div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
		    
		    <div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
            	<div class="image_caption">
		            <h5><?php echo get_the_title(); ?></h5>
            	</div>
		    </div>
		</a>
		
		<?php
		    break;
		    //end external link
		    
		    case 'Portfolio Content':
            default:
        ?>
        <a href="<?php echo esc_url(get_permalink($portfolio_ID)); ?>">
            <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
            
            <div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
            
            <div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
            	<div class="image_caption">
		            <h5><?php echo get_the_title(); ?></h5>
            	</div>
		    </div>
		</a>
	    
	    <?php
		    break;
		    //portfolio content
            
            case 'Image':
		?>
		<a data-caption="<?php echo esc_attr(get_the_title()); ?>" href="<?php echo esc_url($image_url[0]); ?>" class="fancy-gallery">
		    <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
		    
		    <div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
		    
		    <div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
            	<div class="image_caption">
		            <h5><?php echo get_the_title(); ?></h5>
            	</div>
		    </div>
	    </a>
		
		<?php
		    break;
		    //end image
		    
		    case 'Youtube Video':
		?>
		
		<a href="https://www.youtube.com/embed/<?php echo esc_attr($portfolio_video_id); ?>" class="lightbox_youtube" data-options="width:1425, height:802">
		    <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
		    
		    <div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
		    
		    <div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
            	<div class="image_caption">
		            <h5><?php echo get_the_title(); ?></h5>
            	</div>
		    </div>
		</a>
		
		<?php
		    break;
		    //end youtube
		
		case 'Vimeo Video':
		?>
		<a href="https://player.vimeo.com/video/<?php echo esc_attr($portfolio_video_id); ?>?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802">
		    <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
		    
		    <div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
		    
		    <div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
            	<div class="image_caption">
		            <h5><?php echo get_the_title(); ?></h5>
            	</div>
		    </div>
		</a>
		
		<?php
		    break;
		    //end vimeo
		    
		case 'Self-Hosted Video':
		
		    //Get video URL
		    $portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
		    $preview_image = wp_get_attachment_image_src($image_id, 'large', true);
		?>
		<a href="<?php echo esc_url($portfolio_mp4_url); ?>" class="lightbox_vimeo">
		    <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
		    
		    <div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
		    
		    <div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
            	<div class="image_caption">
		            <h5><?php echo get_the_title(); ?></h5>
            	</div>
		    </div>
		</a>
		
		<?php
		    break;
		    //end self-hosted
		?>
		
		<?php
		    }
		    //end switch
		?>
    <?php
        }		
    ?>
    </div>
</div>
<?php
	endwhile; endif;
?>
<script>
jQuery(window).load(function(){ 
	jQuery('#infinite_load_more').attr('data-largecounter', <?php echo esc_js($large_counter); ?>);
	jQuery('#infinite_load_more').attr('data-nextnumbertoadd', <?php echo esc_js($next_number_to_add); ?>);
	jQuery('#infinite_load_more').attr('data-nexttrigger', <?php echo esc_js($next_trigger); ?>);
});
</script>
<?php
	
	die();
}

add_action('wp_ajax_kirki_dynamic_css', 'kirki_dynamic_css');
add_action('wp_ajax_nopriv_kirki_dynamic_css', 'kirki_dynamic_css');

function kirki_dynamic_css() {
	$kirki = grandphotography_get_kirki();

	die();
}

/**
*	End custom script function
**/


if(THEMEDEMO)
{
	function grandphotography_add_my_query_var( $link ) 
	{
		$arr_params = array();
	    
	    if(isset($_GET['topbar'])) 
		{
			$arr_params['topbar'] = $_GET['topbar'];
		}
		
		if(isset($_GET['menu'])) 
		{
			$arr_params['menu'] = $_GET['menu'];
		}
		
		if(isset($_GET['frame'])) 
		{
			$arr_params['frame'] = $_GET['frame'];
		}
		
		if(isset($_GET['frame_color'])) 
		{
			$arr_params['frame_color'] = $_GET['frame_color'];
		}
		
		if(isset($_GET['boxed'])) 
		{
			$arr_params['boxed'] = $_GET['boxed'];
		}
		
		if(isset($_GET['footer'])) 
		{
			$arr_params['footer'] = $_GET['footer'];
		}
		
		if(isset($_GET['menulayout'])) 
		{
			$arr_params['menulayout'] = $_GET['menulayout'];
		}
		
		$link = add_query_arg( $arr_params, $link );
	    
	    return $link;
	}
	add_filter('category_link','grandphotography_add_my_query_var');
	add_filter('page_link','grandphotography_add_my_query_var');
	add_filter('post_link','grandphotography_add_my_query_var');
	add_filter('term_link','grandphotography_add_my_query_var');
	add_filter('tag_link','grandphotography_add_my_query_var');
	add_filter('category_link','grandphotography_add_my_query_var');
	add_filter('post_type_link','grandphotography_add_my_query_var');
	add_filter('attachment_link','grandphotography_add_my_query_var');
	add_filter('year_link','grandphotography_add_my_query_var');
	add_filter('month_link','grandphotography_add_my_query_var');
	add_filter('day_link','grandphotography_add_my_query_var');
	add_filter('search_link','grandphotography_add_my_query_var');
	add_filter('previous_post_link','grandphotography_add_my_query_var');
	add_filter('next_post_link','grandphotography_add_my_query_var');
}


//Setup custom settings when theme is activated
if (isset($_GET['activated']) && $_GET['activated']){
	//Add default contact fields
	$pp_contact_form = get_option('pp_contact_form');
	if(empty($pp_contact_form))
	{
		add_option( 'pp_contact_form', 's:1:"3";' );
	}
	
	$pp_contact_form_sort_data = get_option('pp_contact_form_sort_data');
	if(empty($pp_contact_form_sort_data))
	{
		add_option( 'pp_contact_form_sort_data', 'a:3:{i:0;s:1:"1";i:1;s:1:"2";i:2;s:1:"3";}' );
	}

	wp_redirect(admin_url("admin.php?page=functions.php&activate=true"));
}
?>