<?php
/**
 * The template for displaying the footer.
 *
 * @package WordPress
 */
 
?>

<?php
	//Check if blank template
	$grandphotography_is_no_header = grandphotography_get_is_no_header();
	$grandphotography_screen_class = grandphotography_get_screen_class();
	
	if(!is_bool($grandphotography_is_no_header) OR !$grandphotography_is_no_header)
	{

	$grandphotography_homepage_style = grandphotography_get_homepage_style();
	
	$tg_footer_sidebar = kirki_get_option('tg_footer_sidebar');
?>

<?php
    if(!empty($tg_footer_sidebar) && $grandphotography_homepage_style != 'fullscreen' && $grandphotography_homepage_style != 'fullscreen_white' && $grandphotography_homepage_style != 'split' && $grandphotography_homepage_style != 'fullscreen_video')
    {
    	$footer_class = '';
    	
    	switch($tg_footer_sidebar)
    	{
    		case 1:
    			$footer_class = 'one';
    		break;
    		case 2:
    			$footer_class = 'two';
    		break;
    		case 3:
    			$footer_class = 'three';
    		break;
    		case 4:
    			$footer_class = 'four';
    		break;
    		default:
    			$footer_class = 'four';
    		break;
    	}
?>
<div id="footer" class="<?php if(isset($grandphotography_homepage_style) && !empty($grandphotography_homepage_style)) { echo esc_attr($grandphotography_homepage_style); } ?> <?php if(!empty($grandphotography_screen_class)) { echo esc_attr($grandphotography_screen_class); } ?>">
<ul class="sidebar_widget <?php echo esc_attr($footer_class); ?>">
    <?php dynamic_sidebar('Footer Sidebar'); ?>
</ul>
</div>
<?php
    }
?>

<?php	
	//If display photostream
	$pp_photostream = get_option('pp_photostream');
	if(THEMEDEMO && isset($_GET['footer']) && !empty($_GET['footer']))
	{
		$pp_photostream = 0;
	}

	if(!empty($pp_photostream) && $grandphotography_homepage_style != 'fullscreen' && $grandphotography_homepage_style != 'fullscreen_white' && $grandphotography_homepage_style != 'split' && $grandphotography_homepage_style != 'fullscreen_video')
	{
		$photos_arr = array();
	
		if($pp_photostream == 'flickr')
		{
			$pp_flickr_id = get_option('pp_flickr_id');
			$photos_arr = grandphotography_get_flickr(array('type' => 'user', 'id' => $pp_flickr_id, 'items' => 12));
		}
		else
		{
			$pp_instagram_username = get_option('pp_instagram_username');
			$is_instagram_authorized = grandphotography_check_instagram_authorization();
			
			if(is_bool($is_instagram_authorized) && $is_instagram_authorized)
			{
				$photos_arr = grandphotography_get_instagram_using_plugin('photostream', 12);
			}
			else
			{
				echo $is_instagram_authorized;
			}
		}
		
		if(!empty($photos_arr) && $grandphotography_screen_class != 'split' && $grandphotography_screen_class != 'split wide' && $grandphotography_homepage_style != 'fullscreen' && $grandphotography_homepage_style != 'flow')
		{
			wp_enqueue_script("modernizr", get_template_directory_uri()."/js/modernizr.js", false, THEMEVERSION, true);
			wp_enqueue_script("gridrotator", get_template_directory_uri()."/js/jquery.gridrotator.js", false, THEMEVERSION, true);
			wp_enqueue_script("grandphotography-script-footer-gridrotator", admin_url('admin-ajax.php')."?action=grandphotography_script_gridrotator&grid=footer_photostream&amp;rows=1", false, THEMEVERSION, true);
?>
<br class="clear"/>
<div id="footer_photostream" class="footer_photostream_wrapper ri-grid ri-grid-size-3">
	<ul>
		<?php
			foreach($photos_arr as $photo)
			{
		?>
			<li><a target="_blank" href="<?php echo esc_url($photo['link']); ?>"><img src="<?php echo esc_url($photo['thumb_url']); ?>" alt="" /></a></li>
		<?php
			}
		?>
	</ul>
</div>
<?php
		}
	}
?>

<?php
if($grandphotography_homepage_style != 'fullscreen' && $grandphotography_homepage_style != 'fullscreen_white' && $grandphotography_homepage_style != 'split')
{
	//Get Footer Sidebar
	$tg_footer_sidebar = kirki_get_option('tg_footer_sidebar');
	if(THEMEDEMO && isset($_GET['footer']) && !empty($_GET['footer']))
	{
	    $tg_footer_sidebar = 0;
	}
?>
<div class="footer_bar <?php if(isset($grandphotography_homepage_style) && !empty($grandphotography_homepage_style)) { echo esc_attr($grandphotography_homepage_style); } ?> <?php if(!empty($grandphotography_screen_class)) { echo esc_attr($grandphotography_screen_class); } ?> <?php if(empty($tg_footer_sidebar)) { ?>noborder<?php } ?>">

	<div class="footer_bar_wrapper <?php if(isset($grandphotography_homepage_style) && !empty($grandphotography_homepage_style)) { echo esc_attr($grandphotography_homepage_style); } ?>">
		<?php
			//Check if display social icons or footer menu
			$tg_footer_copyright_right_area = kirki_get_option('tg_footer_copyright_right_area');
			
			if($tg_footer_copyright_right_area=='social')
			{
				if($grandphotography_homepage_style!='flow' && $grandphotography_homepage_style!='fullscreen' && $grandphotography_homepage_style!='carousel' && $grandphotography_homepage_style!='flip' && $grandphotography_homepage_style!='fullscreen_video')
				{	
					//Check if open link in new window
					$tg_footer_social_link = kirki_get_option('tg_footer_social_link');
			?>
			<div class="social_wrapper">
			    <ul>
			    	<?php
			    		$pp_facebook_url = get_option('pp_facebook_url');
			    		
			    		if(!empty($pp_facebook_url))
			    		{
			    	?>
			    	<li class="facebook"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> href="<?php echo esc_url($pp_facebook_url); ?>"><i class="fa fa-facebook-official"></i></a></li>
			    	<?php
			    		}
			    	?>
			    	<?php
			    		$pp_twitter_username = get_option('pp_twitter_username');
			    		
			    		if(!empty($pp_twitter_username))
			    		{
			    	?>
			    	<li class="twitter"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> href="http://twitter.com/<?php echo esc_attr($pp_twitter_username); ?>"><i class="fa fa-twitter"></i></a></li>
			    	<?php
			    		}
			    	?>
			    	<?php
			    		$pp_flickr_username = get_option('pp_flickr_username');
			    		
			    		if(!empty($pp_flickr_username))
			    		{
			    	?>
			    	<li class="flickr"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Flickr" href="http://flickr.com/people/<?php echo esc_attr($pp_flickr_username); ?>"><i class="fa fa-flickr"></i></a></li>
			    	<?php
			    		}
			    	?>
			    	<?php
			    		$pp_youtube_url = get_option('pp_youtube_url');
			    		
			    		if(!empty($pp_youtube_url))
			    		{
			    	?>
			    	<li class="youtube"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Youtube" href="<?php echo esc_url($pp_youtube_url); ?>"><i class="fa fa-youtube"></i></a></li>
			    	<?php
			    		}
			    	?>
			    	<?php
			    		$pp_vimeo_username = get_option('pp_vimeo_username');
			    		
			    		if(!empty($pp_vimeo_username))
			    		{
			    	?>
			    	<li class="vimeo"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Vimeo" href="http://vimeo.com/<?php echo esc_attr($pp_vimeo_username); ?>"><i class="fa fa-vimeo-square"></i></a></li>
			    	<?php
			    		}
			    	?>
			    	<?php
			    		$pp_tumblr_username = get_option('pp_tumblr_username');
			    		
			    		if(!empty($pp_tumblr_username))
			    		{
			    	?>
			    	<li class="tumblr"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Tumblr" href="http://<?php echo esc_attr($pp_tumblr_username); ?>.tumblr.com"><i class="fa fa-tumblr"></i></a></li>
			    	<?php
			    		}
			    	?>
			    	<?php
			    		$pp_dribbble_username = get_option('pp_dribbble_username');
			    		
			    		if(!empty($pp_dribbble_username))
			    		{
			    	?>
			    	<li class="dribbble"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Dribbble" href="http://dribbble.com/<?php echo esc_attr($pp_dribbble_username); ?>"><i class="fa fa-dribbble"></i></a></li>
			    	<?php
			    		}
			    	?>
			    	<?php
			    		$pp_linkedin_url = get_option('pp_linkedin_url');
			    		
			    		if(!empty($pp_linkedin_url))
			    		{
			    	?>
			    	<li class="linkedin"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Linkedin" href="<?php echo esc_url($pp_linkedin_url); ?>"><i class="fa fa-linkedin"></i></a></li>
			    	<?php
			    		}
			    	?>
			    	<?php
			            $pp_pinterest_username = get_option('pp_pinterest_username');
			            
			            if(!empty($pp_pinterest_username))
			            {
			        ?>
			        <li class="pinterest"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Pinterest" href="http://pinterest.com/<?php echo esc_attr($pp_pinterest_username); ?>"><i class="fa fa-pinterest"></i></a></li>
			        <?php
			            }
			        ?>
			        <?php
			        	$pp_instagram_username = get_option('pp_instagram_username');
			        	
			        	if(!empty($pp_instagram_username))
			        	{
			        ?>
			        <li class="instagram"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Instagram" href="http://instagram.com/<?php echo esc_attr($pp_instagram_username); ?>"><i class="fa fa-instagram"></i></a></li>
			        <?php
			        	}
			        ?>
			        <?php
			        	$pp_behance_username = get_option('pp_behance_username');
			        	
			        	if(!empty($pp_behance_username))
			        	{
			        ?>
			        <li class="behance"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="Behance" href="http://behance.net/<?php echo esc_attr($pp_behance_username); ?>"><i class="fa fa-behance-square"></i></a></li>
			        <?php
			        	}
			        ?>
			        <?php
					    $pp_500px_url = get_option('pp_500px_url');
					    
					    if(!empty($pp_500px_url))
					    {
					?>
					<li class="500px"><a <?php if(!empty($tg_footer_social_link)) { ?>target="_blank"<?php } ?> title="500px" href="<?php echo esc_url($pp_500px_url); ?>"><i class="fa fa-500px"></i></a></li>
					<?php
					    }
					?>
			    </ul>
			</div>
		<?php
				}
			} //End if display social icons
			else
			{
				if ( has_nav_menu( 'footer-menu' ) ) 
			    {
				    wp_nav_menu( 
				        	array( 
				        		'menu_id'			=> 'footer_menu',
				        		'menu_class'		=> 'footer_nav',
				        		'theme_location' 	=> 'footer-menu',
				        	) 
				    ); 
				}
			}
		?>
	    <?php
	    	//Display copyright text
	        $tg_footer_copyright_text = kirki_get_option('tg_footer_copyright_text');

	        if(!empty($tg_footer_copyright_text))
	        {
	        	echo '<div id="copyright">'.wp_kses_post(htmlspecialchars_decode($tg_footer_copyright_text)).'</div><br class="clear"/>';
	        }
	    ?>
	    
	    <?php
	    	//Check if display to top button
	    	$tg_footer_copyright_totop = kirki_get_option('tg_footer_copyright_totop');
	    	
	    	if(!empty($tg_footer_copyright_totop))
	    	{
	    ?>
	    	<a id="toTop" href="javascript:;"><i class="fa fa-angle-up"></i></a>
	    <?php
	    	}
	    ?>
	</div>
</div>
<?php
}
?>
</div>

<?php
    } //End if not blank template
?>

<div id="overlay_background">
	<?php
		$grandphotography_page_gallery_id = grandphotography_get_page_gallery_id();
		
		//Check if display sharing buttons
		$tg_global_sharing = kirki_get_option('tg_global_sharing');
		
		if(is_single() OR !empty($grandphotography_page_gallery_id) OR !empty($tg_global_sharing))
		{
	?>
	<div id="fullscreen_share_wrapper">
		<div class="fullscreen_share_content">
	<?php
			get_template_part("/templates/template-share");
	?>
		</div>
	</div>
	<?php
		}
	?>
</div>

<?php
    //Check if theme demo then enable layout switcher
    if(THEMEDEMO)
    {
?>
    <div id="option_wrapper">
    <div class="inner">
    	<div style="text-align:center">
    	<h6>PREDEFINED STYLING</h6><br/>
    	<p>
    	<?php echo esc_html(THEMENAME); ?> is photography focused theme built for creative & photographers folks allow you to easily create your own style of creative photography site. Here are example styling that can be imported with one click.</p>
    	<?php
    		$customizer_styling_arr = array( 
				array(
					'id'	=>	'styling1', 
					'title' => 'Center Logo With 2 Menus', 
					'url' => site_url()
				),
				array(
					'id'	=>	'styling2', 
					'title' => 'Left Align Menu', 
					'url' => site_url('/?menulayout=leftalign')
				),
				array(
					'id'	=>	'styling3', 
					'title' => 'Center Align Menu', 
					'url' => site_url('/?menulayout=centeralignmenu')
				),
				array(
					'id'	=>	'styling4', 
					'title' => 'Fullscreen Menu', 
					'url' => site_url('/?menulayout=hammenufull')
				),
				array(
					'id'	=>	'styling5', 
					'title' => 'Left Vertical Menu', 
					'url' => site_url('/?menulayout=leftmenu')
				),
				array(
					'id'	=>	'styling6', 
					'title' => 'Side Menu', 
					'url' => site_url('/?menulayout=hammenuside')
				),
				array(
					'id'	=>	'styling7', 
					'title' => 'Frame', 
					'url' => site_url('/?frame=1')
				),
				array(
					'id'	=>	'styling8', 
					'title' => 'Boxed', 
					'url' => site_url('/?boxed=1')
				),
			);
    	?>
    	<ul class="demo_list">
    		<?php
    			foreach($customizer_styling_arr as $customizer_styling)
    			{
    		?>
    		<li>
        		<img src="<?php echo get_template_directory_uri(); ?>/cache/demos/customizer/screenshots/<?php echo esc_html($customizer_styling['id']); ?>.jpg" alt=""/>
        		<div class="demo_thumb_hover_wrapper">
        		    <div class="demo_thumb_hover_inner">
        		    	<div class="demo_thumb_desc">
    	    	    		<h6><?php echo esc_html($customizer_styling['title']); ?></h6>
    	    	    		<a href="<?php echo esc_url($customizer_styling['url']); ?>" target="_blank" class="button white">Launch</a>
        		    	</div> 
        		    </div>	   
        		</div>		   
    		</li>
    		<?php
    			}
    		?>
    	</ul>
    	</div>
    </div>
    </div>
    <div id="option_btn">
    	<a href="javascript:;" class="demotip" title="Choose Theme Demo"><i class="fa fa-cog"></i></a>
    	<a href="http://themes.themegoods.com/grandphotography/doc" class="demotip" title="Theme Documentation" target="_blank"><i class="fa fa-book"></i></a>
    	<a href="https://1.envato.market/jk1Za" class="demotip" title="Purchase Theme" target="_blank"><i class="fa fa-shopping-basket"></i></a>
    </div>
<?php
    	wp_enqueue_script("cookie", get_template_directory_uri()."/js/jquery.cookie.js", false, THEMEVERSION, true);
    	wp_enqueue_script("grandphotography-script-demo", admin_url('admin-ajax.php')."?action=grandphotography_script_demo", false, THEMEVERSION, true);
    }
?>

<?php
    $tg_frame = kirki_get_option('tg_frame');
    if(THEMEDEMO && isset($_GET['frame']) && !empty($_GET['frame']))
    {
	    $tg_frame = 1;
    }
    
    if(!empty($tg_frame))
    {
    	wp_enqueue_style("tg_frame", get_template_directory_uri()."/css/tg_frame.css", false, THEMEVERSION, "all");
?>
    <div class="frame_top"></div>
    <div class="frame_bottom"></div>
    <div class="frame_left"></div>
    <div class="frame_right"></div>
<?php
    }
    if(THEMEDEMO && isset($_GET['frame_color']) && !empty($_GET['frame_color']))
    {
?>
<style>
.frame_top, .frame_bottom, .frame_left, .frame_right { background: <?php echo esc_html($_GET['frame_color']); ?> !important; }
</style>
<?php
	}
?>

<?php
	/* Always have wp_footer() just before the closing </body>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to reference JavaScript files.
	 */

	wp_footer();
?>
</body>
</html>
