<?php
/**
 * The main template file for display single post page.
 *
 * @package WordPress
*/

get_header();

$grandphotography_topbar = grandphotography_get_topbar();

/**
*	Get current page id
**/

$current_page_id = $post->ID;

//If display feat content
$tg_blog_feat_content = kirki_get_option('tg_blog_feat_content');

/**
*	Get current page id
**/

$current_page_id = $post->ID;
$post_gallery_id = '';
if(!empty($tg_blog_feat_content))
{
	$post_gallery_id = get_post_meta($current_page_id, 'post_gallery_id', true);
}

//Include custom header feature
get_template_part("/templates/template-post-header");
?>
    
    <div class="inner">

    	<!-- Begin main content -->
    	<div class="inner_wrapper">

	    	<div class="sidebar_content full_width">
					
<?php
if (have_posts()) : while (have_posts()) : the_post();

	$image_thumb = '';
								
	if(!empty($tg_blog_feat_content) && has_post_thumbnail(get_the_ID(), 'large'))
	{
	    $image_id = get_post_thumbnail_id(get_the_ID());
	    $image_thumb = wp_get_attachment_image_src($image_id, 'large', true);
	}
?>
						
<!-- Begin each blog post -->
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="post_wrapper">
	    
	    <div class="post_content_wrapper">
	    
	    	<?php
	    	if(!empty($tg_blog_feat_content) )
	    	{
			    //Get post featured content
			    $post_ft_type = get_post_meta(get_the_ID(), 'post_ft_type', true);
			    
			    switch($post_ft_type)
			    {
			    	case 'Image':
			    	default:
			        	if(!empty($image_thumb))
			        	{
			        		$large_image_url = wp_get_attachment_image_src($image_id, 'original', true);
			        		
			        		$pp_menu_layout = get_option('pp_menu_layout');
			        		
			        		if($pp_menu_layout != 'leftmenu')
							{
								$small_image_url = wp_get_attachment_image_src($image_id, 'original', true);
							}
							else
							{
			        			$small_image_url = wp_get_attachment_image_src($image_id, 'large', true);
			        		}
			?>
			
			    	    <div class="post_img static">
			    	    	<a href="<?php echo esc_url($large_image_url[0]); ?>" class="img_frame">
			    	    		<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="" class="" style="width:<?php echo esc_attr($small_image_url[1]); ?>px;height:<?php echo esc_attr($small_image_url[2]); ?>px;"/>
				            </a>
			    	    </div>
			
			<?php
			    		}
			    	break;
			    	
			    	case 'Vimeo Video':
			    		$post_ft_vimeo = get_post_meta(get_the_ID(), 'post_ft_vimeo', true);
			?>
			    		<?php echo do_shortcode('[tg_vimeo video_id="'.$post_ft_vimeo.'" width="670" height="377"]'); ?>
			    		<br/>
			<?php
			    	break;
			    	
			    	case 'Youtube Video':
			    		$post_ft_youtube = get_post_meta(get_the_ID(), 'post_ft_youtube', true);
			?>
			    		<?php echo do_shortcode('[tg_youtube video_id="'.$post_ft_youtube.'" width="670" height="377"]'); ?>
			    		<br/>
			<?php
			    	break;
			    	
			    	case 'Gallery':
			    		$post_ft_gallery = get_post_meta(get_the_ID(), 'post_ft_gallery', true);
	
						//Get gallery images
						$all_photo_arr = get_post_meta($post_ft_gallery, 'wpsimplegallery_gallery', true);
						
						//Get gallery sorting
						$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);
						
						if(!empty($all_photo_arr))
						{
			?>
						<div class="post_gallery_wrapper">
			<?php
							$all_photo_count = count($all_photo_arr);
							$plus_photo_count = 0;
							
							if($all_photo_count > 6)
							{
								$plus_photo_count = $all_photo_count - 6;
							}
							
							$i = 0;
							foreach($all_photo_arr as $key => $photo_id)
							{
							    $small_image_url = '';
							    $hyperlink_url = get_permalink($photo_id);
							    $thumb_image_url = '';
							    
							    if(!empty($photo_id))
							    {
							    	//if mobile or tablet then use smaller image size for better performance
							    	if(!wp_is_mobile())
							    	{
								    	$image_size = 'original';
							    	}
							    	else
							    	{
								    	$image_size = 'large';
							    	}
							    	$image_url = wp_get_attachment_image_src($photo_id, $image_size, true);
							    	$thumb_image_url = wp_get_attachment_image_src($photo_id, 'thumbnail', true);
							    }
							    
							    //Get image meta data
							    $image_caption = get_post_field('post_excerpt', $photo_id);
							    $image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
							    $tg_lightbox_enable_caption = kirki_get_option('tg_lightbox_enable_caption');
							    
							    //First image large
							    if($i == 0)
							    {
			?>
							    <div class="post_img post_gallery_featured static">
							    	<a <?php if(!empty($tg_lightbox_enable_caption)) { ?>title="<?php if(!empty($image_caption)) { ?><?php echo esc_attr($image_caption); ?><?php } ?>"<?php } ?> class="fancy-gallery" href="<?php echo esc_url($image_url[0]); ?>">
								    	<img src="<?php echo esc_url($image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>"/>
									</a>
								</div>
			<?php
							    }
							    else
							    {
							    	$last_class = '';
							    	if(($i)%6 == 0)
							    	{
								    	$last_class = 'last';
							    	}
							    	
							    	$hidden_class = '';
							    	if($i > 6)
							    	{
								    	$hidden_class = 'hidden';
							    	}
			?>
								<div class="one_fifth <?php echo esc_attr($last_class); ?> <?php echo esc_attr($hidden_class); ?>">
									<a <?php if(!empty($tg_lightbox_enable_caption)) { ?>title="<?php if(!empty($image_caption)) { ?><?php echo esc_attr($image_caption); ?><?php } ?>"<?php } ?> class="fancy-gallery" href="<?php echo esc_url($image_url[0]); ?>">
								    	<?php
								    		if($i == 6)
								    		{
									    ?>
									    <div class="more_gallery_count">+<?php echo intval($plus_photo_count); ?></div>
									    <?php
								    		}
								    	?>
								    	<img src="<?php echo esc_url($thumb_image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>"/>
									</a>
								</div>
			<?php
							    }
							    $i++;
							}
						}
			?>
						</div><br class="clear"/>
			<?php
						
			    	break;
			    	
			    } //End switch
			} //End if enable blog featured image
			?>
		    
		    <div class="post_header">
			    <div class="post_header_title">
			    	<h5><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h5>

			    	<div class="post_detail single_post">
			    		<span class="post_info_date">
			        		<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo date_i18n(THEMEDATEFORMAT, get_the_time('U')); ?></a>
			    		</span>
			    		<span class="post_info_author">
			    			<?php echo esc_html_e('By', 'grandphotography' ); ?>&nbsp;
			    			<?php
			      				$author_name = get_the_author();
			      			?>
			      			<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo esc_html($author_name); ?></a>
			    		</span>
			    		<span class="post_info_comment">
			    			<?php echo esc_html_e('With', 'grandphotography' ); ?>&nbsp;
			    			<a href="<?php comments_link(); ?>">
			    				<?php 
			        				$post_comment_number = get_comments_number();
			        				echo intval($post_comment_number).'&nbsp;';
			        				
			        				if($post_comment_number <= 1)
			        				{
			    	    				echo esc_html_e('Comment', 'grandphotography' );
			        				}
			        				else
			        				{
			    	    				echo esc_html_e('Comments', 'grandphotography' );
			        				}
			    				?>
			    			</a>
			    		</span>
			    	</div>
			    	
			    	<div class="post_info_cat">
			    	    <?php
			    	    	//Get Post's Categories
			    	    	$post_categories = wp_get_post_categories($post->ID);
			    	    	
			    	    	$count_categories = count($post_categories);
			    			$i = 0;
			    	    	
			    	    	if(!empty($post_categories))
			    	    	{
			    	    		echo esc_html_e('In', 'grandphotography' ).'&nbsp;';
			    	    	
			    	        	foreach($post_categories as $key => $c)
			    	        	{
			    	        		$cat = get_category( $c );
			    	    ?>
			    	        	<a href="<?php echo esc_url(get_category_link($cat->term_id)); ?>"><?php echo esc_html($cat->name); ?></a>
			    	    <?php
			    	    			if(++$i != $count_categories) 
			    	    			{
			    	    				echo '&nbsp;/&nbsp;';
			    	    			}
			    	        	}
			    	        }
			    	    ?>
			    	</div>
			    </div>
			</div>
			    
			<br class="clear"/>
			    
			<?php
			    the_content();
			    wp_link_pages();
			?>
		    
		    <?php
			 $tg_blog_display_tags = kirki_get_option('tg_blog_display_tags');
			
			    if(has_tag() && !empty($tg_blog_display_tags))
			    {
			?>
			    <div class="post_excerpt post_tag">
			    	<i class="fa fa-tags"></i>
			    	<?php the_tags('', '', '<br />'); ?>
			    </div>
			    <br class="clear"/>
			<?php
			    }
			?>
			
			<?php
				//Get share button
				get_template_part("/templates/template-post-share");
			?>
			
			<hr class="double"/>
			
			<?php
			    //Get post author
				get_template_part("/templates/template-author");
			?>
			
			<?php
			    $tg_blog_display_related = kirki_get_option('tg_blog_display_related');
			    
			    if($tg_blog_display_related)
			    {
			?>
			
			<?php
			//for use in the loop, list 9 post titles related to post's tags on current post
			$tags = wp_get_post_tags($post->ID);
			
			if ($tags) {
			
			    $tag_in = array();
			  	//Get all tags
			  	foreach($tags as $tags)
			  	{
			      	$tag_in[] = $tags->term_id;
			  	}
			
			  	$args=array(
			      	  'tag__in' => $tag_in,
			      	  'post__not_in' => array($post->ID),
			      	  'showposts' => 3,
			      	  'ignore_sticky_posts' => 1,
			      	  'orderby' => 'date',
			      	  'order' => 'DESC'
			  	 );
			  	$my_query = new WP_Query($args);
			  	$i_post = 1;
			  	
			  	if( $my_query->have_posts() ) {
			 ?>
			 	<br class="clear"/><br/>
			  	<h6 class="subtitle"><span><?php echo esc_html_e('You might also like', 'grandphotography' ); ?></span></h6><hr class="title_break"/><br class="clear"/>
			  	<div class="post_related">
			    <?php
			       while ($my_query->have_posts()) : $my_query->the_post();
			       
			       $last_class = '';
			       if($i_post%3==0)
			       {
				       $last_class = 'last';
			       }
			       
			       $image_thumb = '';
								
					if(has_post_thumbnail(get_the_ID(), 'large'))
					{
					    $image_id = get_post_thumbnail_id(get_the_ID());
					    $image_thumb = wp_get_attachment_image_src($image_id, 'large', true);
					}
			    ?>
			       <div class="one_third <?php echo esc_attr($last_class); ?>">
					   <!-- Begin each blog post -->
						<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						
							<div class="post_wrapper grid_layout">
							
								<?php
								    //Get post featured content
								    $post_ft_type = get_post_meta(get_the_ID(), 'post_ft_type', true);
								    
								    switch($post_ft_type)
								    {
								    	case 'Image':
								    	default:
								        	if(!empty($image_thumb))
								        	{
								        		$small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-blog', true);
								?>
								
								    	    <div class="post_img small static">
								    	    	<a href="<?php the_permalink(); ?>">
								    	    		<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="" class="" style="width:<?php echo esc_attr($small_image_url[1]); ?>px;height:<?php echo esc_attr($small_image_url[2]); ?>px;"/>
								                </a>
								    	    </div>
								
								<?php
								    		}
								    	break;
								    	
								    	case 'Vimeo Video':
								    		$post_ft_vimeo = get_post_meta(get_the_ID(), 'post_ft_vimeo', true);
								?>
								    		<?php echo do_shortcode('[tg_vimeo video_id="'.$post_ft_vimeo.'" width="670" height="377"]'); ?>
								    		<br/>
								<?php
								    	break;
								    	
								    	case 'Youtube Video':
								    		$post_ft_youtube = get_post_meta(get_the_ID(), 'post_ft_youtube', true);
								?>
								    		<?php echo do_shortcode('[tg_youtube video_id="'.$post_ft_youtube.'" width="670" height="377"]'); ?>
								    		<br/>
								<?php
								    	break;
								    	
								    } //End switch
								?>
							    
							    <div class="blog_grid_content">
									<div class="post_header">
									    <h6><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h6>
									    <div class="post_detail single_post">
										    <span class="post_info_date">
										    	<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo date_i18n(THEMEDATEFORMAT, get_the_time('U')); ?></a>
										    </span>
										</div>
									</div>
							    </div>
							    
							</div>
						
						</div>
						<!-- End each blog post -->
			       </div>
			     <?php
			     		$i_post++;
				 		endwhile;
				 		
				 		wp_reset_postdata();
			     ?>
			  	</div>
			    <br class="clear"/>
			<?php
			  	}
			}
			?>
			<hr class="double"/><br/>
			<?php
			    } //end if show related
			?>
			
	    </div>
	    
	</div>

</div>
<!-- End each blog post -->


<?php
if (comments_open($post->ID)) 
{
?>
<div class="fullwidth_comment_wrapper">
	<?php comments_template( '', true ); ?>
</div>
<?php
}
?>

<?php endwhile; endif; ?>
    	
    	</div>
    
    </div>
    <!-- End main content -->
   
</div>

<br class="clear"/><br/><br/>
</div>
<?php get_footer(); ?>