<?php
/**
 * Template Name: Portfolio 3 Columns Contained
 * The main template file for display portfolio page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
if(!is_null($post))
{
	$page_obj = get_page($post->ID);
}

$current_page_id = '';

/**
*	Get current page id
**/

if(!is_null($post) && isset($page_obj->ID))
{
    $current_page_id = $page_obj->ID;
}

get_header();

$grandphotography_get_portfolio_filterable_header = grandphotography_get_portfolio_filterable_header();
grandphotography_set_portfolio_filterable_header(true);

//Include custom header feature
get_template_part("/templates/template-header");

wp_enqueue_script("grandphotography-custom-grid-portfolio-click", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=3&id=portfolio_filter_wrapper&button_id=infinite_load_more&loading_id=infinite_loading"), false, THEMEVERSION, true);

$tg_portfolio_filterable = kirki_get_option('tg_portfolio_filterable');
if(!empty($tg_portfolio_filterable))
{
	wp_enqueue_script("grandphotography-custom-grid-portfolio-filterable-click", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_filterable_click&columns=3&id=portfolio_filter_wrapper&button_id=infinite_load_more&loading_id=infinite_loading"), false, THEMEVERSION, true);
}
?>

<!-- Begin content -->
<?php
	//Get all portfolio items for paging
	$wp_query = grandphotography_get_wp_query();
	
	$query_string = 'paged='.$paged;
	$query_string.= grandphotography_get_initial_portfolio_query(3);
	
	if(!empty($term))
	{
		$ob_term = get_term_by('slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
		$custom_tax = $wp_query->query_vars['taxonomy'];
	    $query_string .= '&posts_per_page=-1&'.$custom_tax.'='.$term;
	}

	parse_str($query_string, $args);
	
	if(THEMEDEMO)
	{
		$args['tax_query'] = array(
		    array(
		        'taxonomy' => 'portfoliosets',
		        'terms' => array(DEMOPORTFOLIOSETID),
		        'field' => 'slug',
		        'operator' => 'NOT IN',
		    ),
		);
	}

	query_posts($args);
	$current_photo_count = $wp_query->post_count;
	$all_photo_count = $wp_query->found_posts;
?>
    
<div class="inner">

	<div class="inner_wrapper nopadding">
	
	<?php
	    if(!empty($post->post_content) && empty($term))
	    {
	?>
	    <div class="standard_wrapper"><?php echo grandphotography_apply_content($post->post_content); ?></div><br class="clear"/><br/>
	<?php
	    }
	?>
	
	<div id="page_main_content" class="sidebar_content full_width nopadding fixed_column">
	
	<div id="portfolio_filter_wrapper" class="gallery three_cols portfolio-content section content clearfix" data-columns="3">
	
	<?php
		$key = 0;
		if (have_posts()) : while (have_posts()) : the_post();
			$key++;
			$image_url = '';
			$portfolio_ID = get_the_ID();
					
			if(has_post_thumbnail($portfolio_ID, 'original'))
			{
			    $image_id = get_post_thumbnail_id($portfolio_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			    
			    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
			}
			
			$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
			
			if(empty($portfolio_link_url))
			{
			    $permalink_url = get_permalink($portfolio_ID);
			}
			else
			{
			    $permalink_url = $portfolio_link_url;
			}
			
			//Get portfolio category
			$portfolio_item_set = '';
			$portfolio_item_sets = wp_get_object_terms($portfolio_ID, 'portfoliosets');
			
			if(is_array($portfolio_item_sets))
			{
			    foreach($portfolio_item_sets as $set)
			    {
			    	$portfolio_item_set.= $set->slug.' ';
			    }
			}
	?>
	<div class="element grid classic3_cols <?php echo esc_attr($portfolio_item_set); ?>" data-type="<?php echo esc_attr($portfolio_item_set); ?>">
	
		<div class="one_third gallery3 static filterable gallery_type animated<?php echo esc_attr($key+1); ?> portfolio_type" data-id="post-<?php echo esc_attr($key+1); ?>">
		<?php 
				if(!empty($image_url[0]))
				{
			?>		
					<?php
						$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
						$portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
						
						switch($portfolio_type)
						{
						case 'External Link':
							$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
					?>
					<a target="_blank" href="<?php echo esc_url($portfolio_link_url); ?>">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end external link
						
						case 'Portfolio Content':
        				default:
        			?>
        			<a href="<?php echo esc_url(get_permalink($portfolio_ID)); ?>">
        				<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
        				
        				<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
        				
        				<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
	                
	                <?php
						break;
						//portfolio content
        				
        				case 'Image':
					?>
					<a data-caption="<?php echo esc_attr(get_the_title()); ?>" href="<?php echo esc_url($image_url[0]); ?>" class="fancy-gallery">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
	                </a>
					
					<?php
						break;
						//end image
						
						case 'Youtube Video':
					?>
					
					<a href="https://www.youtube.com/embed/<?php echo esc_attr($portfolio_video_id); ?>" class="lightbox_youtube" data-options="width:1425, height:802">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end youtube
					
					case 'Vimeo Video':
					?>
					<a href="https://player.vimeo.com/video/<?php echo esc_attr($portfolio_video_id); ?>?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end vimeo
						
					case 'Self-Hosted Video':
					
						//Get video URL
						$portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
						$preview_image = wp_get_attachment_image_src($image_id, 'large', true);
					?>
					<a href="<?php echo esc_url($portfolio_mp4_url); ?>" class="lightbox_vimeo">
						<img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_<?php echo esc_attr($portfolio_ID); ?>" class="portfolio_title">
        					<div class="image_caption">
						        <h6><?php echo get_the_title(); ?></h6>
        					</div>
				        </div>
		            </a>
					
					<?php
						break;
						//end self-hosted
					?>
					
					<?php
						}
						//end switch
					?>
			<?php
				}		
			?>
		</div>
	</div>
	<?php
		endwhile; endif;
	?>
		
	</div>
	<br class="clear"/>
	<?php
	    //Check if has pagination
	    if($all_photo_count > $current_photo_count)
	    {
	    	$tg_portfolio_pagination_three = kirki_get_option('tg_portfolio_pagination_three');
	?>
	    <a href="javascript:;" id="infinite_load_more" class="infinite_load_more" data-start="<?php echo intval($current_photo_count); ?>" data-items="<?php echo intval($tg_portfolio_pagination_three); ?>"><?php echo esc_html__('Load more', 'grandphotography' ); ?></a>
	<?php
	    }
	?>
	<div id="infinite_loading" class="infinite_loading"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
	</div>

</div>
</div>

</div>
<?php get_footer(); ?>
<!-- End content -->