<?php
/**
 * The main template file for display gallery page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandphotography_page_gallery_id = grandphotography_get_page_gallery_id();
if(!empty($grandphotography_page_gallery_id))
{
	$current_page_id = $grandphotography_page_gallery_id;
}

//Check if password protected
get_template_part("/templates/template-password");

//Get gallery images
$all_photo_arr = array();

if(!isset($_GET['view'])) 
{
	$all_photo_arr = get_post_meta($current_page_id, 'wpsimplegallery_gallery', true);
}
else if(isset($_GET['view']) && $_GET['view'] == 'approve')
{
	$all_photo_arr = get_post_meta($current_page_id, 'wpsimplegallery_gallery', true);
	$current_images_approve = get_post_meta($current_page_id, 'gallery_images_approve', true);
	
	$all_photo_arr = array_intersect($all_photo_arr, $current_images_approve);
}
else if(isset($_GET['view']) && $_GET['view'] == 'reject')
{
	$all_photo_arr = get_post_meta($current_page_id, 'wpsimplegallery_gallery', true);
	$current_images_approve = get_post_meta($current_page_id, 'gallery_images_approve', true);
	
	$all_photo_arr = array_diff($all_photo_arr, $current_images_approve);
}


$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);

get_header();

$grandphotography_topbar = grandphotography_get_topbar();

$grandphotography_page_content_class = grandphotography_get_page_content_class();
grandphotography_set_page_content_class('wide');

//Get gallery header
get_template_part("/templates/template-gallery-header");

wp_register_script("grandphotography-script-gallery-image-proofing-".$current_page_id, get_template_directory_uri()."/js/custom_proofing.js", false, THEMEVERSION, true);

$params = array(
  'ajaxurl' => esc_url(admin_url('admin-ajax.php')),
  'ajax_nonce' => wp_create_nonce('tgajax-post-contact-nonce'),
);

wp_localize_script("grandphotography-script-gallery-image-proofing-".$current_page_id, 'tgAjax', $params );

wp_enqueue_script("grandphotography-script-gallery-image-proofing-".$current_page_id, get_template_directory_uri()."/js/custom_proofing.js", false, THEMEVERSION, true);

wp_enqueue_script("grandphotography-custom-grid-pagination-click", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=3&id=portfolio_filter_wrapper&element=element&button_id=infinite_load_more&loading_id=infinite_loading&gallery_id=".$current_page_id."&type=masonry&gutter=30&photoframe=1"), false, THEMEVERSION, true);


//Get current approved images
$current_images_approve = get_post_meta($current_page_id, 'gallery_images_approve', true);
if(!is_array($current_images_approve))
{
	$current_images_approve = array();
}
?>
<input type="hidden" id="gallery_proofing_status" name="gallery_proofing_status" value="0"/>

<div class="standard_wrapper portfolio_wall_filters_wrapper">
	<ul class="portfolio_wall_filters filter full photo_proofing"> 
		<li>
			<a <?php if(!isset($_GET['view'])) { ?>class="active"<?php } ?> href="<?php echo esc_url(get_permalink($current_page_id)); ?>"><?php echo esc_html_e('All', 'grandphotography' ); ?></a>
			<span class="separator">/</span>
		</li>
		<li>
			<a <?php if(isset($_GET['view']) && $_GET['view'] == 'approve') { ?>class="active"<?php } ?> href="<?php echo esc_url(add_query_arg('view', 'approve', get_permalink($current_page_id))); ?>"><?php echo esc_html_e('Approved Photos', 'grandphotography' ); ?></a>
			<span class="separator">/</span>
		</li>
		<li>
			<a <?php if(isset($_GET['view']) && $_GET['view'] == 'reject') { ?>class="active"<?php } ?> href="<?php echo esc_url(add_query_arg('view', 'reject', get_permalink($current_page_id))); ?>"><?php echo esc_html_e('Rejected Photos', 'grandphotography' ); ?></a>
			<span class="separator">/</span>
		</li>
	</ul>
	
	<div class="comment_box photo_proofing">
		<?php
			$post_comment_number = get_comments_number();
			echo intval($post_comment_number);
		?>
	</div>
	
	<?php
		//Get gallery download
		$gallery_download = get_post_meta($current_page_id, 'gallery_download', true);
		
		if(!empty($gallery_download))
		{
	?>
	<a href="javascript:;" class="photoproofing_download tooltip" title="<?php esc_html_e('Download all gallery images', 'grandphotography' ); ?>" href="<?php echo esc_url($gallery_download); ?>"><i class="fa fa-download"></i></a>
	<?php
		}
	?>
</div>

<br class="clear"/>
    
<div class="inner photo_proofing">

	<?php
		$wrapper_class = 'three_cols';
		$grid_wrapper_class = 'classic3_cols';
		$column_class = 'one_third gallery3';
	?>

	<div class="inner_wrapper nopadding">
	
	<div id="page_main_content" class="sidebar_content full_width fixed_column photoframe">
	
	<div id="portfolio_filter_wrapper" class="gallery <?php echo esc_attr($wrapper_class); ?> portfolio-content section content clearfix" data-columns="3">
	
	<?php
		$tg_full_image_caption = kirki_get_option('tg_full_image_caption');
	
	    foreach($all_photo_arr as $key => $photo_id)
	    {
	        $small_image_url = '';
	        $image_url = '';
	        
	        if(!empty($photo_id))
	        {
	        	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
	        	$small_image_url = wp_get_attachment_image_src($photo_id, 'grandphotography-gallery-masonry', true);
	        }
	        
	        //Get image meta data
	        $image_caption = get_post_field('post_excerpt', $photo_id);
	        $image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
	?>
	<div class="element masonry photoframe <?php echo esc_attr($grid_wrapper_class); ?> animated<?php echo esc_attr($key+1); ?>">
	
		<div class="<?php echo esc_attr($column_class); ?> classic static filterable gallery_type proofing" data-id="post-<?php echo esc_attr($photo_id+1); ?>">
		
			<?php 
			    if(isset($image_url[0]) && !empty($image_url[0]))
			    {	
			    	$is_approved = in_array($photo_id, $current_images_approve);
			    	
			    	$approve_calss = 'reject';
			    	if($is_approved) 
			    	{
			    		$approve_calss = 'approve';
			    	}
			?>		
			    <div id="image<?php echo esc_attr($photo_id); ?>_wrapper" class="overlay_mask">
			        <img id="image<?php echo esc_attr($photo_id); ?>" src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>" class="<?php echo esc_attr($approve_calss); ?>" />
			        
			        <div class="loading hidden"><i class="fa fa-circle-o-notch fa-spin"></i></div>
			        
			        <div class="onapprove <?php if(!$is_approved) { ?>hidden<?php } ?>"><i class="fa fa-check"></i></div>
			        
			        <?php
			        	//Check how to display photo info
			        	$tg_gallery_proofing_info = kirki_get_option('tg_gallery_proofing_info');
			        	$gallery_proofing_info = '';
			        	
			        	if($tg_gallery_proofing_info == 'wordpress_id')
			        	{
			        		$gallery_proofing_info = '#'.$photo_id;
			        	}
			        	else if($tg_gallery_proofing_info == 'title')
			        	{
			        		$image_title = get_post_field('post_title', $photo_id);
			        		$gallery_proofing_info = $image_title;
			        	}
			        	else
			        	{
				        	$gallery_proofing_meta = wp_get_attachment_metadata($photo_id);
				        	
				        	if(isset($gallery_proofing_meta['file']))
				        	{
				        		$gallery_proofing_info = basename($gallery_proofing_meta['file']);
				        	}
			        	}
			        	
			        	//Check if enable download option
			        	$tg_gallery_proofing_download = kirki_get_option('tg_gallery_proofing_download');
			        ?>
			        
			        <div class="portfolio_classic_icon_wrapper">
					    <div class="portfolio_classic_icon_content">
					    	<div class="portfolio_classic_icon_content_middle">
						    	<a title="<?php esc_html_e('View', 'grandphotography' ); ?>" id="image<?php echo esc_attr($photo_id); ?>_image" <?php if(!empty($tg_full_image_caption)) { ?>data-caption="<?php if(!empty($image_caption)) { ?><?php echo esc_attr($image_caption); ?><?php } ?>"<?php } ?> class="fancy-gallery tooltip" href="<?php echo esc_url($image_url[0]); ?>">
							    	<i class="fa fa-search-plus"></i>
						    	</a>
						    	
						    	<?php
							    	if(!empty($tg_gallery_proofing_download))
							    	{
							    ?>
						    	<a title="<?php esc_html_e('Download', 'grandphotography' ); ?>" id="image<?php echo esc_attr($photo_id); ?>_download" href="<?php echo esc_url($image_url[0]); ?>" class="tooltip" target="_blank">
							    	<i class="fa fa-download"></i>
						    	</a>
						    	<?php
							    	}
							    ?>
							    
						    	<a title="<?php esc_html_e('Approve', 'grandphotography' ); ?>" id="image<?php echo esc_attr($photo_id); ?>_approve" href="javascript:;" class="image_approve <?php if($is_approved) { ?>hidden<?php } ?> tooltip" data-image="<?php echo esc_attr($photo_id); ?>" data-gallery="<?php echo esc_attr($current_page_id); ?>">
						    		<i class="fa fa-check"></i>
						    	</a>
						    	
						    	<a title="<?php esc_html_e('Reject', 'grandphotography' ); ?>" id="image<?php echo esc_attr($photo_id); ?>_unapprove" href="javascript:;" class="image_unapprove <?php if(!$is_approved) { ?>hidden<?php } ?> tooltip" data-image="<?php echo esc_attr($photo_id); ?>" data-gallery="<?php echo esc_attr($current_page_id); ?>">
						    		<i class="fa fa-minus"></i>
						    	</a>
					    	</div>
					    </div>
					</div>
			    </div>
			<?php
			    }		
			?>
		
		</div>
		
		<?php
			if(!empty($gallery_proofing_info))
		    {
		?>
		    <div class="gallery_info_wrapper"><?php echo esc_html($gallery_proofing_info); ?></div>
		<?php
		    }
		?>
	</div>
	<?php
		}
	?>
		
	</div>
	
	<?php
		//Get contact email address
		$contact_email = get_option('pp_contact_email');
		$tg_gallery_proofing_notification = kirki_get_option('tg_gallery_proofing_notification');
		
		if(!empty($contact_email) && !empty($tg_gallery_proofing_notification))
		{
			wp_register_script("script-photoproofing-notify", admin_url('admin-ajax.php')."?action=grandphotography_script_image_proofing_notification&button_id=photo_proofing_notify&response_id=reponse_notification", false, THEMEVERSION, true);
			$params = array(
			  'ajaxurl' => admin_url('admin-ajax.php').'?action=grandphotography_proofing_notify_mailer',
			  'ajax_nonce' => wp_create_nonce('tgajax-post-contact-nonce'),
			);
			wp_localize_script( 'script-photoproofing-notify', 'tgAjax', $params );
			wp_enqueue_script("script-photoproofing-notify", admin_url('admin-ajax.php')."?action=grandphotography_script_image_proofing_notification&button_id=photo_proofing_notify&response_id=reponse_notification", false, THEMEVERSION, true);
	?>
		<br class="clear"/>
		<div class="standard_wrapper" style="text-align:center">
			<a href="javascript:;" id="photo_proofing_notify" class="button ghost tooltip" title="<?php esc_html_e('Send email notification to phographer.', 'grandphotography' ); ?>" data-gallery="<?php echo esc_attr($current_page_id); ?>"><i class="fa fa-envelope-o"></i><?php esc_html_e('Notify Photographer', 'grandphotography' ); ?></a>
			<div id="reponse_notification"></div>
			<hr class="double"/><br/>
		</div>
	<?php
		}
	?>
    
    <?php
		if (comments_open($post->ID)) 
		{
	?>
		<div class="standard_wrapper">
			<div class="fullwidth_comment_wrapper">
				<?php comments_template( '', true ); ?>
				</div>
				</div>
	<?php
		}
	?>
	
	</div>

</div>
</div>
<br class="clear"/>
</div>
<?php get_footer(); ?>
<!-- End content -->