<?php
/**
 * The main template file.
 *
 * @package WordPress
 */

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandphotography_page_gallery_id = grandphotography_get_page_gallery_id();
if(!empty($grandphotography_page_gallery_id))
{
	$current_page_id = $grandphotography_page_gallery_id;
}

//Check if password protected
get_template_part("/templates/template-password");

//important to apply dynamic header & footer style
$grandphotography_homepage_style = grandphotography_get_homepage_style();

$tg_kenburns_menu_transparent = kirki_get_option('tg_kenburns_menu_transparent');
if(empty($tg_kenburns_menu_transparent))
{
	$grandphotography_homepage_style = 'fullscreen_white';
}
else
{
	$grandphotography_homepage_style = 'fullscreen';
}
grandphotography_set_homepage_style($grandphotography_homepage_style);

get_header(); 

wp_enqueue_script("grandphotography-kenburns", get_template_directory_uri()."/js/kenburns.js", false, THEMEVERSION, true);
wp_enqueue_script("grandphotography-kenburns-gallery", admin_url('admin-ajax.php')."?action=grandphotography_script_kenburns_gallery&gallery_id=".$current_page_id, false, THEMEVERSION, true);
?>
<div id="kenburns_overlay"></div>
<canvas id="kenburns">
    <p><?php esc_html_e('Your browser doesn\'t support canvas!', 'grandphotography' ); ?></p>
</canvas>

<?php
	get_footer();
?>