<?php
/**
 * The main template file for display gallery page.
 *
 * @package WordPress
*/

/**
*	Get Current page object
**/
$page = get_page($post->ID);
$current_page_id = '';

if(isset($page->ID))
{
    $current_page_id = $page->ID;
}

//Check if gallery template
$grandphotography_page_gallery_id = grandphotography_get_page_gallery_id();
if(!empty($grandphotography_page_gallery_id))
{
	$current_page_id = $grandphotography_page_gallery_id;
}

//Check if password protected
get_template_part("/templates/template-password");

//Get gallery images
$all_photo_arr = get_post_meta($current_page_id, 'wpsimplegallery_gallery', true);
$all_photo_count = count($all_photo_arr);

//Sort gallery images
$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);

//Get only inital images from setting
$all_photo_arr = grandphotography_get_initial_gallery_photos($all_photo_arr, 3, 'masonry');
$current_photo_count = count($all_photo_arr);

get_header();

$grandphotography_topbar = grandphotography_get_topbar();

//Get gallery header
get_template_part("/templates/template-gallery-header");

wp_enqueue_script("grandphotography-custom-grid-pagination-click", admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=3&id=portfolio_filter_wrapper&element=element&button_id=infinite_load_more&loading_id=infinite_loading&gallery_id=".$current_page_id."&type=masonry&gutter=30"), false, THEMEVERSION, true);
?>
    
<div class="inner">

	<div class="inner_wrapper nopadding">
	
	<div id="page_main_content" class="sidebar_content full_width nopadding fixed_column">
	
	<div id="portfolio_filter_wrapper" class="gallery three_cols portfolio-content section content clearfix" data-columns="3">
	
	<?php
		$tg_lightbox_enable_caption = kirki_get_option('tg_lightbox_enable_caption');
	
	    foreach($all_photo_arr as $key => $photo_id)
	    {
	        $small_image_url = '';
	        $image_url = '';
	        
	        if(!empty($photo_id))
	        {
	        	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
	        	$small_image_url = wp_get_attachment_image_src($photo_id, 'grandphotography-gallery-masonry', true);
	        }
	        
	        //Get image meta data
			$image_caption = get_post_field('post_excerpt', $photo_id);
			$image_caption_raw = $image_caption;
			$image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
			$tg_full_image_caption = kirki_get_option('tg_full_image_caption');
			$image_share_url = get_permalink($photo_id);
			
			//Get image purchase URL
			$grandphotography_purchase_url = get_post_meta($photo_id, 'grandphotography_purchase_url', true);
			
			$image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
	?>
	<div class="element masonry classic3_cols">
	
		<div class="one_third gallery3 static filterable gallery_type animated<?php echo esc_attr($key+1); ?>" data-id="post-<?php echo esc_attr($key+1); ?>">
		
			<?php 
			    if(isset($image_url[0]) && !empty($image_url[0]))
			    {
			?>		
			    <a <?php if(!empty($tg_lightbox_enable_caption)) { ?>data-caption="<?php if(!empty($image_caption)) { ?><?php echo esc_attr($image_caption); ?><?php } ?>"<?php } ?> class="fancy-gallery" href="<?php echo esc_url($image_url[0]); ?>">
			        <img src="<?php echo esc_url($small_image_url[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>" />
			        <?php
					     if(!empty($grandphotography_purchase_url))
					     {
					 ?>
					 <a href="<?php echo esc_url($grandphotography_purchase_url); ?>" title="<?php echo esc_html__('Purchase', 'grandphotography' ); ?>" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>
					 <?php
					     }
					 ?>
					
					<?php
					 	if(!empty($image_caption_raw))
					 	{
					 ?>
					     <div class="portfolio_title">
					    	<div class="image_caption">
					    	    <?php echo esc_html($image_caption_raw); ?>
					        </div>
					     </div>
					<?php
					    }
					?>
			    </a>
			<?php
			    }		
			?>
		
		</div>
		
	</div>
	<?php
		}
	?>
		
	</div>
	<br class="clear"/>
	<?php
	    //Check if has pagination
	    if($all_photo_count > $current_photo_count)
	    {
	    	$tg_gallery_pagination_three = kirki_get_option('tg_gallery_pagination_three');
	?>
	    <a href="javascript:;" id="infinite_load_more" class="infinite_load_more" data-start="<?php echo intval($current_photo_count); ?>" data-items="<?php echo intval($tg_gallery_pagination_three); ?>"><?php echo esc_html__('Load more', 'grandphotography' ); ?></a>
	    <div id="infinite_loading" class="infinite_loading"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>
	<?php
	    }
	?>
	
	<?php
	    //Get share button
	    get_template_part("/templates/template-post-share");
	    
	    //Get gallery navigation
	    get_template_part("/templates/template-gallery-navigation");
	?>
	</div>

</div>
</div>
<br class="clear"/>
</div>
<?php get_footer(); ?>
<!-- End content -->