<?php

function ppb_text_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'width' => '100',
		'padding' => 30,
		'bgcolor' => '',
		'fontcolor' => '',
		'textalign' => 'left',
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	
	if($size!='one')
	{
		$return_html.= '<div class="standard_wrapper">';
	}

	//Set main shortcode div content
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_text"';
	
	$custom_css.= 'text-align:'.esc_attr($textalign).';padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).' !important;';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper">';
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	if(!empty($width))
	{
		$return_html.= '<div style="margin:auto;width:'.esc_attr(rawurldecode($width)).'%">';
	}
	$return_html.= do_shortcode(grandphotography_apply_content($content));
	if(!empty($width))
	{
		$return_html.= '</div>';
	}
	$return_html.= '</div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	if($size!='one')
	{
		$return_html.= '</div>';
	}

	return $return_html;

}

add_shortcode('ppb_text', 'ppb_text_func');


function ppb_text_fullwidth_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'width' => '100',
		'padding' => 30,
		'bgcolor' => '',
		'fontcolor' => '',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	
	if($size!='one')
	{
		$return_html.= '<div class="standard_wrapper">';
	}
	
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_text"';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px;';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).' !important;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= do_shortcode(grandphotography_apply_content($content));
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	if($size!='one')
	{
		$return_html.= '</div>';
	}

	return $return_html;

}

add_shortcode('ppb_text_fullwidth', 'ppb_text_fullwidth_func');


function ppb_text_image_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'width' => '100',
		'padding' => 30,
		'textalign' => 'left',
		'background' => '',
		'background_position' => '',
		'parallax' => 0,
		'bgcolor' => '#000000',
		'opacity' => 100,
		'fontcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';
	
	switch($size)
	{
		case 'one_half':
			$size = 'one_half_bg';
		break;
		
		case 'one_half last':
			$size = 'one_half_bg last';
		break;
		
		case 'one_third':
			$size = 'one_third_bg';
		break;
		
		case 'one_third last':
			$size = 'one_third_bg last';
		break;
		
		case 'two_third':
			$size = 'two_third_bg';
		break;
		
		case 'two_third last':
			$size = 'two_third_bg last';
		break;
		
		case 'one_fourth':
			$size = 'one_fourth_bg';
		break;
		
		case 'one_fourth last':
			$size = 'one_fourth_bg last';
		break;
	}

	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_text_image ';
	
	if(!empty($background))
	{
		$return_html.= 'withbg ';
		$custom_css.= 'background-image:url('.esc_url($background).');';
	}
	
	if(!empty($parallax))
	{
		$return_html.= 'parallax ';
	}
	
	if(!empty($background_position))
	{
		$custom_css.= 'background-position: center '.esc_attr($background_position).';';
	}
	
	$return_html.= '"';
	
	$custom_css.= 'text-align:'.esc_attr($textalign).';padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).' !important;';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	$custom_bgcolor_css = '';
	if(!empty($bgcolor))
	{
	    $ori_bgcolor = $bgcolor;
	    $opacity = $opacity/100;
	    $bgcolor = grandphotography_hex_to_rgb($bgcolor);
	
	    $custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
	    $custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
	    $custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
	    
	    $return_html.= '<div class="overlay_background" style="'.esc_attr($custom_bgcolor_css).'"></div>';
	}
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if($size == 'one')
	{	
		$return_html.= '<div class="standard_wrapper">';
	}
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	if(!empty($width))
	{
		$return_html.= '<div style="margin:auto;width:'.esc_attr(rawurldecode($width)).'%">';
	}
	$return_html.= do_shortcode(grandphotography_apply_content($content));
	if(!empty($width))
	{
		$return_html.= '</div>';
	}
	$return_html.= '</div></div>';
	
	if($size == 'one')
	{	
		$return_html.= '</div>';
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_text_image', 'ppb_text_image_func');


function ppb_text_sidebar_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'title' => '',
		'slug' => '',
		'subtitle' => '',
		'sidebar' => '',
		'padding' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="one withsmallpadding" ';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode($custom_css).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper"><div class="page_content_wrapper"><div class="inner"><div class="inner_wrapper">';
	
	$return_html.= '<div class="sidebar_content">';
	
	$return_html.= do_shortcode(grandphotography_apply_content($content)).'</div>';
	
	//Display Sidebar
	$return_html.= '<div class="sidebar_wrapper"><div class="sidebar"><div class="content"><ul class="sidebar_widget">';
	$return_html.= grandphotography_get_dynamic_sidebar(rawurldecode($sidebar));
	$return_html.= '</ul></div></div></div>';
	
	$return_html.= '</div></div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;
}

add_shortcode('ppb_text_sidebar', 'ppb_text_sidebar_func');


function ppb_header_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'bgcolor' => '',
		'fontcolor' => '',
		'textalign' => 'left',
		'width' => '100',
		'padding' => 30,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));

	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';
	if($size != 'one')
	{
		$return_html.= '<div class="standard_wrapper">';
	}

	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_header ';
	
	if(!empty($layout) && $layout == 'fullwidth')
	{
		$return_html.= 'fullwidth ';
	}

	$return_html.= '"';
	
	$custom_css.= 'text-align:'.esc_attr($textalign).';padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if($size == 'one')
	{	
		$return_html.= '<div class="standard_wrapper">';
	}
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	if(!empty($width))
	{
		$return_html.= '<div style="margin:auto;width:'.esc_attr(rawurldecode($width)).'%">';
	}
	
	//Add title and content
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	if(!empty($subtitle))
	{
		$return_html.= '<hr class="title_break bold '.esc_attr($textalign).'" style="'.esc_attr($custom_css_bordercolor).'"/>';
		$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
	}
	
	if(!empty($content))
	{
		$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
	}
	
	$return_html.= '</div>';
	
	if($size == 'one')
	{
		$return_html.= '</div>';
	}
	
	if(!empty($width))
	{
		$return_html.= '</div>';
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	if($size != 'one')
	{
		$return_html.= '</div>';
	}

	return $return_html;

}

add_shortcode('ppb_header', 'ppb_header_func');


function ppb_header_image_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'fontcolor' => '',
		'textalign' => 'left',
		'width' => '100',
		'padding' => 30,
		'background' => '',
		'background_position' => '',
		'bgcolor' => '#000000',
		'opacity' => 100,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'parallax' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	if($size != 'one')
	{	
		$return_html.= '<div class="standard_wrapper">';
	}

	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_header ';
	
	if(!empty($parallax))
	{
		$return_html.= 'parallax ';
	}
	
	if(!empty($background))
	{
		$return_html.= 'withbg ';
		$custom_css.= 'background-image:url('.esc_url($background).');';
	}
	
	if(!empty($background_position))
	{
		$custom_css.= 'background-position: center '.esc_attr($background_position).';';
	}

	$return_html.= '"';
	
	$custom_css.= 'text-align:'.esc_attr($textalign).';padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	$custom_bgcolor_css = '';
	if(!empty($bgcolor))
	{
	    $ori_bgcolor = $bgcolor;
	    $opacity = $opacity/100;
	    $bgcolor = grandphotography_hex_to_rgb($bgcolor);
	
	    $custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
	    $custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
	    $custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
	    
	    $return_html.= '<div class="overlay_background" style="'.esc_attr($custom_bgcolor_css).'"></div>';
	}
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if($size == 'one')
	{	
		$return_html.= '<div class="standard_wrapper">';
	}
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	if(!empty($width))
	{
		$return_html.= '<div style="margin:auto;width:'.esc_attr(rawurldecode($width)).'%">';
	}
	
	//Add title and content
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	if(!empty($subtitle))
	{
		$return_html.= '<hr class="title_break bold '.esc_attr($textalign).'" style="'.esc_attr($custom_css_bordercolor).'"/>';
		$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
	}
	
	if(!empty($content))
	{
		$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
	}
	
	$return_html.= '</div>';
	
	if(!empty($width))
	{
		$return_html.= '</div>';
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	if($size != 'one')
	{
		$return_html.= '</div>';
	}

	return $return_html;

}

add_shortcode('ppb_header_image', 'ppb_header_image_func');


function ppb_divider_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'builder_id' => '',
	), $atts));

	//Set begin wrapper div for live builder
	$return_html= grandphotography_live_builder_begin_wrapper($builder_id, 'ppb_divider');
	
	$return_html.= '<div class="divider '.esc_attr($size).'">&nbsp;</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);

	return $return_html;

}

add_shortcode('ppb_divider', 'ppb_divider_func');


function ppb_gallery_slider_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'gallery' => '',
		'autoplay' => 0,
		'caption' => 0,
		'timer' => 5,
		'padding' => 0,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).'" ';
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= do_shortcode('[tg_gallery_slider gallery_id="'.esc_attr($gallery).'" size="original" autoplay="'.esc_attr($autoplay).'" caption="'.esc_attr($caption).'" timer="'.esc_attr($timer).'" fullwidth="1"]');
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_slider', 'ppb_gallery_slider_func');


function ppb_gallery_slider_fixed_width_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'gallery' => '',
		'autoplay' => 0,
		'caption' => 0,
		'timer' => 5,
		'padding' => 0,
		'bgcolor' => '',
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';
	$return_html.= '<div class="standard_wrapper">';
	
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).'" ';
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="page_content_wrapper nopadding"><div class="inner">';
	
	$return_html.= do_shortcode('[tg_gallery_slider gallery_id="'.esc_attr($gallery).'" size="original" autoplay="'.esc_attr($autoplay).'" caption="'.esc_attr($caption).'"  timer="'.esc_attr($timer).'"]');
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_slider_fixed_width', 'ppb_gallery_slider_fixed_width_func');


function ppb_gallery_horizontal_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'title' => '',
		'gallery' => '',
		'items' => -1,
		'display_caption' => 1,
		'custom_css' => '',
		'layout' => 'wide',
		'height' => 75,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$return_html = '<div class="'.esc_attr($size).'" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode(esc_attr($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	//Get gallery images
	$all_photo_arr = get_post_meta($gallery, 'wpsimplegallery_gallery', true);
	
	//Get global gallery sorting
	$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);
	
	if(!empty($all_photo_arr) && is_array($all_photo_arr))
	{
		wp_enqueue_script("grandphotography-horizontal-gallery", get_template_directory_uri()."/js/horizontal_gallery.js", false, THEMEVERSION, true);
	
		$gallery_excerpt = get_post_field('post_excerpt', $gallery);
	
		//Check if select contained layout
		if($layout == 'contain')
		{
			$return_html.= '<div class="page_content_wrapper horizontal_gallery">';
		}
	
		$return_html.= '
		<div class="horizontal_gallery">
			<table class="horizontal_gallery_wrapper">
				<tbody><tr>';
		
		foreach($all_photo_arr as $photo_id)
		{
		    $small_image_url = '';
		    $hyperlink_url = get_permalink($photo_id);
		    $thumb_image_url = '';
		    
		    if(!empty($photo_id))
		    {
		    	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
		    }
		    
		    //Get image meta data
		    $image_caption = get_post_field('post_excerpt', $photo_id);
		    $image_description = get_post_field('post_content', $photo_id);
		    $tg_full_image_caption = kirki_get_option('tg_full_image_caption');
		    $image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
		    
		    $image_caption_raw = $image_caption;
		    $image_share_url = get_permalink($photo_id);
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
		 
		 	$return_html.= '<td>';
		 	
		 	if(isset($image_url[0]) && !empty($image_url[0]))
	    	{
	    		//Check if enable horizontal gallery lightbox
	    		$tg_lightbox_enable_horizontal_gallery = kirki_get_option('tg_lightbox_enable_horizontal_gallery');
	    	
				if(!empty($tg_lightbox_enable_horizontal_gallery))
				{
		    		$return_html.= '<a ';
		    		
		    		if(!empty($tg_full_image_caption)) 
		    		{ 
		    			$return_html.= 'data-caption="';
		    			
		    			if(!empty($image_caption)) 
		    			{ 
		    				$return_html.= esc_attr($image_caption);
		    			} 
		    			
		    			$return_html.= '"';
		    		} 
		    			$return_html.= 'class="fancy-gallery" href="'.esc_url($image_url[0]).'">';
	    		}
			    	
			    $return_html.= '<div class="gallery_image_wrapper">
				    	<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($image_alt).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>';
			   
				if(!empty($tg_lightbox_enable_horizontal_gallery))
				{
					$return_html.= '</a>';
				}
				
				//Get image purchase URL
				$grandphotography_purchase_url = get_post_meta($photo_id, 'grandphotography_purchase_url', true);
				
				if(!empty($grandphotography_purchase_url))
				{
				    $return_html.= '<a href="'.esc_url($grandphotography_purchase_url).'" title="'.esc_html__('Purchase', 'photography-translation' ).'" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>';
				}
	    	
	    		if(!empty($display_caption))
				{
				    $return_html.= '<div class="image_caption_wrapper"><div class="image_caption">'.esc_html($image_caption_raw).'</div></div>';
				}
				
				$return_html.= '</div>';
	    	}
		 	
		 	$return_html.= '</td>';   
		}
			
		$return_html.= '
				</tr></tbody>
			</table>
		</div>
		';
		
		//Check if select contained layout
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_horizontal', 'ppb_gallery_horizontal_func');


function ppb_gallery_striped_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'title' => '',
		'gallery' => '',
		'items' => -1,
		'display_caption' => 1,
		'custom_css' => '',
		'layout' => 'wide',
		'height' => 75,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$return_html = '<div class="'.esc_attr($size).'" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode(esc_attr($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	//Get gallery images
	$all_photo_arr = get_post_meta($gallery, 'wpsimplegallery_gallery', true);
	
	//Get global gallery sorting
	$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);
	
	if(!empty($all_photo_arr) && is_array($all_photo_arr))
	{
		wp_enqueue_script("grandphotography-horizontal-gallery", get_template_directory_uri()."/js/horizontal_gallery.js", false, THEMEVERSION, true);
	
		$gallery_excerpt = get_post_field('post_excerpt', $gallery);
	
		//Check if select contained layout
		if($layout == 'contain')
		{
			$return_html.= '<div class="page_content_wrapper horizontal_gallery">';
		}
	
		$return_html.= '
		<div class="horizontal_gallery">
			<table class="horizontal_gallery_wrapper">
				<tbody><tr>';
		
		foreach($all_photo_arr as $photo_id)
		{
		    $small_image_url = '';
		    $hyperlink_url = get_permalink($photo_id);
		    $thumb_image_url = '';
		    
		    if(!empty($photo_id))
		    {
		    	$small_image_url = wp_get_attachment_image_src($photo_id, 'grandphotography-gallery-striped', true);
		    	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
		    }
		    
		    //Get image meta data
		    $image_caption = get_post_field('post_excerpt', $photo_id);
		    $image_description = get_post_field('post_content', $photo_id);
		    $tg_full_image_caption = kirki_get_option('tg_full_image_caption');
		    
		    $image_caption_raw = $image_caption;
		    $image_share_url = get_permalink($photo_id);
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
		    $image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
		 
		 	$return_html.= '<td>';
		 	
		 	if(isset($image_url[0]) && !empty($image_url[0]))
	    	{
	    		//Check if enable horizontal gallery lightbox
	    		$tg_lightbox_enable_horizontal_gallery = kirki_get_option('tg_lightbox_enable_horizontal_gallery');
	    	
				if(!empty($tg_lightbox_enable_horizontal_gallery))
				{
		    		$return_html.= '<a ';
		    		
		    		if(!empty($tg_full_image_caption)) 
		    		{ 
		    			$return_html.= 'data-caption="';
		    			
		    			if(!empty($image_caption)) 
		    			{ 
		    				$return_html.= esc_attr($image_caption);
		    			} 
		    			
		    			$return_html.= '"';
		    		} 
		    			$return_html.= 'class="fancy-gallery" href="'.esc_url($image_url[0]).'">';
	    		}
			    	
			    $return_html.= '<div class="gallery_image_wrapper">
				    	<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($image_alt).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>';
			   
				if(!empty($tg_lightbox_enable_horizontal_gallery))
				{
					$return_html.= '</a>';
				}
				
				//Get image purchase URL
				$grandphotography_purchase_url = get_post_meta($photo_id, 'grandphotography_purchase_url', true);
				
				if(!empty($grandphotography_purchase_url))
				{
				    $return_html.= '<a href="'.esc_url($grandphotography_purchase_url).'" title="'.esc_html__('Purchase', 'photography-translation' ).'" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>';
				}
	    	
	    		if(!empty($display_caption))
				{
				    $return_html.= '<div class="image_caption_wrapper"><div class="image_caption">'.esc_html($image_caption_raw).'</div></div>';
				}
				
				$return_html.= '</div>';
	    	}
		 	
		 	$return_html.= '</td>';   
		}
			
		$return_html.= '
				</tr></tbody>
			</table>
		</div>
		';
		
		//Check if select contained layout
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_striped', 'ppb_gallery_striped_func');


function ppb_gallery_grid_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'gallery_id' => '',
		'layout' => 'wide',
		'columns' => 4,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'pagination' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	if(!is_numeric($columns))
	{
		$columns = 4;
	}
	
	$custom_css = '';
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_gallery_grid '.esc_attr($size).'" style="'.$custom_css.'">';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$images_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
	$all_photo_count = count($images_arr);
	
	$images_arr = grandphotography_resort_gallery_img($images_arr);
	$current_photo_count = count($images_arr);
	
	if(!empty($pagination))
	{
		//Get only inital images from setting
		$images_arr = grandphotography_get_initial_gallery_photos($images_arr, $columns);
		$current_photo_count = count($images_arr);
	}
	
	$custom_id = time().rand();
	
	$wrapper_class = '';
	$grid_wrapper_class = '';
	$column_class = '';
	
	switch($columns)
	{
		case 2:
			$wrapper_class = 'two_cols';
			$grid_wrapper_class = 'classic2_cols';
			$column_class = 'one_half gallery2';
		break;
		
		case 3:
			$wrapper_class = 'three_cols';
			$grid_wrapper_class = 'classic3_cols';
			$column_class = 'one_third gallery3';
		break;
		
		case 4:
			$wrapper_class = 'four_cols';
			$grid_wrapper_class = 'classic4_cols';
			$column_class = 'one_fourth gallery4';
		break;
		
		case 5:
			$wrapper_class = 'five_cols';
			$grid_wrapper_class = 'classic5_cols';
			$column_class = 'one_fifth gallery5';
		break;
	}
	
	wp_enqueue_script("grandphotography-custom-grid-pagination-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=".$columns."&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gallery_id=".$gallery_id), false, THEMEVERSION, true);

	if(!empty($images_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery '.esc_attr($wrapper_class).' ' .esc_attr($layout).'" data-columns="'.esc_attr($columns).'">';
		
		$i = 0;
		foreach($images_arr as $key => $image)
		{
			$image_url = wp_get_attachment_image_src($image, 'original', true);
			$small_image_url = wp_get_attachment_image_src($image, 'grandphotography-gallery-grid', true);
			
			$image_caption = get_post_field('post_excerpt', $image);
			$image_alt = get_post_meta($image, '_wp_attachment_image_alt', true);
			
			$image_caption_raw = $image_caption;
		    $image_share_url = get_permalink($image);
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
			
			$tg_lightbox_enable_caption = kirki_get_option('tg_lightbox_enable_caption');
			
			$return_html.= '<div class="element grid  ' .esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' static filterable gallery_type animated'.esc_attr($key+1).'">';
			$return_html.= '<a class="fancy-gallery" href="'.esc_url($image_url[0]).'" ';
			
			if(!empty($tg_lightbox_enable_caption)) 
			{
			    $return_html.= 'data-caption="'.esc_attr($image_caption).'" ';
			}
			
			$return_html.= '>';
			$return_html.= '<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($image_alt).'"/>';
			
			//Get image purchase URL
			$grandphotography_purchase_url = get_post_meta($image, 'grandphotography_purchase_url', true);
			
			if(!empty($grandphotography_purchase_url))
			{
			    $return_html.= '<a href="'.esc_url($grandphotography_purchase_url).'" title="'.esc_html__('Purchase', 'grandphotography-translation' ).'" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>';
			}
			
			if(!empty($image_caption_raw))
			{
			    $return_html.= '<div class="portfolio_title">
			        	<div class="image_caption">
			        	    '.esc_html($image_caption_raw).'
			            </div>
			         </div>';
			}
			
			$return_html.= '</a>';
			$return_html.= '</div>';
			$return_html.= '</div>';
			
			$i++;
		}
		
		$return_html.= '</div>';
		
		//Check if has pagination
	    if($all_photo_count > $current_photo_count && !empty($pagination))
	    {
	    	$return_html.= '<br class="clear"/>';
	    
			switch($columns)
			{
				case 1:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_one');
				break;
				
				case 2:
				default:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_two');
				break;
				
				case 3:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_three');
				break;
				
				case 4:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_four');
				break;
				
				case 5:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_five');
				break;
			}
			
			$return_html.= '<a href="javascript:;" id="infinite_load_more_'.$custom_id.'" class="infinite_load_more" data-start="'.intval($current_photo_count).'" data-items="'.intval($tg_gallery_pagination).'">'.esc_html__('Load more', 'grandphotography-translation' ).'</a>';
			
			$return_html.= '<div id="infinite_loading_'.$custom_id.'" class="infinite_loading"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>';
		}
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	else
	{
		$return_html.= esc_html__( 'Empty gallery item. Please make sure you have upload image to it or check the short code.', 'grandphotography-custom-post' );
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_grid', 'ppb_gallery_grid_func');


function ppb_gallery_board_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'gallery_id' => '',
		'layout' => 'wide',
		'padding' => 40,
		'pagination' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$custom_css = '';
	
	$custom_css.= 'margin:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' page_main_content sidebar_content full_width fixed_column photoframe" style="'.$custom_css.'">';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$images_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
	$all_photo_count = count($images_arr);
	
	$images_arr = grandphotography_resort_gallery_img($images_arr);
	$current_photo_count = count($images_arr);
	
	if(!empty($pagination))
	{
		//Get only inital images from setting
		$images_arr = grandphotography_get_initial_gallery_photos($images_arr, 3);
		$current_photo_count = count($images_arr);
	}
	
	$custom_id = time().rand();
	
	$wrapper_class = 'three_cols';
	$grid_wrapper_class = 'classic3_cols';
	$column_class = 'one_third gallery3';
	
	wp_enqueue_script("grandphotography-custom-grid-pagination-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=3&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gallery_id=".$gallery_id."&type=masonry&gutter=30&photoframe=1"), false, THEMEVERSION, true);

	if(!empty($images_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery '.esc_attr($wrapper_class).'" data-columns="3">';
		
		$i = 0;
		foreach($images_arr as $key => $image)
		{
			$image_url = wp_get_attachment_image_src($image, 'original', true);
			$small_image_url = wp_get_attachment_image_src($image, 'grandphotography-gallery-masonry', true);
			
			$image_caption = get_post_field('post_excerpt', $image);
			$image_alt = get_post_meta($image, '_wp_attachment_image_alt', true);
			
			$image_caption_raw = $image_caption;
		    $image_share_url = get_permalink($image);
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
			
			$tg_lightbox_enable_caption = kirki_get_option('tg_lightbox_enable_caption');
			
			$return_html.= '<div class="element masonry photoframe ' .esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' static filterable gallery_type animated'.esc_attr($key+1).'">';
			$return_html.= '<a class="fancy-gallery" href="'.esc_url($image_url[0]).'" ';
			
			if(!empty($tg_lightbox_enable_caption)) 
			{
			    $return_html.= 'data-caption="'.esc_attr($image_caption).'" ';
			}
			
			$return_html.= '>';
			$return_html.= '<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($image_alt).'"/>';
			
			//Get image purchase URL
			$grandphotography_purchase_url = get_post_meta($image, 'grandphotography_purchase_url', true);
			
			if(!empty($grandphotography_purchase_url))
			{
			    $return_html.= '<a href="'.esc_url($grandphotography_purchase_url).'" title="'.esc_html__('Purchase', 'grandphotography-translation' ).'" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>';
			}
			
			$return_html.= '</a>';
			$return_html.= '</div>';
			
			if(!empty($image_caption))
			{
			    $return_html.= '<div class="gallery_info_wrapper">
			        	'.esc_html($image_caption_raw).'
			         </div>';
			}
			
			$return_html.= '</div>';
			
			$i++;
		}
		
		$return_html.= '</div>';
		
		//Check if has pagination
	    if($all_photo_count > $current_photo_count && !empty($pagination))
	    {
	    	$return_html.= '<br class="clear"/>';
	    
			$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_three');
			
			$return_html.= '<a href="javascript:;" id="infinite_load_more_'.$custom_id.'" class="infinite_load_more" data-start="'.intval($current_photo_count).'" data-items="'.intval($tg_gallery_pagination).'">'.esc_html__('Load more', 'grandphotography-translation' ).'</a>';
			
			$return_html.= '<div id="infinite_loading_'.$custom_id.'" class="infinite_loading"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>';
		}
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	else
	{
		$return_html.= esc_html__( 'Empty gallery item. Please make sure you have upload image to it or check the short code.', 'grandphotography-custom-post' );
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_board', 'ppb_gallery_board_func');


function ppb_gallery_masonry_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'gallery_id' => '',
		'layout' => 'wide',
		'columns' => 4,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'pagination' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	if(!is_numeric($columns))
	{
		$columns = 4;
	}
	
	$custom_css = '';
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).'" style="'.$custom_css.'">';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$images_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
	$all_photo_count = count($images_arr);
	
	$images_arr = grandphotography_resort_gallery_img($images_arr);
	
	$current_photo_count = count($images_arr);
	
	if(!empty($pagination))
	{
		//Get only inital images from setting
		$images_arr = grandphotography_get_initial_gallery_photos($images_arr, $columns);
		$current_photo_count = count($images_arr);
	}
	
	$custom_id = time().rand();
	
	$wrapper_class = '';
	$grid_wrapper_class = '';
	$column_class = '';
	
	switch($columns)
	{
		case 2:
			$wrapper_class = 'two_cols';
			$grid_wrapper_class = 'classic2_cols';
			$column_class = 'one_half gallery2';
		break;
		
		case 3:
			$wrapper_class = 'three_cols';
			$grid_wrapper_class = 'classic3_cols';
			$column_class = 'one_third gallery3';
		break;
		
		case 4:
			$wrapper_class = 'four_cols';
			$grid_wrapper_class = 'classic4_cols';
			$column_class = 'one_fourth gallery4';
		break;
		
		case 5:
			$wrapper_class = 'five_cols';
			$grid_wrapper_class = 'classic5_cols';
			$column_class = 'one_fifth gallery5';
		break;
	}
	
	$masonry_query = '&type=masonry';
	if($layout == 'contain')
	{
		$masonry_query.= '&gutter=30';
	}
	
	wp_enqueue_script("grandphotography-custom-grid-pagination-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=".$columns."&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gallery_id=".$gallery_id.$masonry_query), false, THEMEVERSION, true);

	if(!empty($images_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery '.esc_attr($wrapper_class).' ' .esc_attr($layout).'" data-columns="'.esc_attr($columns).'">';
		
		$i = 0;
		foreach($images_arr as $key => $image)
		{
			$image_url = wp_get_attachment_image_src($image, 'original', true);
			$small_image_url = wp_get_attachment_image_src($image, 'grandphotography-gallery-masonry', true);
			
			$image_caption = get_post_field('post_excerpt', $image);
			$image_alt = get_post_meta($image, '_wp_attachment_image_alt', true);
			
			$image_caption_raw = $image_caption;
		    $image_share_url = get_permalink($image);
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
			
			$tg_lightbox_enable_caption = kirki_get_option('tg_lightbox_enable_caption');
			
			$return_html.= '<div class="element masonry  ' .esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' static filterable gallery_type animated'.esc_attr($key+1).'">';
			$return_html.= '<a class="fancy-gallery" href="'.esc_url($image_url[0]).'" ';
			
			if(!empty($tg_lightbox_enable_caption)) 
			{
			    $return_html.= 'data-caption="'.esc_attr($image_caption).'" ';
			}
			
			$return_html.= '>';
			$return_html.= '<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($image_alt).'"/>';
			
			//Get image purchase URL
			$grandphotography_purchase_url = get_post_meta($image, 'grandphotography_purchase_url', true);
			
			if(!empty($grandphotography_purchase_url))
			{
			    $return_html.= '<a href="'.esc_url($grandphotography_purchase_url).'" title="'.esc_html__('Purchase', 'grandphotography-translation' ).'" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>';
			}
			
			if(!empty($image_caption_raw))
			{
			    $return_html.= '<div class="portfolio_title">
			        	<div class="image_caption">
			        	    '.esc_html($image_caption_raw).'
			            </div>
			         </div>';
			}
			
			$return_html.= '</a>';
			$return_html.= '</div>';
			$return_html.= '</div>';
			
			$i++;
		}
		
		$return_html.= '</div>';
		
		//Check if has pagination
	    if($all_photo_count > $current_photo_count && !empty($pagination))
	    {
	    	$return_html.= '<br class="clear"/>';
	    
			switch($columns)
			{
				case 1:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_one');
				break;
				
				case 2:
				default:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_two');
				break;
				
				case 3:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_three');
				break;
				
				case 4:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_four');
				break;
				
				case 5:
					$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_five');
				break;
			}
			
			$return_html.= '<a href="javascript:;" id="infinite_load_more_'.$custom_id.'" class="infinite_load_more" data-start="'.intval($current_photo_count).'" data-items="'.intval($tg_gallery_pagination).'">'.esc_html__('Load more', 'grandphotography-translation' ).'</a>';
			
			$return_html.= '<div id="infinite_loading_'.$custom_id.'" class="infinite_loading"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>';
		}
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	else
	{
		$return_html.= esc_html__( 'Empty gallery item. Please make sure you have upload image to it or check the short code.', 'grandphotography-custom-post' );
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_masonry', 'ppb_gallery_masonry_func');


function ppb_gallery_justified_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'gallery_id' => '',
		'layout' => 'wide',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'pagination' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$custom_css = '';
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).'" style="'.$custom_css.'">';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$images_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
	$all_photo_count = count($images_arr);
	
	$images_arr = grandphotography_resort_gallery_img($images_arr);
	
	$current_photo_count = count($images_arr);
	
	if(!empty($pagination))
	{
		//Get only inital images from setting
		$images_arr = grandphotography_get_initial_gallery_photos($images_arr, 'justified', 'masonry');
		$current_photo_count = count($images_arr);
	}
	
	$custom_id = time().rand();
	
	$wrapper_class = 'five_cols justified';
	$grid_wrapper_class = 'classic5_cols';
	$column_class = 'one_fifth gallery5';
	
	wp_enqueue_script("grandphotography-custom-grid-pagination-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=5&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gallery_id=".$gallery_id.'&type=masonry&gutter=10&justified=1'), false, THEMEVERSION, true);

	if(!empty($images_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery '.esc_attr($wrapper_class).' ' .esc_attr($layout).'" data-columns="5">';
		
		$i = 0;
		foreach($images_arr as $key => $image)
		{
			$image_url = wp_get_attachment_image_src($image, 'original', true);
			$small_image_url = wp_get_attachment_image_src($image, 'grandphotography-gallery-masonry', true);
			
			$image_caption = get_post_field('post_excerpt', $image);
			$image_alt = get_post_meta($image, '_wp_attachment_image_alt', true);
			
			$image_caption_raw = $image_caption;
		    $image_share_url = get_permalink($image);
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
			
			$tg_lightbox_enable_caption = kirki_get_option('tg_lightbox_enable_caption');
			
			$return_html.= '<div class="element masonry  ' .esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' static filterable gallery_type animated'.esc_attr($key+1).'">';
			$return_html.= '<a class="fancy-gallery" href="'.esc_url($image_url[0]).'" ';
			
			if(!empty($tg_lightbox_enable_caption)) 
			{
			    $return_html.= 'data-caption="'.esc_attr($image_caption).'" ';
			}
			
			$return_html.= '>';
			$return_html.= '<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($image_alt).'"/>';
			
			//Get image purchase URL
			$grandphotography_purchase_url = get_post_meta($image, 'grandphotography_purchase_url', true);
			
			if(!empty($grandphotography_purchase_url))
			{
			    $return_html.= '<a href="'.esc_url($grandphotography_purchase_url).'" title="'.esc_html__('Purchase', 'grandphotography-translation' ).'" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>';
			}
			
			if(!empty($image_caption_raw))
			{
			    $return_html.= '<div class="portfolio_title">
			        	<div class="image_caption">
			        	    '.esc_html($image_caption_raw).'
			            </div>
			         </div>';
			}
			
			$return_html.= '</a>';
			$return_html.= '</div>';
			$return_html.= '</div>';
			
			$i++;
		}
		
		$return_html.= '</div>';
		
		//Check if has pagination
	    if($all_photo_count > $current_photo_count && !empty($pagination))
	    {
	    	$return_html.= '<br class="clear"/>';
	    
			$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_justified');
			
			$return_html.= '<a href="javascript:;" id="infinite_load_more_'.$custom_id.'" class="infinite_load_more" data-start="'.intval($current_photo_count).'" data-items="'.intval($tg_gallery_pagination).'">'.esc_html__('Load more', 'grandphotography-translation' ).'</a>';
			
			$return_html.= '<div id="infinite_loading_'.$custom_id.'" class="infinite_loading"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>';
		}
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	else
	{
		$return_html.= esc_html__( 'Empty gallery item. Please make sure you have upload image to it or check the short code.', 'grandphotography-custom-post' );
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_justified', 'ppb_gallery_justified_func');


function ppb_gallery_mixed_grid_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'gallery_id' => '',
		'layout' => 'wide',
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'pagination' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_gallery_mixed_grid '.$size.' nopadding ';
	
	$return_html.= '" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	//Get gallery images
	$all_photo_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
	$all_photo_count = count($all_photo_arr);
	
	//Get global gallery sorting
	$all_photo_arr = grandphotography_resort_gallery_img($all_photo_arr);
	
	$current_photo_count = count($all_photo_arr);
	
	if(!empty($pagination))
	{
		//Get only inital images from setting
		$all_photo_arr = grandphotography_get_initial_gallery_photos($all_photo_arr, 3);
		$current_photo_count = count($all_photo_arr);
	}
	
	$custom_id = time().rand();
	
	wp_enqueue_script("grandphotography-custom-grid-pagination-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=3&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gallery_id=".$gallery_id."&type=metro"), false, THEMEVERSION, true);
	
	if(!empty($all_photo_arr) && is_array($all_photo_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
		
		$wrapper_class = 'three_cols';
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_mixed_filter_wrapper gallery portfolio-content section content clearfix '.esc_attr($wrapper_class).' ' .esc_attr($layout).'">';
		
		$large_counter = 1;
		$next_number_to_add = 4;
		$next_trigger = 1;
		
		foreach($all_photo_arr as $key => $photo_id)
		{
			//Calculated columns size
			$grid_wrapper_class = 'classic3_cols';
			$column_class = 'one_third gallery3';
			$grandphotography_image_size = 'grandphotography-gallery-grid';
			
			$large_counter_trigger = FALSE;
			
			if($next_trigger == $key+1)
			{
				$large_counter_trigger = TRUE;
				$next_trigger = $next_trigger+$next_number_to_add;
				
				if($next_number_to_add == 4)
				{
					$next_number_to_add = 2;
				}
				else if($next_number_to_add==2)
				{
					$next_number_to_add = 4;
				}
			}
			
			if($large_counter_trigger)
			{
				$wrapper_class = 'three_cols double_size';
				$grid_wrapper_class = 'classic3_cols double_size';
				$column_class = 'one_third gallery3 double_size';
				$grandphotography_image_size = 'grandphotography-gallery-grid-large';
			}
			
			$large_counter++;
		
		    $small_image_url = '';
		    $hyperlink_url = get_permalink($photo_id);
		    $thumb_image_url = '';
		    
		    if(!empty($photo_id))
		    {
		    	$image_url = wp_get_attachment_image_src($photo_id, 'original', true);
		    	$small_image_url = wp_get_attachment_image_src($photo_id, $grandphotography_image_size, true);
		    }
		    
		    //Get image meta data
		    $image_caption = get_post_field('post_excerpt', $photo_id);
		    $image_alt = get_post_meta($photo_id, '_wp_attachment_image_alt', true);
		    
		    $image_caption_raw = $image_caption;
		    $image_share_url = get_permalink($photo_id);
		    $image_caption.= '<a href="'.esc_url($image_share_url).'" class="button" target="_blank">'.esc_html__('Share', 'grandphotography' ).'</a>';
		    
			//Begin display HTML
			$return_html.= '<div class="element '.esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' filterable gallery_type static'.($key+1).'">';
			
			$return_html.= '<a class="fancy-gallery" href="'.esc_url($image_url[0]).'" ';
			
			if(!empty($tg_lightbox_enable_caption)) 
			{
			    $return_html.= 'data-caption="'.esc_attr($image_caption).'" ';
			}
			
			$return_html.= '>';
			$return_html.= '<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($image_alt).'"/>';
			
			//Get image purchase URL
			$grandphotography_purchase_url = get_post_meta($photo_id, 'grandphotography_purchase_url', true);
			
			if(!empty($grandphotography_purchase_url))
			{
			    $return_html.= '<a href="'.esc_url($grandphotography_purchase_url).'" title="'.esc_html__('Purchase', 'grandphotography-translation' ).'" class="button tooltip"><i class="fa fa-shopping-cart"></i></a>';
			}
			
			if(!empty($image_caption_raw))
			{
			    $return_html.= '<div class="portfolio_title">
			        	<div class="image_caption">
			        	    '.esc_html($image_caption_raw).'
			            </div>
			         </div>';
			}
			
			$return_html.= '</a>';
			
			$return_html.= '</div>';
			$return_html.= '</div>';
		}
		
		$return_html.= '</div>';
		
		//Check if has pagination
	    if($all_photo_count > $current_photo_count && !empty($pagination))
	    {
	    	$return_html.= '<br class="clear"/>';
	    
			$tg_gallery_pagination = kirki_get_option('tg_gallery_pagination_three');
			
			$return_html.= '<a href="javascript:;" id="infinite_load_more_'.$custom_id.'" class="infinite_load_more" data-start="'.intval($current_photo_count).'" data-items="'.intval($tg_gallery_pagination).'" data-largecounter="'.esc_attr($large_counter).'" data-nextnumbertoadd="'.esc_attr($next_number_to_add).'"  data-nexttrigger="'.esc_attr($next_trigger).'">'.esc_html__('Load more', 'grandphotography-translation' ).'</a>';
			
			$return_html.= '<div id="infinite_loading_'.$custom_id.'" class="infinite_loading"><i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i></div>';
		}
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_gallery_mixed_grid', 'ppb_gallery_mixed_grid_func');


function ppb_gallery_archive_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'cat' => '',
		'items' => '',
		'layout' => 'contain',
		'columns' => 3,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 3;
	}
	if(!is_numeric($columns))
	{
		$columns = 3;
	}

	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_gallery_archive '.esc_attr($size).'" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode(esc_attr($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	//Display galleries items
	$args = array(
	    'numberposts' => $items,
	    'order' => 'ASC',
	    'orderby' => 'menu_order',
	    'post_type' => array('galleries'),
	    'suppress_filters' => 0,
	    'meta_key' => '_thumbnail_id',
	);
	
	if(!empty($cat))
	{
		$args['gallerycat'] = $cat;
	}

	$galleris_arr = get_posts($args);
	
	$custom_id = time().rand();
	
	$wrapper_class = '';
	$grid_wrapper_class = '';
	$column_class = '';
	
	switch($columns)
	{
		case 2:
			$wrapper_class = 'two_cols';
			$grid_wrapper_class = 'classic2_cols';
			$column_class = 'one_half gallery2';
		break;
		
		case 3:
			$wrapper_class = 'three_cols';
			$grid_wrapper_class = 'classic3_cols';
			$column_class = 'one_third gallery3';
		break;
		
		case 4:
			$wrapper_class = 'four_cols';
			$grid_wrapper_class = 'classic4_cols';
			$column_class = 'one_fourth gallery4';
		break;
	}
	
	wp_enqueue_script("grandphotography-custom-grid-pagination-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=".$columns."&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gallery_id=".$custom_id), false, THEMEVERSION, true);
	
	if(!empty($galleris_arr) && is_array($galleris_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		//Check if disable slideshow hover effect
		$tg_gallery_hover_slide = kirki_get_option( "tg_gallery_hover_slide" );
		
		if(!empty($tg_gallery_hover_slide))
		{
			wp_enqueue_script("grandphotography-jquery-cycle2", get_template_directory_uri()."/js/jquery.cycle2.min.js", false, THEMEVERSION, true);
			wp_enqueue_script("grandphotography-custom-cycle", get_template_directory_uri()."/js/custom_cycle.js", false, THEMEVERSION, true);
		}
		
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery '.esc_attr($wrapper_class).' ' .esc_attr($layout).'" data-columns="'.esc_attr($columns).'">';
		
		foreach($galleris_arr as $key => $gallery)
		{
			$image_url = '';
			$gallery_ID = $gallery->ID;
			    	
			if(has_post_thumbnail($gallery_ID, 'original'))
			{
			    $image_id = get_post_thumbnail_id($gallery_ID);
			    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
			}
			
			$permalink_url = get_permalink($gallery_ID);
			
			$return_html.= '<div class="element grid  ' .esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' static filterable gallery_type animated'.esc_attr($key+1).' archive">';
			
			if(!empty($small_image_url[0]))
			{
				$all_photo_arr = array();
						
				if(!empty($tg_gallery_hover_slide))
				{
				    //Get gallery images
				    $all_photo_arr = get_post_meta($gallery_ID, 'wpsimplegallery_gallery', true);
				    
				    //Get only 5 recent photos
				    $all_photo_arr = array_slice($all_photo_arr, 0, 5);
				}
			    
			    $return_html.= '<a href="'.esc_url($permalink_url).'">';

				if(!empty($all_photo_arr))
				{
					 $return_html.= '<ul class="gallery_img_slides">';

					foreach($all_photo_arr as $photo)
					{
						$slide_image_url = wp_get_attachment_image_src($photo, 'grandphotography-gallery-grid', true);
						$return_html.= '<li><img src="'.esc_url($slide_image_url[0]).'" alt="" class="static"/></li>';
					}
					
					$return_html.= '</ul>';
				}

				$return_html.= '<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($gallery->post_title).'"/>';
				
				$return_html.= '<div class="portfolio_title">
					    <div class="image_caption">
					    	<h7>'.$gallery->post_title.'</h7>
					    </div>
					</div>';
				
				$return_html.= '</a>';
			}
			
			$return_html.= '</div>';
			$return_html.= '</div>';
		}
		
		$return_html.= '</div>';
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_gallery_archive', 'ppb_gallery_archive_func');


function ppb_gallery_archive_board_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'cat' => '',
		'items' => '',
		'layout' => 'contain',
		'columns' => 3,
		'padding' => 40,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 3;
	}
	if(!is_numeric($columns))
	{
		$columns = 3;
	}

	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_gallery_archive_board '.esc_attr($size).' page_main_content sidebar_content full_width fixed_column photoframe" ';
	
	$custom_css.= 'margin:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode(esc_attr($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	//Display galleries items
	$args = array(
	    'numberposts' => $items,
	    'order' => 'ASC',
	    'orderby' => 'menu_order',
	    'post_type' => array('galleries'),
	    'suppress_filters' => 0,
	    'meta_key' => '_thumbnail_id',
	);
	
	if(!empty($cat))
	{
		$args['gallerycat'] = $cat;
	}

	$galleris_arr = get_posts($args);
	
	$custom_id = time().rand();
	
	$wrapper_class = 'three_cols';
	$grid_wrapper_class = 'classic3_cols';
	$column_class = 'one_third gallery3';
	
	wp_enqueue_script("grandphotography-custom-grid-pagination-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_gallery_pagination_click&columns=".$columns."&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gallery_id=".$custom_id."&type=masonry&gutter=30&photoframe=1"), false, THEMEVERSION, true);
	
	if(!empty($galleris_arr) && is_array($galleris_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		//Check if disable slideshow hover effect
		$tg_gallery_hover_slide = kirki_get_option( "tg_gallery_hover_slide" );
		
		if(!empty($tg_gallery_hover_slide))
		{
			wp_enqueue_script("grandphotography-jquery-cycle2", get_template_directory_uri()."/js/jquery.cycle2.min.js", false, THEMEVERSION, true);
			wp_enqueue_script("grandphotography-custom-cycle", get_template_directory_uri()."/js/custom_cycle.js", false, THEMEVERSION, true);
		}
		
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery '.esc_attr($wrapper_class).'" data-columns="3">';
		
		foreach($galleris_arr as $key => $gallery)
		{
			$image_url = '';
			$gallery_ID = $gallery->ID;
			    	
			if(has_post_thumbnail($gallery_ID, 'original'))
			{
			    $image_id = get_post_thumbnail_id($gallery_ID);
			    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
			}
			
			$permalink_url = get_permalink($gallery_ID);
			
			$return_html.= '<div class="element masonry photoframe ' .esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' static filterable gallery_type animated'.esc_attr($key+1).' archive">';
			
			if(!empty($small_image_url[0]))
			{
				$all_photo_arr = array();
						
				if(!empty($tg_gallery_hover_slide))
				{
				    //Get gallery images
				    $all_photo_arr = get_post_meta($gallery_ID, 'wpsimplegallery_gallery', true);
				    
				    //Get only 5 recent photos
				    $all_photo_arr = array_slice($all_photo_arr, 0, 5);
				}
			    
			    $return_html.= '<a href="'.esc_url($permalink_url).'">';

				if(!empty($all_photo_arr))
				{
					 $return_html.= '<ul class="gallery_img_slides">';

					foreach($all_photo_arr as $photo)
					{
						$slide_image_url = wp_get_attachment_image_src($photo, 'grandphotography-gallery-grid', true);
						$return_html.= '<li><img src="'.esc_url($slide_image_url[0]).'" alt="" class="static"/></li>';
					}
					
					$return_html.= '</ul>';
				}

				$return_html.= '<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($gallery->post_title).'"/>';
				
				$return_html.= '</a>';
			}
			
			$return_html.= '</div>';
			
			$return_html.= '<div class="gallery_info_wrapper"><h6>'.$gallery->post_title.'</h6></div>';
			
			$return_html.= '</div>';
		}
		
		$return_html.= '</div>';
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_gallery_archive_board', 'ppb_gallery_archive_board_func');


function ppb_collection_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'cat' => '',
		'height' => 600,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	$return_html.= '<div '.$sec_id.' class="ppb_collection '.esc_attr($size).'" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$cat_arr = explode(',', $cat);
	
	if(!empty($cat_arr) && is_array($cat_arr))
	{
		foreach($cat_arr as $key => $cat_slug)
		{
			$custom_term = get_term_by('slug', $cat_slug, 'gallerycat');
			$term_title = $custom_term->name;
			$term_description = $custom_term->description;
			$term_link = get_term_link($cat_slug, 'gallerycat');
			
			if(!empty($term_title))
			{
				$return_html.= '<div class="standard_wrapper withpadding">';
				$return_html.= '<div class="floatleft term_title"><h5>'.esc_html($term_title).'</h5></div>';
				
				if(!empty($term_description))
				{
					$return_html.= '<div class="floatright term_desc">'.esc_html($term_description).'</div>';
				}
				$return_html.= '<br class="clear"/></div>';
			}
		
			//Display galleries items
			$args = array(
			    'numberposts' => 4,
			    'order' => 'ASC',
			    'orderby' => 'menu_order',
			    'post_type' => array('galleries'),
			    'suppress_filters' => 0,
			    'gallerycat' => $cat_slug,
			    'meta_key' => '_thumbnail_id',
			);
			
			$galleries_arr = get_posts($args);
			$count_galleries = count($galleries_arr);
			
			if(!empty($galleries_arr) && is_array($galleries_arr))
			{
				foreach($galleries_arr as $key_gallery => $gallery)
				{
					if($key_gallery == 0)
					{
						$image_url = '';
						$gallery_ID = $gallery->ID;
						    	
						if(has_post_thumbnail($gallery_ID, 'large'))
						{
						    $image_id = get_post_thumbnail_id($gallery_ID);
						    $small_image_url = wp_get_attachment_image_src($image_id, 'large', true);
						}
						
						$permalink_url = get_permalink($gallery_ID);
					
						//First image
						$return_html.= '<div class="one_half_bg nopadding gallery_type animated'.esc_attr($key+1).' slideUp" style="background:url('.esc_url($small_image_url[0]).');height:'.intval($height).'px;">';
						$return_html.= '<a href="'.esc_url($permalink_url).'"></a>';
						$return_html.= '<div class="portfolio_title">
						    <div class="image_caption">
						    	<h5>'.$gallery->post_title.'</h5>
						    </div>
						</div>';
						$return_html.= '</div>';
					}
					
					if($key_gallery == 1)
					{
						$return_html.= '<div class="one_half_bg nopadding">';
						
						$image_url = '';
						$gallery_ID = $gallery->ID;
						    	
						if(has_post_thumbnail($gallery_ID, 'large'))
						{
						    $image_id = get_post_thumbnail_id($gallery_ID);
						    $small_image_url = wp_get_attachment_image_src($image_id, 'large', true);
						}
						
						$permalink_url = get_permalink($gallery_ID);
						
						$return_html.= '<div class="one_half_bg nopadding gallery_type animated'.esc_attr($key+1).' slideUp" style="background:url('.esc_url($small_image_url[0]).');height:'.intval($height/2).'px;">';
						$return_html.= '<a href="'.esc_url($permalink_url).'"></a>';
						$return_html.= '<div class="portfolio_title">
						    <div class="image_caption">
						    	<h6>'.$gallery->post_title.'</h6>
						    </div>
						</div>';
						$return_html.= '</div>';
					}
						
					if($key_gallery > 1)
					{
						$image_url = '';
						$gallery_ID = $gallery->ID;
						    	
						if(has_post_thumbnail($gallery_ID, 'large'))
						{
						    $image_id = get_post_thumbnail_id($gallery_ID);
						    $small_image_url = wp_get_attachment_image_src($image_id, 'large', true);
						}
						
						$permalink_url = get_permalink($gallery_ID);
					
						$return_html.= '<div class="one_half_bg nopadding gallery_type animated'.esc_attr($key+1).' slideUp" style="background:url('.esc_url($small_image_url[0]).');height:'.intval($height/2).'px;">';
						$return_html.= '<a href="'.esc_url($permalink_url).'"></a>';
						$return_html.= '<div class="portfolio_title">
						    <div class="image_caption">
						    	<h6>'.$gallery->post_title.'</h6>
						    </div>
						</div>';
						$return_html.= '</div>';
					}
				}
				
				if($count_galleries > 2)
				{
					$return_html.= '<div class="one_half_bg term_link" style="line-height:'.intval($height/2.1).'px;height:'.intval($height/2).'px;">';
					$return_html.= '<a href="'.esc_url($term_link).'" class="button">'.esc_html__('More', 'grandphotography-translation' ).' '.esc_html($term_title).'</a>';
					$return_html.= '</div>';
					
					$return_html.= '</div>';
				}
				else
				{
					$return_html.= '<div class="one_half_bg nopadding">';
					$return_html.= '<div class="one_half_bg term_link" style="line-height:'.intval($height/2.1).'px;height:'.intval($height/2).'px;">';
					$return_html.= '<a href="'.esc_url($term_link).'" class="button">'.esc_html__('More', 'grandphotography-translation' ).' '.esc_html($term_title).'</a>';
					$return_html.= '</div>';
					$return_html.= '</div>';
				}
			}
		}
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_collection', 'ppb_collection_func');


function ppb_image_fullwidth_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'image' => '',
		'height' => 400,
		'display_caption' => 1,
		'background_position' => 'center',
		'padding' => 0,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));

	if(!is_numeric($height))
	{
		$height = 400;
	}
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' ppb_image_fullwidth" ';
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="one withbg"';
	
	if(!empty($image))
	{
		$return_html.= ' style="background-image:url('.esc_url($image).');background-size:cover;background-position:center '.esc_attr($background_position).';height:'.esc_attr($height).'px;position:relative;"';
	}
	
	$return_html.= '>';
	$return_html.= '</div>';
	
	if(!empty($display_caption))
	{
		//Get image meta data
		$image_id = grandphotography_get_image_id($image);
		$image_caption = get_post_field('post_excerpt', $image_id);
		
		if(!empty($image_caption))
		{
			$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_image_fullwidth', 'ppb_image_fullwidth_func');


function ppb_image_parallax_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'title' => '',
		'slug' => '',
		'image' => '',
		'height' => 80,
		'display_caption' => 1,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	if(!is_numeric($height))
	{
		$height = 80;
	}
	
	if($height > 100)
	{
		$height = 100;
	}
	
	$image_id = '';
	
	//Set begin wrapper div for live builder
	$return_html = grandphotography_live_builder_begin_wrapper($builder_id);

	$return_html.= '<div '.$sec_id.' class="parallax ';
	$return_html.= '" ';
	
	if(!empty($image))
	{
		$custom_css.= 'background-image: url('.esc_url($image).');';
	}
		
	if(!empty($height))
	{
		$custom_css.= 'height:'.$height.'vh; ';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'"';
	}
	
	$return_html.= '>';
	
	$return_html.= '</div>';
	
	if(!empty($display_caption))
	{
		//Get image meta data
		$image_id = grandphotography_get_image_id($image);
		$image_caption = get_post_field('post_excerpt', $image_id);
		
		if(!empty($image_caption))
		{
			$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		}
	}

	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);

	return $return_html;
}

add_shortcode('ppb_image_parallax', 'ppb_image_parallax_func');


function ppb_image_fixed_width_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'image' => '',
		'display_caption' => 1,
		'padding' => 0,
		'lightbox' => 0,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';

	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' ppb_image_fixed_width" ';
	
	$custom_css.= 'padding-top:'.esc_attr($padding).'px;padding-bottom'.esc_attr($padding).'px;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper">';
	
	if(!empty($image))
	{
		$image_id = grandphotography_get_image_id($image);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
		$return_html.= '<div class="image_classic_frame"><div class="image_wrapper">';
		
		if(!empty($lightbox))
		{
			$return_html.= '<a href="'.esc_url($image).'" class="img_frame">';
		}
		
		$return_html.= '<img src="'.esc_url($image).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
		
		if(!empty($lightbox))
		{
			$return_html.= '</a>';
		}
		
		$return_html.= '</div>';
	}
	
	if(!empty($display_caption))
	{
		//Get image meta data
		$image_id = grandphotography_get_image_id($image);
		$image_caption = get_post_field('post_excerpt', $image_id);
		
		if(!empty($image_caption))
		{
			$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		}
	}
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_image_fixed_width', 'ppb_image_fixed_width_func');


function ppb_content_half_bg_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'background' => '',
		'background_parallax' => '',
		'background_position' => '',
		'padding' => 30,
		'bgcolor' => '#000000',
		'opacity' => 100,
		'fontcolor' => '',
		'align' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'parallax' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($bgcolor))
	{
		$bgcolor = '#ffffff';
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_content_half_bg ';
	
	if(!empty($background))
	{
		$return_html.= 'withbg ';
		$custom_css.= 'background-image:url('.esc_url($background).');';
	}
	
	$parallax_stellar = '';
	if(!empty($parallax))
	{
		$return_html.= 'parallax ';
		$parallax_stellar.= 'data-stellar-ratio="1.3"';
	}
	
	if(!empty($background_position))
	{
		$custom_css.= 'background-position: center '.esc_attr($background_position).';';
	}
	
	$return_html.= '"';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper"><div class="page_content_wrapper"><div class="inner">';
	
	if(!empty($title) OR !empty($subtitle) OR !empty($content))
	{
		$custom_bgcolor_css = '';
		if(!empty($bgcolor))
		{
			$ori_bgcolor = $bgcolor;
			$opacity = $opacity/100;
			$bgcolor = grandphotography_hex_to_rgb($bgcolor);
		
			$custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
			$custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
			$custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
		}
		
		$custom_css_fontcolor = '';
		$custom_css_bordercolor = '';
		if(!empty($fontcolor))
		{
			$custom_css.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
		}
	
		if($align == 'left')
		{
			$return_html.= '<div class="one_half_bg" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).'" '.$parallax_stellar.'>';
		}
		else
		{
			$return_html.= '<div class="one_half_bg floatright" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).'" '.$parallax_stellar.'>';
		}
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		$return_html.= '</div>';
	}
	
	$return_html.= '</div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_content_half_bg', 'ppb_content_half_bg_func');


function ppb_content_center_bg_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'background' => '',
		'background_parallax' => '',
		'background_position' => '',
		'padding' => 30,
		'height' => 600,
		'bgcolor' => '#000000',
		'opacity' => 100,
		'fontcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'parallax' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($bgcolor))
	{
		$bgcolor = '#ffffff';
	}
	
	if(empty($height))
	{
		$height = 600;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_content_center_bg ';
	
	if(!empty($background))
	{
		$return_html.= 'withbg ';
		$custom_css.= 'background-image:url('.esc_url($background).');';
	}
	
	$parallax_stellar = '';
	if(!empty($parallax))
	{
		$return_html.= 'parallax ';
		$parallax_stellar.= 'data-stellar-ratio="1.3"';
	}
	
	if(!empty($background_position))
	{
		$custom_css.= 'background-position: center '.esc_attr($background_position).';';
	}
	
	if(!empty($height))
	{
		$custom_css.= 'height:'.intval($height).'px;';
	}
	
	$return_html.= '"';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if(!empty($title) OR !empty($subtitle) OR !empty($content))
	{
		$custom_bgcolor_css = '';
		if(!empty($bgcolor))
		{
			$ori_bgcolor = $bgcolor;
			$opacity = $opacity/100;
			$bgcolor = grandphotography_hex_to_rgb($bgcolor);
		
			$custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
			$custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
			$custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
		}
		
		$custom_css_fontcolor = '';
		$custom_css_bordercolor = '';
		if(!empty($fontcolor))
		{
			$custom_css.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
		}
	
		$return_html.= '<div class="one_third" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).';padding:'.esc_attr($padding).'px;" '.$parallax_stellar.'>';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		$return_html.= '</div>';
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_content_center_bg', 'ppb_content_center_bg_func');


function ppb_image_half_fixed_width_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'image' => '',
		'align' => 1,
		'padding' => 0,
		'bgcolor' => '',
		'fontcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($align))
	{
		$align = 'left';
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).'" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	$custom_css_fontcolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
	}
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper"><div class="page_content_wrapper"><div class="inner">';
	
	if($align=='left')
	{
		$return_html.= '<div class="one_half">';
		if(!empty($image))
		{
			$image_id = grandphotography_get_image_id($image);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
		
			$return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
			$return_html.= '<a href="'.esc_url($image).'" class="img_frame"><img src="'.esc_url($image).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/></a>';
			$return_html.= '</div></div>';
		}
		$return_html.= '</div>';
		
		$return_html.= '<div class="one_half last content_middle" style="padding:'.esc_attr($padding).'px;">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		//Add title and content
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		
		$return_html.= '</div>';
	}
	else
	{	
		$return_html.= '<div class="one_half content_middle textright" style="padding:'.esc_attr($padding).'px;">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		//Add title and content
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		
		$return_html.= '</div>';
		
		$return_html.= '<div class="one_half last">';
		if(!empty($image))
		{
			$image_id = grandphotography_get_image_id($image);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
		
			$return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
			$return_html.= '<a href="'.esc_url($image).'" class="img_frame"><img src="'.esc_url($image).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/></a>';
			$return_html.= '</div></div>';
		}
		$return_html.= '</div>';
	}
	
	$return_html.= '<br class="clear"/></div>';
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_image_half_fixed_width', 'ppb_image_half_fixed_width_func');


function ppb_image_half_fullwidth_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'image' => '',
		'height' => 500,
		'align' => 1,
		'padding' => 0,
		'bgcolor' => '',
		'fontcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'parallax' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($align))
	{
		$align = 'left';
	}
	
	if(!is_numeric($height))
	{
		$height = 500;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).'" ';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$content_custom_css = '';
	if($align=='left')
	{
		$return_html.= '<div class="one_half_bg';
		
		if(!empty($parallax))
		{
			$return_html.= ' parallax';
		}
		
		$return_html.= '"';
		
		if(!empty($image))
		{
			$return_html.= ' style="background-image:url('.esc_url($image).');height:'.esc_attr($height).'px;"';
		}
		$return_html.= '></div>';
		
		$content_custom_css.= 'style="padding:'.esc_attr($padding).'px;"';
		$return_html.= '<div class="one_half_bg" '.$content_custom_css.'>';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		
		$return_html.= '</div>';
	}
	else
	{	
		$content_custom_css.= 'style="padding:'.esc_attr($padding).'px;"';
		$return_html.= '<div class="one_half_bg textright" '.$content_custom_css.'>';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
	
		$return_html.= '</div>';
		
		$return_html.= '<div class="one_half_bg';
		
		if(!empty($parallax))
		{
			$return_html.= ' parallax';
		}
		
		$return_html.= '"';
		
		if(!empty($image))
		{
			$return_html.= ' style="background-image:url('.esc_url($image).');height:'.esc_attr($height).'px;"';
		}
		$return_html.= '></div>';
	}
	
	$return_html.= '<br class="clear"/>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_image_half_fullwidth', 'ppb_image_half_fullwidth_func');


function ppb_image_two_third_fullwidth_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'image' => '',
		'height' => 500,
		'align' => 1,
		'parallax' => 0,
		'bgcolor' => '',
		'fontcolor' => '',
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	if(empty($align))
	{
		$align = 'left';
	}
	
	if(!is_numeric($height))
	{
		$height = 500;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="ppb_image_two_third_fullwidth '.esc_attr($size).'" ';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$content_custom_css = '';
	if($align=='left')
	{
		$return_html.= '<div class="two_third_bg';
		
		if(!empty($parallax))
		{
			$return_html.= ' parallax';
		}
		
		$return_html.= '"';
		if(!empty($image))
		{
			$return_html.= ' style="background-image:url('.esc_url($image).');height:'.esc_attr($height).'px;"';
		}
		$return_html.= '></div>';
		
		$return_html.= '<div class="one_third_bg" style="height:'.esc_attr($height).'px;">';
		
		$return_html.= '<div class="center_wrapper"><div class="inner_content">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		//Add title and content
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		
		$return_html.= '</div>';
		$return_html.= '</div>';
		$return_html.= '</div>';
	}
	else
	{	
		$return_html.= '<div class="one_third_bg textright" style="height:'.esc_attr($height).'px;">';
		
		$return_html.= '<div class="center_wrapper"><div class="inner_content">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		//Add title and content
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
	
		$return_html.= '</div>';
		$return_html.= '</div>';
		$return_html.= '</div>';
		
		$return_html.= '<div class="two_third_bg';
		
		if(!empty($parallax))
		{
			$return_html.= ' parallax';
		}
		
		$return_html.= '"';
		if(!empty($image))
		{
			$return_html.= ' style="background-image:url('.esc_url($image).');height:'.esc_attr($height).'px;"';
		}
		$return_html.= '></div>';
	}
	
	$return_html.= '<br class="clear"/>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_image_two_third_fullwidth', 'ppb_image_two_third_fullwidth_func');


function ppb_two_cols_images_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'image1' => '',
		'image2' => '',
		'display_caption' => 1,
		'padding' => 0,
		'lightbox' => 0,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' ppb_two_cols_images" ';
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';

	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper">';
	
	$return_html.= '<div class="one_half">';
	if(!empty($image1))
	{
		$image_id = grandphotography_get_image_id($image1);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{	
	    	$return_html.= '<a href="'.esc_url($image1).'" class="img_frame">';
	    }
	    	$return_html.= '<img src="'.esc_url($image1).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    	
	    if(!empty($lightbox))
		{
	    	$return_html.= '</a>';
	    }
	    
	    $return_html.= '</div>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image1);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div>';
	
	$return_html.= '<div class="one_half last">';
	if(!empty($image2))
	{
		$image_id = grandphotography_get_image_id($image2);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{	
	    	$return_html.= '<a href="'.esc_url($image2).'" class="img_frame">';
	    }
	    	$return_html.= '<img src="'.esc_url($image2).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    	
	    if(!empty($lightbox))
		{
	    	$return_html.= '</a>';
	    }
	    
	    $return_html.= '</div>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image2);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_two_cols_images', 'ppb_two_cols_images_func');


function ppb_two_cols_images_no_space_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'image1' => '',
		'image2' => '',
		'height' => 600,
		'parallax' => 0,
		'display_caption' => 1,
		'padding' => 0,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).'" ';
	$custom_css = '';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner" style="padding:0;">';
	
	if(!empty($image1) && !empty($height))
	{
		$return_html.= '<div class="one_half_bg';
		
		if(!empty($parallax))
		{
			$return_html.= ' parallax';
		}
		
		$return_html.= '"';
		$return_html.= 'style="background-image:url(\''.$image1.'\');height:'.$height.'px;"';
		$return_html.= '>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image1);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	
	if(!empty($image2) && !empty($height))
	{
		$return_html.= '<div class="one_half_bg';
		
		if(!empty($parallax))
		{
			$return_html.= ' parallax';
		}
		
		$return_html.= '"';
		$return_html.= 'style="background-image:url(\''.$image2.'\');height:'.$height.'px;"';
		$return_html.= '>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image2);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_two_cols_images_no_space', 'ppb_two_cols_images_no_space_func');


function ppb_three_cols_images_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'image1' => '',
		'image2' => '',
		'image3' => '',
		'display_caption' => 1,
		'lightbox' => 0,
		'padding' => 0,
		'bgcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	$return_html.= '<div class="standard_wrapper">';
	$return_html.= '<div '.$sec_id.' class="ppb_three_cols_images '.esc_attr($size).'" ';
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	//First image
	$return_html.= '<div class="one_third">';
	if(!empty($image1))
	{
		$image_id = grandphotography_get_image_id($image1);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{
	    	$return_html.= '<a href="'.esc_url($image1).'" class="img_frame">';
	    }
	    $return_html.= '<img src="'.esc_url($image1).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    
	    if(!empty($lightbox))
		{
			$return_html.= '</a>';
		}
	    $return_html.= '</div>';
	    
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image1);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div>';
	
	//Second image
	$return_html.= '<div class="one_third">';
	if(!empty($image2))
	{
		$image_id = grandphotography_get_image_id($image2);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{
	    	$return_html.= '<a href="'.esc_url($image2).'" class="img_frame">';
	    }
	    $return_html.= '<img src="'.esc_url($image2).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    
	    if(!empty($lightbox))
		{
			$return_html.= '</a>';
		}
	    
	    $return_html.= '</div>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image2);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div>';
	
	//Third image
	$return_html.= '<div class="one_third last">';
	if(!empty($image3))
	{
		$image_id = grandphotography_get_image_id($image3);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{
	    	$return_html.= '<a href="'.esc_url($image3).'" class="img_frame">';
	    }
	    $return_html.= '<img src="'.esc_url($image3).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    
	    if(!empty($lightbox))
		{
			$return_html.= '</a>';
		}
	    
	    $return_html.= '</div>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image3);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div></div>';
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_three_cols_images', 'ppb_three_cols_images_func');


function ppb_three_images_block_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'image_portrait' => '',
		'image_portrait_align' => 'left',
		'image2' => '',
		'image3' => '',
		'display_caption' => 1,
		'lightbox' => 0,
		'padding' => 0,
		'bgcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($image_portrait_align))
	{
		$image_portrait_align = 'left';
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	$return_html.= '<div class="standard_wrapper">';
	$return_html.= '<div '.$sec_id.' class="ppb_three_images_block '.esc_attr($size).'" ';
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	if($image_portrait_align=='left')
	{
		//First column
		$return_html.= '<div class="one_half">';
		if(!empty($image_portrait))
		{
			$image_id = grandphotography_get_image_id($image_portrait);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
		
		    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
		    
		    if(!empty($lightbox))
			{
		    	$return_html.= '<a href="'.esc_url($image_portrait).'" class="img_frame">';
		    }	
		    $return_html.= '<img src="'.esc_url($image_portrait).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
		    if(!empty($lightbox))
			{
		    	$return_html.= '</a>';
		    }
		    
		    $return_html.= '</div>';
		    if(!empty($display_caption))
		    {
		    	//Get image meta data
		    	$image_id = grandphotography_get_image_id($image_portrait);
		    	$image_caption = get_post_field('post_excerpt', $image_id);
		    	
		    	if(!empty($image_caption))
		    	{
		    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		    	}
		    }
		    $return_html.= '</div>';
		}
		$return_html.= '</div>';
		
		//Second column
		$return_html.= '<div class="one_half last">';
		if(!empty($image2))
		{
			$image_id = grandphotography_get_image_id($image2);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
		
		    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
		    
		    if(!empty($lightbox))
			{
		    	$return_html.= '<a href="'.esc_url($image2).'" class="img_frame">';
		    }	
		    $return_html.= '<img src="'.esc_url($image2).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
		    if(!empty($lightbox))
			{
		    	$return_html.= '</a>';
		    }
		    
		    $return_html.= '</div>';
		    if(!empty($display_caption))
		    {
		    	//Get image meta data
		    	$image_id = grandphotography_get_image_id($image2);
		    	$image_caption = get_post_field('post_excerpt', $image_id);
		    	
		    	if(!empty($image_caption))
		    	{
		    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		    	}
		    }
		    $return_html.= '</div>';
		}
		
		if(!empty($image3))
		{
			$image_id = grandphotography_get_image_id($image3);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
		
		    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
		    
		    if(!empty($lightbox))
			{
		    	$return_html.= '<a href="'.esc_url($image3).'" class="img_frame">';
		    }	
		    $return_html.= '<img src="'.esc_url($image3).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
		    if(!empty($lightbox))
			{
		    	$return_html.= '</a>';
		    }
		    
		    $return_html.= '</div>';
		    if(!empty($display_caption))
		    {
		    	//Get image meta data
		    	$image_id = grandphotography_get_image_id($image3);
		    	$image_caption = get_post_field('post_excerpt', $image_id);
		    	
		    	if(!empty($image_caption))
		    	{
		    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		    	}
		    }
		    $return_html.= '</div>';
		}
		
		$return_html.= '</div>';
	}
	else
	{
		//First column
		$return_html.= '<div class="one_half">';
		if(!empty($image2))
		{
			$image_id = grandphotography_get_image_id($image2);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
		
		    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
		    
		    if(!empty($lightbox))
			{
		    	$return_html.= '<a href="'.esc_url($image2).'" class="img_frame">';
		    }	
		    $return_html.= '<img src="'.esc_url($image2).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
		    if(!empty($lightbox))
			{
		    	$return_html.= '</a>';
		    }
		    
		    $return_html.= '</div>';
		    if(!empty($display_caption))
		    {
		    	//Get image meta data
		    	$image_id = grandphotography_get_image_id($image2);
		    	$image_caption = get_post_field('post_excerpt', $image_id);
		    	
		    	if(!empty($image_caption))
		    	{
		    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		    	}
		    }
		    $return_html.= '</div>';
		}
		
		if(!empty($image3))
		{
			$image_id = grandphotography_get_image_id($image3);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
		
		    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
		    
		    if(!empty($lightbox))
			{
		    	$return_html.= '<a href="'.esc_url($image3).'" class="img_frame">';
		    }	
		    $return_html.= '<img src="'.esc_url($image3).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
		    if(!empty($lightbox))
			{
		    	$return_html.= '</a>';
		    }
		    
		    $return_html.= '</div>';
		    if(!empty($display_caption))
		    {
		    	//Get image meta data
		    	$image_id = grandphotography_get_image_id($image3);
		    	$image_caption = get_post_field('post_excerpt', $image_id);
		    	
		    	if(!empty($image_caption))
		    	{
		    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		    	}
		    }
		    $return_html.= '</div>';
		}
		
		$return_html.= '</div>';
		
		//Second column
		$return_html.= '<div class="one_half last">';
		if(!empty($image_portrait))
		{
			$image_id = grandphotography_get_image_id($image_portrait);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
		
		    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
		    
		    if(!empty($lightbox))
			{
		    	$return_html.= '<a href="'.esc_url($image_portrait).'" class="img_frame">';
		    }	
		    $return_html.= '<img src="'.esc_url($image_portrait).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
		    if(!empty($lightbox))
			{
		    	$return_html.= '</a>';
		    }
		    
		    $return_html.= '</div>';
		    if(!empty($display_caption))
		    {
		    	//Get image meta data
		    	$image_id = grandphotography_get_image_id($image_portrait);
		    	$image_caption = get_post_field('post_excerpt', $image_id);
		    	
		    	if(!empty($image_caption))
		    	{
		    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
		    	}
		    }
		    $return_html.= '</div>';
		}
		$return_html.= '</div>';
	}
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	$return_html.= '<div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_three_images_block', 'ppb_three_images_block_func');


function ppb_four_images_block_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'image1' => '',
		'image2' => '',
		'image3' => '',
		'image4' => '',
		'display_caption' => 1,
		'lightbox' => 0,
		'padding' => 0,
		'bgcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	$return_html.= '<div class="standard_wrapper">';
	$return_html.= '<div '.$sec_id.' class="ppb_four_images_block '.esc_attr($size).'" ';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	//First image
	$return_html.= '<div class="one_half grid4">';
	if(!empty($image1))
	{
		$image_id = grandphotography_get_image_id($image1);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{
	    	$return_html.= '<a href="'.esc_url($image1).'" class="img_frame">';
	    }
	    $return_html.= '<img src="'.esc_url($image1).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    if(!empty($lightbox))
		{
	    	$return_html.= '</a>';
	    }
	    
	    $return_html.= '</div>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image1);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div>';
	
	//Second image
	$return_html.= '<div class="one_half last grid4">';
	if(!empty($image2))
	{
		$image_id = grandphotography_get_image_id($image2);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{
	    	$return_html.= '<a href="'.esc_url($image2).'" class="img_frame">';
	    }
	    $return_html.= '<img src="'.esc_url($image2).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    if(!empty($lightbox))
		{
	    	$return_html.= '</a>';
	    }
	    
	    $return_html.= '</div>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image2);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div>';
	
	$return_html.= '<br class="clear"/>';
	
	//Third image
	$return_html.= '<div class="one_half grid4">';
	if(!empty($image3))
	{
		$image_id = grandphotography_get_image_id($image3);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{
	    	$return_html.= '<a href="'.esc_url($image3).'" class="img_frame">';
	    }
	    $return_html.= '<img src="'.esc_url($image3).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    if(!empty($lightbox))
		{
	    	$return_html.= '</a>';
	    }
	    
	    $return_html.= '</div>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image3);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div>';
	
	//Fourth image
	$return_html.= '<div class="one_half last grid4">';
	if(!empty($image4))
	{
		$image_id = grandphotography_get_image_id($image4);
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
	
	    $return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
	    
	    if(!empty($lightbox))
		{
	    	$return_html.= '<a href="'.esc_url($image4).'" class="img_frame">';
	    }
	    $return_html.= '<img src="'.esc_url($image4).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
	    if(!empty($lightbox))
		{
	    	$return_html.= '</a>';
	    }
	    
	    $return_html.= '</div>';
	    if(!empty($display_caption))
	    {
	    	//Get image meta data
	    	$image_id = grandphotography_get_image_id($image4);
	    	$image_caption = get_post_field('post_excerpt', $image_id);
	    	
	    	if(!empty($image_caption))
	    	{
	    		$return_html.= '<div class="ppb_image_caption">'.$image_caption.'</div>';
	    	}
	    }
	    $return_html.= '</div>';
	}
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	$return_html.= '</div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_four_images_block', 'ppb_four_images_block_func');


function ppb_metro_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'image1' => '',
		'image2' => '',
		'image3' => '',
		'image4' => '',
		'image5' => '',
		'height' => 600,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	$return_html.= '<div '.$sec_id.' class="ppb_metro '.esc_attr($size).'" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if(!empty($image1))
	{
		//First image
		$return_html.= '<div class="one_half_bg nopadding" style="background:url('.esc_url($image1).');height:'.intval($height).'px;"></div>';
	}
	
	if(!empty($image2))
	{
		$return_html.= '<div class="one_half_bg nopadding">';
		
		$return_html.= '<div class="one_half_bg" style="background:url('.esc_url($image2).');height:'.intval($height/2).'px;"></div>';
		
		if(!empty($image3))
		{
			$return_html.= '<div class="one_half_bg" style="background:url('.esc_url($image3).');height:'.intval($height/2).'px;"></div>';
		}
		
		if(!empty($image4))
		{
			$return_html.= '<div class="one_half_bg" style="background:url('.esc_url($image4).');height:'.intval($height/2).'px;"></div>';
		}
		
		if(!empty($image5))
		{
			$return_html.= '<div class="one_half_bg" style="background:url('.esc_url($image5).');height:'.intval($height/2).'px;"></div>';
		}
		
	    $return_html.= '</div>';
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_metro', 'ppb_metro_func');


function ppb_portfolio_slider_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 9,
		'cat' => '',
		'order' => 'default',
		'autoplay' => '',
		'timer' => 5,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 9;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_portfolio '.$size.' nopadding ';
	
	$return_html.= '" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$portfolio_order = 'ASC';
	$portfolio_order_by = 'menu_order';
	switch($order)
	{
		case 'default':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'menu_order';
		break;
		
		case 'newest':
			$portfolio_order = 'DESC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'oldest':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'title':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'title';
		break;
		
		case 'random':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'rand';
		break;
	}
	
	//Get portfolio items
	$args = array(
	    'numberposts' => $items,
	    'order' => $portfolio_order,
	    'orderby' => $portfolio_order_by,
	    'post_type' => array('portfolios'),
	    'suppress_filters' => false,
	);
	
	if(!empty($cat))
	{
		$args['portfoliosets'] = $cat;
	}
	
	$portfolios_arr = get_posts($args);
	
	if(!empty($portfolios_arr) && is_array($portfolios_arr))
	{
		wp_enqueue_script("flexslider", get_template_directory_uri()."/js/flexslider/jquery.flexslider-min.js", false, THEMEVERSION, true);
		wp_enqueue_script("script-gallery-flexslider", admin_url('admin-ajax.php')."?action=grandphotography_script_portfolio_flexslider&autoplay=".$autoplay.'&timer='.$timer, false, THEMEVERSION, true);
	
		$return_html.= '<div class="slider_wrapper portfolio">';
		$return_html.= '<div class="flexslider tg_gallery" data-height="750">';
		$return_html.= '<ul class="slides">';
	
		foreach($portfolios_arr as $key => $portfolio)
		{
			$image_url = '';
			$portfolio_ID = $portfolio->ID;
					
			if(has_post_thumbnail($portfolio_ID, 'original'))
			{
			    $image_id = get_post_thumbnail_id($portfolio_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			}
			
			$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
			
			if(empty($portfolio_link_url))
			{
			    $permalink_url = get_permalink($portfolio_ID);
			}
			else
			{
			    $permalink_url = $portfolio_link_url;
			}
			
			//Begin display HTML
			$return_html.= '<li>';
			
			if(!empty($image_url[0]))
			{
				$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
			    $portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
			    
			    switch($portfolio_type)
			    {
				    case 'External Link':
						$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
				
						$return_html.= '<a target="_blank" href="'.esc_url($portfolio_link_url).'">';
				        
				    break;
				    //end external link
				    
				    case 'Portfolio Content':
	        	    default:
	
			        	$return_html.= '<a href="'.get_permalink($portfolio_ID).'">';
		        
				    break;
				    //end external link
	        	    
	        	    case 'Image':
				
						$return_html.= '<a data-caption="'.esc_attr($portfolio->post_title).'" href="'.esc_url($image_url[0]).'" class="fancy-gallery">';
				
				    break;
				    //end image
				    
				    case 'Youtube Video':
				
						$return_html.= '<a href="https://www.youtube.com/embed/'.esc_attr($portfolio_video_id).'" class="lightbox_youtube" data-options="width:1425, height:802">';
				
				    break;
				    //end youtube
				
				case 'Vimeo Video':
	
						$return_html.= '<a href="https://player.vimeo.com/video/'.esc_attr($portfolio_video_id).'?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802">';
				
				    break;
				    //end vimeo
				    
					case 'Self-Hosted Video':
				
				    //Get video URL
				    $portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
				    $preview_image = wp_get_attachment_image_src($image_id, 'large', true);
				    
						$return_html.= '<a href="'.esc_url($portfolio_mp4_url).'" class="lightbox_vimeo">';
				
				    break;
				    //end self-hosted
			    }
			    //end switch
			}
			
			//Display portfolio detail
			if(isset($image_url[0]) && !empty($image_url[0]))
			{
				$return_html.= '<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>';
			}
			
			$return_html.= '<div class="portfolio_title">';
            $return_html.= '<div class="image_caption"><h4>'.$portfolio->post_title.'</h4></div>';
            $return_html.= '</div>';
            $return_html.= '</a>';
			$return_html.= '</li>';
		}
	}
	
	$return_html.= '</ul></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_portfolio_slider', 'ppb_portfolio_slider_func');


function ppb_portfolio_classic_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 9,
		'cat' => '',
		'columns' => 2,
		'order' => 'default',
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'filterable' => 'hide',
		'layout' => 'contain',
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 9;
	}
	$all_items = $items;
	
	if(!is_numeric($columns))
	{
		$columns = 2;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_portfolio_classic '.$size.' nopadding ';
	
	$return_html.= '" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.='<div class="page_content_wrapper page_main_content sidebar_content full_width fixed_column photoframe">';
	
	$portfolio_order = 'ASC';
	$portfolio_order_by = 'menu_order';
	switch($order)
	{
		case 'default':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'menu_order';
		break;
		
		case 'newest':
			$portfolio_order = 'DESC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'oldest':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'title':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'title';
		break;
		
		case 'random':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'rand';
		break;
	}
	
	//Get portfolio items
	$args = array(
	    'numberposts' => $items,
	    'order' => $portfolio_order,
	    'orderby' => $portfolio_order_by,
	    'post_type' => array('portfolios'),
	    'suppress_filters' => false,
	);
	
	if(!empty($cat))
	{
		$args['portfoliosets'] = $cat;
	}
	
	$portfolios_arr = get_posts($args);
	
	$custom_id = time().rand();
	
	$wrapper_class = '';
	$grid_wrapper_class = '';
	$column_class = '';
	
	switch($columns)
	{
		case 2:
			$wrapper_class = 'two_cols';
			$grid_wrapper_class = 'classic2_cols';
			$column_class = 'one_half gallery2';
		break;
		
		case 3:
			$wrapper_class = 'three_cols';
			$grid_wrapper_class = 'classic3_cols';
			$column_class = 'one_third gallery3';
		break;
		
		case 4:
			$wrapper_class = 'four_cols';
			$grid_wrapper_class = 'classic4_cols';
			$column_class = 'one_fourth gallery4';
		break;
	}
	
	wp_enqueue_script("grandphotography-custom-grid-portfolio-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=".$columns."&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gutter=30&photoframe=1"), false, THEMEVERSION, true);
	
	if(!empty($portfolios_arr) && is_array($portfolios_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery '.esc_attr($wrapper_class).'" data-columns="'.esc_attr($columns).'">';
	
		foreach($portfolios_arr as $key => $portfolio)
		{
			$image_url = '';
			$portfolio_ID = $portfolio->ID;
					
			if(has_post_thumbnail($portfolio_ID, 'original'))
			{
			    $image_id = get_post_thumbnail_id($portfolio_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			    
			    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
			}
			
			$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
			
			if(empty($portfolio_link_url))
			{
			    $permalink_url = get_permalink($portfolio_ID);
			}
			else
			{
			    $permalink_url = $portfolio_link_url;
			}
			
			//Begin display HTML
			$return_html.= '<div class="element grid photoframe fixed_columns '.esc_attr($grid_wrapper_class).' animated'.($key+1).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' classic filterable portfolio_type">';
			
			if(!empty($image_url[0]))
			{
				$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
			    $portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
			    
			    switch($portfolio_type)
			    {
				    case 'External Link':
						$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
				
						$return_html.= '<a target="_blank" href="'.esc_url($portfolio_link_url).'"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
							<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
						</a>';
				        
				    break;
				    //end external link
				    
				    case 'Portfolio Content':
	        	    default:
	
			        	$return_html.= '<a href="'.get_permalink($portfolio_ID).'"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
			        		<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
			        	</a>';
		        
				    break;
				    //end external link
	        	    
	        	    case 'Image':
				
						$return_html.= '<a data-caption="'.esc_attr($portfolio->post_title).'" href="'.esc_url($image_url[0]).'" class="fancy-gallery"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
							<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
						</a>';
				
				    break;
				    //end image
				    
				    case 'Youtube Video':
				
						$return_html.= '<a href="https://www.youtube.com/embed/'.esc_attr($portfolio_video_id).'" class="lightbox_youtube" data-options="width:1425, height:802"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
							<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						</a>';
				
				    break;
				    //end youtube
				
				case 'Vimeo Video':
	
						$return_html.= '<a href="https://player.vimeo.com/video/'.esc_attr($portfolio_video_id).'?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
							<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						</a>';
				
				    break;
				    //end vimeo
				    
				case 'Self-Hosted Video':
				
				    //Get video URL
				    $portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
				    $preview_image = wp_get_attachment_image_src($image_id, 'large', true);
				    
						$return_html.= '<a title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($portfolio_mp4_url).'" class="lightbox_vimeo"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
							<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						</a>';
				
				    break;
				    //end self-hosted
			    }
			    //end switch
			}
			$return_html.= '</div>';
			
			//Display portfolio detail
			$return_html.= '<div class="gallery_info_wrapper">';
            $return_html.= '<h5>'.$portfolio->post_title.'</h5>';
			$return_html.= '</div>';
			
			$return_html.= '</div>';
		}
		
		$return_html.= '</div>';
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_portfolio_classic', 'ppb_portfolio_classic_func');


function ppb_portfolio_grid_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 9,
		'cat' => '',
		'columns' => 2,
		'order' => 'default',
		'custom_css' => '',
		'layout' => 'contain',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 9;
	}
	$all_items = $items;
	
	if(!is_numeric($columns))
	{
		$columns = 2;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_portfolio_grid '.$size.' nopadding ';
	
	$return_html.= '" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.='<div class="page_content_wrapper">';
	
	$portfolio_order = 'ASC';
	$portfolio_order_by = 'menu_order';
	switch($order)
	{
		case 'default':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'menu_order';
		break;
		
		case 'newest':
			$portfolio_order = 'DESC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'oldest':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'title':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'title';
		break;
		
		case 'random':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'rand';
		break;
	}
	
	//Get portfolio items
	$args = array(
	    'numberposts' => $items,
	    'order' => $portfolio_order,
	    'orderby' => $portfolio_order_by,
	    'post_type' => array('portfolios'),
	    'suppress_filters' => false,
	);
	
	if(!empty($cat))
	{
		$args['portfoliosets'] = $cat;
	}
	
	$portfolios_arr = get_posts($args);
	
	$custom_id = time().rand();
	
	$wrapper_class = '';
	$grid_wrapper_class = '';
	$column_class = '';
	
	switch($columns)
	{
		case 2:
			$wrapper_class = 'two_cols';
			$grid_wrapper_class = 'classic2_cols';
			$column_class = 'one_half gallery2';
		break;
		
		case 3:
			$wrapper_class = 'three_cols';
			$grid_wrapper_class = 'classic3_cols';
			$column_class = 'one_third gallery3';
		break;
		
		case 4:
			$wrapper_class = 'four_cols';
			$grid_wrapper_class = 'classic4_cols';
			$column_class = 'one_fourth gallery4';
		break;
	}
	
	wp_enqueue_script("grandphotography-custom-grid-portfolio-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=".$columns."&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id), false, THEMEVERSION, true);
	
	if(!empty($portfolios_arr) && is_array($portfolios_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery portfolio-content section content clearfix '.esc_attr($wrapper_class).' ' .esc_attr($layout).'" data-columns="'.esc_attr($columns).'">';
	
		foreach($portfolios_arr as $key => $portfolio)
		{
			$image_url = '';
			$portfolio_ID = $portfolio->ID;
					
			if(has_post_thumbnail($portfolio_ID, 'original'))
			{
			    $image_id = get_post_thumbnail_id($portfolio_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			    
			    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
			}
			
			$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
			
			if(empty($portfolio_link_url))
			{
			    $permalink_url = get_permalink($portfolio_ID);
			}
			else
			{
			    $permalink_url = $portfolio_link_url;
			}
			
			//Begin display HTML
			$return_html.= '<div class="element '.esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' filterable static animated'.($key+1).' portfolio_type">';
			
			if(!empty($image_url[0]))
			{
				$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
			    $portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
			    
			    switch($portfolio_type)
			    {
				    case 'External Link':
						$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
				
						$return_html.= '<a target="_blank" href="'.esc_url($portfolio_link_url).'"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h7>'.$portfolio->post_title.'</h7>
	        				</div>
					    </div></a>';
				        
				    break;
				    //end external link
				    
				    case 'Portfolio Content':
	        	    default:
	
			        	$return_html.= '<a href="'.get_permalink($portfolio_ID).'"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
			        	
			        	<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
			        	
			        	<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h7>'.$portfolio->post_title.'</h7>
	        				</div>
					    </div></a>';
		        
				    break;
				    //end external link
	        	    
	        	    case 'Image':
				
						$return_html.= '<a data-title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($image_url[0]).'" class="fancy-gallery"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h7>'.$portfolio->post_title.'</h7>
	        				</div>
					    </div></a>';
				
				    break;
				    //end image
				    
				    case 'Youtube Video':
				
						$return_html.= '<a href="https://www.youtube.com/embed/'.esc_attr($portfolio_video_id).'" class="lightbox_youtube" data-options="width:1425, height:802"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>

						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h7>'.$portfolio->post_title.'</h7>
	        				</div>
					    </div></a>';
				
				    break;
				    //end youtube
				
				case 'Vimeo Video':
	
						$return_html.= '<a href="https://player.vimeo.com/video/'.esc_attr($portfolio_video_id).'?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h7>'.$portfolio->post_title.'</h7>
	        				</div>
					    </div></a>';
				
				    break;
				    //end vimeo
				    
				case 'Self-Hosted Video':
				
				    //Get video URL
				    $portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
				    $preview_image = wp_get_attachment_image_src($image_id, 'large', true);
				    
						$return_html.= '<a title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($portfolio_mp4_url).'" class="lightbox_vimeo"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h7>'.$portfolio->post_title.'</h7>
	        				</div>
					    </div></a>';
				
				    break;
					//end self-hosted
			    }
			    //end switch
			}
			$return_html.= '</div>';
			
			$return_html.= '</div>';
		}
		
		$return_html.= '</div>';
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_portfolio_grid', 'ppb_portfolio_grid_func');


function ppb_portfolio_mixed_grid_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 9,
		'cat' => '',
		'order' => 'default',
		'custom_css' => '',
		'layout' => 'contain',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 9;
	}
	$original_items = $items;
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_portfolio_mixed_grid '.$size.' nopadding ';
	
	$return_html.= '" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$portfolio_order = 'ASC';
	$portfolio_order_by = 'menu_order';
	switch($order)
	{
		case 'default':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'menu_order';
		break;
		
		case 'newest':
			$portfolio_order = 'DESC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'oldest':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'title':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'title';
		break;
		
		case 'random':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'rand';
		break;
	}
	
	//Get portfolio items
	$args = array(
	    'numberposts' => $items,
	    'order' => $portfolio_order,
	    'orderby' => $portfolio_order_by,
	    'post_type' => array('portfolios'),
	    'suppress_filters' => false,
	);
	
	if(!empty($cat))
	{
		$args['portfoliosets'] = $cat;
	}
	
	$portfolios_arr = get_posts($args);
	
	//Get all portfolio items
	$args = array(
	    'numberposts' => -1,
	    'order' => $portfolio_order,
	    'orderby' => $portfolio_order_by,
	    'post_type' => array('portfolios'),
	    'suppress_filters' => false,
	);
	
	if(!empty($cat))
	{
		$args['portfoliosets'] = $cat;
	}
	
	$portfolios_all_arr = get_posts($args);
	$custom_id = time().rand();
	
	wp_enqueue_script("grandphotography-custom-grid-portfolio-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=3&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&type=metro"), false, THEMEVERSION, true);
	
	if(!empty($portfolios_arr) && is_array($portfolios_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
		
		//Define columns class
		$wrapper_class = 'three_cols';
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_mixed_filter_wrapper gallery portfolio-content section content clearfix '.esc_attr($wrapper_class).' ' .esc_attr($layout).'" data-columns="3">';
	
		$large_counter = 1;
		$next_number_to_add = 4;
		$next_trigger = 1;
		
		foreach($portfolios_arr as $key => $portfolio)
		{
			//Calculated columns size
			$grid_wrapper_class = 'classic3_cols';
			$column_class = 'one_third gallery3';
			$grandphotography_image_size = 'grandphotography-gallery-grid';
			
			$large_counter_trigger = FALSE;
			
			if($next_trigger == $key+1)
			{
				$large_counter_trigger = TRUE;
				$next_trigger = $next_trigger+$next_number_to_add;
				
				if($next_number_to_add == 4)
				{
					$next_number_to_add = 2;
				}
				else if($next_number_to_add==2)
				{
					$next_number_to_add = 4;
				}
			}
			
			if($large_counter_trigger)
			{
				$wrapper_class = 'three_cols double_size';
				$grid_wrapper_class = 'classic3_cols double_size';
				$column_class = 'one_third gallery3 double_size';
				$grandphotography_image_size = 'grandphotography-gallery-grid-large';
			}
			
			$large_counter++;
		
			$image_url = '';
			$portfolio_ID = $portfolio->ID;
					
			if(has_post_thumbnail($portfolio_ID, 'original'))
			{
			    $image_id = get_post_thumbnail_id($portfolio_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			    
			    $small_image_url = wp_get_attachment_image_src($image_id, $grandphotography_image_size, true);
			}
			
			$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
			
			if(empty($portfolio_link_url))
			{
			    $permalink_url = get_permalink($portfolio_ID);
			}
			else
			{
			    $permalink_url = $portfolio_link_url;
			}
			
			//Begin display HTML
			$return_html.= '<div class="element '.esc_attr($grid_wrapper_class).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' filterable static'.($key+1).' portfolio_type">';
			
			if(!empty($image_url[0]))
			{
				$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
			    $portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
			    
			    switch($portfolio_type)
			    {
				    case 'External Link':
						$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
				
						$return_html.= '<a target="_blank" href="'.esc_url($portfolio_link_url).'"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h5>'.$portfolio->post_title.'</h5>
	        				</div>
					    </div></a>';
				        
				    break;
				    //end external link
				    
				    case 'Portfolio Content':
	        	    default:
	
			        	$return_html.= '<a href="'.get_permalink($portfolio_ID).'"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
			        	
			        	<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
			        	
			        	<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h5>'.$portfolio->post_title.'</h5>
	        				</div>
					    </div></a>';
		        
				    break;
				    //end external link
	        	    
	        	    case 'Image':
				
						$return_html.= '<a data-title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($image_url[0]).'" class="fancy-gallery"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h5>'.$portfolio->post_title.'</h5>
	        				</div>
					    </div></a>';
				
				    break;
				    //end image
				    
				    case 'Youtube Video':
				
						$return_html.= '<a href="https://www.youtube.com/embed/'.esc_attr($portfolio_video_id).'" class="lightbox_youtube" data-options="width:1425, height:802"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>

						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h5>'.$portfolio->post_title.'</h5>
	        				</div>
					    </div></a>';
				
				    break;
				    //end youtube
				
				case 'Vimeo Video':
	
						$return_html.= '<a href="https://player.vimeo.com/video/'.esc_attr($portfolio_video_id).'?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h5>'.$portfolio->post_title.'</h5>
	        				</div>
					    </div></a>';
				
				    break;
				    //end vimeo
				    
				case 'Self-Hosted Video':
				
				    //Get video URL
				    $portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
				    $preview_image = wp_get_attachment_image_src($image_id, 'large', true);
				    
						$return_html.= '<a title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($portfolio_mp4_url).'" class="lightbox_vimeo"><img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div id="portfolio_desc_'.esc_attr($portfolio_ID).'" class="portfolio_title">
	        				<div class="image_caption">
	        					<h5>'.$portfolio->post_title.'</h5>
	        				</div>
					    </div></a>';
				
				    break;
					//end self-hosted
			    }
			    //end switch
			}
			$return_html.= '</div>';
			
			$return_html.= '</div>';
		}
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_portfolio_mixed_grid', 'ppb_portfolio_mixed_grid_func');


function ppb_portfolio_horizontal_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 9,
		'cat' => '',
		'custom_css' => '',
		'layout' => 'wide',
		'order' => 'default',
		'height' => 75,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$return_html = '<div class="ppb_portfolio_horizontal '.esc_attr($size).'" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode(esc_attr($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$portfolio_order = 'ASC';
	$portfolio_order_by = 'menu_order';
	switch($order)
	{
		case 'default':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'menu_order';
		break;
		
		case 'newest':
			$portfolio_order = 'DESC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'oldest':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'title':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'title';
		break;
		
		case 'random':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'rand';
		break;
	}
	
	//Get portfolio items
	$args = array(
	    'numberposts' => $items,
	    'order' => $portfolio_order,
	    'orderby' => $portfolio_order_by,
	    'post_type' => array('portfolios'),
	    'suppress_filters' => false,
	);
	
	if(!empty($cat))
	{
		$args['portfoliosets'] = $cat;
	}
	
	$portfolios_arr = get_posts($args);
	
	if(!empty($portfolios_arr) && is_array($portfolios_arr))
	{
		wp_enqueue_script("grandphotography-horizontal-gallery", get_template_directory_uri()."/js/horizontal_gallery.js", false, THEMEVERSION, true);
	
		//Check if select contained layout
		if($layout == 'contain')
		{
			$return_html.= '<div class="page_content_wrapper horizontal_gallery">';
		}
	
		$return_html.= '
		<div class="horizontal_gallery">
			<table class="horizontal_gallery_wrapper">
				<tbody><tr>';
		
		foreach($portfolios_arr as $key => $portfolio)
		{
		    $image_url = '';
			$portfolio_ID = $portfolio->ID;
					
			if(has_post_thumbnail($portfolio_ID, 'original'))
			{
			    $image_id = get_post_thumbnail_id($portfolio_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			}
			
			$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
			
			if(empty($portfolio_link_url))
			{
			    $permalink_url = get_permalink($portfolio_ID);
			}
			else
			{
			    $permalink_url = $portfolio_link_url;
			}
		 
		 	$return_html.= '<td>';
		 	
		 	if(!empty($image_url[0]))
			{
				$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
			    $portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
			    	
			    switch($portfolio_type)
			    {
				    case 'External Link':
						$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
				
						$return_html.= '<a target="_blank" href="'.esc_url($portfolio_link_url).'"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
						
						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				        
				    break;
				    //end external link
				    
				    case 'Portfolio Content':
	        	    default:
	
			        	$return_html.= '<a href="'.get_permalink($portfolio_ID).'"><div class="gallery_image_wrapper">
			        	
			        	<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
			        	
			        	<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
			        	
			        	<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
		        
				    break;
				    //end external link
	        	    
	        	    case 'Image':
				
						$return_html.= '<a data-title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($image_url[0]).'" class="fancy-gallery"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
						
						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				
				    break;
				    //end image
				    
				    case 'Youtube Video':
				
						$return_html.= '<a href="https://www.youtube.com/embed/'.esc_attr($portfolio_video_id).'" class="lightbox_youtube" data-options="width:1425, height:802"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>

						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				
				    break;
				    //end youtube
				
				case 'Vimeo Video':
	
						$return_html.= '<a href="https://player.vimeo.com/video/'.esc_attr($portfolio_video_id).'?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				
				    break;
				    //end vimeo
				    
				case 'Self-Hosted Video':
				
				    //Get video URL
				    $portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
				    $preview_image = wp_get_attachment_image_src($image_id, 'large', true);
				    
						$return_html.= '<a title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($portfolio_mp4_url).'" class="lightbox_vimeo"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				
				    break;
					//end self-hosted
			    }
			    //end switch
	    	}
		 	
		 	$return_html.= '</td>';   
		}
			
		$return_html.= '
				</tr></tbody>
			</table>
		</div>
		';
		
		//Check if select contained layout
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_portfolio_horizontal', 'ppb_portfolio_horizontal_func');


function ppb_portfolio_striped_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 9,
		'cat' => '',
		'custom_css' => '',
		'layout' => 'wide',
		'order' => 'default',
		'height' => 75,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$return_html = '<div class="ppb_portfolio_horizontal '.esc_attr($size).'" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode(esc_attr($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$portfolio_order = 'ASC';
	$portfolio_order_by = 'menu_order';
	switch($order)
	{
		case 'default':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'menu_order';
		break;
		
		case 'newest':
			$portfolio_order = 'DESC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'oldest':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'post_date';
		break;
		
		case 'title':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'title';
		break;
		
		case 'random':
			$portfolio_order = 'ASC';
			$portfolio_order_by = 'rand';
		break;
	}
	
	//Get portfolio items
	$args = array(
	    'numberposts' => $items,
	    'order' => $portfolio_order,
	    'orderby' => $portfolio_order_by,
	    'post_type' => array('portfolios'),
	    'suppress_filters' => false,
	);
	
	if(!empty($cat))
	{
		$args['portfoliosets'] = $cat;
	}
	
	$portfolios_arr = get_posts($args);
	
	if(!empty($portfolios_arr) && is_array($portfolios_arr))
	{
		wp_enqueue_script("grandphotography-horizontal-gallery", get_template_directory_uri()."/js/horizontal_gallery.js", false, THEMEVERSION, true);
	
		//Check if select contained layout
		if($layout == 'contain')
		{
			$return_html.= '<div class="page_content_wrapper horizontal_gallery">';
		}
	
		$return_html.= '
		<div class="horizontal_gallery">
			<table class="horizontal_gallery_wrapper">
				<tbody><tr>';
		
		foreach($portfolios_arr as $key => $portfolio)
		{
		    $image_url = '';
			$portfolio_ID = $portfolio->ID;
					
			if(has_post_thumbnail($portfolio_ID, 'grandphotography-gallery-striped'))
			{
			    $image_id = get_post_thumbnail_id($portfolio_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-striped', true);
			}
			
			$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
			
			if(empty($portfolio_link_url))
			{
			    $permalink_url = get_permalink($portfolio_ID);
			}
			else
			{
			    $permalink_url = $portfolio_link_url;
			}
		 
		 	$return_html.= '<td>';
		 	
		 	if(!empty($image_url[0]))
			{
				$portfolio_type = get_post_meta($portfolio_ID, 'portfolio_type', true);
			    $portfolio_video_id = get_post_meta($portfolio_ID, 'portfolio_video_id', true);
			    	
			    switch($portfolio_type)
			    {
				    case 'External Link':
						$portfolio_link_url = get_post_meta($portfolio_ID, 'portfolio_link_url', true);
				
						$return_html.= '<a target="_blank" href="'.esc_url($portfolio_link_url).'"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-external-link"></i></div>
						
						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				        
				    break;
				    //end external link
				    
				    case 'Portfolio Content':
	        	    default:
	
			        	$return_html.= '<a href="'.get_permalink($portfolio_ID).'"><div class="gallery_image_wrapper">
			        	
			        	<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
			        	
			        	<div class="portfolio_type_wrapper"><i class="fa fa-file-text-o"></i></div>
			        	
			        	<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
		        
				    break;
				    //end external link
	        	    
	        	    case 'Image':
				
						$return_html.= '<a data-title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($image_url[0]).'" class="fancy-gallery"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-image"></i></div>
						
						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				
				    break;
				    //end image
				    
				    case 'Youtube Video':
				
						$return_html.= '<a href="https://www.youtube.com/embed/'.esc_attr($portfolio_video_id).'" class="lightbox_youtube" data-options="width:1425, height:802"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>

						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				
				    break;
				    //end youtube
				
				case 'Vimeo Video':
	
						$return_html.= '<a href="https://player.vimeo.com/video/'.esc_attr($portfolio_video_id).'?badge=0" class="lightbox_vimeo" data-options="width:1425, height:802"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				
				    break;
				    //end vimeo
				    
				case 'Self-Hosted Video':
				
				    //Get video URL
				    $portfolio_mp4_url = get_post_meta($portfolio_ID, 'portfolio_mp4_url', true);
				    $preview_image = wp_get_attachment_image_src($image_id, 'large', true);
				    
						$return_html.= '<a title="'.esc_attr($portfolio->post_title).'" href="'.esc_url($portfolio_mp4_url).'" class="lightbox_vimeo"><div class="gallery_image_wrapper">
						
						<img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($portfolio->post_title).'" class="horizontal_gallery_img" data-height="'.esc_attr($height).'"/>
						
						<div class="portfolio_type_wrapper"><i class="fa fa-play"></i></div>
						
						<div class="image_caption_wrapper">
	        				<div class="image_caption">
	        					<h6>'.$portfolio->post_title.'</h6>
	        				</div>
					    </div>
					    </div>
					    </a>';
				
				    break;
					//end self-hosted
			    }
			    //end switch
	    	}
		 	
		 	$return_html.= '</td>';   
		}
			
		$return_html.= '
				</tr></tbody>
			</table>
		</div>
		';
		
		//Check if select contained layout
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_portfolio_striped', 'ppb_portfolio_striped_func');


function ppb_blog_grid_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'cat' => '',
		'items' => '',
		'padding' => '',
		'custom_css' => '',
		'link_title' => '',
		'link_url' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';
	$return_html.= '<div class="standard_wrapper">';
	
	$return_html.= '<div '.$sec_id.' class="ppb_blog_grid '.$size.' withsmallpadding"';
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode($custom_css).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.='<div class="page_content_wrapper"><div class="inner"><div class="inner_wrapper">';
	
	if(!is_numeric($items))
	{
		$items = 3;
	}
	
	//Get blog posts
	$args = array(
	    'numberposts' => $items,
	    'order' => 'DESC',
	    'orderby' => 'post_date',
	    'post_type' => array('post'),
	    'suppress_filters' => false,
	);

	if(!empty($cat))
	{
		$args['category'] = $cat;
	}
	$posts_arr = get_posts($args);
	
	if(!empty($posts_arr) && is_array($posts_arr))
	{
		$return_html.= '<div class="blog_grid_wrapper sidebar_content full_width ppb_blog_posts">';
	
		foreach($posts_arr as $key => $ppb_post)
		{
			$animate_layer = $key+7;
			$current_order = $key+1;
			$image_thumb = '';
										
			if(has_post_thumbnail($ppb_post->ID, 'large'))
			{
			    $image_id = get_post_thumbnail_id($ppb_post->ID);
			    $image_thumb = wp_get_attachment_image_src($image_id, 'large', true);
			}
			
			$last_class = '';
			if($current_order%3 == 0)
			{
				$last_class = 'last';
			}
			
			$return_html.= '<div id="post-'.$ppb_post->ID.'" class="post type-post hentry status-publish '.esc_attr($last_class).'">
			<div class="post_wrapper grid_layout">';
			
			 //Get post featured content
		    $post_ft_type = get_post_meta($ppb_post->ID, 'post_ft_type', true);
		    
		    switch($post_ft_type)
		    {
		    	case 'Image':
		    	default:
		        	if(!empty($image_thumb))
		        	{
		        		$small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-blog', true);
		
		    	    $return_html.= '<div class="post_img small static">
		    	    	<a href="'.esc_url(get_permalink($ppb_post->ID)).'">
		    	    		<img src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($ppb_post->post_title).'" class=""/>
		                </a>
		    	    </div>';
		    		}
		    	break;
		    	
		    	case 'Vimeo Video':
		    		$post_ft_vimeo = get_post_meta($ppb_post->ID, 'post_ft_vimeo', true);
		
					$return_html.= do_shortcode('[tg_vimeo video_id="'.$post_ft_vimeo.'" width="670" height="377"]').'<br/>';
		    	break;
		    	
		    	case 'Youtube Video':
		    		$post_ft_youtube = get_post_meta($ppb_post->ID, 'post_ft_youtube', true);

		    		$return_html.= do_shortcode('[tg_youtube video_id="'.$post_ft_youtube.'" width="670" height="377"]').'<br/>';
		    	break;
		    	
		    	case 'Gallery':
		    		$post_ft_gallery = get_post_meta($ppb_post->ID, 'post_ft_gallery', true);
		    		$return_html.= do_shortcode('[tg_gallery_slider gallery_id="'.$post_ft_gallery.'" size="gallery_2" width="670" height="270"]');
		    	break;
		    	
		    } //End switch
		    
		    $return_html.= '<div class="blog_grid_content">';
		    
		    $return_html.= '<div class="post_header grid">';
				
			$return_html.= '
				<h6><a href="'.esc_url(get_permalink($ppb_post->ID)).'" title="'.get_the_title($ppb_post->ID).'">'.get_the_title($ppb_post->ID).'</a></h6>
				
				<div class="post_detail single_post">
				    <span class="post_info_date">
				    	<a href="'.esc_url(get_permalink($ppb_post->ID)).'" title="'.get_the_title($ppb_post->ID).'">'.get_the_time(THEMEDATEFORMAT, $ppb_post->ID).'</a>
				    </span>
				</div>
			</div>';
				
			$return_html.= grandphotography_substr($ppb_post->post_excerpt, 170);
			    		    
			$return_html.= '
				<div class="post_button_wrapper">
			    	<a class="readmore" href="'.esc_url(get_permalink($ppb_post->ID)).'">'.esc_html__('Continue Reading', 'grandphotography-translation' ).'</a>
					</div>
			</div>';
		    
		    $return_html.= '    
				</div>
			</div>';
		$clear_br = '';
	
		if($key > 0 && ($key+1)%3 == 0)
		{
			$return_html.= '<br class="clear"/>';
		}

		}
		
		$return_html.= '</div>';
	}
	
	$return_html.= '</div></div></div>';
	
	if(!empty($link_title) && !empty($link_url))
	{
		$return_html.= '<hr class="double"/><br class="clear"/><div class="blog_recent_link">
		<a href="'.esc_url($link_url).'"><i class="fa fa-list-ul marginright middle"></i><h6>'.rawurldecode($link_title).'</h6></a>
	</div>';
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div></div>';
	
	return $return_html;
}

add_shortcode('ppb_blog_grid', 'ppb_blog_grid_func');


function ppb_blog_slider_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 9,
		'cat' => '',
		'order' => 'default',
		'autoplay' => '',
		'timer' => 5,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 9;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_blog_slider '.$size.' nopadding ';
	
	$return_html.= '" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	//Get blog posts
	$args = array(
	    'numberposts' => $items,
	    'order' => 'DESC',
	    'orderby' => 'post_date',
	    'post_type' => array('post'),
	    'suppress_filters' => false,
	);

	if(!empty($cat))
	{
		$args['category'] = $cat;
	}
	$posts_arr = get_posts($args);
	
	if(!empty($posts_arr) && is_array($posts_arr))
	{
		$custom_id = time().rand();
		
		wp_enqueue_script("flexslider", get_template_directory_uri()."/js/flexslider/jquery.flexslider-min.js", false, THEMEVERSION, true);
		wp_enqueue_script("grandphotography-slider-flexslider-".$custom_id, admin_url('admin-ajax.php')."?action=grandphotography_script_slider_flexslider&id=".$custom_id, false, THEMEVERSION, true);
	
		$return_html.= '<div id="'.esc_attr($custom_id).'" class="slider_wrapper">';
		$return_html.= '<div class="flexslider" data-height="550">';
		$return_html.= '<ul class="slides">';
	
		foreach($posts_arr as $key => $post_obj)
		{
			$image_url = '';
			$post_ID = $post_obj->ID;
					
			if(has_post_thumbnail($post_ID, 'large'))
			{
			    $image_id = get_post_thumbnail_id($post_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			}
			
			$permalink_url = get_permalink($post_ID);
			
			//Begin display HTML
			if(isset($image_url[0]) && !empty($image_url[0]))
			{
				$return_html.= '<li>';
				
				$return_html.= '<a href="'.esc_url($permalink_url).'">';
				$return_html.= '
					<div class="slider_image" style="background-image:url('.esc_url($image_url[0]).');">
						<div class="slide_post">
							<div class="slide_post_wrapper">
				';
				$return_html.= '
					<h2>'.$post_obj->post_title.'</h2>
					<hr class="title_break bold"/>
					<div class="post_detail single_post">
					    <span class="post_info_date">
						    '.get_the_time(THEMEDATEFORMAT, $post_ID).'
					    </span>
					    <span class="post_info_author">
					        '.esc_html__('By', 'grandphotography-translation' ).'&nbsp;
					        <a href="'.get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ).'">'.esc_html(get_the_author_meta( 'user_nicename' )).'</a>
					    </span>
					    <span class="post_info_comment">
					        '.esc_html__('With', 'grandphotography-translation' ).'&nbsp;
					        <a href="'.esc_url($permalink_url).'">';

				$post_comment_number = get_comments_number($post_ID);
				$return_html.= intval($post_comment_number).'&nbsp;';
				
				if($post_comment_number <= 1)
				{
				    $return_html.= esc_html__('Comment', 'grandphotography-translation' );
				}
				else
				{
				    $return_html.= esc_html__('Comments', 'grandphotography-translation' );
				}

				$return_html.= '</a>
					    </span>
					</div>
				';
				
				$return_html.= '<div class="post_info_cat">';

				//Get Post's Categories
				$post_categories = wp_get_post_categories($post_ID);
				    	
				$count_categories = count($post_categories);
				$i = 0;
				    	
				if(!empty($post_categories))
				{
					$return_html.= esc_html__('In', 'grandphotography-translation' ).'&nbsp;';
				    	
				    foreach($post_categories as $key => $c)
				    {
				    	$cat = get_category( $c );
				        $return_html.= '<a href="'.esc_url(get_category_link($cat->term_id)).'">'.esc_html($cat->name).'</a>';
				    			
				    	if(++$i != $count_categories) 
				    	{
				    		$return_html.= '&nbsp;/&nbsp;';
				    	}
				    }
				}
				$return_html.= '</div>';
				
				$return_html.= '</div>
						</div>
					</div>
				';
	            $return_html.= '</a>';
				$return_html.= '</li>';
			}
		}
	}
	
	$return_html.= '</ul></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_blog_slider', 'ppb_blog_slider_func');


function ppb_blog_slider_three_cols_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 9,
		'cat' => '',
		'order' => 'default',
		'autoplay' => '',
		'timer' => 5,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 9;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_blog_slider three_cols '.$size.' nopadding ';
	
	$return_html.= '" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	//Get blog posts
	$args = array(
	    'numberposts' => $items,
	    'order' => 'DESC',
	    'orderby' => 'post_date',
	    'post_type' => array('post'),
	    'suppress_filters' => false,
	);

	if(!empty($cat))
	{
		$args['category'] = $cat;
	}
	$posts_arr = get_posts($args);
	
	if(!empty($posts_arr) && is_array($posts_arr))
	{
		$total = count($posts_arr);
		$custom_id = time().rand();
		
		wp_enqueue_script("flexslider", get_template_directory_uri()."/js/flexslider/jquery.flexslider-min.js", false, THEMEVERSION, true);
		wp_enqueue_script("grandphotography-slider-flexslider-".$custom_id, admin_url('admin-ajax.php')."?action=grandphotography_script_slider_flexslider&id=".$custom_id, false, THEMEVERSION, true);
	
		$return_html.= '<div id="'.esc_attr($custom_id).'" class="slider_wrapper three_cols">';
		$return_html.= '<div class="flexslider" data-height="350">';
		$return_html.= '<ul class="slides">';
		
		$next_open_key = 1;
		$next_close_key = 3;
	
		foreach($posts_arr as $key => $post_obj)
		{
			$key++;
			$image_url = '';
			$post_ID = $post_obj->ID;
					
			if(has_post_thumbnail($post_ID, 'large'))
			{
			    $image_id = get_post_thumbnail_id($post_ID);
			    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
			}
			
			$permalink_url = get_permalink($post_ID);
			
			//Begin display HTML
			if(isset($image_url[0]) && !empty($image_url[0]))
			{
				if($key==1 OR $key == $next_open_key)
				{
					$next_open_key+= 3;
					$return_html.= '<li>';
				}
			
				$return_html.= '<a href="'.esc_url($permalink_url).'">';
				$return_html.= '
					<div class="slider_image three_cols" style="background-image:url('.esc_url($image_url[0]).');">
						<div class="slide_post">
							<div class="slide_post_wrapper">
				';
				$return_html.= '
					<h2>'.$post_obj->post_title.'</h2>
					<hr class="title_break bold"/>
					<div class="post_detail single_post">
					    <span class="post_info_date">
						    '.get_the_time(THEMEDATEFORMAT, $post_ID).'
					    </span>
					</div>
				';
				
				$return_html.= '</div>
						</div>
					</div>
				';
	            $return_html.= '</a>';
	            if($key%3==0 OR $key == $next_close_key)
				{
					$next_close_key+= 3;
					$return_html.= '</li>';
				}
			}
		}
	}
	
	$return_html.= '</ul></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_blog_slider_three_cols', 'ppb_blog_slider_three_cols_func');


function ppb_service_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'items' => 3,
		'padding' => 30,
		'cat' => '',
		'columns' => '3',
		'align' => 'left',
		'layout' => 'fixedwidth',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));

	if(!is_numeric($items))
	{
		$items = 4;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withpadding ';
	
	if(!empty($layout) && $layout == 'fullwidth')
	{
		$return_html.= 'fullwidth ';
	}
	
	$return_html.= '" ';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.='<div class="page_content_wrapper"><div class="inner" ';
	if($layout == 'fullwidth')
	{
		$return_html.= 'style="width:100%;"';
	}
	$return_html.= '>';
	
	$service_order = 'ASC';
	$service_order_by = 'menu_order';
	
	//Get service items
	$args = array(
	    'numberposts' => $items,
	    'order' => $service_order,
	    'orderby' => $service_order_by,
	    'post_type' => array('services'),
	);
	
	if(!empty($cat))
	{
		$args['servicecats'] = $cat;
	}
	$services_arr = get_posts($args);
	
	//Check display columns
	$count_column = 3;
	$columns_class = 'one_third';
	$service_h = 'h3';
	
	switch($columns)
	{
		case 1:
			$count_column = 1;
			$columns_class = 'one';
			$service_h = 'h3';
		break;
	
		case 2:
			$count_column = 2;
			$columns_class = 'one_half';
			$service_h = 'h3';
		break;
		
		case 3:
		default:
			$count_column = 3;
			$columns_class = 'one_third';
			$service_h = 'h3';
		break;
		
		case 4:
			$count_column = 4;
			$columns_class = 'one_fourth';
			$service_h = 'h6';
		break;
	}
	
	if(!empty($content))
	{
		$return_html.= '<div class="one_third"  style="text-align:left">';
		$content = preg_replace('/^(?:<br\s*\/?>\s*)+/', '', $content);
		$return_html.= $content;
		$return_html.= '</div>';
	}

	if(!empty($services_arr) && is_array($services_arr))
	{
		if(!empty($content))
		{
			$return_html.= '<div class="two_third last">';
		}
	
		$return_html.= '<div class="service_content_wrapper">';
		$last_class = '';
	
		foreach($services_arr as $key => $service)
		{
			if(($key+1)%$count_column==0)
			{
				$last_class = 'last';
			}
			else
			{
				$last_class = '';
			}
			
			$return_html.= '<div class="'.$columns_class.' '.$last_class.'">';
			
			$image_url = '';
			$service_ID = $service->ID;
					
			//check if use font awesome
			$service_icon_code ='';
			$service_font_awesome = get_post_meta($service_ID, 'service_font_awesome', true);
					
			if(!empty($service_font_awesome))
			{
				$service_icon_code = get_post_meta($service_ID, 'service_font_awesome_code', true);
			}
			else
			{
				if(has_post_thumbnail($service_ID, 'large'))
				{
				    $image_id = get_post_thumbnail_id($service_ID);
				    $image_url = wp_get_attachment_image_src($image_id, 'original', true);
				    $service_icon_code = '<img src="'.$image_url[0].'" alt="'.esc_attr($service->post_title).'" />';
				}
			}
			$return_html.= '<div class="service_wrapper '.esc_attr(rawurldecode($align)).'">';
			
			if(!empty($service_icon_code))
			{
				$return_html.= '<div class="service_icon">'.$service_icon_code.'<div class="service_border"></div></div>';
			}
			
			$return_html.= '<div class="service_title">';
			$return_html.= '<'.$service_h.'>'.$service->post_title.'</'.$service_h.'>';
			$return_html.= '<div class="service_content">'.$service->post_content.'</div>';
			$return_html.= '</div>';
			
			$return_html.= '</div>';
			$return_html.= '</div>';
		}
		
		$return_html.= '</div>';
		
		if(!empty($content))
		{
			$return_html.= '</div>';
		}
	}
	
	$return_html.= '</div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_service', 'ppb_service_func');


function ppb_service_content_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'items' => 3,
		'padding' => 30,
		'cat' => '',
		'order' => 'default',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));

	if(!is_numeric($items))
	{
		$items = 3;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withpadding ';
	
	if(!empty($layout) && $layout == 'fullwidth')
	{
		$return_html.= 'fullwidth ';
	}
	
	$return_html.= '" ';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.='<div class="page_content_wrapper"><div class="inner"> ';
	
	if(!empty($content))
	{
		$return_html.= '<div class="one_half">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title">'.rawurldecode($title).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<div class="ppb_subtitle">'.rawurldecode($subtitle).'</div>';
		}
		
		$return_html.= do_shortcode(grandphotography_apply_content($content));
		$return_html.= '</div>';
	}

	//display service content
	$return_html.= '<div class="one_half last">';	
	$return_html.= do_shortcode('[tg_service_vertical cat="'.esc_attr($cat).'" items="'.esc_attr($items).'" align="left"]');
	$return_html.= '</div>';
	
	$return_html.= '</div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_service_content', 'ppb_service_content_func');


function ppb_fullwidth_button_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'padding' => 30,
		'slug' => '',
		'title' => '',
		'bgcolor' => '',
		'fontcolor' => '#000',
		'button_text' => '',
		'link_url' => '',
		'button_bgcolor' => '',
		'button_fontcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	//Set begin wrapper div for live builder
	$return_html= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' ppb_fullwidth_button" ';
	
	$custom_css = '';
	
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="padding:'.$padding.'px 0 '.$padding.'px 0;'.rawurldecode($custom_css).'" ';
	}
	
	$return_html.= '>';
	
	$return_html.= '<div class="standard_wrapper">';
	
	if(!empty($title))
	{
		$return_html.= '<h2 class="title" style="color:'.esc_attr($fontcolor).';">'.rawurldecode($title).'</h2>';
	}
	
	$custom_css = '';
	if(!empty($button_text))
	{
		if(!empty($button_bgcolor))
		{
			$custom_css.= 'background-color:'.$button_bgcolor.';border-color:'.$button_bgcolor.';';
		}
		
		if(!empty($button_fontcolor))
		{
			$custom_css.= 'color:'.$button_fontcolor.';';
		}
	
		$return_html.= '<a href="'.esc_url($link_url).'" class="button" ';
		
		if(!empty($custom_css))
		{
			$return_html.= 'style="'.$custom_css.'"';
		}
		
		$return_html.= '>'.rawurldecode($button_text).'</a>';
	}
	
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);

	return $return_html;

}

add_shortcode('ppb_fullwidth_button', 'ppb_fullwidth_button_func');


function ppb_pricing_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'skin' => 'normal',
		'items' => 3,
		'cat' => '',
		'columns' => '3',
		'highlightcolor' => '#001d2c',
		'bgcolor' => '',
		'padding' => 30,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));

	if(!is_numeric($items))
	{
		$items = 4;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' ppb_pricing"';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper"><div class="page_content_wrapper"><div class="inner">';
	
	$pricing_order = 'ASC';
	$pricing_order_by = 'menu_order';
	
	//Get portfolio items
	$args = array(
	    'numberposts' => $items,
	    'order' => $pricing_order,
	    'orderby' => $pricing_order_by,
	    'post_type' => array('pricing'),
	);
	
	if(!empty($cat))
	{
		$args['pricingcats'] = $cat;
	}
	$pricing_arr = get_posts($args);
	
	//Check display columns
	$count_column = 3;
	$columns_class = 'one_third';
	
	switch($columns)
	{
		case 2:
			$count_column = 2;
			$columns_class = 'one_half';
		break;
		
		case 3:
		default:
			$count_column = 3;
			$columns_class = 'one_third';
		break;
		
		case 4:
			$count_column = 4;
			$columns_class = 'one_fourth';
		break;
	}
	
	$custom_header = '';
	$custom_button = '';
	$custom_price = '';
	switch($skin)
	{
		case 'light':
		default:
			$custom_header = 'color:'.$highlightcolor.';';
			$custom_price = 'color:'.$highlightcolor.';';
			$custom_button = 'background:'.$highlightcolor.';border-color:'.$highlightcolor.';color:#fff;';
			
		break;
		
		case 'normal':
			$custom_header = 'background:'.$highlightcolor.';';
			$custom_price = 'color:'.$highlightcolor.';';
			$custom_button = 'background:'.$highlightcolor.';border-color:'.$highlightcolor.';color:#fff;';
		break;
	}

	if(!empty($pricing_arr) && is_array($pricing_arr))
	{
		$return_html.= '<div class="pricing_content_wrapper '.$skin.'">';
		$last_class = '';
	
		foreach($pricing_arr as $key => $pricing)
		{
			if(($key+1)%$count_column==0)
			{
				$last_class = 'last';
			}
			else
			{
				$last_class = '';
			}
			
			//Check if featured
			$priing_featured_class = '';
			$priing_button_class = '';
			$pricing_plan_featured = get_post_meta($pricing->ID, 'pricing_featured', true);
			if(!empty($pricing_plan_featured))
			{
				$priing_featured_class = 'featured';
			}
			
			$return_html.= '<div class="pricing '.esc_attr($columns_class).' '.esc_attr($priing_featured_class).' '.esc_attr($last_class).'">';
			$return_html.= '<div class="pricing_wrapper_border"><ul class="pricing_wrapper">';
			
			$return_html.= '<li class="title_row '.esc_attr($priing_featured_class).'" style="'.esc_attr($custom_header).'">'.$pricing->post_title.'</li>';
			
			//Check price
			$pricing_plan_currency = get_post_meta($pricing->ID, 'pricing_plan_currency', true);
			$pricing_plan_price = get_post_meta($pricing->ID, 'pricing_plan_price', true);
			$pricing_plan_time = get_post_meta($pricing->ID, 'pricing_plan_time', true);
			
			$return_html.= '<li class="price_row">';
			$return_html.= '<strong>'.$pricing_plan_currency.'</strong>';
			$return_html.= '<em class="exact_price" style="'.esc_attr($custom_price).'">'.$pricing_plan_price.'</em>';
			$return_html.= '<em class="time">'.$pricing_plan_time.'</em>';
			$return_html.= '</li>';
			
			//Get pricing features
			$pricing_plan_features = get_post_meta($pricing->ID, 'pricing_plan_features', true);
			$pricing_plan_features = trim($pricing_plan_features);
			$pricing_plan_features_arr = explode("\n", $pricing_plan_features);
			$pricing_plan_features_arr = array_filter($pricing_plan_features_arr, 'trim');
			
			foreach ($pricing_plan_features_arr as $feature) {
			    $return_html.= '<li>'.$feature.'</li>';
			}
			
			//Get button
			$pricing_button_text = get_post_meta($pricing->ID, 'pricing_button_text', true);
			$pricing_button_url = get_post_meta($pricing->ID, 'pricing_button_url', true);
			
			$return_html.= '<li class="button_row '.esc_attr($priing_featured_class).'"><a href="'.esc_url($pricing_button_url).'" class="button"  style="'.esc_attr($custom_button).'">'.$pricing_button_text.'</a></li>';
			
			$return_html.= '</ul></div>';
			$return_html.= '</div>';
		}
		
		$return_html.= '</div>';
	}
	
	$return_html.= '</div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_pricing', 'ppb_pricing_func');


function ppb_team_column_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'columns' => 4,
		'title' => '',
		'items' => 4,
		'cat' => '',
		'order' => 'default',
		'layout' => 'wide',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 4;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';
	
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_team_column" ';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.='<div class="page_content_wrapper page_main_content sidebar_content full_width fixed_column photoframe">';
	
	$team_order = 'ASC';
	$team_order_by = 'menu_order';
	switch($order)
	{
		case 'default':
			$team_order = 'ASC';
			$team_order_by = 'menu_order';
		break;
		
		case 'newest':
			$team_order = 'DESC';
			$team_order_by = 'post_date';
		break;
		
		case 'oldest':
			$team_order = 'ASC';
			$team_order_by = 'post_date';
		break;
		
		case 'title':
			$team_order = 'ASC';
			$team_order_by = 'title';
		break;
		
		case 'random':
			$team_order = 'ASC';
			$team_order_by = 'rand';
		break;
	}
	
	//Check display columns
	$wrapper_class = '';
	$grid_wrapper_class = '';
	$column_class = '';
	
	switch($columns)
	{
		case 2:
			$wrapper_class = 'two_cols';
			$grid_wrapper_class = 'classic2_cols';
			$column_class = 'one_half gallery2';
		break;
		
		case 3:
			$wrapper_class = 'three_cols';
			$grid_wrapper_class = 'classic3_cols';
			$column_class = 'one_third gallery3';
		break;
		
		case 4:
			$wrapper_class = 'four_cols';
			$grid_wrapper_class = 'classic4_cols';
			$column_class = 'one_fourth gallery4';
		break;
		
		case 5:
			$wrapper_class = 'five_cols';
			$grid_wrapper_class = 'classic5_cols';
			$column_class = 'one_fifth gallery5';
		break;
	}
	
	$custom_id = time().rand();
	
	//Get team items
	$args = array(
	    'numberposts' => $items,
	    'order' => $team_order,
	    'orderby' => $team_order_by,
	    'post_type' => array('team'),
	);
	
	if(!empty($cat))
	{
		$args['teamcats'] = $cat;
	}
	$team_arr = get_posts($args);
	
	wp_enqueue_script("grandphotography-custom-grid-portfolio-click-".$custom_id, admin_url('admin-ajax.php').esc_attr("?action=grandphotography_script_grid_portfolio_pagination_click&columns=".$columns."&id=".$custom_id."&button_id=infinite_load_more_".$custom_id."&loading_id=infinite_loading_".$custom_id."&gutter=30&photoframe=1"), false, THEMEVERSION, true);
	
	if(!empty($team_arr) && is_array($team_arr))
	{
		if($layout == 'contain')
		{
			$return_html.= '<div class="standard_wrapper">';
		}
	
		$return_html.= '<div id="'.$custom_id.'" class="portfolio_filter_wrapper gallery '.esc_attr($wrapper_class).'" data-columns="'.esc_attr($columns).'">';
	
		foreach($team_arr as $key => $member)
		{
			$image_url = '';
			$member_ID = $member->ID;
					
			if(has_post_thumbnail($member_ID, 'grandphotography-gallery-grid'))
			{
			    $image_id = get_post_thumbnail_id($member_ID);
			    $small_image_url = wp_get_attachment_image_src($image_id, 'grandphotography-gallery-grid', true);
			}
			
			//Begin display HTML
			$return_html.= '<div class="element grid photoframe fixed_columns '.esc_attr($grid_wrapper_class).' animated'.($key+1).'">';
			$return_html.= '<div class="'.esc_attr($column_class).' classic filterable portfolio_type">';
			
			if(!empty($small_image_url[0]))
			{
				$return_html.= '<img class="team_pic" src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($member->post_title).'"/>';
			}
			
			$team_position = get_post_meta($member_ID, 'team_position', true);
			
			$return_html.= '<div class="gallery_info_wrapper">';
            $return_html.= '<h5>'.$member->post_title.'</h5>';
            if(!empty($team_position))
            {
            	$return_html.= '<div class="post_detail">'.$team_position.'</div>';
            }
            
            $member_facebook = get_post_meta($member_ID, 'member_facebook', true);
			$member_twitter = get_post_meta($member_ID, 'member_twitter', true);
			$member_instagram = get_post_meta($member_ID, 'member_instagram', true);
			$member_linkedin = get_post_meta($member_ID, 'member_linkedin', true);
            
            if(!empty($member_facebook) OR !empty($member_twitter) OR !empty($member_instagram) OR !empty($member_linkedin))
			{
			    $return_html.= '<ul class="social_wrapper team">';
			    
			    if(!empty($member_twitter))
			    {
			        $return_html.= '<li><a title="'.esc_attr($member->post_title).' on Twitter" target="_blank" class="tooltip" href="https://twitter.com/'.$member_twitter.'"><i class="fa fa-twitter"></i></a></li>';
			    }
	 
			    if(!empty($member_facebook))
			    {
			        $return_html.= '<li><a title="'.esc_attr($member->post_title).' on Facebook" target="_blank" class="tooltip" href="https://facebook.com/'.$member_facebook.'"><i class="fa fa-facebook"></i></a></li>';
			    }
			    
			    if(!empty($member_instagram))
			    {
			        $return_html.= '<li><a title="'.esc_attr($member->post_title).' on Instagram" target="_blank" class="tooltip" href="'.$member_instagram.'"><i class="fa fa-instagram"></i></a></li>';
			    }
			        
			    if(!empty($member_linkedin))
			    {
			        $return_html.= '<li><a title="'.esc_attr($member->post_title).' on Linkedin" target="_blank" class="tooltip" href="'.$member_linkedin.'"><i class="fa fa-linkedin"></i></a></li>';
			    }
			    
			    $return_html.= '</ul>';
			}

			$return_html.= '</div>';
			$return_html.= '</div>';
			$return_html.= '</div>';
		}
		
		$return_html.= '</div>';
		
		if($layout == 'contain')
		{
			$return_html.= '</div>';
		}
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_team_column', 'ppb_team_column_func');


function ppb_promo_box_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'title' => '',
		'button_text' => '',
		'button_url' => '',
		'background_color' => '',
		'builder_id' => '',
	), $atts));
	
	$return_html = '<div class="one skinbg" ';
	
	if(!empty($background_color))
	{
		$return_html.= 'style="background:'.esc_attr($background_color).'"';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.='<div class="page_content_wrapper promo_box_wrapper">';
	$return_html.= do_shortcode('[tg_promo_box title="'.$title.'" button_text="'.rawurldecode($button_text).'" button_url="'.esc_url($button_url).'" button_style="button transparent"]'.$content.'[/tg_promo_box]');
	$return_html.='</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_promo_box', 'ppb_promo_box_func');


function ppb_testimonial_slider_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'title' => '',
		'slug' => '',
		'items' => '',
		'cat' => '',
		'bgcolor' => '',
		'fontcolor' => '',
		'background' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	wp_enqueue_script("flexslider", get_template_directory_uri()."/js/flexslider/jquery.flexslider-min.js", false, THEMEVERSION, true);
	wp_enqueue_script("sciprt-testimonials-flexslider", admin_url('admin-ajax.php')."?action=grandphotography_script_testimonials_flexslider", false, THEMEVERSION, true);
	
	$testimonials_order = 'ASC';
	$testimonials_order_by = 'menu_order';
	
	//Get testimonial items
	$args = array(
	    'numberposts' => $items,
	    'order' => $testimonials_order,
	    'orderby' => $testimonials_order_by,
	    'post_type' => array('testimonials'),
	);
	
	if(!empty($cat))
	{
		$args['testimonialcats'] = $cat;
	}
	$testimonial_arr = get_posts($args);
	
	$return_html = '';
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ';
	
	if(!empty($background))
	{
		$return_html.= 'withbg ';
	}
	
	$return_html.= '" ';
	
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
	}

	if(!empty($background))
	{
		$custom_css.= 'background-image:url('.esc_url($background).');background-size:cover; ';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper">';
	$return_html.= '<div class="page_content_wrapper" style="text-align:center"><div class="inner">';
	
	if(!empty($testimonial_arr) && is_array($testimonial_arr))
	{
		$return_html.= '<div class="testimonial_slider_wrapper">';
		$return_html.= '<div class="flexslider" data-height="750">';
		$return_html.= '<ul class="slides">';
		
		foreach($testimonial_arr as $key => $testimonial)
		{
			$testimonial_ID = $testimonial->ID;
		
			//Get testimonial meta
			$testimonial_name = get_post_meta($testimonial_ID, 'testimonial_name', true);
			
			$return_html.= '<li>';
			$return_html.= '<div class="testimonial_slider_wrapper">';
			
			if(!empty($testimonial->post_content))
			{
				$return_html.= $testimonial->post_content;
			}
			
			if(!empty($testimonial_name))
			{
				$return_html.= '<div class="testimonial_slider_meta">';
				
				//Get customer picture
				if(has_post_thumbnail($testimonial_ID, 'thumbnail'))
				{
				    $image_id = get_post_thumbnail_id($testimonial_ID);
				    $small_image_url = wp_get_attachment_image_src($image_id, 'thumbnail', true);
				}
				
				if(!empty($small_image_url[0]))
				{
					$return_html.= '<div class="testimonial_image animated" data-animation="bigEntrance">';
					$return_html.='<img class="team_pic" src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($testimonial_name).'"/>';
					$return_html.= '</div>';
				}
				
				$return_html.= '<h6 ';
				
				if(!empty($fontcolor))
				{
				    $return_html.= 'style="color:'.esc_attr($fontcolor).'"';
				}
				
				$return_html.= '>'.$testimonial_name.'</h6>';
				
				$return_html.= '</div>';
			}
			
			$return_html.= '</div>';
			$return_html.= '</li>';
		}
		
		$return_html.= '</ul>';
		$return_html.= '</div>';
		$return_html.= '</div>';
	}
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;
}

add_shortcode('ppb_testimonial_slider', 'ppb_testimonial_slider_func');


function ppb_testimonial_column_func($atts, $content) {
	remove_filter('the_content', 'pp_formatter', 99);

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'columns' => 2,
		'items' => 4,
		'cat' => '',
		'fontcolor' => '',
		'bgcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(!is_numeric($items))
	{
		$items = 4;
	}
	
	if(!is_numeric($columns))
	{
		$columns = 2;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '';
	$return_html.= '<div class="standard_wrapper">';
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_testimonial_column"';
	
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
	}
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$testimonials_order = 'ASC';
	$testimonials_order_by = 'menu_order';
	
	//Check display columns
	$count_column = 3;
	$columns_class = 'one_third';
	
	switch($columns)
	{	
		case 2:
			$count_column = 2;
			$columns_class = 'one_half';
		break;
		
		case 3:
		default:
			$count_column = 3;
			$columns_class = 'one_third';
		break;
		
		case 4:
			$count_column = 4;
			$columns_class = 'one_fourth';
		break;
	}
	
	//Get testimonial items
	$args = array(
	    'numberposts' => $items,
	    'order' => $testimonials_order,
	    'orderby' => $testimonials_order_by,
	    'post_type' => array('testimonials'),
	);
	
	if(!empty($cat))
	{
		$args['testimonialcats'] = $cat;
	}
	$testimonial_arr = get_posts($args);
	
	if(!empty($testimonial_arr) && is_array($testimonial_arr))
	{
		$return_html.= '<div class="page_content_wrapper"><div class="inner"><div class="testimonial_wrapper">';
	
		foreach($testimonial_arr as $key => $testimonial)
		{
			$image_url = '';
			$testimonial_ID = $testimonial->ID;
					
			//Get customer picture
			if(has_post_thumbnail($testimonial_ID, 'thumbnail'))
			{
			    $image_id = get_post_thumbnail_id($testimonial_ID);
			    $small_image_url = wp_get_attachment_image_src($image_id, 'thumbnail', true);
			}
			
			$last_class = '';
			if(($key+1)%$count_column==0)
			{
				$last_class = 'last';
			}
			
			//Begin display HTML
			$return_html.= '<div class="'.esc_attr($columns_class).' testimonial_column_element animated'.($key+1).' '.esc_attr($last_class).'">';
			
			//Get testimonial meta
			$testimonial_name = get_post_meta($testimonial_ID, 'testimonial_name', true);
			$testimonial_position = get_post_meta($testimonial_ID, 'testimonial_position', true);
			$testimonial_company_name = get_post_meta($testimonial_ID, 'testimonial_company_name', true);
			$testimonial_company_website = get_post_meta($testimonial_ID, 'testimonial_company_website', true);
			
			if(!empty($small_image_url[0]))
			{
				$return_html.= '<div class="testimonial_image animated" data-animation="bigEntrance">';
				$return_html.='<img class="team_pic" src="'.esc_url($small_image_url[0]).'" alt="'.esc_attr($testimonial_name).'"/>';
				$return_html.= '</div>';
			}
			
			if(!empty($testimonial->post_content))
			{
				$return_html.= '<div class="testimonial_content">';
				$return_html.= $testimonial->post_content;
				
				if(!empty($testimonial_name))
				{
					$return_html.= '<br/><br/><div class="testimonial_customer">';
					$return_html.= '<h6 ';
					
					if(!empty($fontcolor))
					{
						$return_html.= 'style="color:'.esc_attr($fontcolor).';"';
					}
					
					$return_html.= '>'.$testimonial_name.'</h6>';
					
					if(!empty($testimonial_position))
					{
						$return_html.= '<div class="testimonial_customer_position" ';
						
						if(!empty($fontcolor))
						{
							$return_html.= 'style="color:'.esc_attr($fontcolor).';"';
						}
						
						$return_html.= '>'.$testimonial_position.'</div>';
					}
					
					if(!empty($testimonial_company_name))
					{
						$return_html.= '-<div class="testimonial_customer_company">';
						
						if(!empty($testimonial_company_website))
						{
							$return_html.= '<a href="'.esc_url($testimonial_company_website).'" target="_blank" ';
							
							if(!empty($fontcolor))
							{
								$return_html.= 'style="color:'.esc_attr($fontcolor).';"';
							}
							
							$return_html.= '>';
						}
						
						$return_html.=$testimonial_company_name;
						
						if(!empty($testimonial_company_website))
						{
							$return_html.= '</a>';
						}
						
						$return_html.= '</div>';
					}
					
					$return_html.= '</div>';
				}
				
				$return_html.= '</div>';
			}
			
			$return_html.= '</div>';
		}
		
		$return_html.= '</div></div></div>';
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_testimonial_column', 'ppb_testimonial_column_func');


function ppb_contact_map_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'title' => '',
		'slug' => '',
		'subtitle' => '',
		'lat' => 0,
		'long' => 0,
		'zoom' => 8,
		'type' => '',
		'popup' => '',
		'address' => '',
		'marker' => '',
		'bgcolor' => '',
		'fontcolor' => '',
		'buttonbgcolor' => '',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="ppb_contact_map one nopadding" ';
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="floatleft nopadding"><div class="one_half_bg contact_form" ';
	
	$contact_form_custom_css = '';
	if(!empty($bgcolor))
	{
		$contact_form_custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$contact_form_custom_css.= 'color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($contact_form_custom_css))
	{
		$return_html.= 'style="'.esc_attr($contact_form_custom_css).'"';
	}
	
	$return_html.= '>';
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	//Display Title
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title" ';
		if(!empty($fontcolor))
		{
			$return_html.= 'style="'.esc_attr($custom_css_fontcolor).';"';
		}
		$return_html.= '>'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	//Display Content
	if(!empty($subtitle))
	{
		$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
		$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
	}
	
	//Display Content
	if(!empty($content))
	{
		$return_html.= '<div class="ppb_header_content">'.rawurldecode($content).'</div>';
	}
	
	//Display contact form
	//Get contact form random ID
	$custom_id = time().rand();
    $pp_contact_form = unserialize(get_option('pp_contact_form_sort_data'));
    
    //Setup Google Map API Key
	grandphotography_set_map_api();
    
    wp_enqueue_script("validate", get_template_directory_uri()."/js/jquery.validate.js", false, THEMEVERSION, true);
    
    wp_register_script("script-contact-form", admin_url('admin-ajax.php')."?action=grandphotography_script_contact_form&form=".$custom_id, false, THEMEVERSION, true);
	$params = array(
	  'ajaxurl' => admin_url('admin-ajax.php'),
	  'ajax_nonce' => wp_create_nonce('tgajax-post-contact-nonce'),
	);
	wp_localize_script( 'script-contact-form', 'tgAjax', $params );
	wp_enqueue_script("script-contact-form", admin_url('admin-ajax.php')."?action=grandphotography_script_contact_form&form=".$custom_id, false, THEMEVERSION, true);

    $return_html.= '<div id="reponse_msg_'.$custom_id.'" class="contact_form_response"><ul></ul></div>';
    
    $return_html.= '<form id="contact_form_'.$custom_id.'" class="contact_form_wrapper" method="post" action="/wp-admin/admin-ajax.php">';
	$return_html.= '<input type="hidden" id="action" name="action" value="grandphotography_contact_mailer"/>';

    if(is_array($pp_contact_form) && !empty($pp_contact_form))
    {
        foreach($pp_contact_form as $form_input)
        {
        	switch($form_input)
        	{
    				case 1:
    				
    				$return_html.= '<label for="your_name">'.esc_html__('Name *', 'grandphotography-custom-post' ).'</label>
    				<input id="your_name" name="your_name" type="text" class="required_field" placeholder="'.esc_html__('Name *', 'grandphotography-custom-post' ).'"/>
    				';	

    				break;
    				
    				case 2:
    				
    				$return_html.= '<label for="email">'.esc_html__('Email *', 'grandphotography-custom-post' ).'</label>
    				<input id="email" name="email" type="text" class="required_field email" placeholder="'.esc_html__('Email *', 'grandphotography-custom-post' ).'"/>
    				';	

    				break;
    				
    				case 3:
    				
    				$return_html.= '<label for="message">'.esc_html__('Message *', 'grandphotography-custom-post' ).'</label>
    				<textarea id="message" name="message" rows="7" cols="10" class="required_field" style="width:96%;" placeholder="'.esc_html__('Message *', 'grandphotography-custom-post' ).'"></textarea>
    				';	

    				break;
    				
    				case 4:
    				
    				$return_html.= '<label for="address">'.esc_html__('Address', 'grandphotography-custom-post' ).'</label>
    				<input id="address" name="address" type="text" placeholder="'.esc_html__('Address', 'grandphotography-custom-post' ).'"/>
    				';	

    				break;
    				
    				case 5:
    				
    				$return_html.= '<label for="phone">'.esc_html__('Phone', 'grandphotography-custom-post' ).'</label>
    				<input id="phone" name="phone" type="text" placeholder="'.esc_html__('Phone', 'grandphotography-custom-post' ).'"/>
    				';

    				break;
    				
    				case 6:
    				
    				$return_html.= '<label for="mobile">'.esc_html__('Mobile', 'grandphotography-custom-post' ).'</label>
    				<input id="mobile" name="mobile" type="text" placeholder="'.esc_html__('Mobile', 'grandphotography-custom-post' ).'"/>
    				';		

    				break;
    				
    				case 7:
    				
    				$return_html.= '<label for="company">'.esc_html__('Company Name', 'grandphotography-custom-post' ).'</label>
    				<input id="company" name="company" type="text" placeholder="'.esc_html__('Company Name', 'grandphotography-custom-post' ).'"/>
    				';

    				break;
    				
    				case 8:
    				
    				$return_html.= '<label for="country">'.esc_html__('Country', 'grandphotography-custom-post' ).'</label>				
    				<input id="country" name="country" type="text" placeholder="'.esc_html__('Country', 'grandphotography-custom-post' ).'"/>
    				';
    				break;
    			}
    		}
    	}

    	$pp_contact_enable_captcha = get_option('pp_contact_enable_captcha');
    	
    	if(!empty($pp_contact_enable_captcha))
    	{
    	
    	$return_html.= '<div id="captcha-wrap">
    		<div class="captcha-box">
    			<img src="'.admin_url('admin-ajax.php').'?action=grandphotography_get_captcha" alt="" id="captcha" />
    		</div>
    		<div class="text-box">
    			<label>Type the two words:</label>
    			<input name="captcha-code" type="text" id="captcha-code">
    		</div>
    		<div class="captcha-action">
    			<img src="'.get_template_directory_uri().'/images/refresh.jpg"  alt="" id="captcha-refresh" />
    		</div>
    	</div>
    	<br class="clear"/><br/>';
    
    }
    
    $return_html.= '<br/><br/><div class="contact_submit_wrapper">
    	<input id="contact_submit_btn'.$custom_id.'" name="contact_submit_btn'.$custom_id.'" type="submit" class="solidbg" value="'.esc_html__('Send', 'grandphotography-custom-post' ).'" ';
	
	if(!empty($buttonbgcolor))
	{
		$return_html.= 'style="background-color:'.esc_attr($buttonbgcolor).';border-color:'.esc_attr($buttonbgcolor).'"';
	}
	
    $return_html.= '/>
    </div>';
    
	$return_html.= '</form>';
	
	
	$return_html.= '</div>';
	
	//Display Map
	$return_html.= '<div class="one_half_bg nopadding" style="height:100%">';
	$return_html.= '<div id="map'.$custom_id.'" class="map_shortcode_wrapper" style="width:100%;height:100%">';
	$return_html.= '<div class="map-marker" ';
	
	if(!empty($popup))
	{
		$return_html.= 'data-title="'.esc_attr(rawurldecode($popup)).'" ';
	}
	
	if(!empty($lat) && !empty($long))
	{
		$return_html.= 'data-latlng="'.esc_attr(rawurldecode($lat)).','.esc_attr(rawurldecode($long)).'" ';
	}
	
	if(!empty($address))
	{
		$return_html.= 'data-address="'.esc_attr(rawurldecode($address)).'" ';
	}
	
	if(!empty($marker))
	{
		$return_html.= 'data-icon="'.esc_attr(rawurldecode($marker)).'" ';
	}
		
	$return_html.= '>';
	
	if(!empty($popup))
	{
		$return_html.= '<div class="map-infowindow">'.rawurldecode($popup).'</div>';
	}
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	$ext_attr = array(
		'id' => 'map'.$custom_id,
		'zoom' => $zoom,
		'type' => $type,
	);
	
	$ext_attr_serialize = serialize($ext_attr);
	
	wp_enqueue_script("simplegmaps", get_template_directory_uri()."/js/jquery.simplegmaps.min.js", false, THEMEVERSION, true);
	wp_enqueue_script("script-contact-map".$custom_id, admin_url('admin-ajax.php')."?action=grandphotography_script_map_shortcode&fullheight=true&data=".$ext_attr_serialize, false, THEMEVERSION, true);
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;
}

add_shortcode('ppb_contact_map', 'ppb_contact_map_func');


function ppb_contact_sidebar_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'title' => '',
		'slug' => '',
		'subtitle' => '',
		'sidebar' => '',
		'sidebar_layout' => 'left',
		'padding' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$sidebar_class = '';
	if($sidebar_layout == 'left')
	{
		$sidebar_class = 'left_sidebar';
	}
	
	$return_html = '';
	$return_html.= '<div class="standard_wrapper">';
	$return_html.= '<div '.$sec_id.' class="ppb_contact_sidebar one withsmallpadding" ';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.rawurldecode($custom_css).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner"><div class="inner_wrapper">';
	
	$return_html.= '<div class="sidebar_content '.esc_attr($sidebar_class).'">';
	
	//Display Title
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	//Display Content
	if(!empty($subtitle))
	{
		$return_html.= '<hr class="title_break bold left"/>';
		$return_html.= '<div class="page_tagline">'.rawurldecode($subtitle).'</div>';
	}
	
	//Display Content
	if(!empty($content))
	{
		$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
	}
	
	//Display contact form
	//Get contact form random ID
	$custom_id = time().rand();
    $pp_contact_form = unserialize(get_option('pp_contact_form_sort_data'));
    wp_enqueue_script("validate", get_template_directory_uri()."/js/jquery.validate.js", false, THEMEVERSION, true);
    
    wp_register_script("script-contact-form", admin_url('admin-ajax.php')."?action=grandphotography_script_contact_form&form=".$custom_id, false, THEMEVERSION, true);
	$params = array(
	  'ajaxurl' => admin_url('admin-ajax.php'),
	  'ajax_nonce' => wp_create_nonce('tgajax-post-contact-nonce'),
	);
	wp_localize_script( 'script-contact-form', 'tgAjax', $params );
	wp_enqueue_script("script-contact-form", admin_url('admin-ajax.php')."?action=grandphotography_script_contact_form&form=".$custom_id, false, THEMEVERSION, true);

    $return_html.= '<div id="reponse_msg_'.$custom_id.'" class="contact_form_response"><ul></ul></div>';
    
    $return_html.= '<form id="contact_form_'.$custom_id.'" class="contact_form_wrapper" method="post" action="/wp-admin/admin-ajax.php">';
	$return_html.= '<input type="hidden" id="action" name="action" value="grandphotography_contact_mailer"/>';

    if(is_array($pp_contact_form) && !empty($pp_contact_form))
    {
        foreach($pp_contact_form as $form_input)
        {
        	switch($form_input)
        	{
    				case 1:
    				
    				$return_html.= '<label for="your_name">'.esc_html__('Name *', 'grandphotography-custom-post' ).'</label>
    				<input id="your_name" name="your_name" type="text" class="required_field" placeholder="'.esc_html__('Name *', 'grandphotography-custom-post' ).'"/>
    				';	

    				break;
    				
    				case 2:
    				
    				$return_html.= '<label for="email">'.esc_html__('Email *', 'grandphotography-custom-post' ).'</label>
    				<input id="email" name="email" type="text" class="required_field email" placeholder="'.esc_html__('Email *', 'grandphotography-custom-post' ).'"/>
    				';	

    				break;
    				
    				case 3:
    				
    				$return_html.= '<label for="message">'.esc_html__('Message *', 'grandphotography-custom-post' ).'</label>
    				<textarea id="message" name="message" rows="7" cols="10" class="required_field" style="width:95.5%;" placeholder="'.esc_html__('Message *', 'grandphotography-custom-post' ).'"></textarea>
    				';	

    				break;
    				
    				case 4:
    				
    				$return_html.= '<label for="address">'.esc_html__('Address', 'grandphotography-custom-post' ).'</label>
    				<input id="address" name="address" type="text" placeholder="'.esc_html__('Address', 'grandphotography-custom-post' ).'"/>
    				';	

    				break;
    				
    				case 5:
    				
    				$return_html.= '<label for="phone">'.esc_html__('Phone', 'grandphotography-custom-post' ).'</label>
    				<input id="phone" name="phone" type="text" placeholder="'.esc_html__('Phone', 'grandphotography-custom-post' ).'"/>
    				';

    				break;
    				
    				case 6:
    				
    				$return_html.= '<label for="mobile">'.esc_html__('Mobile', 'grandphotography-custom-post' ).'</label>
    				<input id="mobile" name="mobile" type="text" placeholder="'.esc_html__('Mobile', 'grandphotography-custom-post' ).'"/>
    				';		

    				break;
    				
    				case 7:
    				
    				$return_html.= '<label for="company">'.esc_html__('Company Name', 'grandphotography-custom-post' ).'</label>
    				<input id="company" name="company" type="text" placeholder="'.esc_html__('Company Name', 'grandphotography-custom-post' ).'"/>
    				';

    				break;
    				
    				case 8:
    				
    				$return_html.= '<label for="country">'.esc_html__('Country', 'grandphotography-custom-post' ).'</label>				
    				<input id="country" name="country" type="text" placeholder="'.esc_html__('Country', 'grandphotography-custom-post' ).'"/>
    				';
    				break;
    			}
    		}
    	}

    	$pp_contact_enable_captcha = get_option('pp_contact_enable_captcha');
    	
    	if(!empty($pp_contact_enable_captcha))
    	{
    	
    	$return_html.= '<div id="captcha-wrap">
    		<div class="captcha-box">
    			<img src="'.admin_url('admin-ajax.php').'?action=grandphotography_get_captcha" alt="" id="captcha" />
    		</div>
    		<div class="text-box">
    			<label>Type the two words:</label>
    			<input name="captcha-code" type="text" id="captcha-code">
    		</div>
    		<div class="captcha-action">
    			<img src="'.get_template_directory_uri().'/images/refresh.jpg"  alt="" id="captcha-refresh" />
    		</div>
    	</div>
    	<br class="clear"/><br/>';
    
    }
    
    $return_html.= '<br/><br/><div class="contact_submit_wrapper">
    	<input id="contact_submit_btn'.$custom_id.'" name="contact_submit_btn'.$custom_id.'" type="submit" class="solidbg" value="'.esc_html__('Send', 'grandphotography-custom-post' ).'"/>
    </div>';
    
	$return_html.= '</form>';
	
	
	$return_html.= '</div>';
	
	//Display Sidebar
	$return_html.= '<div class="sidebar_wrapper '.esc_attr($sidebar_class).'"><div class="sidebar"><div class="content"><ul class="sidebar_widget">';
	$return_html.= grandphotography_get_dynamic_sidebar(rawurldecode($sidebar));
	$return_html.= '</ul></div></div></div>';
	
	$return_html.= '</div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	$return_html.= '</div>';

	return $return_html;
}

add_shortcode('ppb_contact_sidebar', 'ppb_contact_sidebar_func');


function ppb_contact_half_bg_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'background' => '',
		'background_parallax' => '',
		'background_position' => '',
		'padding' => 30,
		'bgcolor' => '#000000',
		'opacity' => 100,
		'fontcolor' => '',
		'align' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'parallax' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($bgcolor))
	{
		$bgcolor = '#ffffff';
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_contact_half_bg ';
	
	if(!empty($background))
	{
		$return_html.= 'withbg ';
		$custom_css.= 'background-image:url('.esc_url($background).');';
	}
	
	$parallax_stellar = '';
	if(!empty($parallax))
	{
		$return_html.= 'parallax ';
		$parallax_stellar.= 'data-stellar-ratio="1.3"';
	}
	
	if(!empty($background_position))
	{
		$custom_css.= 'background-position: center '.esc_attr($background_position).';';
	}
	
	$return_html.= '"';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper"><div class="page_content_wrapper"><div class="inner">';
	
	if(!empty($title) OR !empty($subtitle) OR !empty($content))
	{
		$custom_bgcolor_css = '';
		if(!empty($bgcolor))
		{
			$ori_bgcolor = $bgcolor;
			$opacity = $opacity/100;
			$bgcolor = grandphotography_hex_to_rgb($bgcolor);
		
			$custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
			$custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
			$custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
		}
		
		$custom_css_fontcolor = '';
		$custom_css_bordercolor = '';
		if(!empty($fontcolor))
		{
			$custom_css.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
		}
	
		if($align == 'left')
		{
			$return_html.= '<div class="one_half_bg" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).'" '.$parallax_stellar.'>';
		}
		else
		{
			$return_html.= '<div class="one_half_bg floatright" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).'" '.$parallax_stellar.'>';
		}
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		
		//Display contact form
		//Get contact form random ID
		$custom_id = time().rand();
	    $pp_contact_form = unserialize(get_option('pp_contact_form_sort_data'));
	    
	    //Setup Google Map API Key
		grandphotography_set_map_api();
	    
	    wp_enqueue_script("validate", get_template_directory_uri()."/js/jquery.validate.js", false, THEMEVERSION, true);
	    
	    wp_register_script("script-contact-form", admin_url('admin-ajax.php')."?action=grandphotography_script_contact_form&form=".$custom_id, false, THEMEVERSION, true);
		$params = array(
		  'ajaxurl' => admin_url('admin-ajax.php'),
		  'ajax_nonce' => wp_create_nonce('tgajax-post-contact-nonce'),
		);
		wp_localize_script( 'script-contact-form', 'tgAjax', $params );
		wp_enqueue_script("script-contact-form", admin_url('admin-ajax.php')."?action=grandphotography_script_contact_form&form=".$custom_id, false, THEMEVERSION, true);
	
	    $return_html.= '<div id="reponse_msg_'.$custom_id.'" class="contact_form_response"><ul></ul></div>';
	    
	    $return_html.= '<form id="contact_form_'.$custom_id.'" class="contact_form_wrapper" method="post" action="/wp-admin/admin-ajax.php">';
		$return_html.= '<input type="hidden" id="action" name="action" value="grandphotography_contact_mailer"/>';
	
	    if(is_array($pp_contact_form) && !empty($pp_contact_form))
	    {
	        foreach($pp_contact_form as $form_input)
	        {
	        	switch($form_input)
	        	{
	    				case 1:
	    				
	    				$return_html.= '<label for="your_name">'.esc_html__('Name *', 'grandphotography-custom-post' ).'</label>
	    				<input id="your_name" name="your_name" type="text" class="required_field" placeholder="'.esc_html__('Name *', 'grandphotography-custom-post' ).'"/>
	    				';	
	
	    				break;
	    				
	    				case 2:
	    				
	    				$return_html.= '<label for="email">'.esc_html__('Email *', 'grandphotography-custom-post' ).'</label>
	    				<input id="email" name="email" type="text" class="required_field email" placeholder="'.esc_html__('Email *', 'grandphotography-custom-post' ).'"/>
	    				';	
	
	    				break;
	    				
	    				case 3:
	    				
	    				$return_html.= '<label for="message">'.esc_html__('Message *', 'grandphotography-custom-post' ).'</label>
	    				<textarea id="message" name="message" rows="7" cols="10" class="required_field" style="width:96%;" placeholder="'.esc_html__('Message *', 'grandphotography-custom-post' ).'"></textarea>
	    				';	
	
	    				break;
	    				
	    				case 4:
	    				
	    				$return_html.= '<label for="address">'.esc_html__('Address', 'grandphotography-custom-post' ).'</label>
	    				<input id="address" name="address" type="text" placeholder="'.esc_html__('Address', 'grandphotography-custom-post' ).'"/>
	    				';	
	
	    				break;
	    				
	    				case 5:
	    				
	    				$return_html.= '<label for="phone">'.esc_html__('Phone', 'grandphotography-custom-post' ).'</label>
	    				<input id="phone" name="phone" type="text" placeholder="'.esc_html__('Phone', 'grandphotography-custom-post' ).'"/>
	    				';
	
	    				break;
	    				
	    				case 6:
	    				
	    				$return_html.= '<label for="mobile">'.esc_html__('Mobile', 'grandphotography-custom-post' ).'</label>
	    				<input id="mobile" name="mobile" type="text" placeholder="'.esc_html__('Mobile', 'grandphotography-custom-post' ).'"/>
	    				';		
	
	    				break;
	    				
	    				case 7:
	    				
	    				$return_html.= '<label for="company">'.esc_html__('Company Name', 'grandphotography-custom-post' ).'</label>
	    				<input id="company" name="company" type="text" placeholder="'.esc_html__('Company Name', 'grandphotography-custom-post' ).'"/>
	    				';
	
	    				break;
	    				
	    				case 8:
	    				
	    				$return_html.= '<label for="country">'.esc_html__('Country', 'grandphotography-custom-post' ).'</label>				
	    				<input id="country" name="country" type="text" placeholder="'.esc_html__('Country', 'grandphotography-custom-post' ).'"/>
	    				';
	    				break;
	    			}
	    		}
	    	}
	
	    	$pp_contact_enable_captcha = get_option('pp_contact_enable_captcha');
	    	
	    	if(!empty($pp_contact_enable_captcha))
	    	{
	    	
	    	$return_html.= '<div id="captcha-wrap">
	    		<div class="captcha-box">
	    			<img src="'.admin_url('admin-ajax.php').'?action=grandphotography_get_captcha" alt="" id="captcha" />
	    		</div>
	    		<div class="text-box">
	    			<label>Type the two words:</label>
	    			<input name="captcha-code" type="text" id="captcha-code">
	    		</div>
	    		<div class="captcha-action">
	    			<img src="'.get_template_directory_uri().'/images/refresh.jpg"  alt="" id="captcha-refresh" />
	    		</div>
	    	</div>
	    	<br class="clear"/><br/>';
	    
	    }
	    
	    $return_html.= '<br/><br/><div class="contact_submit_wrapper">
	    	<input id="contact_submit_btn'.$custom_id.'" name="contact_submit_btn'.$custom_id.'" type="submit" class="solidbg" value="'.esc_html__('Send', 'grandphotography-custom-post' ).'" ';
		
	    $return_html.= '/>
	    </div>';
	    
		$return_html.= '</form>';
		
		$return_html.= '</div>';
	}
	
	$return_html.= '</div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_contact_half_bg', 'ppb_contact_half_bg_func');


function ppb_contact_fullwidth_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'width' => '100%',
		'padding' => 30,
		'bgcolor' => '',
		'fontcolor' => '',
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	
	if($size!='one')
	{
		$return_html.= '<div class="standard_wrapper">';
	}

	//Set main shortcode div content
	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_contact_fullwidth"';
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).' !important;';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper">';
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	if(!empty($width))
	{
		$return_html.= '<div style="margin:auto;width:'.esc_attr(rawurldecode($width)).'%">';
	}
	
	//Display contact form
	//Get contact form random ID
	$custom_id = time().rand();
	$pp_contact_form = unserialize(get_option('pp_contact_form_sort_data'));
	
	//Setup Google Map API Key
	grandphotography_set_map_api();
	
	wp_enqueue_script("validate", get_template_directory_uri()."/js/jquery.validate.js", false, THEMEVERSION, true);
	
	wp_register_script("script-contact-form", admin_url('admin-ajax.php')."?action=grandphotography_script_contact_form&form=".$custom_id, false, THEMEVERSION, true);
	$params = array(
	  'ajaxurl' => admin_url('admin-ajax.php'),
	  'ajax_nonce' => wp_create_nonce('tgajax-post-contact-nonce'),
	);
	wp_localize_script( 'script-contact-form', 'tgAjax', $params );
	wp_enqueue_script("script-contact-form", admin_url('admin-ajax.php')."?action=grandphotography_script_contact_form&form=".$custom_id, false, THEMEVERSION, true);
	
	$return_html.= '<div id="reponse_msg_'.$custom_id.'" class="contact_form_response"><ul></ul></div>';
	
	$return_html.= '<form id="contact_form_'.$custom_id.'" class="contact_form_wrapper" method="post" action="/wp-admin/admin-ajax.php">';
	$return_html.= '<input type="hidden" id="action" name="action" value="grandphotography_contact_mailer"/>';
	
	if(is_array($pp_contact_form) && !empty($pp_contact_form))
	{
	    foreach($pp_contact_form as $form_input)
	    {
	    	switch($form_input)
	    	{
	    			case 1:
	    			
	    			$return_html.= '<label for="your_name">'.esc_html__('Name *', 'grandphotography-custom-post' ).'</label>
	    			<input id="your_name" name="your_name" type="text" class="required_field" placeholder="'.esc_html__('Name *', 'grandphotography-custom-post' ).'"/>
	    			';	
	
	    			break;
	    			
	    			case 2:
	    			
	    			$return_html.= '<label for="email">'.esc_html__('Email *', 'grandphotography-custom-post' ).'</label>
	    			<input id="email" name="email" type="text" class="required_field email" placeholder="'.esc_html__('Email *', 'grandphotography-custom-post' ).'"/>
	    			';	
	
	    			break;
	    			
	    			case 3:
	    			
	    			$return_html.= '<label for="message">'.esc_html__('Message *', 'grandphotography-custom-post' ).'</label>
	    			<textarea id="message" name="message" rows="7" cols="10" class="required_field" style="width:96%;" placeholder="'.esc_html__('Message *', 'grandphotography-custom-post' ).'"></textarea>
	    			';	
	
	    			break;
	    			
	    			case 4:
	    			
	    			$return_html.= '<label for="address">'.esc_html__('Address', 'grandphotography-custom-post' ).'</label>
	    			<input id="address" name="address" type="text" placeholder="'.esc_html__('Address', 'grandphotography-custom-post' ).'"/>
	    			';	
	
	    			break;
	    			
	    			case 5:
	    			
	    			$return_html.= '<label for="phone">'.esc_html__('Phone', 'grandphotography-custom-post' ).'</label>
	    			<input id="phone" name="phone" type="text" placeholder="'.esc_html__('Phone', 'grandphotography-custom-post' ).'"/>
	    			';
	
	    			break;
	    			
	    			case 6:
	    			
	    			$return_html.= '<label for="mobile">'.esc_html__('Mobile', 'grandphotography-custom-post' ).'</label>
	    			<input id="mobile" name="mobile" type="text" placeholder="'.esc_html__('Mobile', 'grandphotography-custom-post' ).'"/>
	    			';		
	
	    			break;
	    			
	    			case 7:
	    			
	    			$return_html.= '<label for="company">'.esc_html__('Company Name', 'grandphotography-custom-post' ).'</label>
	    			<input id="company" name="company" type="text" placeholder="'.esc_html__('Company Name', 'grandphotography-custom-post' ).'"/>
	    			';
	
	    			break;
	    			
	    			case 8:
	    			
	    			$return_html.= '<label for="country">'.esc_html__('Country', 'grandphotography-custom-post' ).'</label>				
	    			<input id="country" name="country" type="text" placeholder="'.esc_html__('Country', 'grandphotography-custom-post' ).'"/>
	    			';
	    			break;
	    		}
	    	}
	    }
	
	    $pp_contact_enable_captcha = get_option('pp_contact_enable_captcha');
	    
	    if(!empty($pp_contact_enable_captcha))
	    {
	    
	    $return_html.= '<div id="captcha-wrap">
	    	<div class="captcha-box">
	    		<img src="'.admin_url('admin-ajax.php').'?action=grandphotography_get_captcha" alt="" id="captcha" />
	    	</div>
	    	<div class="text-box">
	    		<label>Type the two words:</label>
	    		<input name="captcha-code" type="text" id="captcha-code">
	    	</div>
	    	<div class="captcha-action">
	    		<img src="'.get_template_directory_uri().'/images/refresh.jpg"  alt="" id="captcha-refresh" />
	    	</div>
	    </div>
	    <br class="clear"/><br/>';
	
	}
	
	$return_html.= '<br/><br/><div class="contact_submit_wrapper">
	    <input id="contact_submit_btn'.$custom_id.'" name="contact_submit_btn'.$custom_id.'" type="submit" class="solidbg" value="'.esc_html__('Send', 'grandphotography-custom-post' ).'" ';
	
	$return_html.= '/>
	</div>';
	
	$return_html.= '</form>';
	
	if(!empty($width))
	{
		$return_html.= '</div>';
	}
	$return_html.= '</div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	if($size!='one')
	{
		$return_html.= '</div>';
	}

	return $return_html;

}

add_shortcode('ppb_contact_fullwidth', 'ppb_contact_fullwidth_func');


function ppb_map_func($atts) {
	//extract short code attr
	extract(shortcode_atts(array(
		'height' => 600,
		'slug' => '',
		'lat' => 0,
		'long' => 0,
		'zoom' => 8,
		'type' => '',
		'popup' => '',
		'address' => '',
		'marker' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$return_html = '<div '.$sec_id.' class="one nopadding">';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);

	$custom_id = time().rand();
	$return_html = '<div class="map_shortcode_wrapper" id="map'.$custom_id.'" style="width:100%;height:'.esc_attr($height).'px">';
	$return_html.= '<div class="map-marker" ';
	
	if(!empty($popup))
	{
		$return_html.= 'data-title="'.esc_attr(rawurldecode($popup)).'" ';
	}
	
	if(!empty($lat) && !empty($long))
	{
		$return_html.= 'data-latlng="'.esc_attr(rawurldecode($lat)).','.esc_attr(rawurldecode($long)).'" ';
	}
	
	if(!empty($address))
	{
		$return_html.= 'data-address="'.esc_attr(rawurldecode($address)).'" ';
	}
	
	if(!empty($marker))
	{
		$return_html.= 'data-icon="'.esc_attr(rawurldecode($marker)).'" ';
	}
		
	$return_html.= '>';
	
	if(!empty($popup))
	{
		$return_html.= '<div class="map-infowindow">'.rawurldecode($popup).'</div>';
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	$ext_attr = array(
		'id' => 'map'.$custom_id,
		'zoom' => $zoom,
		'type' => $type,
	);
	
	$ext_attr_serialize = serialize($ext_attr);
	
	//Setup Google Map API Key
	grandphotography_set_map_api();
	
	wp_enqueue_script("simplegmaps", get_template_directory_uri()."/js/jquery.simplegmaps.min.js", false, THEMEVERSION, true);
	wp_enqueue_script("script-contact-map".$custom_id, admin_url('admin-ajax.php')."?action=grandphotography_script_map_shortcode&data=".$ext_attr_serialize, false, THEMEVERSION, true);

	return $return_html;

}

add_shortcode('ppb_map', 'ppb_map_func');


function ppb_image_poppup_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'layout' => 'contain',
		'bgcolor' => '#fff',
		'fontcolor' => '',
		'textalign' => 'left',
		'padding' => 60,
		'background' => '',
		'background_position' => '',
		'parallax' => 0,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	//Set begin wrapper div for live builder
	$return_html = grandphotography_live_builder_begin_wrapper($builder_id);
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html.= '<div '.$sec_id.' class=" ';
	
	if($layout == 'contain')
	{
		$return_html.= 'standard_wrapper';
	}
	$return_html.= ' ppb_popup one '.esc_attr($layout).' ';
	
	if(!empty($background))
	{
		$return_html.= 'withbg ';
		$custom_css.= 'background-image:url('.esc_url($background).');';
	}
	
	if(!empty($parallax))
	{
		$return_html.= 'parallax ';
	}
	
	if(!empty($background_position))
	{
		$custom_css.= 'background-position: center '.esc_attr($background_position).';';
	}

	$return_html.= '"';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	$custom_css.= 'padding-top:'.esc_attr($padding).'px;padding-bottom:'.esc_attr($padding).'px;';
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	//Add content wrapper
	$return_html.= '<div class="overlay_gallery_wrapper" style="text-align:'.esc_attr($textalign).';background:'.esc_attr($bgcolor).';"><div class="overlay_gallery_border" style="'.esc_attr($custom_css_bordercolor).'"><div class="overlay_gallery_content">';
	
	//Add title and content
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	//Add title and content
	if(!empty($subtitle))
	{
	    $return_html.= '<hr class="title_break bold '.esc_attr($textalign).'" style="'.esc_attr($custom_css_bordercolor).'"/>';
	    $return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
	}
	
	$return_html.= '</div></div></div>';
	//End content wrapper
	
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);

	return $return_html;

}

add_shortcode('ppb_image_poppup', 'ppb_image_poppup_func');


function ppb_animated_gallery_grid_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'title' => '',
		'slug' => '',
		'gallery_id' => '',
		'rows' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}
	
	$custom_css = '';
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).'" style="'.esc_attr(rawurldecode($custom_css)).'">';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$images_arr = get_post_meta($gallery_id, 'wpsimplegallery_gallery', true);
	
	if(!empty($images_arr))
	{
		//Get contact form random ID
		$custom_id = time().rand();
	
		wp_enqueue_script("modernizr", get_template_directory_uri()."/js/modernizr.js", false, THEMEVERSION, true);
		wp_enqueue_script("gridrotator", get_template_directory_uri()."/js/jquery.gridrotator.js", false, THEMEVERSION, true);
		wp_enqueue_script("grandphotography-script-gridrotator-".$custom_id, admin_url('admin-ajax.php')."?action=grandphotography_script_gridrotator&grid=".$custom_id.'&rows='.$rows, false, THEMEVERSION, true);
		
		$return_html.= '<div id="'.$custom_id.'" class="ri-grid ri-grid-size-3">';
		
		$return_html.= '<ul>';
		
		foreach($images_arr as $key => $image)
		{
			$image_url = wp_get_attachment_image_src($image, 'thumbnail', true);
			$image_alt = get_post_meta($image, '_wp_attachment_image_alt', true);
			
			$return_html.= '<li><a href="javascript:;"><img src="'.esc_url($image_url[0]).'" alt="'.esc_attr($image_alt).'"/></a></li>';
		}
		
		$return_html.= '</ul>';
		$return_html.= '</div>';
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	
	return $return_html;
}

add_shortcode('ppb_animated_gallery_grid', 'ppb_animated_gallery_grid_func');


function ppb_header_youtube_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'fontcolor' => '',
		'textalign' => 'left',
		'width' => '100',
		'padding' => 30,
		'youtube' => '',
		'bgcolor' => '#000000',
		'opacity' => 100,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	if($size != 'one')
	{	
		$return_html.= '<div class="standard_wrapper">';
	}

	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_header_youtube withbg parallax" ';
	
	if(!empty($youtube))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($youtube).'" ';
	}
	
	$custom_css.= 'text-align:'.esc_attr($textalign).';padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	$custom_bgcolor_css = '';
	if(!empty($bgcolor))
	{
	    $ori_bgcolor = $bgcolor;
	    $opacity = $opacity/100;
	    $bgcolor = grandphotography_hex_to_rgb($bgcolor);
	
	    $custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
	    $custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
	    $custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
	    
	    $return_html.= '<div class="overlay_background" style="'.esc_attr($custom_bgcolor_css).'"></div>';
	}
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if($size == 'one')
	{	
		$return_html.= '<div class="standard_wrapper">';
	}
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	if(!empty($width))
	{
		$return_html.= '<div style="margin:auto;width:'.esc_attr(rawurldecode($width)).'%">';
	}
	
	//Add title and content
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	if(!empty($subtitle))
	{
		$return_html.= '<hr class="title_break bold '.esc_attr($textalign).'" style="'.esc_attr($custom_css_bordercolor).'"/>';
		$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
	}
	
	if(!empty($content))
	{
		$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
	}
	
	$return_html.= '</div>';
	
	if(!empty($width))
	{
		$return_html.= '</div>';
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	if($size != 'one')
	{
		$return_html.= '</div>';
	}

	return $return_html;

}

add_shortcode('ppb_header_youtube', 'ppb_header_youtube_func');


function ppb_header_vimeo_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'fontcolor' => '',
		'textalign' => 'left',
		'width' => '100',
		'padding' => 30,
		'vimeo' => '',
		'bgcolor' => '#000000',
		'opacity' => 100,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '';
	if($size != 'one')
	{	
		$return_html.= '<div class="standard_wrapper">';
	}

	$return_html.= '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_header_vimeo withbg parallax" ';
	
	if(!empty($vimeo))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($vimeo).'" ';
	}
	
	$custom_css.= 'text-align:'.esc_attr($textalign).';padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	$custom_bgcolor_css = '';
	if(!empty($bgcolor))
	{
	    $ori_bgcolor = $bgcolor;
	    $opacity = $opacity/100;
	    $bgcolor = grandphotography_hex_to_rgb($bgcolor);
	
	    $custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
	    $custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
	    $custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
	    
	    $return_html.= '<div class="overlay_background" style="'.esc_attr($custom_bgcolor_css).'"></div>';
	}
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if($size == 'one')
	{	
		$return_html.= '<div class="standard_wrapper">';
	}
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	if(!empty($width))
	{
		$return_html.= '<div style="margin:auto;width:'.esc_attr(rawurldecode($width)).'%">';
	}
	
	//Add title and content
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	if(!empty($subtitle))
	{
		$return_html.= '<hr class="title_break bold '.esc_attr($textalign).'" style="'.esc_attr($custom_css_bordercolor).'"/>';
		$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
	}
	
	if(!empty($content))
	{
		$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
	}
	
	$return_html.= '</div>';
	
	if(!empty($width))
	{
		$return_html.= '</div>';
	}
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	if($size != 'one')
	{
		$return_html.= '</div>';
	}

	return $return_html;

}

add_shortcode('ppb_header_vimeo', 'ppb_header_vimeo_func');


function ppb_youtube_parallax_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'title' => '',
		'slug' => '',
		'youtube' => '',
		'height' => 50,
		'display_title' => 1,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	if(!is_numeric($height))
	{
		$height = 80;
	}
	
	if($height > 100)
	{
		$height = 100;
	}
	
	$image_id = '';
	
	//Set begin wrapper div for live builder
	$return_html = grandphotography_live_builder_begin_wrapper($builder_id);

	$return_html.= '<div '.$sec_id.' class="parallax" ';
	
	if(!empty($youtube))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($youtube).'" ';
	}
		
	if(!empty($height))
	{
		$custom_css.= 'height:'.$height.'vh; ';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'"';
	}
	
	$return_html.= '>';
	
	$return_html.= '</div>';
	
	if(!empty($display_title))
	{
		if(!empty($title))
		{
			$return_html.= '<div class="ppb_image_caption">'.$title.'</div>';
		}
	}

	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);

	return $return_html;
}

add_shortcode('ppb_youtube_parallax', 'ppb_youtube_parallax_func');


function ppb_vimeo_parallax_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'title' => '',
		'slug' => '',
		'vimeo' => '',
		'height' => 50,
		'display_title' => 1,
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	if(!is_numeric($height))
	{
		$height = 80;
	}
	
	if($height > 100)
	{
		$height = 100;
	}
	
	$image_id = '';
	
	//Set begin wrapper div for live builder
	$return_html = grandphotography_live_builder_begin_wrapper($builder_id);

	$return_html.= '<div '.$sec_id.' class="parallax" ';
	
	if(!empty($vimeo))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($vimeo).'" ';
	}
		
	if(!empty($height))
	{
		$custom_css.= 'height:'.$height.'vh; ';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'"';
	}
	
	$return_html.= '>';
	
	$return_html.= '</div>';
	
	if(!empty($display_title))
	{
		if(!empty($title))
		{
			$return_html.= '<div class="ppb_image_caption">'.$title.'</div>';
		}
	}

	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);

	return $return_html;
}

add_shortcode('ppb_vimeo_parallax', 'ppb_vimeo_parallax_func');


function ppb_youtube_poppup_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'youtube' => '',
		'bgcolor' => '#fff',
		'fontcolor' => '',
		'textalign' => 'left',
		'padding' => 60,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	//Set begin wrapper div for live builder
	$return_html = grandphotography_live_builder_begin_wrapper($builder_id);
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html.= '<div '.$sec_id.' class="ppb_youtube_poppup one withbg parallax" ';
	
	if(!empty($youtube))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($youtube).'" ';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	//Add content wrapper
	$return_html.= '<div class="overlay_gallery_wrapper" style="text-align:'.esc_attr($textalign).';background:'.esc_attr($bgcolor).';"><div class="overlay_gallery_border" style="'.esc_attr($custom_css_bordercolor).'"><div class="overlay_gallery_content">';
	
	//Add title and content
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	//Add title and content
	if(!empty($subtitle))
	{
	    $return_html.= '<hr class="title_break bold '.esc_attr($textalign).'" style="'.esc_attr($custom_css_bordercolor).'"/>';
	    $return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
	}
	
	$return_html.= '</div></div></div>';
	//End content wrapper
	
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);

	return $return_html;

}

add_shortcode('ppb_youtube_poppup', 'ppb_youtube_poppup_func');


function ppb_vimeo_poppup_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'vimeo' => '',
		'bgcolor' => '#fff',
		'fontcolor' => '',
		'textalign' => 'left',
		'padding' => 60,
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	//Set begin wrapper div for live builder
	$return_html = grandphotography_live_builder_begin_wrapper($builder_id);
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html.= '<div '.$sec_id.' class="ppb_youtube_poppup one withbg parallax" ';
	
	if(!empty($vimeo))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($vimeo).'" ';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	$return_html.= '<div class="page_content_wrapper"><div class="inner">';
	
	//Add content wrapper
	$return_html.= '<div class="overlay_gallery_wrapper" style="text-align:'.esc_attr($textalign).';background:'.esc_attr($bgcolor).';"><div class="overlay_gallery_border" style="'.esc_attr($custom_css_bordercolor).'"><div class="overlay_gallery_content">';
	
	//Add title and content
	if(!empty($title))
	{
		$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
	}
	
	//Add title and content
	if(!empty($subtitle))
	{
	    $return_html.= '<hr class="title_break bold '.esc_attr($textalign).'" style="'.esc_attr($custom_css_bordercolor).'"/>';
	    $return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
	}
	
	$return_html.= '</div></div></div>';
	//End content wrapper
	
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);

	return $return_html;

}

add_shortcode('ppb_vimeo_poppup', 'ppb_vimeo_poppup_func');


function ppb_content_half_youtube_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'padding' => 30,
		'bgcolor' => '#000000',
		'opacity' => 100,
		'fontcolor' => '',
		'align' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'youtube' => '',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($bgcolor))
	{
		$bgcolor = '#ffffff';
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_content_half_youtube parallax" ';
	
	if(!empty($youtube))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($youtube).'" ';
	}
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper"><div class="page_content_wrapper"><div class="inner">';
	
	if(!empty($title) OR !empty($subtitle) OR !empty($content))
	{
		$custom_bgcolor_css = '';
		if(!empty($bgcolor))
		{
			$ori_bgcolor = $bgcolor;
			$opacity = $opacity/100;
			$bgcolor = grandphotography_hex_to_rgb($bgcolor);
		
			$custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
			$custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
			$custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
		}
		
		$custom_css_fontcolor = '';
		$custom_css_bordercolor = '';
		if(!empty($fontcolor))
		{
			$custom_css.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
		}
	
		if($align == 'left')
		{
			$return_html.= '<div class="one_half_bg" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).'" data-stellar-ratio="1.3">';
		}
		else
		{
			$return_html.= '<div class="one_half_bg floatright" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).'" data-stellar-ratio="1.3">';
		}
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		$return_html.= '</div>';
	}
	
	$return_html.= '</div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_content_half_youtube', 'ppb_content_half_youtube_func');


function ppb_content_half_vimeo_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'padding' => 30,
		'bgcolor' => '#000000',
		'opacity' => 100,
		'fontcolor' => '',
		'align' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'vimeo' => '',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($bgcolor))
	{
		$bgcolor = '#ffffff';
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_content_half_vimeo parallax" ';
	
	if(!empty($vimeo))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($vimeo).'" ';
	}
	
	$custom_css.= 'padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper"><div class="page_content_wrapper"><div class="inner">';
	
	if(!empty($title) OR !empty($subtitle) OR !empty($content))
	{
		$custom_bgcolor_css = '';
		if(!empty($bgcolor))
		{
			$ori_bgcolor = $bgcolor;
			$opacity = $opacity/100;
			$bgcolor = grandphotography_hex_to_rgb($bgcolor);
		
			$custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
			$custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
			$custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
		}
		
		$custom_css_fontcolor = '';
		$custom_css_bordercolor = '';
		if(!empty($fontcolor))
		{
			$custom_css.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
		}
	
		if($align == 'left')
		{
			$return_html.= '<div class="one_half_bg" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).'" data-stellar-ratio="1.3">';
		}
		else
		{
			$return_html.= '<div class="one_half_bg floatright" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).'" data-stellar-ratio="1.3">';
		}
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		$return_html.= '</div>';
	}
	
	$return_html.= '</div></div></div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_content_half_vimeo', 'ppb_content_half_vimeo_func');


function ppb_content_center_youtube_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'padding' => 30,
		'height' => 600,
		'bgcolor' => '#000000',
		'opacity' => 100,
		'fontcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'youtube' => '',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($bgcolor))
	{
		$bgcolor = '#ffffff';
	}
	
	if(empty($height))
	{
		$height = 600;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_content_center_bg withbg parallax" ';
	
	if(!empty($youtube))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($youtube).'" ';
	}
	
	if(!empty($height))
	{
		$custom_css.= 'height:'.intval($height).'px;';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if(!empty($title) OR !empty($subtitle) OR !empty($content))
	{
		$custom_bgcolor_css = '';
		if(!empty($bgcolor))
		{
			$ori_bgcolor = $bgcolor;
			$opacity = $opacity/100;
			$bgcolor = grandphotography_hex_to_rgb($bgcolor);
		
			$custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
			$custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
			$custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
		}
		
		$custom_css_fontcolor = '';
		$custom_css_bordercolor = '';
		if(!empty($fontcolor))
		{
			$custom_css.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
		}
	
		$return_html.= '<div class="one_third" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).';padding:'.esc_attr($padding).'px;" data-stellar-ratio="1.3">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		$return_html.= '</div>';
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_content_center_youtube', 'ppb_content_center_youtube_func');


function ppb_content_center_vimeo_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'padding' => 30,
		'height' => 600,
		'bgcolor' => '#000000',
		'opacity' => 100,
		'fontcolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'vimeo' => '',
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($bgcolor))
	{
		$bgcolor = '#ffffff';
	}
	
	if(empty($height))
	{
		$height = 600;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' withsmallpadding ppb_content_center_bg withbg parallax" ';
	
	if(!empty($vimeo))
	{
		//Add jarallax video script
		wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
		
		$return_html.= 'data-jarallax-video="'.esc_url($vimeo).'" ';
	}
	
	if(!empty($height))
	{
		$custom_css.= 'height:'.intval($height).'px;';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= ' style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	if(!empty($title) OR !empty($subtitle) OR !empty($content))
	{
		$custom_bgcolor_css = '';
		if(!empty($bgcolor))
		{
			$ori_bgcolor = $bgcolor;
			$opacity = $opacity/100;
			$bgcolor = grandphotography_hex_to_rgb($bgcolor);
		
			$custom_bgcolor_css.= 'background:'.$ori_bgcolor.';';
			$custom_bgcolor_css.= 'background:rgb('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
			$custom_bgcolor_css.= 'background:rgba('.$bgcolor['r'].','.$bgcolor['g'].','.$bgcolor['b'].','.$opacity.');';
		}
		
		$custom_css_fontcolor = '';
		$custom_css_bordercolor = '';
		if(!empty($fontcolor))
		{
			$custom_css.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
			$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
		}
	
		$return_html.= '<div class="one_third" style="'.esc_attr($custom_bgcolor_css.$custom_css_fontcolor).';padding:'.esc_attr($padding).'px;" data-stellar-ratio="1.3">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		$return_html.= '</div>';
	}
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_content_center_vimeo', 'ppb_content_center_vimeo_func');


function ppb_youtube_two_third_fullwidth_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'height' => 500,
		'align' => 1,
		'youtube' => '',
		'bgcolor' => '',
		'fontcolor' => '',
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	if(empty($align))
	{
		$align = 'left';
	}
	
	if(!is_numeric($height))
	{
		$height = 500;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="ppb_image_two_third_fullwidth '.esc_attr($size).'" ';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$content_custom_css = '';
	if($align=='left')
	{
		$return_html.= '<div class="two_third_bg parallax" ';

		if(!empty($youtube))
		{
			//Add jarallax video script
			wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
			
			$return_html.= 'data-jarallax-video="'.esc_url($youtube).'" ';
		}
		
		$return_html.= ' style="height:'.esc_attr($height).'px;"></div>';
		
		$return_html.= '<div class="one_third_bg" style="height:'.esc_attr($height).'px;">';
		
		$return_html.= '<div class="center_wrapper"><div class="inner_content">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		//Add title and content
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		
		$return_html.= '</div>';
		$return_html.= '</div>';
		$return_html.= '</div>';
	}
	else
	{	
		$return_html.= '<div class="one_third_bg textright" style="height:'.esc_attr($height).'px;">';
		
		$return_html.= '<div class="center_wrapper"><div class="inner_content">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		//Add title and content
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
	
		$return_html.= '</div>';
		$return_html.= '</div>';
		$return_html.= '</div>';
		
		$return_html.= '<div class="two_third_bg parallax" ';

		if(!empty($youtube))
		{
			//Add jarallax video script
			wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
			
			$return_html.= 'data-jarallax-video="'.esc_url($youtube).'" ';
		}
		
		$return_html.= ' style="height:'.esc_attr($height).'px;"></div>';
	}
	
	$return_html.= '<br class="clear"/>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_youtube_two_third_fullwidth', 'ppb_youtube_two_third_fullwidth_func');


function ppb_vimeo_two_third_fullwidth_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'slug' => '',
		'title' => '',
		'subtitle' => '',
		'height' => 500,
		'align' => 1,
		'vimeo' => '',
		'bgcolor' => '',
		'fontcolor' => '',
		'custom_css' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'builder_id' => '',
	), $atts));
	
	if(empty($align))
	{
		$align = 'left';
	}
	
	if(!is_numeric($height))
	{
		$height = 500;
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="ppb_image_two_third_fullwidth '.esc_attr($size).'" ';
	if(!empty($bgcolor))
	{
		$custom_css.= 'background-color:'.esc_attr($bgcolor).';';
	}
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
	}
	
	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(rawurldecode($custom_css)).'" ';
	}
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
		$custom_css.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
		$custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$content_custom_css = '';
	if($align=='left')
	{
		$return_html.= '<div class="two_third_bg parallax" ';

		if(!empty($vimeo))
		{
			//Add jarallax video script
			wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
			
			$return_html.= 'data-jarallax-video="'.esc_url($vimeo).'" ';
		}
		
		$return_html.= ' style="height:'.esc_attr($height).'px;"></div>';
		
		$return_html.= '<div class="one_third_bg" style="height:'.esc_attr($height).'px;">';
		
		$return_html.= '<div class="center_wrapper"><div class="inner_content">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		//Add title and content
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		
		$return_html.= '</div>';
		$return_html.= '</div>';
		$return_html.= '</div>';
	}
	else
	{	
		$return_html.= '<div class="one_third_bg textright" style="height:'.esc_attr($height).'px;">';
		
		$return_html.= '<div class="center_wrapper"><div class="inner_content">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		//Add title and content
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
	
		$return_html.= '</div>';
		$return_html.= '</div>';
		$return_html.= '</div>';
		
		$return_html.= '<div class="two_third_bg parallax" ';

		if(!empty($vimeo))
		{
			//Add jarallax video script
			wp_enqueue_script("jarallax-video", get_template_directory_uri()."/js/jarallax-video.js", false, THEMEVERSION, true);
			
			$return_html.= 'data-jarallax-video="'.esc_url($vimeo).'" ';
		}
		
		$return_html.= ' style="height:'.esc_attr($height).'px;"></div>';
	}
	
	$return_html.= '<br class="clear"/>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;

}

add_shortcode('ppb_vimeo_two_third_fullwidth', 'ppb_vimeo_two_third_fullwidth_func');


function ppb_card_two_cols_with_image_func($atts, $content) {

	//extract short code attr
	extract(shortcode_atts(array(
		'size' => 'one',
		'title' => '',
		'subtitle' => '',
		'slug' => '',
		'image_width' => 50,
		'image' => '',
		'align' => 1,
		'content_width' => 50,
		'padding' => 0,
		'bgcolor' => '#fff',
		'fontcolor' => '',
		'bordercolor' => '',
		'margin_top' => 0,
		'margin_right' => 0,
		'margin_bottom' => 0,
		'margin_left' => 0,
		'custom_css' => '',
		'builder_id' => '',
	), $atts));
	
	if(empty($align))
	{
		$align = 'left';
	}
	
	if(!is_numeric($image_width))
	{
		$image_width = 50;
	}
	if(!is_numeric($content_width))
	{
		$content_width = 50;
	}
	
	if(empty($bgcolor))
	{
		$bgcolor = '#fff';
	}
	
	$sec_id = '';
	if(!empty($slug))
	{
		$sec_id = 'id="'.esc_attr($slug).'"';
	}

	$return_html = '<div '.$sec_id.' class="'.esc_attr($size).' ppb_card_two_cols_with_image" ';
	$custom_css.= 'position:relative;padding:'.esc_attr($padding).'px 0 '.esc_attr($padding).'px 0;';
	
	$custom_css_fontcolor = '';
	$custom_css_bordercolor = '';
	if(!empty($fontcolor))
	{
	    $custom_css.= 'color:'.esc_attr($fontcolor).';';
	    $custom_css_fontcolor.= 'color:'.esc_attr($fontcolor).';';
	    $custom_css_bordercolor.= 'border-color:'.esc_attr($fontcolor).';';
	}

	if(!empty($margin_top))
	{
		$custom_css.= 'margin-top:'.esc_attr($margin_top).'px;';
	}
	if(!empty($margin_right))
	{
		$custom_css.= 'margin-right:'.esc_attr($margin_right).'px;';
	}
	if(!empty($margin_bottom))
	{
		$custom_css.= 'margin-bottom:'.esc_attr($margin_bottom).'px;';
	}
	if(!empty($margin_left))
	{
		$custom_css.= 'margin-left:'.esc_attr($margin_left).'px;';
	}
	
	if(!empty($custom_css))
	{
		$return_html.= 'style="'.esc_attr(urldecode($custom_css)).'" ';
	}
	
	//Get content block custom CSS
	$content_custom_css = 'background:'.esc_attr($bgcolor).';';
	
	if(!empty($bordercolor))
	{
	    $content_custom_css.= 'border: 1px solid '.$bordercolor.';';
	}
	
	$return_html.= '>';
	
	//Set begin wrapper div for live builder
	$return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
	
	$return_html.= '<div class="standard_wrapper"><div class="page_content_wrapper"><div class="inner">';
	
	if($align=='left')
	{
		$return_html.= '<div class="one_half parallax_scroll_image" style="width:'.esc_attr($image_width).'%;">';
		if(!empty($image))
		{
			$image_id = grandphotography_get_image_id($image);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
			
			$return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
			$return_html.= '<img src="'.esc_url($image).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
			$return_html.= '</div></div>';
		}
		$return_html.= '</div>';
		
		$return_html.= '<div class="one_half last parallax_scroll" style="width:'.esc_attr($content_width).'%;position:absolute;padding:'.esc_attr($padding).'px;'.esc_attr($content_custom_css).'" data-stellar-ratio="1.3">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		$return_html.= '</div>';
	}
	else
	{	
		$return_html.= '<div class="one_half parallax_scroll" style="width:'.esc_attr($content_width).'%;position:absolute;padding:'.esc_attr($padding).'px;z-index:2;block !important;'.esc_attr($content_custom_css).'" data-stellar-ratio="1.3">';
		
		//Add title and content
		if(!empty($title))
		{
			$return_html.= '<h2 class="ppb_title" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode(grandphotography_get_first_title_word($title)).'</h2>';
		}
		
		if(!empty($subtitle))
		{
			$return_html.= '<hr class="title_break bold left" style="'.esc_attr($custom_css_bordercolor).'"/>';
			$return_html.= '<div class="page_tagline" style="'.esc_attr($custom_css_fontcolor).'">'.rawurldecode($subtitle).'</div>';
		}
		
		if(!empty($content))
		{
			$return_html.= '<div class="ppb_header_content">'.do_shortcode(grandphotography_apply_content($content)).'</div>';
		}
		$return_html.= '</div>';
		
		$return_html.= '<div class="one_half parallax_scroll_image last" style="width:'.$image_width.'%;">';
		if(!empty($image))
		{
			$image_id = grandphotography_get_image_id($image);
			$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
			
			$return_html.= '<div class="image_classic_frame expand"><div class="image_wrapper">';
			$return_html.= '<img src="'.esc_url($image).'" alt="'.esc_attr($image_alt).'" class="portfolio_img"/>';
			$return_html.= '</div></div>';
		}
		$return_html.= '</div>';
	}
	
	$return_html.= '<br class="clear"/></div>';
	$return_html.= '</div>';
	$return_html.= '</div>';
	
	//Set end wrapper div for live builder
	$return_html.= grandphotography_live_builder_end_wrapper($builder_id);
	
	$return_html.= '</div>';

	return $return_html;
}

add_shortcode('ppb_card_two_cols_with_image', 'ppb_card_two_cols_with_image_func');


function ppb_revslider_func($atts, $content) {
	
    //extract short code attr
    extract(shortcode_atts(array(
    	'size' => 'one',
    	'slug' => '',
    	'slider_id' => '',
    	'display' => '',
    	'builder_id' => '',
    ), $atts));
    
    $sec_id = '';
    if(!empty($slug))
    {
    	$sec_id = 'id="'.esc_attr($slug).'"';
    }

    $return_html = '<div '.$sec_id.' class="'.esc_attr($size).' fullwidth ';
    
    if($display == 'force')
    {
    	$return_html.= 'slideronly';
    }
    
    $return_html.= '">';
    
    //Set begin wrapper div for live builder
    $return_html.= grandphotography_live_builder_begin_wrapper($builder_id);
    
    $return_html.= do_shortcode('[rev_slider '.$slider_id.']');
    
    //Set end wrapper div for live builder
    $return_html.= grandphotography_live_builder_end_wrapper($builder_id);
    
    $return_html.= '</div>';

    return $return_html;

}

add_shortcode('ppb_revslider', 'ppb_revslider_func');
?>