if (THREE!==undefined) {	
	THREE.CopyShader={uniforms:{tDiffuse:{value:null},opacity:{value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\n\tvUv = uv;\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform float opacity;\nuniform sampler2D tDiffuse;\nvarying vec2 vUv;\nvoid main() {\n\tvec4 texel = texture2D( tDiffuse, vUv );\n\tgl_FragColor = opacity * texel;\n}"};	
	THREE.DigitalGlitch={uniforms:{tDiffuse:{value:null},tDisp:{value:null},byp:{value:0},amount:{value:.08},angle:{value:.02},seed:{value:.02},seed_x:{value:.02},seed_y:{value:.02},distortion_x:{value:.5},distortion_y:{value:.6},col_s:{value:.05}},vertexShader:"varying vec2 vUv;\nvoid main() {\n\tvUv = uv;\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform int byp;\nuniform sampler2D tDiffuse;\nuniform sampler2D tDisp;\nuniform float amount;\nuniform float angle;\nuniform float seed;\nuniform float seed_x;\nuniform float seed_y;\nuniform float distortion_x;\nuniform float distortion_y;\nuniform float col_s;\nvarying vec2 vUv;\nfloat rand(vec2 co){\n\treturn fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n}\nvoid main() {\n\tif(byp<1) {\n\t\tvec2 p = vUv;\n\t\tfloat xs = floor(gl_FragCoord.x / 0.5);\n\t\tfloat ys = floor(gl_FragCoord.y / 0.5);\n\t\tvec4 normal = texture2D (tDisp, p*seed*seed);\n\t\tif(p.y<distortion_x+col_s && p.y>distortion_x-col_s*seed) {\n\t\t\tif(seed_x>0.){\n\t\t\t\tp.y = 1. - (p.y + distortion_y);\n\t\t\t}\n\t\t\telse {\n\t\t\t\tp.y = distortion_y;\n\t\t\t}\n\t\t}\n\t\tif(p.x<distortion_y+col_s && p.x>distortion_y-col_s*seed) {\n\t\t\tif(seed_y>0.){\n\t\t\t\tp.x=distortion_x;\n\t\t\t}\n\t\t\telse {\n\t\t\t\tp.x = 1. - (p.x + distortion_x);\n\t\t\t}\n\t\t}\n\t\tp.x+=normal.x*seed_x*(seed/5.);\n\t\tp.y+=normal.y*seed_y*(seed/5.);\n\t\tvec2 offset = amount * vec2( cos(angle), sin(angle));\n\t\tvec4 cr = texture2D(tDiffuse, p + offset);\n\t\tvec4 cga = texture2D(tDiffuse, p);\n\t\tvec4 cb = texture2D(tDiffuse, p - offset);\n\t\tgl_FragColor = vec4(cr.r, cga.g, cb.b, cga.a);\n\t\tvec4 snow = 200.*amount*vec4(rand(vec2(xs * seed,ys * seed*50.))*0.2);\n\t\tgl_FragColor = gl_FragColor+ snow;\n\t}\n\telse {\n\t\tgl_FragColor=texture2D (tDiffuse, vUv);\n\t}\n}"};
	THREE.EffectComposer=function(a,b){if(this.renderer=a,void 0===b){var c={minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat},d=a.getSize(new THREE.Vector2);this._pixelRatio=a.getPixelRatio(),this._width=d.width,this._height=d.height,b=new THREE.WebGLRenderTarget(this._width*this._pixelRatio,this._height*this._pixelRatio,c),b.texture.name="EffectComposer.rt1"}else this._pixelRatio=1,this._width=b.width,this._height=b.height;this.renderTarget1=b,this.renderTarget2=b.clone(),this.renderTarget2.texture.name="EffectComposer.rt2",this.writeBuffer=this.renderTarget1,this.readBuffer=this.renderTarget2,this.renderToScreen=!0,this.passes=[],void 0===THREE.CopyShader&&console.error("THREE.EffectComposer relies on THREE.CopyShader"),void 0===THREE.ShaderPass&&console.error("THREE.EffectComposer relies on THREE.ShaderPass"),this.copyPass=new THREE.ShaderPass(THREE.CopyShader),this.clock=new THREE.Clock},Object.assign(THREE.EffectComposer.prototype,{swapBuffers:function(){var a=this.readBuffer;this.readBuffer=this.writeBuffer,this.writeBuffer=a},addPass:function(a){this.passes.push(a),a.setSize(this._width*this._pixelRatio,this._height*this._pixelRatio)},insertPass:function(a,b){this.passes.splice(b,0,a),a.setSize(this._width*this._pixelRatio,this._height*this._pixelRatio)},removePass:function(a){const b=this.passes.indexOf(a);-1!==b&&this.passes.splice(b,1)},isLastEnabledPass:function(a){for(var b=a+1;b<this.passes.length;b++)if(this.passes[b].enabled)return!1;return!0},render:function(a){a===void 0&&(a=this.clock.getDelta());var b,c,d=this.renderer.getRenderTarget(),e=!1,f=this.passes.length;for(c=0;c<f;c++)if(b=this.passes[c],!1!==b.enabled){if(b.renderToScreen=this.renderToScreen&&this.isLastEnabledPass(c),b.render(this.renderer,this.writeBuffer,this.readBuffer,a,e),b.needsSwap){if(e){var g=this.renderer.getContext(),h=this.renderer.state.buffers.stencil;h.setFunc(g.NOTEQUAL,1,4294967295),this.copyPass.render(this.renderer,this.writeBuffer,this.readBuffer,a),h.setFunc(g.EQUAL,1,4294967295)}this.swapBuffers()}void 0!==THREE.MaskPass&&(b instanceof THREE.MaskPass?e=!0:b instanceof THREE.ClearMaskPass&&(e=!1))}this.renderer.setRenderTarget(d)},reset:function(a){if(a===void 0){var b=this.renderer.getSize(new THREE.Vector2);this._pixelRatio=this.renderer.getPixelRatio(),this._width=b.width,this._height=b.height,a=this.renderTarget1.clone(),a.setSize(this._width*this._pixelRatio,this._height*this._pixelRatio)}this.renderTarget1.dispose(),this.renderTarget2.dispose(),this.renderTarget1=a,this.renderTarget2=a.clone(),this.writeBuffer=this.renderTarget1,this.readBuffer=this.renderTarget2},setSize:function(a,b){this._width=a,this._height=b;var c=this._width*this._pixelRatio,d=this._height*this._pixelRatio;this.renderTarget1.setSize(c,d),this.renderTarget2.setSize(c,d);for(var e=0;e<this.passes.length;e++)this.passes[e].setSize(c,d)},setPixelRatio:function(a){this._pixelRatio=a,this.setSize(this._width,this._height)}}),THREE.Pass=function(){this.enabled=!0,this.needsSwap=!0,this.clear=!1,this.renderToScreen=!1},Object.assign(THREE.Pass.prototype,{setSize:function(){},render:function(){console.error("THREE.Pass: .render() must be implemented in derived pass.")}}),THREE.Pass.FullScreenQuad=function(){var a=new THREE.OrthographicCamera(-1,1,1,-1,0,1),b=new THREE.BufferGeometry;b.setAttribute("position",new THREE.Float32BufferAttribute([-1,3,0,-1,-1,0,3,-1,0],3)),b.setAttribute("uv",new THREE.Float32BufferAttribute([0,2,0,0,2,0],2));var c=function(a){this._mesh=new THREE.Mesh(b,a)};return Object.defineProperty(c.prototype,"material",{get:function(){return this._mesh.material},set:function(a){this._mesh.material=a}}),Object.assign(c.prototype,{dispose:function(){this._mesh.geometry.dispose()},render:function(b){b.render(this._mesh,a)}}),c}();
	THREE.RenderPass=function(a,b,c,d,e){THREE.Pass.call(this),this.scene=a,this.camera=b,this.overrideMaterial=c,this.clearColor=d,this.clearAlpha=e===void 0?0:e,this.clear=!0,this.clearDepth=!1,this.needsSwap=!1,this._oldClearColor=new THREE.Color},THREE.RenderPass.prototype=Object.assign(Object.create(THREE.Pass.prototype),{constructor:THREE.RenderPass,render:function(a,b,c){var d=a.autoClear;a.autoClear=!1;var e,f;this.overrideMaterial!==void 0&&(f=this.scene.overrideMaterial,this.scene.overrideMaterial=this.overrideMaterial),this.clearColor&&(a.getClearColor(this._oldClearColor),e=a.getClearAlpha(),a.setClearColor(this.clearColor,this.clearAlpha)),this.clearDepth&&a.clearDepth(),a.setRenderTarget(this.renderToScreen?null:c),this.clear&&a.clear(a.autoClearColor,a.autoClearDepth,a.autoClearStencil),a.render(this.scene,this.camera),this.clearColor&&a.setClearColor(this._oldClearColor,e),this.overrideMaterial!==void 0&&(this.scene.overrideMaterial=f),a.autoClear=d}});
	THREE.GlitchPass = function ( dt_size,obj ) {
		THREE.Pass.call( this );

		if ( THREE.DigitalGlitch === undefined ) console.error( 'THREE.GlitchPass relies on THREE.DigitalGlitch' );

		var shader = THREE.DigitalGlitch;
		this.uniforms = THREE.UniformsUtils.clone( shader.uniforms );
		if (typeof dt_size==="object") {
			obj = {...dt_size};
			dt_size = 64;
		}
		if ( typeof dt_size==="object" || dt_size == undefined ) dt_size = 64;


		this.uniforms[ 'tDisp' ].value = this.generateHeightmap( dt_size );
		//ThemePunch Modifications
		this.uniforms[ 'damount' ] = 90;
		this.uniforms[ 'dseed' ] = 0.3;
		this.uniforms[ 'drepeat'] = 5;
		this.uniforms[ 'dlen'] = 120;

		if (obj) {
			if (obj.damount) this.uniforms[ 'damount' ] = obj.damount;
			if (obj.dseed) this.uniforms[ 'dseed' ] = obj.dseed;
			if (obj.drepeat) this.uniforms[ 'drepeat'] = obj.drepeat;
			if (obj.drepeat) this.uniforms[ 'dlen'] = obj.dlen;
		}


		this.material = new THREE.ShaderMaterial( {
			uniforms: this.uniforms,
			vertexShader: shader.vertexShader,
			fragmentShader: shader.fragmentShader
		} );

		this.fsQuad = new THREE.Pass.FullScreenQuad( this.material );

		this.goWild = false;
		this.curF = 0;
		this.generateTrigger(this.uniforms[ 'dlen']);
	};

	THREE.GlitchPass.prototype = Object.assign( Object.create( THREE.Pass.prototype ), {

		constructor: THREE.GlitchPass,

		render: function ( renderer, writeBuffer, readBuffer /*, deltaTime, maskActive */ ) {

			this.uniforms[ 'tDiffuse' ].value = readBuffer.texture;
			this.uniforms[ 'seed' ].value = Math.random();//default seeding
			this.uniforms[ 'byp' ].value = 0;			
			
			if ( this.curF % this.randX < this.randX / this.uniforms[ 'drepeat'] ) {				
				this.uniforms[ 'amount' ].value = Math.random() / this.uniforms[ 'damount'];
				this.uniforms[ 'angle' ].value = THREE.MathUtils.randFloat( - Math.PI, Math.PI );
				this.uniforms[ 'distortion_x' ].value = THREE.MathUtils.randFloat( 0, 1 );
				this.uniforms[ 'distortion_y' ].value = THREE.MathUtils.randFloat( 0, 1 );
				this.uniforms[ 'seed_x' ].value = THREE.MathUtils.randFloat( - this.uniforms[ 'dseed'], this.uniforms[ 'dseed'] );
				this.uniforms[ 'seed_y' ].value = THREE.MathUtils.randFloat( - this.uniforms[ 'dseed'], this.uniforms[ 'dseed'] );

			} else if ( this.goWild == false ) {

				this.uniforms[ 'byp' ].value = 1;

			}

			this.curF ++;

			if ( this.renderToScreen ) {

				renderer.setRenderTarget( null );
				this.fsQuad.render( renderer );

			} else {

				renderer.setRenderTarget( writeBuffer );
				if ( this.clear ) renderer.clear();
				this.fsQuad.render( renderer );

			}

		},

		generateTrigger: function (len) {

			this.randX = THREE.MathUtils.randInt( len, len*2 );

		},

		generateHeightmap: function ( dt_size ) {

			var data_arr = new Float32Array( dt_size * dt_size * 3 );
			var length = dt_size * dt_size;

			for ( var i = 0; i < length; i ++ ) {

				var val = THREE.MathUtils.randFloat( 0, 1 );
				data_arr[ i * 3 + 0 ] = val;
				data_arr[ i * 3 + 1 ] = val;
				data_arr[ i * 3 + 2 ] = val;

			}

			return new THREE.DataTexture( data_arr, dt_size, dt_size, THREE.RGBFormat, THREE.FloatType );

		}

	} );

	THREE.ShaderPass=function(a,b){THREE.Pass.call(this),this.textureID=b===void 0?"tDiffuse":b,a instanceof THREE.ShaderMaterial?(this.uniforms=a.uniforms,this.material=a):a&&(this.uniforms=THREE.UniformsUtils.clone(a.uniforms),this.material=new THREE.ShaderMaterial({defines:Object.assign({},a.defines),uniforms:this.uniforms,vertexShader:a.vertexShader,fragmentShader:a.fragmentShader})),this.fsQuad=new THREE.Pass.FullScreenQuad(this.material)},THREE.ShaderPass.prototype=Object.assign(Object.create(THREE.Pass.prototype),{constructor:THREE.ShaderPass,render:function(a,b,c){this.uniforms[this.textureID]&&(this.uniforms[this.textureID].value=c.texture),this.fsQuad.material=this.material,this.renderToScreen?(a.setRenderTarget(null),this.fsQuad.render(a)):(a.setRenderTarget(b),this.clear&&a.clear(a.autoClearColor,a.autoClearDepth,a.autoClearStencil),this.fsQuad.render(a))}});	

	var _R = _R_is_Editor ? RVS._R : jQuery.fn.revolution;

	_R.postProcessing = _R.postProcessing || {};

	_R.postProcessing.glitches = {
		init: function(renderer, scene, camera,obj) {
			let PP = {};
			PP.type = "glitches";
			PP.composer = new THREE.EffectComposer( renderer);
		  	PP.renderPass = new THREE.RenderPass( scene, camera );
		  	PP.glitchPass = new THREE.GlitchPass({
		  		damount:parseInt(obj.amount) || 90,
		  		dseed:parseFloat(obj.seed) || 0.3,
		  		drepeat:parseFloat(obj.repeat) || 5,
		  		dlen:parseInt(obj.len) || 120
		  	});		  	
		  	
			PP.composer.addPass( PP.renderPass );				
			PP.composer.addPass( PP.glitchPass );
			return PP;
		}
	}

}