<?php
/**
*	Setup contact form mailing function
**/
add_action('wp_ajax_grandphotography_contact_mailer', 'grandphotography_contact_mailer');
add_action('wp_ajax_nopriv_grandphotography_contact_mailer', 'grandphotography_contact_mailer');

function grandphotography_contact_mailer() {
	check_ajax_referer( 'tgajax-post-contact-nonce', 'tg_security' );
	
	//Error message when message can't send
	define('ERROR_MESSAGE', 'Oops! something went wrong, please try to submit later.');
	
	if (isset($_POST['your_name'])) {
	
		//Get your email address
		$contact_email = get_option('pp_contact_email');
		$pp_contact_thankyou = esc_html__('Thank you! We will get back to you as soon as possible', 'grandphotography-custom-post' );
		
		/*
		|
		| Begin sending mail
		|
		*/
		
		$from_name = $_POST['your_name'];
		$from_email = $_POST['email'];
		
		//Get contact subject
		if(!isset($_POST['subject']))
		{
			$contact_subject = esc_html__('[Email Contact]', 'grandphotography-custom-post' ).' '.get_bloginfo('name');
		}
		else
		{
			$contact_subject = $_POST['subject'];
		}
		
		$headers = "";
	   	//$headers.= 'From: '.$from_name.' <'.$from_email.'>'.PHP_EOL;
	   	$headers.= 'Reply-To: '.$from_name.' <'.$from_email.'>'.PHP_EOL;
	   	$headers.= 'Return-Path: '.$from_name.' <'.$from_email.'>'.PHP_EOL;
		
		$message = esc_html__('Name', 'grandphotography-custom-post' ).': '.$from_name.PHP_EOL;
		$message.= esc_html__('Email', 'grandphotography-custom-post' ).': '.$from_email.PHP_EOL.PHP_EOL;
		$message.= esc_html__('Message', 'grandphotography-custom-post' ).': '.PHP_EOL.$_POST['message'].PHP_EOL.PHP_EOL;
		
		if(isset($_POST['address']))
		{
			$message.= esc_html__('Address', 'grandphotography-custom-post' ).': '.$_POST['address'].PHP_EOL;
		}
		
		if(isset($_POST['phone']))
		{
			$message.= esc_html__('Phone', 'grandphotography-custom-post' ).': '.$_POST['phone'].PHP_EOL;
		}
		
		if(isset($_POST['mobile']))
		{
			$message.= esc_html__('Mobile', 'grandphotography-custom-post' ).': '.$_POST['mobile'].PHP_EOL;
		}
		
		if(isset($_POST['company']))
		{
			$message.= esc_html__('Company:', 'grandphotography-custom-post' ).': '.$_POST['company'].PHP_EOL;
		}
		
		if(isset($_POST['country']))
		{
			$message.= esc_html__('Country:', 'grandphotography-custom-post' ).': '.$_POST['country'].PHP_EOL;
		}
		    
		
		if(!empty($from_name) && !empty($from_email) && !empty($message))
		{
			wp_mail($contact_email, $contact_subject, $message, $headers);
			echo '<p>'.$pp_contact_thankyou.'</p>';
			
			die;
		}
		else
		{
			echo '<p>'.ERROR_MESSAGE.'</p>';
			
			die;
		}

	}
	else 
	{
		echo '<p>'.ERROR_MESSAGE.'</p>';
	}
	die();
}

/**
*	End theme contact form mailing function
**/


/**
*	Setup photo proofing mailing function
**/
add_action('wp_ajax_grandphotography_proofing_notify_mailer', 'grandphotography_proofing_notify_mailer');
add_action('wp_ajax_nopriv_grandphotography_proofing_notify_mailer', 'grandphotography_proofing_notify_mailer');

function grandphotography_proofing_notify_mailer() {
	check_ajax_referer( 'tgajax-post-contact-nonce', 'tg_security' );
	
	//Error message when message can't send
	define('ERROR_MESSAGE', 'Oops! something went wrong, please try to submit later.');
	
	if (isset($_POST['gallery_id'])) {
	
		//Get your email address
		$contact_email = get_option('pp_contact_email');
		$contact_thankyou = esc_html__('Thank you for your selection! We will get back to you as soon as possible.', 'grandphotography-custom-post' );
		$gallery_title = get_the_title($_POST['gallery_id']);
		$gallery_link = get_permalink($_POST['gallery_id']);
		
		/*
		|
		| Begin sending mail
		|
		*/
		
		//Get contact subject
		if(!isset($_POST['subject']))
		{
			$contact_subject = esc_html__('[Notification From Client]', 'grandphotography-custom-post' ).' '.$gallery_title.' | '.get_bloginfo('name');
		}
		else
		{
			$contact_subject = $_POST['subject'];
		}
		
		$message = esc_html__('You client sent notification on gallery', 'grandphotography-custom-post' ).': '.$gallery_title.PHP_EOL;
		$message.= esc_html__('Please check client proofing here', 'grandphotography-custom-post' ).': '.esc_url($gallery_link).PHP_EOL;
		    
		
		if(!empty($message))
		{
			wp_mail($contact_email, $contact_subject, $message);
			echo '<p>'.$contact_thankyou.'</p>';
			
			die;
		}
		else
		{
			echo '<p>'.ERROR_MESSAGE.'</p>';
			
			die;
		}

	}
	else 
	{
		echo '<p>'.ERROR_MESSAGE.'</p>';
	}
	die();
}

/**
*	End theme photo proofing mailing function
**/
?>