<?php
/*
Plugin Name: Grand Photography Theme Custom Post Type
Plugin URI: http://themes.themegoods2.com/grandphotography/demo/
Description: Plugin that will create custom post types for Grand Photography theme.
Version: 2.5
Author: ThemeGoods
Author URI: http://themeforest.net/user/ThemeGoods
License: GPLv2
*/

//Setup translation string via PO file

add_action('plugins_loaded', 'grandphotography_load_textdomain');
function grandphotography_load_textdomain() 
{
	load_plugin_textdomain( 'grandphotography-custom-post', FALSE, dirname( plugin_basename(__FILE__) ) . '/languages/' );
}

function post_type_galleries() {
	//Get custom permalink setting
	$tg_permalink_galleries = get_option(SHORTNAME.'_permalink_galleries');
	if(empty($tg_permalink_galleries)) {
		$tg_permalink_galleries = 'galleries';
	}
	
	$tg_permalink_gallerycat = get_option(SHORTNAME.'_permalink_gallerycat');
	if(empty($tg_permalink_gallerycat)) {
		$tg_permalink_gallerycat = 'gallerycat';
	}
	
	$labels = array(
    	'name' => _x('Galleries', 'post type general name', 'grandphotography-custom-post'),
    	'singular_name' => _x('Gallery', 'post type singular name', 'grandphotography-custom-post'),
    	'add_new' => _x('Add New Gallery', 'book', 'grandphotography-custom-post'),
    	'add_new_item' => esc_html__('Add New Gallery', 'grandphotography-custom-post'),
    	'edit_item' => esc_html__('Edit Gallery', 'grandphotography-custom-post'),
    	'new_item' => esc_html__('New Gallery', 'grandphotography-custom-post'),
    	'view_item' => esc_html__('View Gallery', 'grandphotography-custom-post'),
    	'search_items' => esc_html__('Search Gallery', 'grandphotography-custom-post'),
    	'not_found' =>  esc_html__('No Gallery found', 'grandphotography-custom-post'),
    	'not_found_in_trash' => esc_html__('No Gallery found in Trash', 'grandphotography-custom-post'), 
    	'parent_item_colon' => ''
	);		
	$args = array(
    	'labels' => $labels,
    	'public' => true,
    	'publicly_queryable' => true,
    	'show_ui' => true, 
    	'query_var' => true,
    	'rewrite' => array('slug' => $tg_permalink_galleries,'with_front' => false),
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'menu_position' => null,
    	'supports' => array('title', 'thumbnail', 'excerpt', 'comments' ),
    	'menu_icon' => ''
	); 		

	register_post_type( 'galleries', $args );
	
  	$labels = array(			  
  	  'name' => _x( 'Gallery Categories', 'taxonomy general name', 'grandphotography-custom-post' ),
  	  'singular_name' => _x( 'Gallery Category', 'taxonomy singular name', 'grandphotography-custom-post' ),
  	  'search_items' =>  __( 'Search Gallery Categories', 'grandphotography-custom-post' ),
  	  'all_items' => __( 'All Gallery Categories', 'grandphotography-custom-post' ),
  	  'parent_item' => __( 'Parent Gallery Category', 'grandphotography-custom-post' ),
  	  'parent_item_colon' => __( 'Parent Gallery Category:', 'grandphotography-custom-post' ),
  	  'edit_item' => __( 'Edit Gallery Category', 'grandphotography-custom-post' ), 
  	  'update_item' => __( 'Update Gallery Category', 'grandphotography-custom-post' ),
  	  'add_new_item' => __( 'Add New Gallery Category', 'grandphotography-custom-post' ),
  	  'new_item_name' => __( 'New Gallery Category Name', 'grandphotography-custom-post' ),
  	); 							  	  
  	
  	register_taxonomy(
		'gallerycat',
		'galleries',
		array(
			'public'=>true,
			'hierarchical' => false,
			'labels'=> $labels,
			'query_var' => 'gallerycat',
			'show_ui' => true,
			'rewrite' => array( 'slug' => $tg_permalink_gallerycat, 'with_front' => false ),
		)
	);	
} 
								  
add_action('init', 'post_type_galleries');


function post_type_portfolios() {
	//Get custom permalink setting
	$tg_permalink_portfolio = get_option(SHORTNAME.'_permalink_portfolio');
	if(empty($tg_permalink_portfolio)) {
		$tg_permalink_speaker = 'portfolios';
	}
	
	$tg_permalink_portfoliocat = get_option(SHORTNAME.'_permalink_portfoliocat');
	if(empty($tg_permalink_portfoliocat)) {
		$tg_permalink_portfoliocat = 'portfoliosets';
	}
	
	$labels = array(
    	'name' => _x('Portfolios', 'post type general name', 'grandphotography-custom-post'),
    	'singular_name' => _x('Portfolio', 'post type singular name', 'grandphotography-custom-post'),
    	'add_new' => _x('Add New Portfolio', 'book', 'grandphotography-custom-post'),
    	'add_new_item' => esc_html__('Add New Portfolio', 'grandphotography-custom-post'),
    	'edit_item' => esc_html__('Edit Portfolio', 'grandphotography-custom-post'),
    	'new_item' => esc_html__('New Portfolio', 'grandphotography-custom-post'),
    	'view_item' => esc_html__('View Portfolio', 'grandphotography-custom-post'),
    	'search_items' => esc_html__('Search Portfolios', 'grandphotography-custom-post'),
    	'not_found' =>  esc_html__('No Portfolio found', 'grandphotography-custom-post'),
    	'not_found_in_trash' => esc_html__('No Portfolio found in Trash', 'grandphotography-custom-post'), 
    	'parent_item_colon' => ''
	);		
	$args = array(
    	'labels' => $labels,
    	'public' => true,
    	'publicly_queryable' => true,
    	'show_ui' => true, 
    	'query_var' => true,
    	'rewrite' => array('slug' => $tg_permalink_portfolio,'with_front' => false),
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'menu_position' => null,
    	'supports' => array('title','editor', 'thumbnail', 'excerpt', 'comments'),
    	'menu_icon' => ''
	); 		

	register_post_type( 'portfolios', $args );
	
  	$labels = array(			  
  	  'name' => _x( 'Portfolio Categories', 'taxonomy general name', 'grandphotography-custom-post' ),
  	  'singular_name' => _x( 'Portfolio Category', 'taxonomy singular name', 'grandphotography-custom-post' ),
  	  'search_items' =>  __( 'Search Portfolio Categories', 'grandphotography-custom-post' ),
  	  'all_items' => __( 'All Portfolio Categories', 'grandphotography-custom-post' ),
  	  'parent_item' => __( 'Parent Portfolio Category', 'grandphotography-custom-post' ),
  	  'parent_item_colon' => __( 'Parent Portfolio Category:', 'grandphotography-custom-post' ),
  	  'edit_item' => __( 'Edit Portfolio Category', 'grandphotography-custom-post' ), 
  	  'update_item' => __( 'Update Portfolio Category', 'grandphotography-custom-post' ),
  	  'add_new_item' => __( 'Add New Portfolio Category', 'grandphotography-custom-post' ),
  	  'new_item_name' => __( 'New Portfolio Category Name', 'grandphotography-custom-post' ),
  	); 							  
  	
  	register_taxonomy(
		'portfoliosets',
		'portfolios',
		array(
			'public'=>true,
			'hierarchical' => false,
			'labels'=> $labels,
			'query_var' => 'portfoliosets',
			'show_ui' => true,
			'rewrite' => array( 'slug' => $tg_permalink_portfoliocat, 'with_front' => false ),
		)
	);		  
} 
								  
add_action('init', 'post_type_portfolios');


function post_type_events() {
	$labels = array(
    	'name' => _x('Events', 'post type general name', 'grandphotography-custom-post'),
    	'singular_name' => _x('Event', 'post type singular name', 'grandphotography-custom-post'),
    	'add_new' => _x('Add New Event', 'book', 'grandphotography-custom-post'),
    	'add_new_item' => esc_html__('Add New Event', 'grandphotography-custom-post'),
    	'edit_item' => esc_html__('Edit Event', 'grandphotography-custom-post'),
    	'new_item' => esc_html__('New Event', 'grandphotography-custom-post'),
    	'view_item' => esc_html__('View Event', 'grandphotography-custom-post'),
    	'search_items' => esc_html__('Search Events', 'grandphotography-custom-post'),
    	'not_found' =>  esc_html__('No Event found', 'grandphotography-custom-post'),
    	'not_found_in_trash' => esc_html__('No Event found in Trash', 'grandphotography-custom-post'), 
    	'parent_item_colon' => ''
	);		
	$args = array(
    	'labels' => $labels,
    	'public' => true,
    	'publicly_queryable' => true,
    	'show_ui' => true, 
    	'query_var' => true,
    	'rewrite' => true,
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'menu_position' => null,
    	'supports' => array('title','editor', 'thumbnail', 'comments'),
    	'menu_icon' => ''
	);
	
	$labels = array(			  
  	  'name' => _x( 'Event Categories', 'taxonomy general name', 'grandphotography-custom-post' ),
  	  'singular_name' => _x( 'Event Category', 'taxonomy singular name', 'grandphotography-custom-post' ),
  	  'search_items' =>  __( 'Search Event Categories', 'grandphotography-custom-post' ),
  	  'all_items' => __( 'All Event Categories', 'grandphotography-custom-post' ),
  	  'parent_item' => __( 'Parent Event Category', 'grandphotography-custom-post' ),
  	  'parent_item_colon' => __( 'Parent Event Category:', 'grandphotography-custom-post' ),
  	  'edit_item' => __( 'Edit Event Category', 'grandphotography-custom-post' ), 
  	  'update_item' => __( 'Update Event Category', 'grandphotography-custom-post' ),
  	  'add_new_item' => __( 'Add New Event Category', 'grandphotography-custom-post' ),
  	  'new_item_name' => __( 'New Event Category Name', 'grandphotography-custom-post' ),
  	); 							  
  	
  	register_taxonomy(
		'eventscats',
		'events',
		array(
			'public'=>true,
			'hierarchical' => true,
			'labels'=> $labels,
			'query_var' => 'eventscats',
			'show_ui' => true,
			'rewrite' => array( 'slug' => 'eventscats', 'with_front' => false ),
		)
	);

	register_post_type( 'events', $args );			  
} 
								  
add_action('init', 'post_type_events');


function post_type_testimonials() {
	$labels = array(
    	'name' => _x('Testimonials', 'post type general name', 'grandphotography-custom-post'),
    	'singular_name' => _x('Testimonial', 'post type singular name', 'grandphotography-custom-post'),
    	'add_new' => _x('Add New Testimonial', 'book', 'grandphotography-custom-post'),
    	'add_new_item' => esc_html__('Add New Testimonial', 'grandphotography-custom-post'),
    	'edit_item' => esc_html__('Edit Testimonial', 'grandphotography-custom-post'),
    	'new_item' => esc_html__('New Testimonial', 'grandphotography-custom-post'),
    	'view_item' => esc_html__('View Testimonial', 'grandphotography-custom-post'),
    	'search_items' => esc_html__('Search Testimonial', 'grandphotography-custom-post'),
    	'not_found' =>  esc_html__('No Testimonial found', 'grandphotography-custom-post'),
    	'not_found_in_trash' => esc_html__('No Testimonial found in Trash', 'grandphotography-custom-post'), 
    	'parent_item_colon' => ''
	);		
	$args = array(
    	'labels' => $labels,
    	'public' => true,
    	'publicly_queryable' => true,
    	'show_ui' => true, 
    	'query_var' => true,
    	'rewrite' => true,
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'menu_position' => null,
    	'supports' => array('title', 'editor', 'thumbnail'),
    	'menu_icon' => ''
	); 		

	register_post_type( 'testimonials', $args );
	
	$labels = array(			  
  	  'name' => _x( 'Testimonial Categories', 'taxonomy general name', 'grandphotography-custom-post' ),
  	  'singular_name' => _x( 'Testimonial Category', 'taxonomy singular name', 'grandphotography-custom-post' ),
  	  'search_items' =>  __( 'Search Testimonial Categories', 'grandphotography-custom-post' ),
  	  'all_items' => __( 'All Testimonial Categories', 'grandphotography-custom-post' ),
  	  'parent_item' => __( 'Parent Testimonial Category', 'grandphotography-custom-post' ),
  	  'parent_item_colon' => __( 'Parent Testimonial Category:', 'grandphotography-custom-post' ),
  	  'edit_item' => __( 'Edit Testimonial Category', 'grandphotography-custom-post' ), 
  	  'update_item' => __( 'Update Testimonial Category', 'grandphotography-custom-post' ),
  	  'add_new_item' => __( 'Add New Testimonial Category', 'grandphotography-custom-post' ),
  	  'new_item_name' => __( 'New Testimonial Category Name', 'grandphotography-custom-post' ),
  	); 							  
  	
  	register_taxonomy(
		'testimonialcats',
		'testimonials',
		array(
			'public'=>true,
			'hierarchical' => false,
			'labels'=> $labels,
			'query_var' => 'testimonialcats',
			'show_ui' => true,
			'rewrite' => array( 'slug' => 'testimonialcats', 'with_front' => false ),
		)
	);		  
} 
								  
add_action('init', 'post_type_testimonials');


function post_type_clients() {
	$labels = array(
    	'name' => _x('Clients', 'post type general name', 'grandphotography-custom-post'),
    	'singular_name' => _x('Client', 'post type singular name', 'grandphotography-custom-post'),
    	'add_new' => _x('Add Client', 'book', 'grandphotography-custom-post'),
    	'add_new_item' => esc_html__('Add New Client', 'grandphotography-custom-post'),
    	'edit_item' => esc_html__('Edit Client', 'grandphotography-custom-post'),
    	'new_item' => esc_html__('New Client', 'grandphotography-custom-post'),
    	'view_item' => esc_html__('View Client', 'grandphotography-custom-post'),
    	'search_items' => esc_html__('Search Client', 'grandphotography-custom-post'),
    	'not_found' =>  esc_html__('No Client found', 'grandphotography-custom-post'),
    	'not_found_in_trash' => esc_html__('No Client found in Trash', 'grandphotography-custom-post'), 
    	'parent_item_colon' => ''
	);		
	$args = array(
    	'labels' => $labels,
    	'public' => true,
    	'publicly_queryable' => true,
    	'show_ui' => true, 
    	'query_var' => true,
    	'rewrite' => true,
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'menu_position' => null,
    	'supports' => array('title', 'editor', 'thumbnail'),
    	'menu_icon' => ''
	); 		

	register_post_type( 'clients', $args );
}
add_action('init', 'post_type_clients');


function post_type_team() {
	$labels = array(
    	'name' => _x('Team Members', 'post type general name', 'grandphotography-custom-post'),
    	'singular_name' => _x('Team Member', 'post type singular name', 'grandphotography-custom-post'),
    	'add_new' => _x('Add New Team Member', 'book', 'grandphotography-custom-post'),
    	'add_new_item' => esc_html__('Add New Team Member', 'grandphotography-custom-post'),
    	'edit_item' => esc_html__('Edit Team Member', 'grandphotography-custom-post'),
    	'new_item' => esc_html__('New Team Member', 'grandphotography-custom-post'),
    	'view_item' => esc_html__('View Team Member', 'grandphotography-custom-post'),
    	'search_items' => esc_html__('Search Team Members', 'grandphotography-custom-post'),
    	'not_found' =>  esc_html__('No Team Member found', 'grandphotography-custom-post'),
    	'not_found_in_trash' => esc_html__('No Team Member found in Trash', 'grandphotography-custom-post'), 
    	'parent_item_colon' => ''
	);		
	$args = array(
    	'labels' => $labels,
    	'public' => true,
    	'publicly_queryable' => true,
    	'show_ui' => true, 
    	'query_var' => true,
    	'rewrite' => true,
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'menu_position' => null,
    	'supports' => array('title','editor', 'thumbnail'),
    	'menu_icon' => ''
	); 		

	register_post_type( 'team', $args );
	
	$labels = array(			  
  	  'name' => _x( 'Team Categories', 'taxonomy general name', 'grandphotography-custom-post' ),
  	  'singular_name' => _x( 'Team Category', 'taxonomy singular name', 'grandphotography-custom-post' ),
  	  'search_items' =>  __( 'Team Service Categories', 'grandphotography-custom-post' ),
  	  'all_items' => __( 'All Team Categories', 'grandphotography-custom-post' ),
  	  'parent_item' => __( 'Parent Team Category', 'grandphotography-custom-post' ),
  	  'parent_item_colon' => __( 'Parent Team Category:', 'grandphotography-custom-post' ),
  	  'edit_item' => __( 'Edit Team Category', 'grandphotography-custom-post' ), 
  	  'update_item' => __( 'Update Team Category', 'grandphotography-custom-post' ),
  	  'add_new_item' => __( 'Add New Team Category', 'grandphotography-custom-post' ),
  	  'new_item_name' => __( 'New Team Category Name', 'grandphotography-custom-post' ),
  	); 							  
  	
  	register_taxonomy(
		'teamcats',
		'team',
		array(
			'public'=>true,
			'hierarchical' => false,
			'labels'=> $labels,
			'query_var' => 'teamcats',
			'show_ui' => true,
			'rewrite' => array( 'slug' => 'teamcats', 'with_front' => false ),
		)
	);
}
add_action('init', 'post_type_team');


function post_type_pricing() {
	$labels = array(
    	'name' => _x('Pricing', 'post type general name', 'grandphotography-custom-post'),
    	'singular_name' => _x('Pricing', 'post type singular name', 'grandphotography-custom-post'),
    	'add_new' => _x('Add New Pricing', 'book', 'grandphotography-custom-post'),
    	'add_new_item' => esc_html__('Add New Pricing', 'grandphotography-custom-post'),
    	'edit_item' => esc_html__('Edit Pricing', 'grandphotography-custom-post'),
    	'new_item' => esc_html__('New Pricing', 'grandphotography-custom-post'),
    	'view_item' => esc_html__('View Pricing', 'grandphotography-custom-post'),
    	'search_items' => esc_html__('Search Pricings', 'grandphotography-custom-post'),
    	'not_found' =>  esc_html__('No Pricing found', 'grandphotography-custom-post'),
    	'not_found_in_trash' => esc_html__('No Pricing found in Trash', 'grandphotography-custom-post'), 
    	'parent_item_colon' => ''
	);		
	$args = array(
    	'labels' => $labels,
    	'public' => true,
    	'publicly_queryable' => true,
    	'show_ui' => true, 
    	'query_var' => true,
    	'rewrite' => true,
    	'capability_type' => 'post',
    	'hierarchical' => false,
    	'menu_position' => null,
    	'supports' => array('title'),
    	'menu_icon' => ''
	); 		

	register_post_type( 'pricing', $args );
	
	$labels = array(			  
  	  'name' => _x( 'Pricing Categories', 'taxonomy general name', 'grandphotography-custom-post' ),
  	  'singular_name' => _x( 'Pricing Category', 'taxonomy singular name', 'grandphotography-custom-post' ),
  	  'search_items' =>  __( 'Pricing Service Categories', 'grandphotography-custom-post' ),
  	  'all_items' => __( 'All Pricing Categories', 'grandphotography-custom-post' ),
  	  'parent_item' => __( 'Parent Pricing Category', 'grandphotography-custom-post' ),
  	  'parent_item_colon' => __( 'Parent Pricing Category:', 'grandphotography-custom-post' ),
  	  'edit_item' => __( 'Edit Pricing Category', 'grandphotography-custom-post' ), 
  	  'update_item' => __( 'Update Pricing Category', 'grandphotography-custom-post' ),
  	  'add_new_item' => __( 'Add New Pricing Category', 'grandphotography-custom-post' ),
  	  'new_item_name' => __( 'New Pricing Category Name', 'grandphotography-custom-post' ),
  	); 							  
  	
  	register_taxonomy(
		'pricingcats',
		'pricing',
		array(
			'public'=>true,
			'hierarchical' => false,
			'labels'=> $labels,
			'query_var' => 'pricingcats',
			'show_ui' => true,
			'rewrite' => array( 'slug' => 'pricingcats', 'with_front' => false ),
		)
	);
}
add_action('init', 'post_type_pricing');


add_filter( 'manage_posts_columns', 'rt_add_gravatar_col');
function rt_add_gravatar_col($cols) {
	$cols['thumbnail'] = esc_html__('Thumbnail', 'grandphotography-custom-post');
	return $cols;
}

add_action( 'manage_posts_custom_column', 'rt_get_author_gravatar');
function rt_get_author_gravatar($column_name ) {
	if ( $column_name  == 'thumbnail'  ) {
		echo get_the_post_thumbnail(get_the_ID(), array(100, 100));
	}
}

/*
	Get gallery list
*/
$args = array(
    'numberposts' => -1,
    'post_type' => array('galleries'),
);

$galleries_arr = get_posts($args);
$galleries_select = array();
$galleries_select['(Display Post Featured Image)'] = '';
$galleries_select['(Hide Post Featured Image)'] = -1;

foreach($galleries_arr as $gallery)
{
	$galleries_select[$gallery->post_title] = $gallery->ID;
}

/*
	Get post layouts
*/
$post_layout_select = array();
$post_layout_select = array(
	'With Right Sidebar' => get_template_directory_uri().'/functions/images/post/post1.png',
	'With Left Sidebar' => get_template_directory_uri().'/functions/images/post/post2.png',
	'Fullwidth' => get_template_directory_uri().'/functions/images/post/post3.png',
);

//Get all sidebars
$theme_sidebar = array(
	'' => '',
	'Page Sidebar' => 'Page Sidebar', 
	'Contact Sidebar' => 'Contact Sidebar', 
	'Blog Sidebar' => 'Blog Sidebar',
);

$dynamic_sidebar = get_option('pp_sidebar');

if(!empty($dynamic_sidebar))
{
	foreach($dynamic_sidebar as $sidebar)
	{
		$theme_sidebar[$sidebar] = $sidebar;
	}
}

/*
	Get gallery template sample URLs
*/
$gallery_template_urls = array(
    "Gallery Fullscreen Cover" 				=> site_url('/galleries/fullscreen-gallery-cover/'),
    "Gallery Kenburns" 						=> site_url('/galleries/kenburns-gallery/'),
    "Gallery Horizontal" 					=> site_url('/galleries/horizontal-gallery/'),
    "Gallery Horizontal Contained" 			=> site_url('/galleries/horizontal-gallery-contained/'),
    "Gallery Striped Contained" 			=> site_url('/galleries/striped-gallery/'),
    "Gallery Striped Wide" 					=> site_url('/galleries/gallery-striped-wide/'),
    "Gallery Flow" 							=> site_url('/galleries/flow-gallery/'),
    "Gallery Split Screen" 					=> site_url('/galleries/gallery-split-screen/'),
    "Gallery Split Screen Wide" 			=> site_url('/galleries/gallery-split-screen-wide/'),
    "Gallery 1 Column Contained" 			=> site_url('/galleries/gallery-1-column-contained/'),
    "Gallery 2 Columns Contained" 			=> site_url('/galleries/gallery-2-columns-contained/'),
    "Gallery 3 Columns Contained" 			=> site_url('/galleries/gallery-3-columns-contained/'),
    "Gallery 4 Columns Contained" 			=> site_url('/galleries/gallery-4-columns-contained/'),
    "Gallery Masonry 2 Columns Contained" 	=> site_url('/galleries/gallery-masonry-2-columns-contained/'),
    "Gallery Masonry 3 Columns Contained" 	=> site_url('/galleries/gallery-masonry-3-columns-contained/'),
    "Gallery Masonry 4 Columns Contained" 	=> site_url('/galleries/gallery-masonry-4-columns-contained/'),
    "Gallery 2 Columns Wide" 				=> site_url('/galleries/gallery-2-columns-wide/'),
    "Gallery 3 Columns Wide" 				=> site_url('/galleries/gallery-3-columns-wide/'),
    "Gallery 4 Columns Wide" 				=> site_url('/galleries/gallery-4-columns-wide/'),
    "Gallery 5 Columns Wide" 				=> site_url('/galleries/gallery-5-columns-wide/'),
    "Gallery Metro Contained" 				=> site_url('/galleries/gallery-metro-contained/'),
    "Gallery Metro Wide" 					=> site_url('/galleries/gallery-metro-wide/'),
    "Gallery Masonry 2 Columns Wide" 		=> site_url('/galleries/gallery-masonry-2-columns-wide/'),
    "Gallery Masonry 3 Columns Wide" 		=> site_url('/galleries/gallery-masonry-3-columns-wide/'),
    "Gallery Masonry 4 Columns Wide" 		=> site_url('/galleries/gallery-masonry-4-columns-wide/'),
    "Gallery Masonry 5 Columns Wide" 		=> site_url('/galleries/gallery-masonry-5-columns-wide/'),
    "Gallery Photo Proofing" 				=> site_url('/galleries/photo-proofing/'),
    "Gallery Board Contained" 				=> site_url('/galleries/gallery-board-contained/'),
    "Gallery Board Wide" 					=> site_url('/galleries/gallery-board-wide/'),
    "Gallery Justified Contained" 			=> site_url('/galleries/gallery-justified-contained/'),
    "Gallery Justified Wide" 				=> site_url('/galleries/gallery-justified-wide/'),
);

/*
	Begin creating custom fields
*/

$postmetas = 
	array (
		'post' => array(
			array("section" => "Content Type", "id" => "post_layout", "type" => "template", "title" => "Post Layout", "description" => "You can select layout of this single post page.", "items" => $post_layout_select),
			array(
    		"section" => "Featured Content Type", "id" => "post_ft_type", "type" => "select", "title" => "Featured Content Type", "description" => "Select featured content type for this post. Different content type will be displayed on single post page", 
				"items" => array(
					"Image" => "Image",
					"Gallery" => "Gallery",
					"Vimeo Video" => "Vimeo Video",
					"Youtube Video" => "Youtube Video",
				)),
			
			array("section" => "Gallery", "id" => "post_ft_gallery", "type" => "select", "title" => "Gallery (Optional)", "description" => "Please select a gallery.</strong>", "items" => $galleries_select),
				
			array("section" => "Vimeo Video ID", "id" => "post_ft_vimeo", "type" => "text", "title" => "Vimeo Video ID (Optional)", "description" => "Please enter Vimeo Video ID for example 73317780"),
			
			array("section" => "Youtube Video ID", "id" => "post_ft_youtube", "type" => "text", "title" => "Youtube Video ID (Optional)", "description" => "Please enter Youtube Video ID for example 6AIdXisPqHc"),
		),
		
		'galleries' => array(
			array("section" => "Gallery Template", "id" => "gallery_template", "type" => "template", "title" => "Gallery Template", "description" => "Select gallery template for this gallery", 
				"items" => array(
					"Gallery Fullscreen Cover" 				=> get_template_directory_uri()."/functions/images/gallery/gallery1.jpg",
					"Gallery Kenburns" 						=> get_template_directory_uri()."/functions/images/gallery/gallery1.jpg",
					"Gallery Horizontal" 					=> get_template_directory_uri()."/functions/images/gallery/gallery3.jpg",
					"Gallery Horizontal Contained" 			=> get_template_directory_uri()."/functions/images/gallery/gallery4.jpg",
					"Gallery Striped Contained" 			=> get_template_directory_uri()."/functions/images/gallery/gallery5.jpg",
					"Gallery Striped Wide" 					=> get_template_directory_uri()."/functions/images/gallery/gallery6.jpg",
					"Gallery Flow" 							=> get_template_directory_uri()."/functions/images/gallery/gallery7.jpg",
					"Gallery Split Screen" 					=> get_template_directory_uri()."/functions/images/gallery/gallery8.jpg",
					"Gallery Split Screen Wide" 			=> get_template_directory_uri()."/functions/images/gallery/gallery9.jpg",
					"Gallery 1 Column Contained" 			=> get_template_directory_uri()."/functions/images/gallery/gallery10.jpg",
					"Gallery 2 Columns Contained" 			=> get_template_directory_uri()."/functions/images/gallery/gallery11.jpg",
					"Gallery 3 Columns Contained" 			=> get_template_directory_uri()."/functions/images/gallery/gallery12.jpg",
					"Gallery 4 Columns Contained" 			=> get_template_directory_uri()."/functions/images/gallery/gallery13.jpg",
					"Gallery Masonry 2 Columns Contained" 	=> get_template_directory_uri()."/functions/images/gallery/gallery14.jpg",
					"Gallery Masonry 3 Columns Contained" 	=> get_template_directory_uri()."/functions/images/gallery/gallery15.jpg",
					"Gallery Masonry 4 Columns Contained" 	=> get_template_directory_uri()."/functions/images/gallery/gallery16.jpg",
					"Gallery 2 Columns Wide" 				=> get_template_directory_uri()."/functions/images/gallery/gallery17.jpg",
					"Gallery 3 Columns Wide" 				=> get_template_directory_uri()."/functions/images/gallery/gallery18.jpg",
					"Gallery 4 Columns Wide" 				=> get_template_directory_uri()."/functions/images/gallery/gallery19.jpg",
					"Gallery 5 Columns Wide" 				=> get_template_directory_uri()."/functions/images/gallery/gallery20.jpg",
					"Gallery Metro Contained" 				=> get_template_directory_uri()."/functions/images/gallery/gallery21.jpg",
					"Gallery Metro Wide" 					=> get_template_directory_uri()."/functions/images/gallery/gallery22.jpg",
					"Gallery Masonry 2 Columns Wide" 		=> get_template_directory_uri()."/functions/images/gallery/gallery23.jpg",
					"Gallery Masonry 3 Columns Wide" 		=> get_template_directory_uri()."/functions/images/gallery/gallery24.jpg",
					"Gallery Masonry 4 Columns Wide" 		=> get_template_directory_uri()."/functions/images/gallery/gallery25.jpg",
					"Gallery Masonry 5 Columns Wide" 		=> get_template_directory_uri()."/functions/images/gallery/gallery26.jpg",
					"Gallery Photo Proofing" 				=> get_template_directory_uri()."/functions/images/gallery/gallery27.jpg",
					"Gallery Board Contained" 				=> get_template_directory_uri()."/functions/images/gallery/gallery28.jpg",
					"Gallery Board Wide" 					=> get_template_directory_uri()."/functions/images/gallery/gallery29.jpg",
					"Gallery Justified Contained" 			=> get_template_directory_uri()."/functions/images/gallery/gallery30.jpg",
					"Gallery Justified Wide" 				=> get_template_directory_uri()."/functions/images/gallery/gallery31.jpg",
				)),
			
			array("section" => "Password Protect", "id" => "gallery_password", "title" => "Password (Optional)", "description" => "Enter your password for this gallery so viewer required entering password before they can see gallery images."),
			
			array("section" => "Download", "id" => "gallery_download", "type" => "file", "title" => "Gallery Download (Optional)", "description" => "Upload zip file of your gallery images and it can be download by visitors when view the gallery page."),
		),
		
		'portfolios' => array(
			array("section" => "Content Type", "id" => "portfolio_type", "type" => "select", "title" => "Content Type", "description" => "Select content type for this project:", 
				"items" => array(
					"Portfolio Content" => "Portfolio Content",
					"Image" => "Image",
					"Vimeo Video" => "Vimeo Video",
					"Youtube Video" => "Youtube Video", 
					//"Self-Hosted Video" => "Self-Hosted Video",
					"External Link" => "External Link",
				)),
				
			array("section" => "Content Type", "id" => "portfolio_hide_image", "type" => "checkbox", "title" => "Do not display Featured Image as Header", "description" => "Check this option if you want to hide featured image on single portfolio page"),
			
			array("section" => "Content Type", "id" => "portfolio_video_id", "title" => "Youtube or Vimeo Video ID (Only if you selected Youtube Video or Vimeo Video)", "description" => "Enter your video ID here:"),
			
			array("section" => "Content Type", "id" => "portfolio_mp4_url", "title" => "Video URL (Only if you selected Self-Hosted)", "description" => "Enter your video URL (.mp4 file format):"),
			
			array("section" => "Content Type", "id" => "portfolio_link_url", "title" => "Link URL", "description" => "Project item will link to this URL"),
		),
		
		'clients' => array(
			array("section" => "Client Option", "id" => "client_password", "title" => "Password (Optional)", "description" => "Enter your password for client page"),
			array("section" => "Client Option", "id" => "client_galleries", "type" => "checkboxes", "title" => "Galleries", "description" => "Select galleries for this client", 
				"items" => $galleries_select),
		),
		
		'team' => array(
			array("section" => "Team Option", "id" => "team_position", "type" => "text", "title" => "Position and Role", "description" => "Enter team member position and role ex. Marketing Manager"),
			array("section" => "Facebook URL", "id" => "member_facebook", "type" => "text", "title" => "Facebook URL", "description" => "Enter team member Facebook URL"),
		    array("section" => "Twitter URL", "id" => "member_twitter", "type" => "text", "title" => "Twitter URL", "description" => "Enter team member Twitter URL"),
		    array("section" => "Instagram URL", "id" => "member_instagram", "type" => "text", "title" => "Instagram URL", "description" => "Enter team member Instagram URL"),
		    array("section" => "Linkedin URL", "id" => "member_linkedin", "type" => "text", "title" => "Linkedin URL", "description" => "Enter team member Linkedin URL"),
		),
		
		'events' => array(
		    array("section" => "Date", "id" => "event_date", "type" => "date", "title" => "Event Date", "description" => "Select date for this event"),
		    array("section" => "Date", "id" => "event_date_raw", "type" => "date_raw", "title" => "Event Date Raw", "description" => "Select date for this event"),
		    array("section" => "Time", "id" => "event_from_time", "type" => "time", "title" => "From", "description" => "Select begin time for this event"),
		    array("section" => "Time", "id" => "event_to_time", "type" => "time", "title" => "To", "description" => "Select end time for this event"),
		    
		    array("section" => "Location", "id" => "event_location", "type" => "textarea", "title" => "Event Location", "description" => "Enter address for this event ex. 34 Kingstong Road, United Kingdom"),
		    
		    array("section" => "Location Type", "id" => "event_get_direction", "type" => "checkbox", "title" => "Get Direction on Google Map", "description" => "Check this option if you want to find map with direction using location above (Optional)"),
		    
		    array("section" => "Ticket", "id" => "event_ticket_url", "title" => "Buy Ticket URL", "description" => "Enter URL where visitor can buy ticket for this event (Optional)"),
		),
		
		'pricing' => array(
			array("section" => "Pricing Option", "id" => "pricing_featured", "type" => "checkbox", "title" => "Make this pricing featured", "description" => "Check this option if you want to display this pricing as featured one."),
			array("section" => "Pricing Option", "id" => "pricing_plan_currency", "type" => "text", "title" => "Currency", "description" => "Enter currency", "sample" => "$"),
			array("section" => "Pricing Option", "id" => "pricing_plan_price", "type" => "text", "title" => "Exact Price", "description" => "Enter exact price", "sample" => "10"),
			array("section" => "Pricing Option", "id" => "pricing_plan_time", "type" => "text", "title" => "Time", "description" => "Enter price per time (optional)", "sample" => 'month'),
			array("section" => "Pricing Option", "id" => "pricing_plan_features", "type" => "textarea", "title" => "Plan Features", "description" => "Enter pricing plan features.", "sample" => "Unlimited Pages\nUnlimited Storage\nMobile Website\n24/7 Customer Support"),
			array("section" => "Pricing Option", "id" => "pricing_button_text", "type" => "text", "title" => "Button Text", "description" => "Enter pricing button text", "sample" => "Purchase Now"),
		    array("section" => "Pricing Option", "id" => "pricing_button_url", "type" => "text", "title" => "Button URL", "description" => "Enter pricing button  URL", "sample" => "http://themeforest.net"),
		),
		
		'testimonials' => array(
			array("section" => "Testimonial Option", "id" => "testimonial_name", "type" => "text", "title" => "Customer Name", "description" => "Enter customer name"),
			array("section" => "Testimonial Option", "id" => "testimonial_position", "type" => "text", "title" => "Customer Position", "description" => "Enter customer position in company"),
			array("section" => "Testimonial Option", "id" => "testimonial_company_name", "type" => "text", "title" => "Company Name", "description" => "Enter customer company name"),
			array("section" => "Testimonial Option", "id" => "testimonial_company_website", "type" => "text", "title" => "Company Website URL", "description" => "Enter customer company website URL"),
		),
);

function create_meta_box() {

	global $postmetas;
	
	if(!isset($_GET['post_type']) OR empty($_GET['post_type']))
	{
		if(isset($_GET['post']) && !empty($_GET['post']))
		{
			$post_obj = get_post($_GET['post']);
			$_GET['post_type'] = $post_obj->post_type;
		}
		else
		{
			$_GET['post_type'] = 'post';
		}
	}
	
	if ( function_exists('add_meta_box') && isset($postmetas) && count($postmetas) > 0 ) {  
		foreach($postmetas as $key => $postmeta)
		{
			if($_GET['post_type']==$key && !empty($postmeta))
			{
				add_meta_box( 'metabox', ucfirst($key).' Options', 'new_meta_box', $key, 'normal', 'default' );
			}
		}
	}

}  

function new_meta_box() {
	global $post, $postmetas, $gallery_template_urls;
	
	if(!isset($_GET['post_type']) OR empty($_GET['post_type']))
	{
		if(isset($_GET['post']) && !empty($_GET['post']))
		{
			$post_obj = get_post($_GET['post']);
			$_GET['post_type'] = $post_obj->post_type;
		}
		else
		{
			$_GET['post_type'] = 'post';
		}
	}

	echo '<input type="hidden" name="pp_meta_form" id="pp_meta_form" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
	
	//Get visual page template option
	$pp_visual_page_templates = get_option('pp_visual_page_templates');
	
	$meta_section = '';

	foreach ( $postmetas as $key => $postmeta ) {
	
		if($_GET['post_type'] == $key)
		{
		
			foreach ( $postmeta as $postmeta_key => $each_meta ) {
		
				$meta_id = $each_meta['id'];
				$meta_title = $each_meta['title'];
				$meta_description = $each_meta['description'];
				
				if(isset($postmeta['section']))
				{
					$meta_section = $postmeta['section'];
				}
				
				$meta_type = '';
				if(isset($each_meta['type']))
				{
					$meta_type = $each_meta['type'];
				}
				
				echo '<div id="post_option_'.strtolower($each_meta['id']).'" class="pp_meta_option key'.intval($postmeta_key+1).' '.$meta_type.'">';
				echo "<div class=\"meta_title_wrapper\">";
				echo "<strong>".$meta_title."</strong>";
				
				echo "<div class='pp_widget_description'>$meta_description</div>";
				
				echo "</div>";
				echo "<div class=\"meta_title_field\">";
				
				if ($meta_type == 'checkbox') {
					$checked = get_post_meta($post->ID, $meta_id, true) == '1' ? "checked" : "";
					echo "<input type='checkbox' name='$meta_id' id='$meta_id' class='iphone_checkboxes' value='1' $checked />";
				}
				else if ($meta_type == 'select') {
					echo "<select name='$meta_id' id='$meta_id'>";
					
					if(!empty($each_meta['items']))
					{
						foreach ($each_meta['items'] as $key => $item)
						{
							echo '<option value="'.$item.'"';
							
							if($item == get_post_meta($post->ID, $meta_id, true))
							{
								echo ' selected ';
							}
							
							echo '>'.$key.'</option>';
						}
					}
					
					echo "</select>";
				}
				else if ($meta_type == 'template') {
					$current_value = get_post_meta($post->ID, $meta_id, true);
					echo "<input type='hidden' name='$meta_id' id='$meta_id' value='$current_value' />";
					echo "<ul name=\"".$meta_id."_list\" id=\"".$meta_id."_list\" class=\"meta_template_list\">";
					
					if(!empty($each_meta['items']))
					{
						foreach ($each_meta['items'] as $key => $image_thumb)
						{
							echo '<li data-parent="'.$meta_id.'" data-value="'.esc_attr($key).'" ';
							
							if($key == $current_value)
							{
								echo 'class="checked"';
							}
							
							echo '>';
							
							//Check if use visual page templates
						    if(!empty($pp_visual_page_templates))
						    {
								if(isset($gallery_template_urls[$key]))
								{
									echo '<a href="'.esc_url($gallery_template_urls[$key]).'" target="_blank" title="View Sample" class="tooltipster meta_template_link"><i class="fa fa-external-link"></i></a>';
								}
								
								echo '<a href="javascript:;" class="preview"><img src="'.$image_thumb.'"/></a><div class="meta_template_check"><i class="fa fa-check"></i></div>';
							}
							echo '<div class="template_title">'.$key.'</div>';
							echo '</li>';
						}
					}
					
					echo "</ul>";
				}
				else if ($meta_type == 'checkboxes') {
					if(!empty($each_meta['items']))
					{
						$checkboxes_post_values = get_post_meta($post->ID, $meta_id, true);
						
						echo '<div class="wp-tab-panel"><ul id="clientgallerychecklist">';
					
						foreach ($each_meta['items'] as $key => $item)
						{
							if($item > 1)
							{
								echo '<li>';
								echo '<input name="'.$meta_id.'[]" id="'.$meta_id.'[]" type="checkbox"  value="'.$item.'"';
								
								if(is_array($checkboxes_post_values) && !empty($checkboxes_post_values) && in_array($item, $checkboxes_post_values))
								{
									echo ' checked ';
								}
								
								echo '/>'.$key;
								echo '</li>';
							}
						}
						
						echo '</ul></div>';
					}
				}
				else if ($meta_type == 'file') { 
				    echo "<input type='text' name='$meta_id' id='$meta_id' class='' value='".get_post_meta($post->ID, $meta_id, true)."' style='width:calc(100% - 75px)' /><input id='".$meta_id."_button' name='".$meta_id."_button' type='button' value='Upload' class='metabox_upload_btn button' readonly='readonly' rel='".$meta_id."' style='margin:0 0 0 5px' />";
				}
				else if ($meta_type == 'textarea') {
					if(isset($postmeta[$postmeta_key]['sample']))
					{
						echo "<textarea name='$meta_id' id='$meta_id' class=' hint' style='width:100%' rows='7' title='".$postmeta[$postmeta_key]['sample']."'>".get_post_meta($post->ID, $meta_id, true)."</textarea>";
					}
					else
					{
						echo "<textarea name='$meta_id' id='$meta_id' class='' style='width:100%' rows='7'>".get_post_meta($post->ID, $meta_id, true)."</textarea>";
					}
				}			
				else {
					if(isset($postmeta[$postmeta_key]['sample']))
					{
						echo "<input type='text' name='$meta_id' id='$meta_id' class='' title='".$postmeta[$postmeta_key]['sample']."' value='".get_post_meta($post->ID, $meta_id, true)."' style='width:100%' />";
					}
					else
					{
						echo "<input type='text' name='$meta_id' id='$meta_id' class='' value='".get_post_meta($post->ID, $meta_id, true)."' style='width:100%' />";
					}
				}
				
				echo "</div>";
				echo '</div>';
			}
		}
	}

}

function save_postdata( $post_id ) {

	global $postmetas;

	// verify this came from the our screen and with proper authorization,
	// because save_post can be triggered at other times

	if ( isset($_POST['pp_meta_form']) && !wp_verify_nonce( $_POST['pp_meta_form'], plugin_basename(__FILE__) )) {
		return $post_id;
	}

	// verify if this is an auto save routine. If it is our form has not been submitted, so we dont want to do anything

	if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || (defined('DOING_AJAX') && DOING_AJAX) || isset($_REQUEST['bulk_edit']))
        return;

	// Check permissions

	if ( isset($_POST['post_type']) && 'page' == $_POST['post_type'] ) {
		if ( !current_user_can( 'edit_page', $post_id ) )
			return $post_id;
		} else {
		if ( !current_user_can( 'edit_post', $post_id ) )
			return $post_id;
	}

	// OK, we're authenticated

	if ( $parent_id = wp_is_post_revision($post_id) )
	{
		$post_id = $parent_id;
	}
	
	if (isset($_POST['pp_meta_form'])) 
	{
		//If import page content builder
		if(is_admin() && isset($_POST['ppb_import_current']) && !empty($_POST['ppb_import_current']))
		{
			//If upload import builder file
			if(isset($_FILES['ppb_import_current_file']['name']) && !empty($_FILES['ppb_import_current_file']['name']))
			{
				//Check if zip file
				$import_filename = $_FILES['ppb_import_current_file']['name'];
				$import_type = $_FILES['ppb_import_current_file']['type'];
				$is_zip = FALSE;
				$new_filename = basename($import_filename, '_.zip');
				
				$accepted_types = array('application/zip', 
	                                'application/x-zip-compressed', 
	                                'multipart/x-zip', 
	                                'application/s-compressed');
	 
			    foreach($accepted_types as $mime_type) {
			        if($mime_type == $import_type) {
			            $is_zip = TRUE;
			            break;
			        } 
			    }
			}
			//If import demo pages
			else if(isset($_POST['ppb_import_demo_file']) && !empty($_POST['ppb_import_demo_file']))
			{
				$is_zip = FALSE;
			}
			//If import from saved template
			else if(isset($_POST['ppb_import_template_key']) && !empty($_POST['ppb_import_template_key']))
			{
				$is_zip = FALSE;
			}
			
			if($is_zip)
			{
				WP_Filesystem();
				$upload_dir = wp_upload_dir();
				$cache_dir = '';
				
				if(isset($upload_dir['basedir']))
				{
					$cache_dir = $upload_dir['basedir'].'/meteors';
				}
				
				move_uploaded_file($_FILES["ppb_import_current_file"]["tmp_name"], $cache_dir.'/'.$import_filename);
				//$unzipfile = unzip_file( $cache_dir.'/'.$import_filename, $cache_dir);
				
				$zip = new ZipArchive();
				$x = $zip->open($cache_dir.'/'.$import_filename);
				
				for($i = 0; $i < $zip->numFiles; $i++) {
			        $new_filename = $zip->getNameIndex($i);
			        break;
			    }  
				
				if ($x === true) {
					$zip->extractTo($cache_dir); 
					$zip->close();
				}

				$import_options_json = file_get_contents($cache_dir.'/'.$new_filename);
				unlink($cache_dir.'/'.$import_filename);
				unlink($cache_dir.'/'.$new_filename);
			}
			else
			{
				//If import demo pages
				if(isset($_POST['ppb_import_demo_file']) && !empty($_POST['ppb_import_demo_file']))
				{
					$import_options_json = file_get_contents(get_template_directory().'/cache/demos/pages/'.$_POST['ppb_import_demo_file']);
				}
				//If import from saved template
				else if(isset($_POST['ppb_import_template_key']) && !empty($_POST['ppb_import_template_key']))
				{
					$import_options_json = get_option( SHORTNAME."_template_".$_POST['ppb_import_template_key']);
				}
				else
				{
					//If .json file then import
					$import_options_json = $wp_filesystem->get_contents($_FILES["ppb_import_current_file"]["tmp_name"]);
					
					if(empty($import_options_json))
					{
						$import_options_json = file_get_contents($_FILES["ppb_import_current_file"]["tmp_name"]);
					}
				}
			}
			
			$import_options_arr = json_decode($import_options_json, true);
			
			if(isset($import_options_arr['ppb_form_data_order'][0]) && !empty($import_options_arr['ppb_form_data_order'][0]))
			{
				grandphotography_page_update_custom_meta($post_id, $import_options_arr['ppb_form_data_order'][0], 'ppb_form_data_order');
			}
			
			$ppb_item_arr = explode(',', $import_options_arr['ppb_form_data_order'][0]);
			
			if(is_array($ppb_item_arr) && !empty($ppb_item_arr))
			{
				foreach($ppb_item_arr as $key => $ppb_item_arr)
				{
					if(isset($import_options_arr[$ppb_item_arr.'_data'][0]) && !empty($import_options_arr[$ppb_item_arr.'_data'][0]))
					{
						grandphotography_page_update_custom_meta($post_id, $import_options_arr[$ppb_item_arr.'_data'][0], $ppb_item_arr.'_data');
					}
					
					if(isset($import_options_arr[$ppb_item_arr.'_size'][0]) && !empty($import_options_arr[$ppb_item_arr.'_size'][0]))
					{
						grandphotography_page_update_custom_meta($post_id, $import_options_arr[$ppb_item_arr.'_size'][0], $ppb_item_arr.'_size');
					}
				}
			}
			
			header("Location: ".$_SERVER['HTTP_REFERER']);
			exit;
		}
	
		//If export page content builder
		if(is_admin() && isset($_POST['ppb_export_current']) && !empty($_POST['ppb_export_current']))
		{
			$page_title = get_the_title($post_id);
		
			$json_file_name = THEMENAME.'-Page-'.sanitize_title($page_title).'-Export-'.date('m-d-Y_hia');
			$json_file_name = strtolower($json_file_name);
	
			header('Content-disposition: attachment; filename='.$json_file_name.'.json');
			header('Content-type: application/json');
			
			//Get current content builder data
			$ppb_form_data_order = get_post_meta($post_id, 'ppb_form_data_order');
			$export_options_arr = array();
			
			if(!empty($ppb_form_data_order))
			{
				$export_options_arr['ppb_form_data_order'] = $ppb_form_data_order;

				//Get each builder module data
				$ppb_form_item_arr = explode(',', $ppb_form_data_order[0]);
			
				foreach($ppb_form_item_arr as $key => $ppb_form_item)
				{
					$ppb_form_item_data = get_post_meta($post_id, $ppb_form_item.'_data');
					$export_options_arr[$ppb_form_item.'_data'] = $ppb_form_item_data;
					
					$ppb_form_item_size = get_post_meta($post_id, $ppb_form_item.'_size');
					$export_options_arr[$ppb_form_item.'_size'] = $ppb_form_item_size;
				}
			}
		
			echo json_encode($export_options_arr);
			
			exit;
		}
	
		foreach ( $postmetas as $postmeta ) {
			foreach ( $postmeta as $each_meta ) {
				
				if (isset($_POST[$each_meta['id']]) && $_POST[$each_meta['id']]) {
					update_custom_meta($post_id, $_POST[$each_meta['id']], $each_meta['id']);
				}
				
				if (isset($_POST[$each_meta['id']]) && $_POST[$each_meta['id']] == "") {
					delete_post_meta($post_id, $each_meta['id']);
				}
				
				if (!isset($_POST[$each_meta['id']])) {
					delete_post_meta($post_id, $each_meta['id']);
				}
			
			}
		}
	
		// Saving Page Builder Data
		if(isset($_POST['ppb_enable']) && !empty($_POST['ppb_enable']))
		{
		    update_custom_meta($post_id, $_POST['ppb_enable'], 'ppb_enable');
		}
		else
		{
		    delete_post_meta($post_id, 'ppb_enable');
		}
		
		if(isset($_POST['ppb_form_data_order']) && !empty($_POST['ppb_form_data_order']))
		{
		    update_custom_meta($post_id, $_POST['ppb_form_data_order'], 'ppb_form_data_order');
		    
		    $ppb_item_arr = explode(',', $_POST['ppb_form_data_order']);
		    if(is_array($ppb_item_arr) && !empty($ppb_item_arr))
		    {
		    	foreach($ppb_item_arr as $key => $ppb_item_arr)
		    	{
		    		if(isset($_POST[$ppb_item_arr.'_data']) && !empty($_POST[$ppb_item_arr.'_data']))
		    		{
		    			update_custom_meta($post_id, $_POST[$ppb_item_arr.'_data'], $ppb_item_arr.'_data');
		    		}
		    		
		    		if(isset($_POST[$ppb_item_arr.'_size']) && !empty($_POST[$ppb_item_arr.'_size']))
		    		{
		    			update_custom_meta($post_id, $_POST[$ppb_item_arr.'_size'], $ppb_item_arr.'_size');
		    		}
		    	}
		    }
		}
		//If content builder is empty
		else
		{
		    update_custom_meta($post_id, '', 'ppb_form_data_order');
		}
		
		//If enable Content Builder then also copy its content to standard page content
		if (isset($_POST['ppb_enable']) && !empty($_POST['ppb_enable']) && ! wp_is_post_revision( $post_id ) )
		{
			//unhook this function so it doesn't loop infinitely
			remove_action('save_post', 'save_postdata');
		
			//update the post, which calls save_post again
			$ppb_page_content = grandphotography_apply_builder($post_id, 'portfolios', FALSE);
			
			$current_post = array (
		      'ID'           => $post_id,
		      'post_content' => $ppb_page_content,
		    );
		    
		    wp_update_post($current_post);
		    if (is_wp_error($post_id)) {
				$errors = $post_id->get_error_messages();
				foreach ($errors as $error) {
					echo esc_html($error);
				}
			}
	
			//re-hook this function
			add_action('save_post', 'save_postdata');
		}
		
		//Check if save changes on gallery post options
		if ( isset($_POST['post_type']) && 'galleries' == $_POST['post_type'] ) {
			$gallery_template = get_post_meta($post_id, 'gallery_template', true);
			
			if($gallery_template == 'Gallery Flow')
			{
				$xml_cache_path = THEMEUPLOAD.'/flow-gallery-'.$post_id.'.xml';
				
				if(file_exists($xml_cache_path))
				{
					unlink($xml_cache_path);
				}
				
				if(!file_exists($xml_cache_path))
				{
					//Get custom CSS code to cache
					ob_start(); 
					get_template_part('/modules/script/script-image-flow', null, array( 
					  	'gallery_id' => $post_id,
					  )
					);
					
					$gallery_flow_custom_xml = ob_get_contents(); 
					ob_end_clean();
					
				    //Writing cache file
					file_put_contents($xml_cache_path, $gallery_flow_custom_xml);
				}
				
				//Refresh page
				header('Location: '.$_SERVER['HTTP_REFERER']);
				
				die;
			}
		}
		
		//Check if save changes on portfolio post options
		if ( isset($_POST['post_type']) && 'portfolios' == $_POST['post_type'] ) {
			$xml_cache_path = THEMEUPLOAD.'/flow-portfolio.xml';
				
			if(file_exists($xml_cache_path))
			{
				unlink($xml_cache_path);
			}
			
			if(!file_exists($xml_cache_path))
			{
				//Get custom CSS code to cache
				ob_start(); 
				get_template_part("/modules/script/script-image-portfolio-flow");
				
				$portfolio_flow_custom_xml = ob_get_contents(); 
				ob_end_clean();
				
			    //Writing cache file
				file_put_contents($xml_cache_path, $portfolio_flow_custom_xml);
			}
			
			//Refresh page
			header('Location: '.$_SERVER['HTTP_REFERER']);
			
			die;
		}
	}
}

function update_custom_meta($postID, $newvalue, $field_name) {

	if (isset($_POST['pp_meta_form'])) 
	{
		if (!get_post_meta($postID, $field_name)) {
			add_post_meta($postID, $field_name, $newvalue);
		} else {
			update_post_meta($postID, $field_name, $newvalue);
		}
	}

}

//init

add_action('admin_menu', 'create_meta_box'); 
add_action('save_post', 'save_postdata'); 

/*
	End creating custom fields
*/

//Include gallery admin interface
include_once (plugin_dir_path( __FILE__ ) . "/gallery/tg-gallery.php");

//Include Theme Shortcode
include_once (plugin_dir_path( __FILE__ ) . "tg-shortcode.php");

//Include Content Builder Shortcode
include_once (plugin_dir_path( __FILE__ ) . "tg-contentbuilder.php");

//Include plugin filter & hook
include_once (plugin_dir_path( __FILE__ ) . "tg-filter.php");

//Include plugin ajax handler
include_once (plugin_dir_path( __FILE__ ) . "tg-ajax.php");
?>