<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

use AmeliaBooking\Domain\Services\Settings\SettingsService;
use AmeliaBooking\Infrastructure\WP\SettingsService\SettingsStorage;

/**
 * Class FrontendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @phpcs:disable
 */
class FrontendStrings
{
    /** @var array */
    private static $settings;

    /**
     * Set Settings
     *
     * @return array|mixed
     */
    public static function getLabelsFromSettings()
    {
        if (!self::$settings) {
            self::$settings = new SettingsService(new SettingsStorage());
        }

        if (self::$settings->getSetting('labels', 'enabled') === true) {
            $labels = self::$settings->getCategorySettings('labels');
            unset($labels['enabled']);

            return $labels;
        }

        return [];
    }

    /**
     * Return all strings for frontend
     *
     * @return array
     */
    public static function getAllStrings()
    {
        return array_merge(
            self::getCommonStrings(),
            self::getBookingStrings(),
            self::getBookableStrings(),
            self::getCatalogStrings(),
            self::getSearchStrings(),
            self::getLabelsFromSettings(),
            self::getEventStrings(),
            self::getCabinetStrings()
        );
    }

    /**
     * Returns the array for the bookable strings
     *
     * @return array
     */
    public static function getBookableStrings() {
        return [
            'allow_customers_to_pay_total'       => __('Check this option if you want your<br> customers to have the option to choose<br> whether they will pay a full amount<br> or just a deposit. If unchecked,<br> customers will only have deposit<br> as a payment option.', 'wpamelia'),
            'deposit_by_the_number_of_people'    => __('Check this option if you want the deposit<br> amount to be multiplied by the number<br> of people that customers add in the<br> "Bringing anyone with you" section.', 'wpamelia'),
            'allow_total_amount'                 => __('Allow customers to pay total appointment amount', 'wpamelia'),
            'deposit'                            => __('Deposit', 'wpamelia'),
            'pay_now'                            => __('(Paying now)', 'wpamelia'),
            'pay_later'                          => __('Left to pay', 'wpamelia'),
            'deposit_amount'                     => __('Deposit amount', 'wpamelia'),
            'deposit_enabled'                    => __('Enable deposit payment', 'wpamelia'),
            'deposit_payment'                    => __('Deposit type', 'wpamelia'),
            'deposit_payment_tooltip'            => __('Percentage deposit will be calculated on the total booking price<br>and fixed amount can be multiplied by the number of persons or stay fixed on the total booking price.', 'wpamelia'),
            'deposit_info'                       => __('Remaining of total amount will be paid on site.', 'wpamelia'),
            'deposit_per_person'                 => __('Multiply deposit amount by the number of people in one booking', 'wpamelia'),
            'fixed_amount'                       => __('Fixed amount', 'wpamelia'),
            'percentage'                         => __('Percentage', 'wpamelia'),
        ];
    }

    /**
     * Returns the array of the common frontend strings
     *
     * @return array
     */
    public static function getCommonStrings()
    {
        return [
            'add_coupon'                   => __('Add Coupon', 'wpamelia'),
            'add_to_calendar'              => __('Add to Calendar', 'wpamelia'),
            'and'                          => __('and'),
            'no_services_employees'        => __('It seems like there are no employees or services created, or no  employees are assigned to the service, at this moment.'),
            'add_services_employees'       => __('If you are the admin of this page, see how to'),
            'add_services_url'             => __('Add services'),
            'add_employees_url'            => __('employees.'),
            'all_slots_selected'           => __('All slots are selected', 'wpamelia'),
            'appointment'                  => __('Appointment', 'wpamelia'),
            'appointments'                 => __('Appointments', 'wpamelia'),
            'appointment_info'             => __('Appointment Info', 'wpamelia'),
            'at'                           => __('at', 'wpamelia'),
            'back'                         => __('Back', 'wpamelia'),
            'base_price_colon'             => __('Base Price:', 'wpamelia'),
            'book'                         => __('Book', 'wpamelia'),
            'booking_completed_approved'   => __('Thank you! Your booking is completed.', 'wpamelia'),
            'booking_completed_email'      => __('An email with details of your booking has been sent to you.', 'wpamelia'),
            'booking_completed_pending'    => __('Thank you! Your booking is completed and now is pending confirmation.', 'wpamelia'),
            'cancel'                       => __('Cancel', 'wpamelia'),
            'canceled'                     => __('Canceled', 'wpamelia'),
            'capacity_colon'               => __('Capacity:', 'wpamelia'),
            'client_time_colon'            => __('Client Time:', 'wpamelia'),
            'closed'                       => __('Closed', 'wpamelia'),
            'full'                         => __('Full', 'wpamelia'),
            'upcoming'                     => __('Upcoming', 'wpamelia'),
            'confirm'                      => __('Confirm', 'wpamelia'),
            'congratulations'              => __('Congratulations', 'wpamelia'),
            'coupon_invalid'               => __('This coupon is not valid anymore', 'wpamelia'),
            'coupon_missing'               => __('Please enter coupon', 'wpamelia'),
            'coupon_send_text'             => __('You can use this coupon for next booking: ', 'wpamelia'),
            'coupon_unknown'               => __('The coupon you entered is not valid', 'wpamelia'),
            'coupon_used'                  => __('Used coupon', 'wpamelia'),
            'credit_card'                  => __('Credit Card', 'wpamelia'),
            'mollie'                       => __('Mollie', 'wpamelia'),
            'credit_or_debit_card_colon'   => __('Credit or debit card:', 'wpamelia'),
            'custom_fields'                => __('Custom Fields', 'wpamelia'),
            'customer'                     => __('Customer', 'wpamelia'),
            'customer_already_booked_app'  => __('You have already booked this appointment', 'wpamelia'),
            'customer_already_booked_ev'   => __('You have already booked this event', 'wpamelia'),
            'date'                         => __('Date', 'wpamelia'),
            'date_colon'                   => __('Date:', 'wpamelia'),
            'discount_amount_colon'        => __('Discount:', 'wpamelia'),
            'duration_colon'               => __('Duration:', 'wpamelia'),
            'email_colon'                  => __('Email:', 'wpamelia'),
            'email_exist_error'            => __('Email already exists with different name. Please check your name.', 'wpamelia'),
            'email_not_sent_error'         => __('Unfortunately a server error occurred and your email was not sent.', 'wpamelia'),
            'email_placeholder'            => __('example@mail.com', 'wpamelia'),
            'employee'                     => __('employee', 'wpamelia'),
            'employees'                    => __('employees', 'wpamelia'),
            'enter_email_warning'          => __('Please enter email', 'wpamelia'),
            'enter_first_name_warning'     => __('Please enter first name', 'wpamelia'),
            'enter_last_name_warning'      => __('Please enter last name', 'wpamelia'),
            'enter_phone_warning'          => __('Please enter phone number', 'wpamelia'),
            'enter_valid_email_warning'    => __('Please enter a valid email address', 'wpamelia'),
            'enter_valid_phone_warning'    => __('Please enter a valid phone number', 'wpamelia'),
            'event_info'                   => __('Event Info', 'wpamelia'),
            'extras_costs_colon'           => __('Extras Cost:', 'wpamelia'),
            'file_upload'                  => __('Drop file here or click to upload', 'wpamelia'),
            'file_upload_error'            => __('Please upload the file', 'wpamelia'),
            'finish_appointment'           => __('Finish', 'wpamelia'),
            'first_name_colon'             => __('First Name:', 'wpamelia'),
            'forbidden_file_upload'        => __('This file is forbidden for upload', 'wpamelia'),
            'outlook_calendar'             => __('Outlook Calendar', 'wpamelia'),
            'h'                            => __('h', 'wpamelia'),
            'incomplete_cvc'               => __('Your card\'s security code is incomplete', 'wpamelia'),
            'incomplete_expiry'            => __('Your card\'s expiration date is incomplete', 'wpamelia'),
            'incomplete_number'            => __('Your card number is incomplete', 'wpamelia'),
            'incomplete_zip'               => __('Your postal code is incomplete', 'wpamelia'),
            'invalid_expiry_year_past'     => __('Your card\'s expiration year is in the past', 'wpamelia'),
            'invalid_number'               => __('Your card number is invalid', 'wpamelia'),
            'last_name_colon'              => __('Last Name:', 'wpamelia'),
            'location'                     => __('Location', 'wpamelia'),
            'location_colon'               => __('Location:', 'wpamelia'),
            'maximum_capacity_reached'     => __('Maximum capacity is reached', 'wpamelia'),
            'min'                          => __('min', 'wpamelia'),
            'name'                         => __('Name', 'wpamelia'),
            'no'                           => __('No', 'wpamelia'),
            'number_of_additional_persons' => __('Number of Additional Persons:', 'wpamelia'),
            'on_site'                      => __('On-site', 'wpamelia'),
            'oops'                         => __('Oops...'),
            'on_line'                      => __('Online', 'wpamelia'),
            'open'                         => __('Open', 'wpamelia'),
            'opened'                       => __('Opened', 'wpamelia'),
            'out_of'                       => __('out of', 'wpamelia'),
            'package'                      => __('Package', 'wpamelia'),
            'package_info'                 => __('Package Info', 'wpamelia'),
            'paid'                         => __('Paid', 'wpamelia'),
            'pay_pal'                      => __('PayPal', 'wpamelia'),
            'payment_error'                => __('Sorry, there was an error processing your payment. Please try again later.', 'wpamelia'),
            'payment_method_colon'         => __('Payment Method:', 'wpamelia'),
            'payment_type_colon'           => __('Payment Type:', 'wpamelia'),
            'persons'                      => __('persons', 'wpamelia'),
            'phone'                        => __('Phone', 'wpamelia'),
            'phone_colon'                  => __('Phone:', 'wpamelia'),
            'please_wait'                  => __('Please Wait', 'wpamelia'),
            'price_colon'                  => __('Price:', 'wpamelia'),
            'recaptcha_error'              => __('Please confirm you are not a robot', 'wpamelia'),
            'recaptcha_invalid_error'      => __('Verification expired. Please try again.', 'wpamelia'),
            'required_field'               => __('This field is required', 'wpamelia'),
            'select_calendar'              => __('Select Calendar', 'wpamelia'),
            'service'                      => __('service', 'wpamelia'),
            'services'                     => __('Services', 'wpamelia'),
            'services_lower'               => __('services', 'wpamelia'),
            'stripe'                       => __('Stripe', 'wpamelia'),
            'subtotal_colon'               => __('Subtotal:', 'wpamelia'),
            'time'                         => __('Time', 'wpamelia'),
            'time_colon'                   => __('Local Time:', 'wpamelia'),
            'time_slot_unavailable'        => __('Time slot is unavailable', 'wpamelia'),
            'time_slot_unavailable_plural' => __('Time slots are unavailable', 'wpamelia'),
            'package_booking_unavailable'  => __('Booking is unavailable', 'wpamelia'),
            'total_cost_colon'             => __('Total Cost:', 'wpamelia'),
            'total_number_of_persons'      => __('Total Number of Persons:', 'wpamelia'),
            'waiting_for_payment'          => __('Waiting for payment', 'wpamelia'),
            'wc'                           => __('On-line', 'wpamelia'),
            'wc_appointment_is_removed'    => __('Appointment is removed from the cart.', 'wpamelia'),
            'wc_appointment_remove'        => __('On-line', 'wpamelia'),
            'wc_error'                     => __('Sorry, there was an error while adding booking to WooCommerce cart.', 'wpamelia'),
            'wc_product_name'              => __('Appointment', 'wpamelia'),
            'zoom_join'                    => __('Join Zoom Meeting', 'wpamelia'),
            'zoom_start'                   => __('Start Zoom Meeting', 'wpamelia'),
            'day'                          => __('Day', 'wpamelia'),
            'days'                         => __('Days', 'wpamelia'),
            'week'                         => __('Week', 'wpamelia'),
            'weeks'                        => __('Weeks', 'wpamelia'),
            'month'                        => __('Month', 'wpamelia'),
            'months'                       => __('Months', 'wpamelia'),
            'year'                         => __('Year', 'wpamelia'),
            'years'                        => __('Years', 'wpamelia'),
        ];
    }

    /**
     * Returns the array of the frontend strings for the search shortcode
     *
     * @return array
     */
    public static function getSearchStrings()
    {
        return [
            'appointment_date_colon'  => __('Appointment Date:', 'wpamelia'),
            'book_package'            => __('Book Package', 'wpamelia'),
            'bringing_anyone'         => __('Bringing anyone with you?', 'wpamelia'),
            'enter_appointment_date'  => __('Please enter appointment date...', 'wpamelia'),
            'from'                    => __('From', 'wpamelia'),
            'name_asc'                => __('Name Ascending', 'wpamelia'),
            'name_desc'               => __('Name Descending', 'wpamelia'),
            'next'                    => __('Next', 'wpamelia'),
            'no_results_found'        => __('No results found...', 'wpamelia'),
            'of'                      => __('of', 'wpamelia'),
            'price_asc'               => __('Price Ascending', 'wpamelia'),
            'price_desc'              => __('Price Descending', 'wpamelia'),
            'refine_search'           => __('Please refine your search criteria', 'wpamelia'),
            'results'                 => __('results', 'wpamelia'),
            'search'                  => __('Search...', 'wpamelia'),
            'search_filters'          => __('Search Filters', 'wpamelia'),
            'search_results'          => __('Search Results', 'wpamelia'),
            'select'                  => __('Select', 'wpamelia'),
            'select_appointment_time' => __('Select the Appointment Time', 'wpamelia'),
            'select_extras'           => __('Select the Extras you\'d like', 'wpamelia'),
            'select_location'         => __('Select Location', 'wpamelia'),
            'showing'                 => __('Showing', 'wpamelia'),
            'time_range_colon'        => __('Time Range:', 'wpamelia'),
            'to_lower'                => __('to', 'wpamelia'),
            'to_upper'                => __('To', 'wpamelia'),
        ];
    }

    /**
     * Returns the array of the frontend strings for the booking shortcode
     *
     * @return array
     */
    public static function getBookingStrings()
    {
        return [
            'add_extra'                => __('Add extra', 'wpamelia'),
            'any'                      => __('Any', 'wpamelia'),
            'any_employee'             => __('Any Employee', 'wpamelia'),
            'book_appointment'         => __('Book Appointment', 'wpamelia'),
            'bringing_anyone_with_you' => __('Bringing anyone with you?', 'wpamelia'),
            'continue'                 => __('Continue', 'wpamelia'),
            'extra_colon'              => __('Extra:', 'wpamelia'),
            'extra_error'              => __('Please select the extra:', 'wpamelia'),
            'package_available'        => __('Available in package', 'wpamelia'),
            'package_list_overview'    => __('Overview', 'wpamelia'),
            'package_discount_text'    => __('Save ', 'wpamelia'),
            'package_book_service'     => __('All services are booked separately.', 'wpamelia'),
            'package_book_duration'    => __('The package is time-limited to', 'wpamelia'),
            'package_book_expire'      => __('Valid Until:', 'wpamelia'),
            'package_book_expiration'  => __('Duration:', 'wpamelia'),
            'package_book_unlimited'   => __('Unlimited', 'wpamelia'),
            'package_next_appointment' => __('Add appointment', 'wpamelia'),
            'package_next_service'     => __('Next Service', 'wpamelia'),
            'package_min_book'         => __('appointment is required to be booked now.', 'wpamelia'),
            'package_min_book_plural'  => __('appointments are required to be booked now.', 'wpamelia'),
            'person_upper'             => __('Person', 'wpamelia'),
            'persons_upper'            => __('Persons', 'wpamelia'),
            'pick_date_and_time_colon' => __('Pick date & time:', 'wpamelia'),
            'please_select'            => __('Please select', 'wpamelia'),
            'qty_colon'                => __('Qty:', 'wpamelia'),
            'coupons_used'             => __('Coupon Limit Reached', 'wpamelia'),
            'coupons_used_description' => __('Number of appointments with applied coupon is', 'wpamelia'),
            'recurring_costs_colon'    => __('Recurring Appointments:', 'wpamelia'),
            'recurring_appointments'   => __('Recurring Appointments', 'wpamelia'),
            'recurring_edit'           => __('You can edit or delete each appointment', 'wpamelia'),
            'recurring_sub_message1'   => __('Some of the desired slots are busy. We offered you the nearest time slots instead.', 'wpamelia'),
            'recurring_sub_message2'   => __('Number of adjusted time slots: ', 'wpamelia'),
            'recurring_active'         => __('Repeat this appointment', 'wpamelia'),
            'recurring_type_daily'     => __('Daily', 'wpamelia'),
            'recurring_type_weekly'    => __('Weekly', 'wpamelia'),
            'recurring_type_monthly'   => __('Monthly', 'wpamelia'),
            'recurring_repeat'         => __('Repeat:', 'wpamelia'),
            'recurring_every'          => __('Every:', 'wpamelia'),
            'recurring_until'          => __('Until:', 'wpamelia'),
            'recurring_every_text'     => __('Every', 'wpamelia'),
            'recurring_from_text'      => __('from', 'wpamelia'),
            'recurring_until_text'     => __('until', 'wpamelia'),
            'recurring_on'             => __('On:', 'wpamelia'),
            'recurring_each'           => __('Each:', 'wpamelia'),
            'recurring_substring_on'   => __('on', 'wpamelia'),
            'recurring_times'          => __('Time(s):', 'wpamelia'),
            'recurring_date_specific'  => __('Specific Date', 'wpamelia'),
            'recurring_date_first'     => __('First', 'wpamelia'),
            'recurring_date_second'    => __('Second', 'wpamelia'),
            'recurring_date_third'     => __('Third', 'wpamelia'),
            'recurring_date_fourth'    => __('Fourth', 'wpamelia'),
            'recurring_date_last'      => __('Last', 'wpamelia'),
            'recurring_confirm_delete' => __('Do you want to delete this appointment?', 'wpamelia'),
            'payment_type_deposit_only'=> __('Deposit only', 'wpamelia'),
            'payment_type_full_amount' => __('Whole amount', 'wpamelia'),
        ];
    }

    /**
     * Returns the array of the frontend strings for the event shortcode
     *
     * @return array
     */
    public static function getEventStrings()
    {
        return [
            'apply_to_all'          => __('Apply this to all recurring events', 'wpamelia'),
            'event'                 => __('Event', 'wpamelia'),
            'events'                => __('Events', 'wpamelia'),
            'event_about'           => __('About this Event', 'wpamelia'),
            'event_free'            => __('Free', 'wpamelia'),
            'event_book_now'        => __('Book now', 'wpamelia'),
            'event_book_event'      => __('Book event', 'wpamelia'),
            'event_book'            => __('Book this event', 'wpamelia'),
            'event_book_persons'    => __('Number of persons', 'wpamelia'),
            'event_pick_min_date'   => __('Show from date', 'wpamelia'),
            'event_type'            => __('Event Type', 'wpamelia'),
            'event_location'        => __('Event Location', 'wpamelia'),
            'event_status'          => __('Event Status', 'wpamelia'),
            'event_employee'        => __('Event Employee', 'wpamelia'),
            'event_capacity'        => __('Capacity:', 'wpamelia'),
            'event_today'           => __('Today', 'wpamelia'),
            'event_filters'         => __('Filters', 'wpamelia'),
            'event_upcoming_events' => __('Upcoming events', 'wpamelia'),
            'event_spot'            => __('spot left', 'wpamelia'),
            'event_spots'           => __('spots left', 'wpamelia'),
            'event_no_spots'        => __('No spots left', 'wpamelia'),
            'event_schedule'        => __('Schedule:', 'wpamelia'),
            'event_hosted_by'       => __('Hosted by:', 'wpamelia'),
            'event_show_less'       => __('Show less', 'wpamelia'),
            'event_many_people'     => __('How many people are coming?', 'wpamelia'),
            'event_upcoming_empty'  => __('There are no upcoming events for this period', 'wpamelia'),
            'no_events'             => __('No results found...', 'wpamelia'),
        ];
    }

    /**
     * Returns the array of the frontend strings for the catalog shortcode
     *
     * @return array
     */
    public static function getCatalogStrings()
    {
        return [
            'booking_appointment'    => __('Booking Appointment', 'wpamelia'),
            'buffer_time'            => __('Buffer Time', 'wpamelia'),
            'categories'             => __('Categories', 'wpamelia'),
            'category_colon'         => __('Category:', 'wpamelia'),
            'description'            => __('Description', 'wpamelia'),
            'description_colon'      => __('Description:', 'wpamelia'),
            'extras'                 => __('Extras', 'wpamelia'),
            'info'                   => __('Info', 'wpamelia'),
            'maximum_quantity_colon' => __('Maximum Quantity:', 'wpamelia'),
            'view_more'              => __('View More', 'wpamelia'),
        ];
    }

    /**
     * Returns the array of the frontend strings for the event shortcode
     *
     * @return array
     */
    public static function getCabinetStrings()
    {
        return [
            'add_date'                               => __('Add Date', 'wpamelia'),
            'add_day_off'                            => __('Add Day Off', 'wpamelia'),
            'add_day_off_placeholder'                => __('Enter holiday or day off name', 'wpamelia'),
            'add_period'                             => __('Add Period', 'wpamelia'),
            'add_special_day'                        => __('Add Special Day', 'wpamelia'),
            'apply_to_all_days'                      => __('Apply to All Days', 'wpamelia'),
            'appointment_canceled'                   => __('Appointment Canceled', 'wpamelia'),
            'appointment_change_time'                => __('To reschedule your appointment, select an available date time from the calendar, then click Confirm.', 'wpamelia'),
            'appointment_deleted'                    => __('Appointment has been deleted', 'wpamelia'),
            'appointment_rescheduled'                => __('Appointment has been rescheduled', 'wpamelia'),
            'appointment_saved'                      => __('Appointment has been saved', 'wpamelia'),
            'appointments'                           => __('Appointments', 'wpamelia'),
            'appointments_to_book'                   => __('Appointments to book', 'wpamelia'),
            'approved'                               => __('Approved', 'wpamelia'),
            'assigned_services'                      => __('Assigned Services', 'wpamelia'),
            'attendees'                              => __('Attendees', 'wpamelia'),
            'available'                              => __('Available', 'wpamelia'),
            'away'                                   => __('Away', 'wpamelia'),
            'booking_cancel_exception'               => __('Booking can\'t be canceled', 'wpamelia'),
            'booking_closes'                         => __('Booking Closes', 'wpamelia'),
            'booking_opens'                          => __('Booking Opens', 'wpamelia'),
            'booking_reschedule_exception'           => __('Appointment can\'t be rescheduled', 'wpamelia'),
            'break'                                  => __('On Break', 'wpamelia'),
            'break_hours'                            => __('Break Hours', 'wpamelia'),
            'breaks'                                 => __('Breaks', 'wpamelia'),
            'busy'                                   => __('Busy', 'wpamelia'),
            'cancel'                                 => __('Cancel', 'wpamelia'),
            'cancel_appointment'                     => __('Cancel Appointment', 'wpamelia'),
            'cancel_event'                           => __('Cancel Event', 'wpamelia'),
            'cancel_following'                       => __('Cancel following', 'wpamelia'),
            'canceled'                               => __('Canceled', 'wpamelia'),
            'capacity'                               => __('Capacity', 'wpamelia'),
            'category'                               => __('Category', 'wpamelia'),
            'change_group_status'                    => __('Change group status', 'wpamelia'),
            'change_password'                        => __('Change Password', 'wpamelia'),
            'choose_a_group_service'                 => __('Choose a group service', 'wpamelia'),
            'company_days_off'                       => __('Company Days off', 'wpamelia'),
            'confirm_cancel'                         => __('Are you sure you want to cancel this event?', 'wpamelia'),
            'confirm_cancel_appointment'             => __('Are you sure you want to cancel this appointment?', 'wpamelia'),
            'confirm_cancel_event'                   => __('Are you sure you want to cancel your attendance?', 'wpamelia'),
            'confirm_cancel_following'               => __('Do you want to cancel following events?', 'wpamelia'),
            'confirm_delete'                         => __('Are you sure you want to delete this event?', 'wpamelia'),
            'confirm_delete_appointment'             => __('Are you sure you want to delete this appointment?', 'wpamelia'),
            'confirm_delete_attendee'                => __('Are you sure you want to delete selected attendee?', 'wpamelia'),
            'confirm_delete_attendees'               => __('Are you sure you want to delete selected attendees?', 'wpamelia'),
            'confirm_delete_following'               => __('Do you want to delete following canceled events?', 'wpamelia'),
            'confirm_duplicate_appointment'          => __('Are you sure you want to duplicate this appointment?', 'wpamelia'),
            'confirm_duplicate_event'                => __('Are you sure you want to duplicate this event?', 'wpamelia'),
            'confirm_open'                           => __('Are you sure you want to open this event?', 'wpamelia'),
            'confirm_open_following'                 => __('Do you want to open following events?', 'wpamelia'),
            'confirm_save_following'                 => __('Do you want to update following events?', 'wpamelia'),
            'create_new'                             => __('Create New', 'wpamelia'),
            'custom_fields'                          => __('Custom Fields', 'wpamelia'),
            'customer_profile'                       => __('Customer Profile ', 'wpamelia'),
            'customers'                              => __('Customers', 'wpamelia'),
            'customers_singular_plural'              => __('Customer(s)', 'wpamelia'),
            'customers_tooltip'                      => __('Indicates the number of new and returning customers<br/>for the selected date range.', 'wpamelia'),
            'customize'                              => __('Customize', 'wpamelia'),
            'date'                                   => __('Date', 'wpamelia'),
            'date_of_birth'                          => __('Date of Birth', 'wpamelia'),
            'day1'                                   => __('1 day', 'wpamelia'),
            'day_off_name'                           => __('Day Off name', 'wpamelia'),
            'dayoff'                                 => __('Day Off', 'wpamelia'),
            'days2'                                  => __('2 days', 'wpamelia'),
            'days3'                                  => __('3 days', 'wpamelia'),
            'days4'                                  => __('4 days', 'wpamelia'),
            'days5'                                  => __('5 days', 'wpamelia'),
            'days6'                                  => __('6 days', 'wpamelia'),
            'days_off'                               => __('Days Off', 'wpamelia'),
            'days_off_add'                           => __('Add Day Off', 'wpamelia'),
            'days_off_date_warning'                  => __('Please enter date', 'wpamelia'),
            'days_off_name_warning'                  => __('Please enter name', 'wpamelia'),
            'days_off_repeat_yearly'                 => __('Repeat Yearly', 'wpamelia'),
            'delete'                                 => __('Delete', 'wpamelia'),
            'delete_following'                       => __('Delete following', 'wpamelia'),
            'delete_profile'                         => __('Delete profile', 'wpamelia'),
            'delete_profile_description'             => __('Are you sure you want to delete your profile? You will lose access to all your bookings and access to the customer panel.', 'wpamelia'),
            'description'                            => __('Description', 'wpamelia'),
            'details'                                => __('Details', 'wpamelia'),
            'disabled'                               => __('Disabled', 'wpamelia'),
            'discount_amount'                        => __('Discount', 'wpamelia'),
            'duration'                               => __('Duration', 'wpamelia'),
            'edit'                                   => __('Edit', 'wpamelia'),
            'edit_appointment'                       => __('Edit Appointment', 'wpamelia'),
            'edit_event'                             => __('Edit Event', 'wpamelia'),
            'email'                                  => __('Email', 'wpamelia'),
            'email_or_username'                      => __('Email or Username', 'wpamelia'),
            'employee_days_off'                      => __('Employee Days off', 'wpamelia'),
            'enter_address'                          => __('Enter Address', 'wpamelia'),
            'enter_email_warning'                    => __('Please enter email', 'wpamelia'),
            'enter_event_name'                       => __('Enter Event Name', 'wpamelia'),
            'enter_event_name_warning'               => __('Please enter name', 'wpamelia'),
            'enter_location_warning'                 => __('Please select location', 'wpamelia'),
            'enter_password_warning'                 => __('Please enter password', 'wpamelia'),
            'enter_valid_email_warning'              => __('Please enter a valid email address', 'wpamelia'),
            'error'                                  => __('Error', 'wpamelia'),
            'event_add_attendee'                     => __('Add Attendee', 'wpamelia'),
            'event_attendee_deleted'                 => __('Attendee have been deleted', 'wpamelia'),
            'event_attendee_not_deleted'             => __('Attendee have not been deleted', 'wpamelia'),
            'event_attendee_remove'                  => __('Remove Attendee', 'wpamelia'),
            'event_attendee_saved'                   => __('Attendee has been saved', 'wpamelia'),
            'event_edit_attendees'                   => __('Edit Attendees', 'wpamelia'),
            'event_attendees'                        => __('Attendees', 'wpamelia'),
            'event_attendees_deleted'                => __('Attendees have been deleted', 'wpamelia'),
            'event_attendees_not_deleted'            => __('Attendees have not been deleted', 'wpamelia'),
            'event_book_more_than_once'              => __('Allow the same customer to book more than once', 'wpamelia'),
            'event_attendees_search'                 => __('Find Attendees', 'wpamelia'),
            'event_booking_closes_after'             => __('Booking closes when event starts', 'wpamelia'),
            'event_booking_closes_on'                => __('Closes on:', 'wpamelia'),
            'event_booking_closes_apply'             => __('If this option is not checked the plugin will calculate the time <br> for closing the booking based on the selected time for the first event', 'wpamelia'),
            'event_booking_opens_apply'              => __('If this option is not checked the plugin will calculate the time <br> for opening the booking based on the selected time for the first event', 'wpamelia'),
            'event_booking_opens_now'                => __('Booking opens immediately', 'wpamelia'),
            'event_booking_opens_on'                 => __('Opens on:', 'wpamelia'),
            'event_bringing_anyone'                  => __('Allow bringing more persons', 'wpamelia'),
            'event_cancel'                           => __('Cancel Event', 'wpamelia'),
            'event_canceled'                         => __('Event has been canceled', 'wpamelia'),
            'event_colors'                           => __('Event Colors:', 'wpamelia'),
            'event_colors_custom'                    => __('Custom Color', 'wpamelia'),
            'event_colors_preset'                    => __('Preset Colors', 'wpamelia'),
            'event_custom_address'                   => __('Custom Address', 'wpamelia'),
            'event_delete'                           => __('Delete Event', 'wpamelia'),
            'event_deleted'                          => __('Event has been deleted', 'wpamelia'),
            'event_details'                          => __('Event Details', 'wpamelia'),
            'event_duplicate'                        => __('Duplicate', 'wpamelia'),
            'event_edit_attendee'                    => __('Edit Attendee', 'wpamelia'),
            'event_gallery'                          => __('Event Gallery:', 'wpamelia'),
            'event_max_capacity'                     => __('Maximum allowed spots', 'wpamelia'),
            'event_name'                             => __('Name:', 'wpamelia'),
            'event_open'                             => __('Open Event', 'wpamelia'),
            'event_opened'                           => __('Event has been opened', 'wpamelia'),
            'event_period_dates'                     => __('Dates:', 'wpamelia'),
            'event_period_time'                      => __('Time:', 'wpamelia'),
            'event_recurring_enabled'                => __('This is recurring event', 'wpamelia'),
            'event_recurring_period'                 => __('Repeat Event', 'wpamelia'),
            'event_recurring_until'                  => __('Until when?', 'wpamelia'),
            'event_saved'                            => __('Event has been saved', 'wpamelia'),
            'event_select_address'                   => __('Select Address', 'wpamelia'),
            'event_show_on_site'                     => __('Show event on site', 'wpamelia'),
            'event_staff'                            => __('Staff', 'wpamelia'),
            'event_status_changed'                   => __('Booking status has been changed to ', 'wpamelia'),
            'event_tags'                             => __('Tags', 'wpamelia'),
            'event_tags_create'                      => __('No Tags. Create a new one.', 'wpamelia'),
            'event_tags_select_or_create'            => __('Select or Create Tag', 'wpamelia'),
            'export'                                 => __('Export', 'wpamelia'),
            'export_tooltip_attendees'               => __('You can use this option to export attendees in CSV file<br/>for the selected event.', 'wpamelia'),
            'extras'                                 => __('Extras', 'wpamelia'),
            'forgot_password'                        => __('Forgot Password?', 'wpamelia'),
            'general'                                => __('General', 'wpamelia'),
            'google_calendar'                        => __('Google Calendar', 'wpamelia'),
            'google_calendar_tooltip'                => __('Connect your Google Calendar here so once<br/>the appointment is scheduled it can be added<br/>to your Google Calendar automatically.', 'wpamelia'),
            'google_sign_in'                         => __('Sign in with Google', 'wpamelia'),
            'google_sign_out'                        => __('Sign out from Google', 'wpamelia'),
            'h1'                                     => __('1h', 'wpamelia'),
            'h10'                                    => __('10h', 'wpamelia'),
            'h11'                                    => __('11h', 'wpamelia'),
            'h12'                                    => __('12h', 'wpamelia'),
            'h1min30'                                => __('1h 30min', 'wpamelia'),
            'h2'                                     => __('2h', 'wpamelia'),
            'h3'                                     => __('3h', 'wpamelia'),
            'h4'                                     => __('4h', 'wpamelia'),
            'h6'                                     => __('6h', 'wpamelia'),
            'h8'                                     => __('8h', 'wpamelia'),
            'h9'                                     => __('9h', 'wpamelia'),
            'invalid_credentials'                    => __('Incorrect email or password', 'wpamelia'),
            'integrations_settings'                  => __('Integrations', 'wpamelia'),
            'lesson_space'                           => __('Lesson Space', 'wpamelia'),
            'lesson_space_join'                      => __('Join Space', 'wpamelia'),
            'lesson_space_link'                      => __('Lesson Space Link', 'wpamelia'),
            'lesson_space_links'                     => __('Lesson Space Links', 'wpamelia'),
            'loader_message'                         => __('Please Wait', 'wpamelia'),
            'login'                                  => __('Login', 'wpamelia'),
            'login_email_placeholder'                => __('Enter your email', 'wpamelia'),
            'login_password_placeholder'             => __('Enter your password', 'wpamelia'),
            'logout'                                 => __('Logout', 'wpamelia'),
            'maximum_capacity'                       => __('Max. Capacity', 'wpamelia'),
            'min1'                                   => __('1min', 'wpamelia'),
            'min10'                                  => __('10min', 'wpamelia'),
            'min12'                                  => __('12min', 'wpamelia'),
            'min15'                                  => __('15min', 'wpamelia'),
            'min2'                                   => __('2min', 'wpamelia'),
            'min20'                                  => __('20min', 'wpamelia'),
            'min30'                                  => __('30min', 'wpamelia'),
            'min45'                                  => __('45min', 'wpamelia'),
            'min5'                                   => __('5min', 'wpamelia'),
            'minimum_capacity'                       => __('Min. Capacity', 'wpamelia'),
            'minimum_time_before_canceling'          => __('Minimum time required before canceling', 'wpamelia'),
            'minimum_time_before_canceling_tooltip'  => __('Set the time before the appointment when customers<br/>will not be able to cancel the appointment.', 'wpamelia'),
            'months3'                                => __('3 months', 'wpamelia'),
            'months6'                                => __('6 months', 'wpamelia'),
            'multiple_emails'                        => __('Multiple Emails', 'wpamelia'),
            'my_profile'                             => __('My Profile', 'wpamelia'),
            'new_appointment'                        => __('New Appointment', 'wpamelia'),
            'new_event'                              => __('New Event', 'wpamelia'),
            'new_password_colon'                     => __('New Password:', 'wpamelia'),
            'new_password_length'                    => __('Password must be longer than 3 characters', 'wpamelia'),
            'new_password_required'                  => __('Please enter new password', 'wpamelia'),
            'no_attendees_yet'                       => __('There are no attendees yet...', 'wpamelia'),
            'no_results'                             => __('There are no results...', 'wpamelia'),
            'no_selected_extras_requirements'        => __('Select customer, employee and service', 'wpamelia'),
            'no_selected_slot_requirements'          => __('Select date and time', 'wpamelia'),
            'note'                                   => __('Note', 'wpamelia'),
            'note_internal'                          => __('Note (Internal)', 'wpamelia'),
            'notify_customers'                       => __('Notify the customer(s)', 'wpamelia'),
            'notify_customers_tooltip'               => __('Check this checkbox if you want your customer to<br/>receive an email about the scheduled appointment.', 'wpamelia'),
            'once_off'                               => __('Once Off', 'wpamelia'),
            'open_following'                         => __('Open following', 'wpamelia'),
            'package_back_to_appointments'           => __('Back to appointments', 'wpamelia'),
            'package_total_appointments'             => __('Appointments in this service', 'wpamelia'),
            'package_left_appointments'              => __('appointment slots left to be booked', 'wpamelia'),
            'package_book_next_appointment'          => __('Book next appointment', 'wpamelia'),
            'package_continue_booking'               => __('Continue Booking', 'wpamelia'),
            'package_booked_appointments'            => __('Booked Appointments', 'wpamelia'),
            'package_service_info'                   => __('Service info', 'wpamelia'),
            'password'                               => __('Password', 'wpamelia'),
            'password_has_been_changed'              => __('Password has been changed', 'wpamelia'),
            'passwords_do_not_match'                 => __('Passwords do not match', 'wpamelia'),
            'payment'                                => __('Payment', 'wpamelia'),
            'payment_method'                         => __('Payment Method', 'wpamelia'),
            'payments'                               => __('Payments', 'wpamelia'),
            'pending'                                => __('Pending', 'wpamelia'),
            'period_location_filter1_tooltip'        => __('Select specific location for this period.', 'wpamelia'),
            'period_location_filter2_tooltip'        => __('Select specific location for each period.', 'wpamelia'),
            'period_services_filter'                 => __('Applied for all assigned services', 'wpamelia'),
            'period_services_filter1_tooltip'        => __('Select only specific services for this period.<br/>If no services are selected, then all assigned services for this employee<br/>will be available for booking in this period.', 'wpamelia'),
            'period_services_filter2_tooltip'        => __('Select specific services for each period.', 'wpamelia'),
            'periods'                                => __('Periods', 'wpamelia'),
            'pick_a_date_or_range'                   => __('Pick a date or range', 'wpamelia'),
            'pick_a_year'                            => __('Pick a year', 'wpamelia'),
            'price'                                  => __('Price', 'wpamelia'),
            'price_per_spot'                         => __('Price per Spot', 'wpamelia'),
            'profile_deleted'                        => __('Profile deleted', 'wpamelia'),
            'profile_saved'                          => __('Profile has been updated', 'wpamelia'),
            'provider_profile'                       => __('Employee Profile', 'wpamelia'),
            're_type_requred'                        => __('Please enter new password again', 'wpamelia'),
            'recovery_email_sent'                    => __('Email with access link has been sent', 'wpamelia'),
            'recurring'                              => __('Recurring', 'wpamelia'),
            'recurring_active'                       => __('Repeat this appointment', 'wpamelia'),
            'recurring_active_tooltip'               => __('Check this option if you want to create recurring appointments', 'wpamelia'),
            'recurring_type_monthly'                 => __('Monthly', 'wpamelia'),
            'recurring_type_weekly'                  => __('Weekly', 'wpamelia'),
            'recurring_type_yearly'                  => __('Yearly', 'wpamelia'),
            'redirect_url_after_appointment'         => __('Redirect URL After Booking', 'wpamelia'),
            'redirect_url_after_appointment_tooltip' => __('Customer will be redirected to this URL once he schedules the appointment.', 'wpamelia'),
            'rejected'                               => __('Rejected', 'wpamelia'),
            'repeat_every_year'                      => __('Repeat Every Year', 'wpamelia'),
            'reschedule'                             => __('Reschedule', 'wpamelia'),
            'retype_new_password_colon'              => __('Re-type New Password:', 'wpamelia'),
            'save'                                   => __('Save', 'wpamelia'),
            'duplicate'                              => __('Duplicate', 'wpamelia'),
            'save_changes'                           => __('Save Changes', 'wpamelia'),
            'save_single'                            => __('No, just this one', 'wpamelia'),
            'save_special_day'                       => __('Save Special Day', 'wpamelia'),
            'schedule'                               => __('Schedule', 'wpamelia'),
            'select'                                 => __('Select', 'wpamelia'),
            'select_customer_warning'                => __('Please select at least one customer', 'wpamelia'),
            'select_customers'                       => __('Select Customer(s)', 'wpamelia'),
            'select_date_warning'                    => __('Please select date', 'wpamelia'),
            'select_cycle_warning'                   => __('Please select repeat period', 'wpamelia'),
            'select_interval_warning'                => __('Please select repeat interval', 'wpamelia'),
            'select_employee'                        => __('Select Employee', 'wpamelia'),
            'select_employee_warning'                => __('Please select employee', 'wpamelia'),
            'select_coupon'                          => __('Select Coupon', 'wpamelia'),
            'select_location'                        => __('Select Location', 'wpamelia'),
            'select_max_customer_count_warning'      => __('Maximum number of places is', 'wpamelia'),
            'select_repeat_period'                   => __('Select Repeat Period', 'wpamelia'),
            'select_repeat_interval'                 => __('Select Repeat Interval', 'wpamelia'),
            'select_service'                         => __('Select Service', 'wpamelia'),
            'select_service_category'                => __('Select Service Category', 'wpamelia'),
            'select_service_warning'                 => __('Please select service', 'wpamelia'),
            'select_time'                            => __('Select Time', 'wpamelia'),
            'select_time_warning'                    => __('Please select time', 'wpamelia'),
            'selected_customers'                     => __('Selected Customers', 'wpamelia'),
            'send'                                   => __('Send', 'wpamelia'),
            'send_recovery_email'                    => __('Send Access Link', 'wpamelia'),
            'send_recovery_email_description'        => __('Enter your account email address and we will send you an access link to your inbox.', 'wpamelia'),
            'service_category'                       => __('Service Category', 'wpamelia'),
            'service_price'                          => __('Service Price', 'wpamelia'),
            'service_provider_remove_fail'           => __('You have appointments for this service', 'wpamelia'),
            'service_provider_remove_fail_all'       => __('You have appointments for', 'wpamelia'),
            'set_password'                           => __('Set Password', 'wpamelia'),
            'settings'                               => __('Settings', 'wpamelia'),
            'sign_in'                                => __('Sign In', 'wpamelia'),
            'special_day_date_warning'               => __('Please enter date', 'wpamelia'),
            'special_day_end_time_warning'           => __('Please enter end time', 'wpamelia'),
            'special_day_start_time_warning'         => __('Please enter start time', 'wpamelia'),
            'special_days'                           => __('Special Days', 'wpamelia'),
            'special_days_reflect_services'          => __('Reflect On', 'wpamelia'),
            'spots'                                  => __('Spots', 'wpamelia'),
            'status'                                 => __('Status', 'wpamelia'),
            'subtotal'                               => __('Subtotal', 'wpamelia'),
            'success'                                => __('Success', 'wpamelia'),
            'time'                                   => __('Time', 'wpamelia'),
            'today'                                  => __('Today', 'wpamelia'),
            'tomorrow'                               => __('Tomorrow', 'wpamelia'),
            'total'                                  => __('Total', 'wpamelia'),
            'total_price'                            => __('Total Price', 'wpamelia'),
            'update_following'                       => __('Update following', 'wpamelia'),
            'user_profile'                           => __('User Profile', 'wpamelia'),
            'week1'                                  => __('1 week', 'wpamelia'),
            'weekday_friday'                         => __('Friday', 'wpamelia'),
            'weekday_monday'                         => __('Monday', 'wpamelia'),
            'weekday_saturday'                       => __('Saturday', 'wpamelia'),
            'weekday_sunday'                         => __('Sunday', 'wpamelia'),
            'weekday_thursday'                       => __('Thursday', 'wpamelia'),
            'weekday_tuesday'                        => __('Tuesday', 'wpamelia'),
            'weekday_wednesday'                      => __('Wednesday', 'wpamelia'),
            'weeks2'                                 => __('2 weeks', 'wpamelia'),
            'weeks3'                                 => __('3 weeks', 'wpamelia'),
            'weeks4'                                 => __('4 weeks', 'wpamelia'),
            'wc_product'                             => __('Select WooCommerce product', 'wpamelia'),
            'wc_product_tooltip'                     => __('Here you can choose the product that will be used for WooCommerce integration.', 'wpamelia'),
            'work_hours'                             => __('Work Hours', 'wpamelia'),
            'working_hours'                          => __('Working Hours', 'wpamelia'),
            'wp_timezone_warning'                    => __('Choosing a time zone applies only for managing appointments and events, working hours use a time zone set on the admin side.', 'wpamelia'),
            'yes'                                    => __('Yes', 'wpamelia'),
            'outlook_sign_in'                        => __('Sign in with Outlook', 'wpamelia'),
            'outlook_sign_out'                       => __('Sign out from Outlook', 'wpamelia'),
            'outlook_calendar_tooltip'               => __('Here you can connect employee with Outlook Calendar,<br/>so once the appointment is scheduled it will be<br/>automatically added to employee\'s calendar.', 'wpamelia'),
            'outlook_placeholder'                    => __('Select Outlook Calendar', 'wpamelia'),
            'zoom'                                   => __('Zoom', 'wpamelia'),
            'zoom_click_to_join'                     => __('Join Zoom Meeting', 'wpamelia'),
            'zoom_click_to_start'                    => __('Start Zoom Meeting', 'wpamelia'),
            'zoom_join_link'                         => __('Zoom Join Link (Participants)', 'wpamelia'),
            'zoom_link'                              => __('Zoom Link', 'wpamelia'),
            'zoom_links'                             => __('Zoom Links', 'wpamelia'),
            'zoom_start_link'                        => __('Zoom Start Link (Host)', 'wpamelia'),
            'zoom_user'                              => __('Zoom User', 'wpamelia'),
            'zoom_user_placeholder'                  => __('Select Zoom User', 'wpamelia'),
            'zoom_user_tooltip'                      => __('Here you can select Zoom User,<br/>so once the appointment is scheduled,<br/>zoom meeting will be automatically created.', 'wpamelia'),
        ];
    }
}
