<?php

namespace AmeliaBooking\Domain\ValueObjects\String;

/**
 * Class NotificationStatus
 *
 * @package AmeliaBooking\Domain\ValueObjects\String
 */
final class NotificationStatus
{
    const ENABLED = 'enabled';
    const DISABLED = 'disabled';

    /**
     * @var string
     */
    private $status;

    /**
     * Status constructor.
     *
     * @param int $status
     */
    public function __construct($status)
    {
        $this->status = $status;
    }

    /**
     * Return the status from the value object
     *
     * @return string
     */
    public function getValue()
    {
        return $this->status;
    }
}
